/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.dao;

import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasMarketAppinfo;
import com.irdstudio.allinapaas.executor.application.executor.core.util.db.ProxySQL;
import com.irdstudio.allinapaas.executor.application.executor.core.util.pub.NumberUtil;
import com.irdstudio.sdk.beans.core.util.POJOUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaasMarketAppinfoDao {
    private static final Logger logger = LoggerFactory.getLogger(PaasMarketAppinfoDao.class);
    Connection conn = null;

    public PaasMarketAppinfoDao(Connection conn) {
        this.conn = conn;
    }

    public List<PaasMarketAppinfo> queryPaasMarketAppinfoList(final PaasMarketAppinfo paramVO) {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("*");
                this.FROM("`allinpaas_db`.paas_market_appinfo");
                List vals = POJOUtils.getPOJOValues((Object)((Object)paramVO));
                for (Object[] val : vals) {
                    this.WHERE(String.format("%s = ?", val[0].toString()));
                    param.add(val[1]);
                }
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<PaasMarketAppinfo> list = new ArrayList<PaasMarketAppinfo>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                PaasMarketAppinfo bean = (PaasMarketAppinfo)((Object)POJOUtils.generatePOJO((ResultSet)rs, PaasMarketAppinfo.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("query queryPaasMarketAppinfoList is wrong", e);
        }
        return list;
    }

    public PaasMarketAppinfo queryPaasMarketAppinfo(final String marketAppId) {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("*");
                this.FROM("`allinpaas_db`.paas_market_appinfo");
                this.WHERE("market_app_id = ?");
                param.add(marketAppId);
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<PaasMarketAppinfo> list = new ArrayList<PaasMarketAppinfo>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                PaasMarketAppinfo bean = (PaasMarketAppinfo)((Object)POJOUtils.generatePOJO((ResultSet)rs, PaasMarketAppinfo.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("query PaasMarketAppinfo is wrong", e);
        }
        return list.isEmpty() ? null : (PaasMarketAppinfo)((Object)list.get(0));
    }

    public boolean deletePaasMarketAppinfo(final String marketAppId) {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.DELETE_FROM("`allinpaas_db`.paas_market_appinfo");
                this.WHERE("market_app_id = ?");
                param.add(marketAppId);
            }
        }.toString();
        PreparedStatement ps = null;
        Object rs = null;
        int num = 0;
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            num = ps.executeUpdate();
        }
        catch (Exception e) {
            throw new RuntimeException("deletePaasMarketAppinfo is wrong", e);
        }
        return num == 1;
    }

    public boolean deletePaasMarketAppinfo(final String appId, final String subsId) {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.DELETE_FROM("`allinpaas_db`.paas_market_appinfo");
                this.WHERE("app_id = ?");
                param.add(appId);
                if (subsId != null) {
                    this.WHERE("subs_id = ?");
                    param.add(subsId);
                }
            }
        }.toString();
        PreparedStatement ps = null;
        Object rs = null;
        int num = 0;
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            num = ps.executeUpdate();
        }
        catch (Exception e) {
            throw new RuntimeException("deletePaasMarketAppinfo is wrong", e);
        }
        return num == 1;
    }

    public int deletePaasMarketAppinfoBySysCode(final String subsId) {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.DELETE_FROM("`allinpaas_db`.paas_market_appinfo");
                this.WHERE("subs_id = ?");
                param.add(subsId);
            }
        }.toString();
        PreparedStatement ps = null;
        Object rs = null;
        int num = 0;
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            num = ps.executeUpdate();
        }
        catch (Exception e) {
            throw new RuntimeException("deletePaasMarketAppinfoBySysCode is wrong", e);
        }
        return num;
    }

    public boolean insertPaasMarketAppinfo(final PaasMarketAppinfo paasMarketAppinfo) throws SQLException {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.INSERT_INTO("`allinpaas_db`.paas_market_appinfo");
                List vals = POJOUtils.getPOJOValues((Object)((Object)paasMarketAppinfo));
                for (Object[] val : vals) {
                    this.VALUES(val[0].toString(), "?");
                    param.add(val[1]);
                }
            }
        }.toString();
        PreparedStatement ps = null;
        Object rs = null;
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            int re = ps.executeUpdate();
            if (re == 1) {
                return true;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("query insertPaasMarketAppinfo is wrong", e);
        }
        return false;
    }

    public PaasMarketAppinfo queryByBatchSerialNo(final String batchSerialNo) throws SQLException {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("*");
                this.FROM("`allinpaas_db`.paas_market_appinfo");
                this.WHERE("batch_serial_no = ?");
                param.add(batchSerialNo);
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<PaasMarketAppinfo> list = new ArrayList<PaasMarketAppinfo>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            if (rs.next()) {
                PaasMarketAppinfo bean = (PaasMarketAppinfo)((Object)POJOUtils.generatePOJO((ResultSet)rs, PaasMarketAppinfo.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("query queryByBatchSerialNo is wrong", e);
        }
        return list.isEmpty() ? null : (PaasMarketAppinfo)((Object)list.get(0));
    }

    public boolean updateByPk(final PaasMarketAppinfo appInfo) {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.UPDATE("`allinpaas_db`.paas_market_appinfo");
                List vals = POJOUtils.getPOJOValues((Object)((Object)appInfo));
                for (Object[] val : vals) {
                    if (val[0].toString().equals("marketAppId")) continue;
                    this.SET(String.format("%s = ?", val[0].toString()));
                    param.add(val[1]);
                }
                this.WHERE("marketAppId = ?");
                param.add(appInfo.getMarketAppId());
            }
        }.toString();
        PreparedStatement ps = null;
        try {
            int i;
            ps = this.conn.prepareStatement(sql);
            for (i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            i = ps.executeUpdate();
        }
        catch (Exception e) {
            throw new RuntimeException("update by pk is wrong", e);
        }
        return true;
    }

    public void createKeyMap() {
        String sql = "CREATE TABLE trans_key_map(`key_id` TEXT NOT NULL, `map_id` TEXT NOT NULL, PRIMARY KEY (`key_id`))";
        PreparedStatement ps = null;
        boolean rs = true;
        try {
            ps = this.conn.prepareStatement(sql);
            rs = ps.execute();
        }
        catch (Exception e) {
            throw new RuntimeException("query createKeyMap is wrong", e);
        }
    }

    public int saveKeyMap(Map<String, String> keyMap) {
        int size = keyMap.size();
        ArrayList<String> valueList = new ArrayList<String>(size);
        for (Map.Entry<String, String> entry : keyMap.entrySet()) {
            StringBuffer valSb = new StringBuffer();
            valSb.append("(");
            valSb.append("'").append(entry.getKey()).append("',");
            valSb.append("'").append(entry.getValue()).append("'");
            valSb.append(")");
            valueList.add(valSb.toString());
        }
        int loop = NumberUtil.calcLoop(size);
        int cur = 0;
        int num = 0;
        for (int i = 1; i <= loop; ++i) {
            int end = 200 * i;
            if (end > valueList.size()) {
                end = valueList.size();
            }
            List sub = valueList.subList(cur, end);
            cur += 200;
            StringBuffer sqlSb = new StringBuffer();
            sqlSb.append("INSERT INTO trans_key_map").append("(key_id, map_id)\n");
            sqlSb.append(" VALUES \n");
            sqlSb.append(StringUtils.join(sub, (String)","));
            String sql = sqlSb.toString();
            ProxySQL.log.debug("SQL generate result \n{}", (Object)sql);
            PreparedStatement ps = null;
            int rs = 0;
            try {
                ps = this.conn.prepareStatement(sql);
                rs = ps.executeUpdate();
            }
            catch (Exception e) {
                throw new RuntimeException("insert batch trans_key_map is wrong", e);
            }
            num += rs;
        }
        return num;
    }

    public String queryKeyMap(final String key) {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("map_id");
                this.FROM("trans_key_map");
                this.WHERE("key_id = ?");
                param.add(key);
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        String mapId = null;
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                mapId = rs.getString(1);
            }
        }
        catch (Exception e) {
            mapId = key;
        }
        return mapId;
    }
}

