/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.dao;

import com.irdstudio.allinapaas.executor.application.executor.core.dao.AbstractPortalPageDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SCheckResultDtl;
import com.irdstudio.allinapaas.executor.application.executor.core.util.db.ProxySQL;
import com.irdstudio.allinapaas.executor.application.executor.core.util.pub.NumberUtil;
import com.irdstudio.sdk.beans.core.util.POJOUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCheckResultDtlDao
extends AbstractPortalPageDao {
    private static final Logger logger = LoggerFactory.getLogger(SCheckResultDtlDao.class);
    Connection conn = null;

    public SCheckResultDtlDao(Connection conn) {
        super(conn);
        this.conn = conn;
    }

    public List<SCheckResultDtl> queryListByPage(final SCheckResultDtl paramVO) {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("*");
                this.FROM("`allinpaas_db`.s_check_result_dtl");
                List vals = POJOUtils.getPOJOValues((Object)((Object)paramVO));
                for (Object[] val : vals) {
                    this.WHERE(String.format("%s = ?", val[0].toString()));
                    param.add(val[1]);
                }
                this.ORDER_BY("create_time asc");
            }
        }.toString();
        this.queryTotalRecord(sql, paramVO, param);
        paramVO.checkAndSetPageInfo();
        String limitSql = this.buildPageSql(paramVO, sql);
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<SCheckResultDtl> list = new ArrayList<SCheckResultDtl>();
        try {
            ps = this.conn.prepareStatement(limitSql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                SCheckResultDtl bean = (SCheckResultDtl)((Object)POJOUtils.generatePOJO((ResultSet)rs, SCheckResultDtl.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("queryListByPage is wrong", e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return list;
    }

    public List<SCheckResultDtl> queryList(final SCheckResultDtl paramVO) throws Exception {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("*");
                this.FROM("`allinpaas_db`.s_check_result_dtl");
                List vals = POJOUtils.getPOJOValues((Object)((Object)paramVO));
                for (Object[] val : vals) {
                    this.WHERE(String.format("%s = ?", val[0].toString()));
                    param.add(val[1]);
                }
                this.ORDER_BY("create_time asc");
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<SCheckResultDtl> list = new ArrayList<SCheckResultDtl>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                SCheckResultDtl bean = (SCheckResultDtl)((Object)POJOUtils.generatePOJO((ResultSet)rs, SCheckResultDtl.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("queryList is wrong", e);
        }
        return list;
    }

    public SCheckResultDtl queryByPk(final String dtlId) throws Exception {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("*");
                this.FROM("`allinpaas_db`.s_check_result_dtl");
                this.WHERE("dtl_id = ?");
                param.add(dtlId);
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<SCheckResultDtl> list = new ArrayList<SCheckResultDtl>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                SCheckResultDtl bean = (SCheckResultDtl)((Object)POJOUtils.generatePOJO((ResultSet)rs, SCheckResultDtl.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("query queryByPk is wrong", e);
        }
        return list.isEmpty() ? null : (SCheckResultDtl)((Object)list.get(0));
    }

    public boolean insert(final SCheckResultDtl obj) throws SQLException {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.INSERT_INTO("`allinpaas_db`.s_check_result_dtl");
                List vals = POJOUtils.getPOJOValues((Object)((Object)obj));
                for (Object[] val : vals) {
                    this.VALUES(val[0].toString(), "?");
                    param.add(val[1]);
                }
            }
        }.toString();
        PreparedStatement ps = null;
        Object rs = null;
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            int re = ps.executeUpdate();
            if (re == 1) {
                return true;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("insert is wrong", e);
        }
        return false;
    }

    public int deleteByPk(final String dtlId) throws SQLException {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.DELETE_FROM("`allinpaas_db`.s_check_result_dtl");
                this.WHERE("dtl_id = ?");
                param.add(dtlId);
            }
        }.toString();
        PreparedStatement ps = null;
        Object rs = null;
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            int re = ps.executeUpdate();
            return re;
        }
        catch (Exception e) {
            throw new RuntimeException("deleteByPk is wrong", e);
        }
    }

    public int updateByPk(final SCheckResultDtl field) throws SQLException {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.UPDATE("`allinpaas_db`.s_check_result_dtl");
                List vals = POJOUtils.getPOJOValues((Object)((Object)field));
                for (Object[] val : vals) {
                    if (val[0].toString().equals("dtl_id")) continue;
                    this.SET(String.format("%s = ?", val[0].toString()));
                    param.add(val[1]);
                }
                this.WHERE("dtl_id = ?");
                param.add(field.getDtlId());
            }
        }.toString();
        if (param.size() < 2) {
            return 0;
        }
        PreparedStatement ps = null;
        Object rs = null;
        int result = 0;
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            result = ps.executeUpdate();
        }
        catch (Exception e) {
            throw new RuntimeException("updateByPk is wrong", e);
        }
        return result;
    }

    public Integer queryFailNum(final String serialNo, final String ruleId) throws Exception {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("count(1) as failNum");
                this.FROM("`allinpaas_db`.s_check_result_dtl");
                this.WHERE("serial_no = ?");
                param.add(serialNo);
                this.WHERE("rule_id = ?");
                param.add(ruleId);
                this.WHERE("check_result = 'F'");
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        Integer num = 0;
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            if (rs.next()) {
                num = rs.getInt("failNum");
            }
        }
        catch (Exception e) {
            throw new RuntimeException("queryFailNum is wrong", e);
        }
        return num;
    }

    public int batchInsertPage(List<SCheckResultDtl> list, Connection conn) {
        if (CollectionUtils.isEmpty(list)) {
            return 0;
        }
        int num = 0;
        if (list.size() < 200) {
            num += this.batchInsert(list, conn);
        } else {
            int loop = NumberUtil.calcLoop(list.size());
            int cur = 0;
            for (int i = 1; i <= loop; ++i) {
                int end = 200 * i;
                if (end > list.size()) {
                    end = list.size();
                }
                List<SCheckResultDtl> sub = list.subList(cur, end);
                cur += 200;
                num += this.batchInsert(sub, conn);
            }
        }
        return num;
    }

    public int batchInsert(List<SCheckResultDtl> vos, Connection conn) {
        List[] insertInfos = POJOUtils.generateInsertInfo(vos);
        if (insertInfos == null) {
            return -1;
        }
        ArrayList param = new ArrayList();
        StringBuffer sqlSb = new StringBuffer();
        sqlSb.append("INSERT INTO ").append("`allinpaas_db`.s_check_result_dtl").append(" (");
        Object[] columns = insertInfos[0].toArray(new String[0]);
        String[] values = insertInfos[1].toArray(new String[0]);
        sqlSb.append(StringUtils.join((Object[])columns, (String)","));
        sqlSb.append(")\n").append(" VALUES \n");
        for (int i = 2; i < insertInfos.length; ++i) {
            sqlSb.append("(");
            for (int j = 0; j < insertInfos[i].size(); ++j) {
                Object obj = insertInfos[i].get(j);
                if (obj == null) {
                    sqlSb.append("NULL");
                } else if (obj.toString().contains("'") || obj.toString().contains("\\\"")) {
                    sqlSb.append("?");
                    param.add(obj);
                } else {
                    sqlSb.append("'").append(obj).append("'");
                }
                if (j >= insertInfos[i].size() - 1) continue;
                sqlSb.append(",");
            }
            sqlSb.append(")");
            if (i >= insertInfos.length - 1) continue;
            sqlSb.append(", \n");
        }
        String sql = sqlSb.toString();
        ProxySQL.log.debug("SQL generate result \n{}", (Object)sql);
        PreparedStatement ps = null;
        int rs = 0;
        try {
            ps = conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeUpdate();
        }
        catch (Exception e) {
            throw new RuntimeException("insert batch `allinpaas_db`.s_check_result_dtl is wrong", e);
        }
        return rs;
    }
}

