/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.dao;

import com.alibaba.fastjson.JSON;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SrvModelInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.util.db.ProxySQL;
import com.irdstudio.sdk.beans.core.util.POJOUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SrvModelInfoDao {
    private static final Logger logger = LoggerFactory.getLogger(SrvModelInfoDao.class);
    Connection conn = null;

    public SrvModelInfoDao(Connection conn) {
        this.conn = conn;
    }

    public List<SrvModelInfo> querySrvModelInfoList(SrvModelInfo srvModelInfo) throws Exception {
        return this.querySrvModelInfoList(srvModelInfo, null);
    }

    public List<SrvModelInfo> querySrvModelInfoList(final SrvModelInfo srvModelInfo, final List<String> srvModelCatalogs) throws Exception {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("*");
                this.FROM("`allinrdm_db`.srv_model_info");
                if (srvModelInfo.getSubsId() != null) {
                    this.WHERE("app_id in ( select app_id from `allinpaas_db`.paas_apps_info where subs_id = ? )");
                    param.add(srvModelInfo.getSubsId());
                }
                if (srvModelInfo.getAppId() != null) {
                    this.WHERE("app_id = ?");
                    param.add(srvModelInfo.getAppId());
                }
                if (srvModelInfo.getSrvModelCatalog() != null) {
                    this.WHERE("srv_model_catalog = ? ");
                    param.add(srvModelInfo.getSrvModelCatalog());
                }
                if (srvModelInfo.getTableModelId() != null) {
                    this.WHERE("table_model_id = ? ");
                    param.add(srvModelInfo.getTableModelId());
                }
                if (srvModelInfo.getSrvModelId() != null && StringUtils.isNotBlank((CharSequence)srvModelInfo.getSrvModelId())) {
                    if (StringUtils.contains((CharSequence)srvModelInfo.getSrvModelId(), (CharSequence)",")) {
                        this.WHERE(String.format("srv_model_id in ('%s') ", StringUtils.join((Object[])StringUtils.split((String)srvModelInfo.getSrvModelId(), (String)","), (String)"','")));
                    } else {
                        this.WHERE("srv_model_id = ? ");
                        param.add(srvModelInfo.getSrvModelId());
                    }
                }
                if (srvModelInfo.getTableModelCode() != null) {
                    this.WHERE("table_model_code = ? ");
                    param.add(srvModelInfo.getTableModelCode());
                }
                if (srvModelCatalogs != null) {
                    ArrayList<String> inSql = new ArrayList<String>(srvModelCatalogs.size());
                    for (String el : srvModelCatalogs) {
                        inSql.add(String.format("'%s'", el));
                    }
                    this.WHERE("srv_model_catalog in (" + StringUtils.join(inSql, (String)",") + ")");
                }
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<SrvModelInfo> list = new ArrayList<SrvModelInfo>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                SrvModelInfo bean = (SrvModelInfo)((Object)POJOUtils.generatePOJO((ResultSet)rs, SrvModelInfo.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("query queryOsrvNodeInfoList is wrong", e);
        }
        return list;
    }

    public SrvModelInfo queryById(final String appId, final String srvModelId) throws Exception {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("*");
                this.FROM("`allinrdm_db`.srv_model_info");
                this.WHERE("app_id = ?");
                param.add(appId);
                this.WHERE("srv_model_id = ?");
                param.add(srvModelId);
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<SrvModelInfo> list = new ArrayList<SrvModelInfo>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            if (rs.next()) {
                SrvModelInfo bean = (SrvModelInfo)((Object)POJOUtils.generatePOJO((ResultSet)rs, SrvModelInfo.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("query queryByPk is wrong", e);
        }
        return list.isEmpty() ? null : (SrvModelInfo)((Object)list.get(0));
    }

    public SrvModelInfo queryBySrvModelId(final String srvModelId) throws Exception {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("*");
                this.FROM("`allinrdm_db`.srv_model_info");
                this.WHERE("srv_model_id = ?");
                param.add(srvModelId);
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<SrvModelInfo> list = new ArrayList<SrvModelInfo>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            if (rs.next()) {
                SrvModelInfo bean = (SrvModelInfo)((Object)POJOUtils.generatePOJO((ResultSet)rs, SrvModelInfo.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("query queryByPk is wrong", e);
        }
        return list.isEmpty() ? null : (SrvModelInfo)((Object)list.get(0));
    }

    public int countByAppId(final String appId, final String srvModelCatalog) throws Exception {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("count(1) as num");
                this.FROM("`allinrdm_db`.srv_model_info");
                this.WHERE("app_id = ?");
                param.add(appId);
                this.WHERE("srv_model_catalog = ? ");
                param.add(srvModelCatalog);
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        int count = 0;
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                count = rs.getInt(1);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("query countByAppId is wrong", e);
        }
        return count;
    }

    public int countByTableModelId(final String appId, final String tableModelId) throws Exception {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("count(1) as num");
                this.FROM("`allinrdm_db`.srv_model_info");
                this.WHERE("app_id = ?");
                param.add(appId);
                this.WHERE("table_model_id = ? ");
                param.add(tableModelId);
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        int count = 0;
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                count = rs.getInt(1);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("query countByAppId is wrong", e);
        }
        return count;
    }

    public int deleteByAppId(final String appId, final String srvModelCatalog) {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.DELETE_FROM("`allinrdm_db`.srv_model_info");
                if (StringUtils.isNotBlank((CharSequence)srvModelCatalog)) {
                    this.WHERE("srv_model_catalog = ?");
                    param.add(srvModelCatalog);
                }
                this.WHERE("app_id = ?");
                param.add(appId);
            }
        }.toString();
        PreparedStatement ps = null;
        Object rs = null;
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            int re = ps.executeUpdate();
            return re;
        }
        catch (Exception e) {
            throw new RuntimeException("deleteByAppId is wrong", e);
        }
    }

    public int updateByPk(final SrvModelInfo field) throws Exception {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.UPDATE("`allinrdm_db`.srv_model_info");
                List vals = POJOUtils.getPOJOValues((Object)((Object)field));
                for (Object[] val : vals) {
                    if (val[0].toString().equals("srv_model_id")) continue;
                    this.SET(String.format("%s = ?", val[0].toString()));
                    param.add(val[1]);
                }
                this.WHERE("srv_model_id = ?");
                param.add(field.getSrvModelId());
            }
        }.toString();
        if (param.size() < 2) {
            return 0;
        }
        PreparedStatement ps = null;
        Object rs = null;
        int result = 0;
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            result = ps.executeUpdate();
        }
        catch (Exception e) {
            throw new RuntimeException("updateByPk is wrong " + JSON.toJSONString(param), e);
        }
        return result;
    }
}

