/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.builder;

import com.irdstudio.allinapaas.design.console.types.AppType;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.BatInstBatchDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.ModelTableInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEnvInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.SrvModelInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.BatInstBatch;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.ModelTableInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasEnvInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SrvModelInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.apps.SdEnvUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.builder.AbstractBuilderPlugin;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.db.TdpAgentCommonUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.gencode.CodeGenerateConstant;
import com.irdstudio.allinapaas.executor.application.executor.core.util.date.CurrentDateUtil;
import com.irdstudio.allinapaas.portal.console.types.ArchType;
import com.irdstudio.allinrdm.dam.console.types.ObjectType;
import com.irdstudio.allinrdm.dev.console.types.SrvModelCatalogEnum;
import com.irdstudio.sdk.beans.core.util.BeanUtility;
import com.irdstudio.sdk.beans.core.util.TmModelUtil;
import com.irdstudio.sdk.beans.freemarker.bo.CodeTemplateDataBo;
import com.irdstudio.sdk.beans.freemarker.bo.ModelTableInfoBo;
import com.irdstudio.sdk.beans.freemarker.bo.TmProjectInfoBo;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;

public class TdpStartPlugin
extends AbstractBuilderPlugin {
    private PaasAppsInfo appInfo = null;
    private BatInstBatch batchInst;
    private Map<String, Object> extParam;
    private String loginUserId = "";

    @Override
    protected boolean doReadConfigureFromDB(Connection conn, String szConfIdentify) throws SQLException {
        String batchSerialNo = this.context.getSzBatchSn();
        BatInstBatchDao batInstBatchDao = new BatInstBatchDao(conn);
        this.batchInst = batInstBatchDao.queryByBatchSerialNo(batchSerialNo);
        PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
        this.appInfo = paasAppsInfoDao.queryByAppId(this.batchInst.getAppId());
        this.extParam = batInstBatchDao.getExtParam(this.batchInst);
        this.loginUserId = MapUtils.getString(this.extParam, (Object)"createUserId");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean execute() {
        boolean result = true;
        Connection conn = null;
        try {
            TmProjectInfoBo tpib;
            String subsId = this.appInfo.getSubsId();
            String subsCode = this.appInfo.getAppCode();
            conn = this.getPluginConnection();
            PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
            ModelTableInfoDao modelTableInfoDao = new ModelTableInfoDao(conn);
            SrvModelInfoDao srvModelInfoDao = new SrvModelInfoDao(conn);
            PaasAppsInfo e4aParam = new PaasAppsInfo();
            e4aParam.setSubsId(subsId);
            e4aParam.setAppType(AppType.A10.getCode());
            e4aParam.setAppTemplateId("A13SPR");
            List<PaasAppsInfo> e4aList = paasAppsInfoDao.queryPaasAppsInfoList(e4aParam);
            Map e4aMap = Collections.emptyMap();
            if (CollectionUtils.isNotEmpty(e4aList)) {
                PaasAppsInfo e4aApp = e4aList.get(0);
                Map<String, Object> e4aAppParam = this.wrapAppsParam(e4aApp.getAppId(), null, conn);
                String appCode = SdEnvUtil.wrapperAppCode(e4aApp.getAppCode());
                String package_prefix = MapUtils.getString(e4aAppParam, (Object)"package_prefix", (String)"com.irdstudio");
                String newAppCode = StringUtils.replace((String)appCode, (String)"-", (String)".");
                String replacePackage = (String)package_prefix + "." + newAppCode;
                e4aMap = BeanUtility.bean2Map((Object)((Object)e4aApp));
                e4aMap.put("filterClass", String.format("%s.facade.filter.E4AFilter", replacePackage));
            }
            List<ModelTableInfo> tableList = modelTableInfoDao.queryModelTableInfoList(this.appInfo.getAppId());
            ArrayList<Object> ctdbList = new ArrayList<Object>(tableList.size());
            ArrayList<Object> tableCodeList = new ArrayList<Object>();
            if (CollectionUtils.isNotEmpty(tableList)) {
                for (ModelTableInfo table : tableList) {
                    int serNum;
                    CodeTemplateDataBo bo = new CodeTemplateDataBo();
                    String TablebjectType2 = String.valueOf(table.getObjectType());
                    tpib = new TmProjectInfoBo();
                    tpib.setProjectId(this.appInfo.getAppCode());
                    tpib.setProjectCode(this.appInfo.getAppCode());
                    tpib.setProjectName(this.appInfo.getAppName());
                    tpib.setProjectType(TablebjectType2);
                    bo.setTmProjectInfo(tpib);
                    bo.getEnvBo().setAuthor(this.loginUserId);
                    bo.getEnvBo().setCurrentDate(CurrentDateUtil.getTodayDate());
                    bo.getEnvBo().setDesc(String.format("%s Dao %s-%s", this.appInfo.getAppName(), table.getObjectName(), table.getObjectCode()));
                    ModelTableInfoBo tableBo = this.generateTableBO(table, conn);
                    bo.setMainTableModel(tableBo);
                    bo.getMapData().put("tableModelCode", table.getObjectCode());
                    this.wrapAppsParam(this.appInfo.getAppId(), bo, conn);
                    ctdbList.add(bo);
                    if (table.getObjectType().intValue() == Integer.valueOf(ObjectType.Inout.getCode()).intValue() || (serNum = srvModelInfoDao.countByTableModelId(this.appInfo.getAppId(), table.getObjectId())) == 0 && table.getObjectType().intValue() == Integer.valueOf(ObjectType.Data.getCode()).intValue()) continue;
                    Object serviceClassName = TmModelUtil.tableCodeToClassName((String)table.getObjectCode());
                    serviceClassName = StringUtils.uncapitalize((String)serviceClassName);
                    tableCodeList.add(serviceClassName);
                }
            }
            SrvModelInfo modelParam = new SrvModelInfo();
            modelParam.setAppId(this.appInfo.getAppId());
            List<SrvModelInfo> modelList = srvModelInfoDao.querySrvModelInfoList(modelParam, Arrays.asList(SrvModelCatalogEnum.TradeServer.getCode(), SrvModelCatalogEnum.BackServer.getCode()));
            if (CollectionUtils.isNotEmpty(modelList)) {
                for (SrvModelInfo model : modelList) {
                    String tableClassName = TmModelUtil.modelCodeToClassName((String)model.getSrvModelCode());
                    tableClassName = StringUtils.uncapitalize((String)tableClassName);
                    tableCodeList.add(tableClassName);
                }
            }
            CodeTemplateDataBo ctdb = null;
            if (CollectionUtils.isEmpty(ctdbList)) {
                CodeTemplateDataBo bo = new CodeTemplateDataBo();
                tpib = new TmProjectInfoBo();
                tpib.setProjectId(this.appInfo.getAppCode());
                tpib.setProjectCode(this.appInfo.getAppCode());
                tpib.setProjectName(this.appInfo.getAppName());
                bo.setTmProjectInfo(tpib);
                bo.getEnvBo().setAuthor(this.loginUserId);
                bo.getEnvBo().setCurrentDate(CurrentDateUtil.getTodayDate());
                bo.getEnvBo().setDesc(String.format("%s start", this.appInfo.getAppName()));
                this.wrapAppsParam(this.appInfo.getAppId(), bo, conn);
                ctdb = bo;
            } else {
                ctdb = (CodeTemplateDataBo)ctdbList.get(0);
            }
            String package_prefix = this.getPackagePrefix(ctdb);
            ctdb.getMapData().put("tableModelCode", this.appInfo.getAppCode());
            ctdb.getMapData().put("tableCodeToClassName", TmModelUtil.tableCodeToClassName((String)this.appInfo.getAppCode()));
            ctdb.getMapData().put("database_name", TdpAgentCommonUtil.getAppDatabaseName(this.appInfo));
            ArrayList appCodes = new ArrayList();
            List<PaasAppsInfo> referenceApps = paasAppsInfoDao.queryReferenceApp(this.appInfo.getAppId());
            if (CollectionUtils.isNotEmpty(referenceApps)) {
                List<String> compTypes = Arrays.asList(AppType.A10.getCode(), AppType.A10.getCode());
                for (PaasAppsInfo paas : referenceApps) {
                    if (compTypes.contains(paas.getAppType())) continue;
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("appCode", paas.getAppCode());
                    appCodes.add(map);
                }
            }
            ctdb.getMapData().put("appCodes", appCodes);
            ctdb.getMapData().put("hasAppCode", appCodes.size() > 0 ? "Y" : "N");
            if (!StringUtils.equals((CharSequence)AppType.M81.getCode(), (CharSequence)this.appInfo.getAppType())) {
                ctdb.getMapData().put("e4a", e4aMap);
                this.produceCodeFile("XXXApplication.java", "start", "src/main/java/" + package_prefix + "/" + TdpStartPlugin.formatClassPath(subsCode) + "/start/", this.appInfo, ctdb);
            }
            if (AppType.M81.getCode().equals(this.appInfo.getAppType())) {
                this.wrapEnvInfoParam(this.batchInst.getEnvId(), this.appInfo, ctdb, conn);
                this.produceCodeFile("application.yml", "start", "src/main/resources/", this.appInfo, ctdb);
                CodeTemplateDataBo pomBo = new CodeTemplateDataBo();
                TmProjectInfoBo pomTp = new TmProjectInfoBo();
                pomTp.setProjectId(this.appInfo.getAppCode());
                pomTp.setProjectCode(this.appInfo.getAppCode());
                pomTp.setProjectName(this.appInfo.getAppName());
                pomBo.setTmProjectInfo(pomTp);
                this.wrapAppsParam(this.appInfo.getAppId(), pomBo, conn);
                pomBo.getMapData().put("e4a", e4aMap);
                this.produceCodeFile("start-pom.xml", "", "start-", "start", "", this.appInfo, pomBo);
                this.produceCodeFile("project-pom.xml", "", "project-", null, "", this.appInfo, pomBo);
                this.produceCodeFile("logback-spring.xml", "", "", "start", "src/main/resources/", this.appInfo, pomBo);
            } else {
                ctdb.getMapData().put("MethodDealList", tableCodeList);
                ArchType archTypeEnum = ArchType.get((String)this.appInfo.getArchType());
                if (StringUtils.isNotBlank((CharSequence)archTypeEnum.getXmlPrefix())) {
                    String xmlPrefix = archTypeEnum != null ? archTypeEnum.getXmlPrefix() : ArchType.Sofa.getXmlPrefix();
                    this.produceCodeFile(xmlPrefix + "-provider-XXX.xml", this.appInfo.getAppCode(), CodeGenerateConstant.TABLE_VAR_NOSPLIT, "start", "src/main/resources/" + xmlPrefix + "/", this.appInfo, ctdb);
                }
                PaasEnvInfoDao paasEnvInfoDao = new PaasEnvInfoDao(conn);
                List<PaasEnvInfo> envList = paasEnvInfoDao.queryPaasEnvInfo(null);
                this.wrapEnvInfoParam("dev", this.appInfo, ctdb, conn);
                this.wrapComponentParams("dev", this.appInfo, ctdb, conn);
                String appNameUnicode = StringEscapeUtils.escapeJava((String)this.appInfo.getAppName());
                ctdb.getMapData().put("appNameUnicode", appNameUnicode);
                this.produceCodeFile("application.properties", "start", "src/main/resources/", this.appInfo, ctdb);
                CodeTemplateDataBo pomBo = new CodeTemplateDataBo();
                TmProjectInfoBo pomTp = new TmProjectInfoBo();
                pomTp.setProjectId(this.appInfo.getAppCode());
                pomTp.setProjectCode(this.appInfo.getAppCode());
                pomTp.setProjectName(this.appInfo.getAppName());
                pomBo.setTmProjectInfo(pomTp);
                this.wrapAppsParam(this.appInfo.getAppId(), pomBo, conn);
                pomBo.getMapData().put("e4a", e4aMap);
                this.produceCodeFile("start-pom.xml", "", "start-", "start", "", this.appInfo, pomBo);
                this.produceCodeFile("logback-spring.xml", "", "", "start", "src/main/resources/", this.appInfo, pomBo);
                this.produceCodeFile("DruidConfig.java", "", "", "start", "src/main/java/" + package_prefix + "/" + TdpStartPlugin.formatClassPath(subsCode) + "/start/config/", this.appInfo, pomBo);
                this.produceCodeFile("TransactionAspConfig.java", "", "", "start", "src/main/java/" + package_prefix + "/" + TdpStartPlugin.formatClassPath(subsCode) + "/start/config/", this.appInfo, pomBo);
            }
            if (conn == null) return result;
        }
        catch (SQLException e) {
            this.logger.error("\u6267\u884c SQL \u5f02\u5e38", e);
            result = false;
            if (conn == null) return result;
            this.closePluginConnection(conn);
            return result;
        }
        catch (Exception e2) {
            this.logger.error(e2.getMessage(), e2);
            result = false;
            if (conn == null) return result;
            {
                catch (Throwable throwable) {
                    if (conn == null) throw throwable;
                    this.closePluginConnection(conn);
                    throw throwable;
                }
            }
            this.closePluginConnection(conn);
            return result;
        }
        this.closePluginConnection(conn);
        return result;
    }
}

