/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.deliver;

import com.alibaba.fastjson.JSON;
import com.irdstudio.allinapaas.design.console.types.AppCategory;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.BatBatchInfoConfigDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.BatInstBatchDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsParamDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasDeployInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEcsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEnvParamDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.BatBatchInfoConfig;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.BatInstBatch;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsParam;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasDeployInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasEcsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasEnvParam;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.AbstractPlugin;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.apps.SdEnvUtil;
import com.irdstudio.sdk.beans.ssh.io.SSHOutputPrinter;
import com.irdstudio.sdk.beans.ssh.utils.RemoteSSHClient;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class OpsRemoteAppOpCommonPlugin
extends AbstractPlugin {
    private BatInstBatch devLog;
    private Map<String, Object> extParam;
    private String actionId;
    private String actionShell;
    private String envId;
    private PaasAppsInfo appInfo;
    protected SSHOutputPrinter sshPrinter = new SSHOutputPrinter(){

        public void print(String line) {
            if (OpsRemoteAppOpCommonPlugin.this.logger != null) {
                OpsRemoteAppOpCommonPlugin.this.logger.info(line);
            } else {
                System.out.println(line);
            }
        }

        public void printError(String line) {
            if (OpsRemoteAppOpCommonPlugin.this.logger != null) {
                OpsRemoteAppOpCommonPlugin.this.logger.error(line);
            } else {
                System.err.println(line);
            }
        }
    };

    @Override
    protected boolean doReadConfigureFromDB(Connection conn, String szConfIdentify) throws SQLException {
        String batchSerialNo = this.context.getSzBatchSn();
        BatInstBatchDao batInstBatchDao = new BatInstBatchDao(conn);
        BatBatchInfoConfigDao batBatchInfoConfigDao = new BatBatchInfoConfigDao(conn);
        this.devLog = batInstBatchDao.queryByBatchSerialNo(batchSerialNo);
        this.envId = this.devLog.getEnvId();
        BatBatchInfoConfig batchInfo = batBatchInfoConfigDao.queryWithKeys(this.context.getSzBatchId());
        this.extParam = batInstBatchDao.getExtParam(this.devLog);
        this.actionId = MapUtils.getString(this.extParam, (Object)"actionId");
        this.actionShell = MapUtils.getString(this.extParam, (Object)"actionShell");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        boolean flag = true;
        Connection conn = null;
        try {
            conn = this.getPluginConnection();
            PaasEcsInfoDao paasEcsInfoDao = new PaasEcsInfoDao(conn);
            PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
            PaasAppsParamDao paasAppsParamDao = new PaasAppsParamDao(conn);
            PaasDeployInfoDao paasDeployInfoDao = new PaasDeployInfoDao(conn);
            this.appInfo = paasAppsInfoDao.queryByAppId(this.devLog.getAppId());
            if (this.appInfo == null) {
                this.appInfo = new PaasAppsInfo();
                this.appInfo.setSubsId(this.devLog.getSubsId());
                this.appInfo.setAppId(this.devLog.getAppId());
                this.appInfo.setAppCode(this.devLog.getAppCode());
                this.appInfo.setAppName(this.devLog.getAppName());
            }
            PaasAppsParam moduleParam = paasAppsParamDao.queryPaasAppsParamByCode(this.devLog.getAppId(), "module");
            Map extParam = (Map)JSON.parseObject((String)this.devLog.getExtParam(), Map.class);
            String ecsId = MapUtils.getString((Map)extParam, (Object)"ecsId");
            String ecsIp = MapUtils.getString((Map)extParam, (Object)"ecsIp");
            String ecsName = MapUtils.getString((Map)extParam, (Object)"ecsName");
            String appDeployId = MapUtils.getString((Map)extParam, (Object)"appDeployId");
            String envId = MapUtils.getString((Map)extParam, (Object)"envId");
            PaasEcsInfo ecsInfo = paasEcsInfoDao.queryByPk(ecsId);
            String bashFile = this.actionShell;
            String appState = "";
            appState = StringUtils.endsWith((CharSequence)this.devLog.getBatchId().toLowerCase(), (CharSequence)"start") ? "R" : (StringUtils.endsWith((CharSequence)this.devLog.getBatchId().toLowerCase(), (CharSequence)"stop") ? "S" : "R");
            PaasEnvParamDao paasEnvParamDao = new PaasEnvParamDao(conn);
            PaasEnvParam deployRoot = paasEnvParamDao.queryByCode("deploy_root", envId);
            String deployRootDir = this.getDeployRootDir(deployRoot.getParamValue());
            flag = StringUtils.equalsAny((CharSequence)this.appInfo.getAppCategory(), (CharSequence[])new CharSequence[]{AppCategory.Middleware.getCode()}) ? this.middleOpsHandler(ecsInfo, deployRootDir, bashFile) : this.appOpsHandler(ecsInfo, deployRootDir, bashFile, moduleParam);
            PaasDeployInfo deployInfo = new PaasDeployInfo();
            deployInfo.setAppDeployId(appDeployId);
            deployInfo = paasDeployInfoDao.queryByPk(deployInfo);
            deployInfo.setAppState(appState);
            paasDeployInfoDao.updateByPk(deployInfo);
        }
        catch (Exception e) {
            this.logger.error("\u5e94\u7528\u8fd0\u7ef4\u547d\u4ee4\u901a\u7528\u6267\u884c\u63d2\u4ef6\u5931\u8d25" + e.getMessage(), e);
            flag = false;
        }
        finally {
            if (conn != null) {
                this.closePluginConnection(conn);
            }
        }
        return flag;
    }

    private String getDeployRootDir(String deployRootDir) {
        if (deployRootDir == null) {
            deployRootDir = "/agent";
        }
        return deployRootDir;
    }

    private boolean appOpsHandler(PaasEcsInfo ecsInfo, String deployRootDir, String bashFile, PaasAppsParam moduleParam) throws Exception {
        this.logger.info("\u8fdc\u7a0b\u64cd\u4f5cLinux\u670d\u52a1\u5668 " + ecsInfo.getEcsIp());
        RemoteSSHClient rsc = new RemoteSSHClient(ecsInfo.getEcsIp(), ecsInfo.getEcsLoginUser(), ecsInfo.getEcsLoginPwd());
        boolean loginFlag = rsc.connect();
        if (!loginFlag) {
            this.logger.error("\u767b\u9646\u670d\u52a1\u5668\u5931\u8d25");
            throw new RuntimeException("\u767b\u9646\u670d\u52a1\u5668\u5931\u8d25");
        }
        if (!rsc.fileExists("/" + deployRootDir)) {
            rsc.executeCommand("mkdir /" + deployRootDir, this.sshPrinter);
        }
        if (!rsc.fileExists("/" + deployRootDir + "/" + bashFile)) {
            String appTemplateId = this.appInfo.getAppTemplateId();
            String localAgentPath = appTemplateId + "-template" + File.separator + appTemplateId + "-script";
            rsc.upload(localAgentPath + bashFile, "/" + deployRootDir);
            rsc.executeCommand("chmod 777 /" + deployRootDir + "/" + bashFile, this.sshPrinter);
        }
        String appCode = SdEnvUtil.wrapperAppCode(this.appInfo.getAppCode());
        String startModelName = String.format("%s-%s", appCode, "start");
        if (moduleParam != null && StringUtils.isNotBlank((CharSequence)moduleParam.getParamValue())) {
            startModelName = moduleParam.getParamValue();
        }
        if (StringUtils.equals((CharSequence)AppCategory.Middleware.getCode(), (CharSequence)this.appInfo.getAppCategory())) {
            startModelName = deployRootDir + "/" + appCode;
        }
        this.logger.info("\u6267\u884c\u547d\u4ee4 " + deployRootDir + String.format("%s  %s %s", bashFile, startModelName, this.envId));
        int status = rsc.executeCommand("cd " + deployRootDir + String.format(" && bash ./%s  %s %s", bashFile, startModelName, this.envId), this.sshPrinter);
        if (status == -1) {
            this.logger.info("\u6267\u884c\u53d1\u5e03\u547d\u4ee4 /" + deployRootDir + "/" + bashFile + " \u72b6\u6001 " + status);
            return false;
        }
        return true;
    }

    private boolean middleOpsHandler(PaasEcsInfo ecsInfo, String deployRootDir, String bashFile) throws Exception {
        this.logger.info("\u8fdc\u7a0b\u64cd\u4f5cLinux\u670d\u52a1\u5668 " + ecsInfo.getEcsIp());
        RemoteSSHClient client = new RemoteSSHClient(ecsInfo.getEcsIp(), ecsInfo.getEcsLoginUser(), ecsInfo.getEcsLoginPwd());
        boolean loginFlag = client.connect();
        if (!loginFlag) {
            this.logger.error("\u767b\u9646\u670d\u52a1\u5668\u5931\u8d25");
            throw new RuntimeException("\u767b\u9646\u670d\u52a1\u5668\u5931\u8d25");
        }
        String appCode = SdEnvUtil.wrapperAppCode(this.appInfo.getAppCode());
        client.executeCommand(String.format("chmod 755 %s/%s/%s", deployRootDir, appCode, bashFile), this.sshPrinter);
        this.logger.info(String.format("\u6267\u884c\u811a\u672c %s/%s/%s %s/%s", deployRootDir, appCode, bashFile, deployRootDir, appCode));
        client.executeCommand(String.format("bash %s/%s/%s %s/%s", deployRootDir, appCode, bashFile, deployRootDir, appCode), this.sshPrinter);
        return true;
    }
}

