/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.deploy;

import com.alibaba.fastjson.JSON;
import com.irdstudio.allinapaas.deliver.console.facade.BatBatchInfoConfigService;
import com.irdstudio.allinapaas.deliver.console.facade.PaasEcsInfoService;
import com.irdstudio.allinapaas.deliver.console.facade.PluginDeployWebService;
import com.irdstudio.allinapaas.deliver.console.facade.dto.BatBatchInfoConfigDTO;
import com.irdstudio.allinapaas.deliver.console.facade.dto.PaasEcsInfoDTO;
import com.irdstudio.allinapaas.deliver.console.facade.dto.PluginDeployWebDTO;
import com.irdstudio.allinapaas.design.console.types.AppCategory;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.BatInstBatchDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsParamDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasDeployInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEcsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEnvInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEnvParamDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.BatInstBatch;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasDeployInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasEcsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasEnvInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasEnvParam;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.AbstractPlugin;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.apps.SdEnvUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.common.SSubsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.common.SSubsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.util.date.CurrentDateUtil;
import com.irdstudio.allinapaas.executor.facade.dto.ValidateRtnDTO;
import com.irdstudio.allinapaas.portal.console.types.YesOrNO;
import com.irdstudio.allintpaas.sdk.sequence.facade.operation.SeqInstInfoService;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import com.irdstudio.sdk.beans.ssh.io.SSHOutputPrinter;
import com.irdstudio.sdk.beans.ssh.utils.RemoteSSHClient;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class AppDeployFontWebPlugin
extends AbstractPlugin {
    private PaasAppsInfo appInfo = null;
    private SSubsInfo sSubsInfo = null;
    private PaasEnvInfo envInfo = null;
    protected SSHOutputPrinter sshPrinter = new SSHOutputPrinter(){

        public void print(String line) {
            if (AppDeployFontWebPlugin.this.logger != null) {
                AppDeployFontWebPlugin.this.logger.info(line);
            } else {
                System.out.println(line);
            }
        }

        public void printError(String line) {
            if (AppDeployFontWebPlugin.this.logger != null) {
                AppDeployFontWebPlugin.this.logger.error(line);
            } else {
                System.err.println(line);
            }
        }
    };

    @Override
    public boolean validate(String batchId, String taskId, ValidateRtnDTO message) {
        PluginDeployWebService service = (PluginDeployWebService)SpringContextUtils.getBean(PluginDeployWebService.class);
        PluginDeployWebDTO param = new PluginDeployWebDTO();
        param.setPluginConfId(taskId);
        param = (PluginDeployWebDTO)service.queryByPk((Object)param);
        if (param == null) {
            return false;
        }
        message.getMessage().addAll(param.validate());
        boolean flag = CollectionUtils.isEmpty((Collection)message.getMessage());
        if (flag) {
            BatBatchInfoConfigService batBatchInfoConfigService = (BatBatchInfoConfigService)SpringContextUtils.getBean(BatBatchInfoConfigService.class);
            BatBatchInfoConfigDTO batchInfo = new BatBatchInfoConfigDTO();
            batchInfo.setBatchId(batchId);
            batchInfo = (BatBatchInfoConfigDTO)batBatchInfoConfigService.queryByPk((Object)batchInfo);
            if (batchInfo == null) {
                return false;
            }
            PaasEcsInfoService paasEcsInfoService = (PaasEcsInfoService)SpringContextUtils.getBean(PaasEcsInfoService.class);
            PaasEcsInfoDTO ecsParam = new PaasEcsInfoDTO();
            ecsParam.setSubsId(batchInfo.getSubsId());
            ecsParam.setAppId(batchInfo.getAppId());
            ecsParam.setEnvId(batchInfo.getEnvId());
            List ecsList = paasEcsInfoService.queryListByPage((Object)ecsParam);
            if (CollectionUtils.isEmpty((Collection)ecsList)) {
                message.getMessage().add("\u670d\u52a1\u5668\u672a\u914d\u7f6e");
                flag = false;
            }
        }
        return flag;
    }

    @Override
    public boolean copyConfig(String batchId, String taskId, String newTaskId) {
        PluginDeployWebService service = (PluginDeployWebService)SpringContextUtils.getBean(PluginDeployWebService.class);
        PluginDeployWebDTO param = new PluginDeployWebDTO();
        param.setPluginConfId(taskId);
        param = (PluginDeployWebDTO)service.queryByPk((Object)param);
        if (param == null) {
            return true;
        }
        param.setPluginConfId(newTaskId);
        int re = service.insert((Object)param);
        return re == 1;
    }

    @Override
    protected boolean doReadConfigureFromDB(Connection conn, String szConfIdentify) throws SQLException {
        String batchSerialNo = this.context.getSzBatchSn();
        PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
        this.appInfo = paasAppsInfoDao.queryByBatchSerialNo(batchSerialNo);
        SSubsInfoDao sSubsInfoDao = new SSubsInfoDao(conn);
        this.sSubsInfo = sSubsInfoDao.querySSubsInfoWithKeys(this.appInfo.getSubsId());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        this.logger.info("\u90e8\u7f72\u81ea\u5b9a\u4e49 web \u5e94\u7528\uff0c\u90e8\u7f72\u5e94\u7528:" + this.appInfo.getAppCode());
        Connection conn = null;
        try {
            conn = this.getPluginConnection();
            BatInstBatchDao batInstBatchDao = new BatInstBatchDao(conn);
            BatInstBatch batInstBatch = batInstBatchDao.queryByBatchSerialNo(this.context.getSzBatchSn());
            String currEnvId = batInstBatch.getEnvId();
            PaasEnvInfoDao paasEnvInfoDao = new PaasEnvInfoDao(conn);
            this.envInfo = paasEnvInfoDao.queryByPk(currEnvId);
            PaasDeployInfoDao paasDeployInfoDao = new PaasDeployInfoDao(conn);
            PaasEcsInfoDao paasEcsInfoDao = new PaasEcsInfoDao(conn);
            PaasEcsInfo ecsParam = new PaasEcsInfo();
            PaasEnvParamDao paasEnvParamDao = new PaasEnvParamDao(conn);
            PaasEnvParam deployRoot = paasEnvParamDao.queryByCode("deploy_root", currEnvId);
            String deployRootDir = deployRoot.getParamValue();
            ecsParam.setSubsId(this.appInfo.getSubsId());
            ecsParam.setAppId(this.appInfo.getAppId());
            ecsParam.setEnvId(currEnvId);
            List<PaasEcsInfo> ecsList = paasEcsInfoDao.queryPaasEcsInfo(ecsParam);
            List<PaasEcsInfo> webList = paasEcsInfoDao.queryPaasEcsInfo(ecsParam);
            ecsList.addAll(webList);
            for (PaasEcsInfo paasEcsInfo : ecsList) {
                this.logger.info(String.format("\u5f00\u59cb\u90e8\u7f72\u5e94\u7528%s\u5230\u670d\u52a1\u5668%s,\u7aef\u53e3%s", paasEcsInfo.getAppName(), paasEcsInfo.getEcsIp(), paasEcsInfo.getEcsPort()));
                boolean bl = this.deployFontWeb(paasEcsInfo, deployRootDir, currEnvId, paasDeployInfoDao, conn);
            }
            PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
            this.appInfo.setAppActionState("DPL");
            if (StringUtils.isNotBlank((String)this.appInfo.getAppVersion())) {
                String version = this.appInfo.getAppVersion();
                Object[] versions = StringUtils.split((String)version, (String)".");
                versions[versions.length - 1] = String.valueOf(Integer.valueOf(versions[versions.length - 1]) + 1);
                version = StringUtils.join((Object[])versions, (String)".");
                this.appInfo.setAppVersion(version);
            } else {
                this.appInfo.setAppVersion("0.0.1");
            }
            paasAppsInfoDao.updateByPk(this.appInfo);
            this.cleanBuildDir();
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (conn != null) {
                this.closePluginConnection(conn);
            }
        }
        return true;
    }

    private boolean cleanBuildDir() {
        String rootPath = this.context.getBatBatchSource().getRepoLocalPath();
        String appCode = SdEnvUtil.wrapperAppCode(this.appInfo.getAppCode());
        File targetDir = new File(rootPath + File.separator);
        return FileUtils.deleteQuietly((File)targetDir);
    }

    private boolean deployFontWeb(PaasEcsInfo paasEcsInfo, String deployRootDir, String currEnvId, PaasDeployInfoDao paasDeployInfoDao, Connection conn) throws Exception {
        PaasAppsParamDao paasAppsParamDao = new PaasAppsParamDao(conn);
        RemoteSSHClient sshClient = new RemoteSSHClient(paasEcsInfo.getEcsIp(), paasEcsInfo.getEcsLoginUser(), paasEcsInfo.getEcsLoginPwd());
        boolean loginFlag = sshClient.connect();
        if (!loginFlag) {
            this.logger.error("\u767b\u9646\u670d\u52a1\u5668\u5931\u8d25");
            return loginFlag;
        }
        PluginDeployWebService service = (PluginDeployWebService)SpringContextUtils.getBean(PluginDeployWebService.class);
        PluginDeployWebDTO param = new PluginDeployWebDTO();
        param.setPluginConfId(this.context.getSzTaskId());
        param = (PluginDeployWebDTO)service.queryByPk((Object)param);
        if (StringUtils.isBlank((String)param.getDeployPath())) {
            this.logger.error("\u65e0\u6cd5\u83b7\u53d6WEB\u5e94\u7528\u90e8\u7f72\u76ee\u5f55");
            return false;
        }
        String deployPath = param.getDeployPath();
        String deploySrc = param.getDeploySrc();
        String rootPath = this.context.getBatBatchSource().getRepoLocalPath();
        String appCode = SdEnvUtil.wrapperAppCode(this.appInfo.getAppCode());
        if (!sshClient.fileExists(deployPath)) {
            sshClient.executeCommand("mkdir -p " + deployPath, this.sshPrinter);
        }
        File rootDir = new File(rootPath + File.separator);
        if (StringUtils.isNotBlank((String)deploySrc)) {
            rootDir = new File(rootDir, deploySrc);
        }
        this.uploadDir(rootDir, deployPath, sshClient);
        if (conn.isClosed()) {
            this.closePluginConnection(conn);
            conn = this.getPluginConnection();
            paasDeployInfoDao = new PaasDeployInfoDao(conn);
        }
        this.updateDeployPath(currEnvId, this.appInfo, paasEcsInfo, deployRootDir + "/" + deployPath, null, paasDeployInfoDao);
        if (StringUtils.equals((String)this.appInfo.getLinkedSaas(), (String)YesOrNO.YES.getCode())) {
            String url = String.format("%s/api/s/subs/info/sync", this.envInfo.getEnvAppsPortal());
            HashMap<String, Object> requestData = new HashMap<String, Object>();
            requestData.put("sub", (Object)this.sSubsInfo);
            requestData.put("app", (Object)this.appInfo);
            String appAccessUrl = this.getAppAccessUrl(this.appInfo, paasEcsInfo);
            requestData.put("appAccessUrl", appAccessUrl);
            String resp = this.requestOpenApi(url, requestData);
            this.logger.info("\u63a8\u9001\u95e8\u6237\u7ed3\u679c:" + resp);
        }
        return true;
    }

    private void uploadDir(File root, String targetPath, RemoteSSHClient sshClient) throws Exception {
        if (root.isDirectory()) {
            File[] subFiles;
            for (File subFile : subFiles = root.listFiles()) {
                if (subFile.getName().equals(".git")) continue;
                if (subFile.isDirectory()) {
                    this.uploadDir(subFile, targetPath + "/" + subFile.getName(), sshClient);
                    continue;
                }
                if (!sshClient.fileExists(targetPath)) {
                    sshClient.executeCommand("mkdir -p " + targetPath, this.sshPrinter);
                }
                sshClient.uploadQuietly(subFile.getAbsolutePath(), targetPath + "/" + subFile.getName());
            }
        } else {
            if (!sshClient.fileExists(targetPath)) {
                sshClient.executeCommand("mkdir -p " + targetPath, this.sshPrinter);
            }
            sshClient.upload(root.getAbsolutePath(), targetPath + "/" + root.getName());
        }
    }

    private void updateDeployPath(String envId, PaasAppsInfo appInfo, PaasEcsInfo ecs, String deployPath, PaasEnvParam loggingFile, PaasDeployInfoDao paasDeployInfoDao) throws Exception {
        boolean flag = true;
        PaasDeployInfo deployInfo = paasDeployInfoDao.queryByAppId(appInfo.getAppId(), envId);
        if (deployInfo == null) {
            deployInfo = new PaasDeployInfo();
            flag = false;
            SeqInstInfoService seqService = (SeqInstInfoService)SpringContextUtils.getBean(SeqInstInfoService.class);
            deployInfo.setAppDeployId(seqService.nextSequence("PAAS-INST-ID", appInfo.getSubsId()));
        }
        deployInfo.setSubsId(appInfo.getSubsId());
        deployInfo.setAppId(appInfo.getAppId());
        deployInfo.setAppName(appInfo.getAppCode());
        deployInfo.setAppCnname(appInfo.getAppName());
        deployInfo.setAppVersion(appInfo.getAppVersion());
        deployInfo.setAppType(appInfo.getAppType());
        String appCode = SdEnvUtil.wrapperAppCode(this.appInfo.getAppCode());
        deployInfo.setAppDeployPath(deployPath);
        deployInfo.setEnvId(envId);
        deployInfo.setAppOrder(0);
        deployInfo.setEcsId(ecs.getEcsId());
        deployInfo.setEcsIp(ecs.getEcsIp());
        deployInfo.setEcsName(ecs.getEcsName());
        deployInfo.setEcsRegion(ecs.getEcsRegionId());
        deployInfo.setAppPort(ecs.getEcsPort());
        deployInfo.setAppState("R");
        deployInfo.setOperUserid("admin");
        deployInfo.setOperTime(CurrentDateUtil.getTodayDateEx2());
        if (flag) {
            paasDeployInfoDao.updateByPk(deployInfo);
        } else {
            paasDeployInfoDao.insertPaasDeployInfo(deployInfo);
        }
    }

    public String requestOpenApi(String url, Object param) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpPost postMethod = new HttpPost(url);
        HttpResponse response = null;
        try {
            String reqJson = JSON.toJSONString((Object)param);
            StringEntity entity = new StringEntity(reqJson, ContentType.APPLICATION_JSON);
            postMethod.setEntity((HttpEntity)entity);
            response = httpClient.execute((HttpUriRequest)postMethod);
            String json = EntityUtils.toString((HttpEntity)response.getEntity());
            return json;
        }
        catch (IOException e) {
            e.printStackTrace();
            this.logger.error(e.getMessage(), e);
            return null;
        }
    }

    private String getAppAccessUrl(PaasAppsInfo appInfo, PaasEcsInfo ecs) {
        String ip;
        String url = "";
        String server_port = "";
        if (StringUtils.isNotBlank((String)ecs.getEcsPort())) {
            server_port = ecs.getEcsPort();
        }
        int port = Integer.valueOf(server_port);
        String serverName = "";
        if (StringUtils.equals((String)appInfo.getAppCategory(), (String)AppCategory.BusinessApp.getCode())) {
            serverName = SdEnvUtil.wrapperAppCode(this.appInfo.getAppCode());
        }
        if (StringUtils.isBlank((String)(ip = ecs.getEcsOutIp()))) {
            ip = ecs.getEcsIp();
        }
        url = String.format("http://%s:%s/%s", ip, port, serverName);
        return url;
    }
}

