/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.deploy;

import com.irdstudio.allinapaas.executor.application.executor.core.dao.BatInstBatchDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.DictOptionEnumDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.DictOptionInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsParamDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasDeployInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEcsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.BatInstBatch;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.DictOptionEnum;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.DictOptionInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsParam;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasEcsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.AbstractPlugin;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.db.TdpAgentCommonUtil;
import com.irdstudio.sdk.beans.db.util.MyJdbcUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class AppDicDataDeployPlugin
extends AbstractPlugin {
    private PaasAppsInfo appInfo = null;

    @Override
    protected boolean doReadConfigureFromDB(Connection conn, String szConfIdentify) throws SQLException {
        String batchSerialNo = this.context.getSzBatchSn();
        PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
        this.appInfo = paasAppsInfoDao.queryByBatchSerialNo(batchSerialNo);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        this.logger.info("\u521d\u59cb\u5316\u5e94\u7528[{" + this.appInfo.getAppId() + "}]\u7684\u6570\u636e\u5e93...");
        Connection conn = null;
        Connection localConn = null;
        try {
            localConn = this.getPluginConnection();
            Map<String, Object> appsParam = this.queryAppsParam(this.appInfo.getAppId(), localConn);
            String database_username = MapUtils.getString(appsParam, (Object)"database_username", (String)"root");
            appsParam.put("database_username", database_username);
            String database_password = MapUtils.getString(appsParam, (Object)"database_password", (String)"Zaqpwdxsw@2");
            appsParam.put("database_password", database_password);
            BatInstBatchDao batInstBatchDao = new BatInstBatchDao(localConn);
            BatInstBatch batInstBatch = batInstBatchDao.queryByBatchSerialNo(this.context.getSzBatchSn());
            String currEnvId = batInstBatch.getEnvId();
            PaasDeployInfoDao paasDeployInfoDao = new PaasDeployInfoDao(localConn);
            PaasEcsInfoDao paasEcsInfoDao = new PaasEcsInfoDao(localConn);
            PaasEcsInfo ecsParam = new PaasEcsInfo();
            ecsParam.setSubsId(this.appInfo.getSubsId());
            ecsParam.setAppId(this.appInfo.getAppId());
            ecsParam.setEnvId(currEnvId);
            List<PaasEcsInfo> ecsList = paasEcsInfoDao.queryPaasEcsInfo(ecsParam);
            for (PaasEcsInfo ecs : ecsList) {
                this.logger.info(String.format("\u5f00\u59cb\u521b\u5efa\u6570\u636e\u5e93%s\u5230\u670d\u52a1\u5668%s,\u7aef\u53e3%s", this.appInfo.getAppCode(), ecs.getEcsIp(), "3306"));
                Connection createConn = null;
                try {
                    appsParam.put("database_ip", ecs.getEcsIp());
                    conn = TdpAgentCommonUtil.getNativeConnection(this.appInfo, appsParam);
                    this.logger.info("\u521d\u59cb\u5e94\u7528{" + this.appInfo.getAppId() + "}\u7684\u57fa\u7840\u6570\u636e");
                    DictOptionInfoDao dictOptionInfoDao = new DictOptionInfoDao(localConn);
                    DictOptionEnumDao dictOptionEnumDao = new DictOptionEnumDao(localConn);
                    List<DictOptionInfo> doivList = dictOptionInfoDao.queryDictOptionInfoListByAppId(this.appInfo.getAppId());
                    PreparedStatement ps = MyJdbcUtil.createPrepareStatement((Connection)conn, (String)"insert into s_dic(enname,cnname,opttype,memo) values(?,?,?,?)");
                    for (DictOptionInfo doiv : doivList) {
                        this.checkAndDelSDic(conn, doiv.getDictCode());
                        List<DictOptionEnum> doevList = dictOptionEnumDao.queryDictOptionEnumListByDictId(doiv.getDictId());
                        for (DictOptionEnum doev : doevList) {
                            try {
                                ps.setString(1, doev.getOptionCode());
                                ps.setString(2, doev.getOptionName());
                                ps.setString(3, doiv.getDictCode());
                                ps.setString(4, doiv.getDictName());
                                ps.execute();
                            }
                            catch (SQLException e) {
                                this.logger.error("\u521d\u59cb\u5316\u5e94\u7528{" + this.appInfo.getAppCode() + "}\u7684\u6570\u636e\u5b57\u5178\u51fa\u9519!");
                                e.printStackTrace();
                            }
                        }
                    }
                    MyJdbcUtil.close(null, null, (PreparedStatement)ps);
                }
                catch (Exception ie) {
                    this.logger.error(ie.getMessage());
                }
                finally {
                    if (createConn == null) continue;
                    MyJdbcUtil.close(createConn);
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u521d\u59cb\u5316\u5e94\u7528\u6570\u636e\u5e93\u51fa\u73b0\u5f02\u5e38\uff01", e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (localConn != null) {
                this.closePluginConnection(localConn);
            }
        }
        return true;
    }

    private void checkAndDelSDic(Connection connection, String optType) {
        this.logger.info("\u6839\u636e\u5b57\u5178\u9879\u7c7b\u578b:" + optType + "\u67e5\u8be2\u6570\u636e\u5f00\u59cb...");
        ResultSet rs = null;
        try {
            String sql = "select count(1) from s_dic where opttype = ?";
            PreparedStatement psmt = connection.prepareStatement(sql);
            psmt.setString(1, optType);
            rs = psmt.executeQuery();
            int count = 0;
            if (rs.next()) {
                count = rs.getInt(1);
            }
            this.logger.info("\u6839\u636e\u5b57\u5178\u9879\u7c7b\u578b:" + optType + "\u67e5\u8be2\u6570\u636e\u7ed3\u675f\uff0c\u7ed3\u679c\u96c6\u5927\u5c0f\u4e3a: " + count);
            if (count > 0) {
                sql = "delete from s_dic where opttype = ?";
                psmt = connection.prepareStatement(sql);
                psmt.setString(1, optType);
                int num = psmt.executeUpdate();
                this.logger.info("\u5220\u9664:" + optType + "\uff0c\u539f\u5b58\u5728\u7684\u6570\u636e\u6570\u91cf\u4e3a: " + num);
            }
        }
        catch (SQLException e) {
            this.logger.error("\u521d\u59cb\u5316\u5e94\u7528{" + this.appInfo.getAppCode() + "}\u7684\u6570\u636e\u5b57\u5178\u51fa\u9519!");
            e.printStackTrace();
        }
    }

    public Map<String, Object> queryAppsParam(String appId, Connection conn) throws Exception {
        PaasAppsParamDao paasAppsParamDao = new PaasAppsParamDao(conn);
        PaasAppsParam param = new PaasAppsParam();
        param.setAppId(appId);
        List<PaasAppsParam> paramList = paasAppsParamDao.queryPaasAppsParamList(param);
        HashMap<String, Object> appsParam = new HashMap<String, Object>();
        if (CollectionUtils.isNotEmpty(paramList)) {
            for (PaasAppsParam p : paramList) {
                appsParam.put(p.getParamCode(), p.getParamValue());
            }
        }
        return appsParam;
    }
}

