/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.deploy;

import com.alibaba.fastjson.JSON;
import com.irdstudio.allinapaas.design.console.types.ParamSource;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.BatInstBatchDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsParamDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasDeployInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEcsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEnvParamDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasTemplateParamDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.BatInstBatch;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsParam;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasEcsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasTemplateParam;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.AbstractPlugin;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.apps.SdEnvUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.common.SSubsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.common.SSubsInfoDao;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class AppPushDataToPortalPlugin
extends AbstractPlugin {
    private BatInstBatch batInst = null;
    private Map<String, Object> extParam = null;

    @Override
    protected boolean doReadConfigureFromDB(Connection conn, String szConfIdentify) throws SQLException {
        String batchSerialNo = this.context.getSzBatchSn();
        BatInstBatchDao batInstBatchDao = new BatInstBatchDao(conn);
        this.batInst = batInstBatchDao.queryByBatchSerialNo(batchSerialNo);
        this.extParam = batInstBatchDao.getExtParam(this.batInst);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        Connection conn = null;
        boolean flag = true;
        try {
            conn = this.getPluginConnection();
            PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
            SSubsInfoDao sSubsInfoDao = new SSubsInfoDao(conn);
            PaasTemplateParamDao paasTemplateParamDao = new PaasTemplateParamDao(conn);
            PaasAppsInfo appInfo = paasAppsInfoDao.queryByAppId(this.batInst.getAppId());
            SSubsInfo sub = sSubsInfoDao.querySSubsInfoWithKeys(appInfo.getSubsId());
            PaasTemplateParam appPortalCtxConfig = paasTemplateParamDao.queryPaasTemplateParamByCode("apps-console-portal", "module");
            PaasEnvParamDao paasEnvParamDao = new PaasEnvParamDao(conn);
            String appPortalIp = paasTemplateParamDao.parseParamValue(ParamSource.Env.getCode(), "ACP.ECS_IP", null, conn);
            String appPortalPort = paasTemplateParamDao.parseParamValue(ParamSource.Env.getCode(), "ACP.ECS_PORT", null, conn);
            String appPortalCtx = appPortalCtxConfig.getParamValue();
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)appPortalIp)) {
                this.logger.error("\u672a\u80fd\u83b7\u53d6\u5230\u5e94\u7528\u95e8\u6237\u5730\u5740");
                boolean bl = flag = false;
                return bl;
            }
            String url = String.format("http://%s:%s/%s/api/s/subs/info/sync", appPortalIp, appPortalPort, appPortalCtx);
            HashMap<String, Object> requestData = new HashMap<String, Object>();
            requestData.put("sub", (Object)sub);
            requestData.put("app", (Object)appInfo);
            String appAccessUrl = this.getAppAccessUrl(appInfo, this.batInst.getEnvId(), conn);
            requestData.put("appAccessUrl", appAccessUrl);
            String resp = this.requestOpenApi(url, requestData);
            this.logger.info("\u63a8\u9001\u95e8\u6237\u7ed3\u679c:" + resp);
        }
        catch (Exception e) {
            this.logger.error("\u63a8\u9001\u5e94\u7528\u6570\u636e\u5230\u95e8\u6237\u5931\u8d25" + e.getMessage(), e);
        }
        finally {
            if (conn != null) {
                this.closePluginConnection(conn);
            }
        }
        return flag;
    }

    public String requestOpenApi(String url, Object param) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpPost postMethod = new HttpPost(url);
        HttpResponse response = null;
        try {
            String reqJson = JSON.toJSONString((Object)param);
            StringEntity entity = new StringEntity(reqJson, ContentType.APPLICATION_JSON);
            postMethod.setEntity((HttpEntity)entity);
            response = httpClient.execute((HttpUriRequest)postMethod);
            String json = EntityUtils.toString((HttpEntity)response.getEntity());
            return json;
        }
        catch (IOException e) {
            e.printStackTrace();
            this.logger.error(e.getMessage(), e);
            return null;
        }
    }

    private String getAppAccessUrl(PaasAppsInfo appInfo, String currEnvId, Connection conn) throws Exception {
        PaasDeployInfoDao paasDeployInfoDao = new PaasDeployInfoDao(conn);
        PaasEcsInfoDao paasEcsInfoDao = new PaasEcsInfoDao(conn);
        PaasEcsInfo ecsParam = new PaasEcsInfo();
        ecsParam.setSubsId(appInfo.getSubsId());
        ecsParam.setAppId(appInfo.getAppId());
        ecsParam.setEnvId(currEnvId);
        List<PaasEcsInfo> ecsList = paasEcsInfoDao.queryPaasEcsInfo(ecsParam);
        Map<String, Object> appsParam = this.queryAppsParam(appInfo.getAppId(), conn);
        String server_port = MapUtils.getString(appsParam, (Object)"server_port", (String)"8080");
        String modelName = "";
        String url = "";
        for (PaasEcsInfo ecs : ecsList) {
            if (StringUtils.isNotBlank((String)ecs.getEcsPort())) {
                server_port = ecs.getEcsPort();
            }
            int port = Integer.valueOf(server_port);
            String rootPath = SdEnvUtil.BUILD_PATH;
            String appCode = SdEnvUtil.wrapperAppCode(appInfo.getAppCode());
            String appSuffix = this.context.getVv().getValue("app_suffix");
            if (StringUtils.isBlank((String)appSuffix)) {
                appSuffix = "start";
            }
            String startModelName = String.format("%s-%s", appCode, appSuffix);
            StringBuffer localProjectWar = new StringBuffer(rootPath);
            localProjectWar.append(appCode).append(File.separator).append(startModelName).append(File.separator).append("target").append(File.separator).append(startModelName).append(".war");
            File warFile = new File(localProjectWar.toString());
            if (!warFile.exists()) {
                warFile = this.searchTargetWarFile(rootPath, appCode, null);
            }
            if (warFile == null || !warFile.exists()) {
                warFile = this.searchTargetJarFile(rootPath, appCode, null);
            }
            if (warFile == null || !warFile.exists()) {
                url = String.format("http://%s:%s/%s", ecs.getEcsIp(), port, SdEnvUtil.wrapperAppCode(appInfo.getAppCode()));
                continue;
            }
            modelName = startModelName = warFile.getName().substring(0, warFile.getName().lastIndexOf("."));
            url = String.format("http://%s:%s/%s", ecs.getEcsIp(), port, modelName);
        }
        return url;
    }

    private File searchTargetWarFile(String rootPath, String appCode, PaasTemplateParam moduleParam) {
        String targetModule;
        File targetFile;
        this.logger.info(String.format("\u641c\u7d22war %s", rootPath));
        File targetDir = new File(rootPath + File.separator + appCode + File.separator);
        if (moduleParam != null && StringUtils.isNotBlank((String)moduleParam.getParamValue()) && (targetFile = new File(targetDir, (targetModule = moduleParam.getParamValue()) + File.separator + "target" + File.separator + targetModule + ".war")).exists() && targetFile.isFile()) {
            return targetFile;
        }
        File jarFile = null;
        if (targetDir.exists() && targetDir.isDirectory()) {
            File[] moduleFiles;
            for (File f : moduleFiles = targetDir.listFiles()) {
                File[] jarFiles;
                if (!f.isDirectory()) continue;
                String name = f.getName();
                if (name.equals("target")) {
                    File[] jarFiles2;
                    for (File jarF : jarFiles2 = f.listFiles()) {
                        if (!jarF.isFile() || !jarF.getName().endsWith(".war")) continue;
                        jarFile = jarF;
                        return jarFile;
                    }
                    continue;
                }
                File buildTargetF = new File(f, "target");
                this.logger.info(String.format("\u641c\u7d22war \u8fdb\u5165\u76ee\u5f55 %s", buildTargetF.getAbsolutePath()));
                if (!buildTargetF.exists()) continue;
                for (File jarF : jarFiles = buildTargetF.listFiles()) {
                    if (!jarF.isFile() || !jarF.getName().endsWith(".war")) continue;
                    jarFile = jarF;
                    return jarFile;
                }
            }
        } else {
            this.logger.error("\u5e94\u7528\u7f16\u8bd1\u76ee\u5f55\u4e0d\u5b58\u5728 " + targetDir.getAbsolutePath());
            return null;
        }
        return null;
    }

    private File searchTargetJarFile(String rootPath, String appCode, PaasTemplateParam moduleParam) {
        String targetModule;
        Object[] modules;
        File targetFile;
        File targetDir = new File(rootPath + File.separator + appCode + File.separator);
        if (moduleParam != null && StringUtils.isNotBlank((String)moduleParam.getParamValue()) && (targetFile = new File(targetDir, StringUtils.join((Object[])(modules = StringUtils.split((String)(targetModule = moduleParam.getParamValue()), (String)"/")), (String)File.separator) + File.separator + "target" + File.separator + (String)modules[modules.length - 1] + ".jar")).exists() && targetFile.isFile()) {
            return targetFile;
        }
        File jarFile = null;
        if (targetDir.exists() && targetDir.isDirectory()) {
            File[] moduleFiles;
            for (File f : moduleFiles = targetDir.listFiles()) {
                File[] jarFiles;
                if (!f.isDirectory()) continue;
                String name = f.getName();
                if (name.equals("target")) {
                    File[] jarFiles2;
                    for (File jarF : jarFiles2 = f.listFiles()) {
                        if (!jarF.isFile() || !jarF.getName().endsWith(".jar.original")) continue;
                        jarFile = new File(jarF.getParentFile(), jarF.getName().substring(0, jarF.getName().length() - 9));
                        return jarFile;
                    }
                    continue;
                }
                File buildTargetF = new File(f, "target");
                if (!buildTargetF.exists()) continue;
                for (File jarF : jarFiles = buildTargetF.listFiles()) {
                    if (!jarF.isFile() || !jarF.getName().endsWith(".jar.original")) continue;
                    jarFile = new File(jarF.getParentFile(), jarF.getName().substring(0, jarF.getName().length() - 9));
                    return jarFile;
                }
            }
        } else {
            this.logger.error("\u5e94\u7528\u7f16\u8bd1\u76ee\u5f55\u4e0d\u5b58\u5728 " + targetDir.getAbsolutePath());
            return null;
        }
        return null;
    }

    public Map<String, Object> queryAppsParam(String appId, Connection conn) throws Exception {
        PaasAppsParamDao paasAppsParamDao = new PaasAppsParamDao(conn);
        PaasAppsParam param = new PaasAppsParam();
        param.setAppId(appId);
        List<PaasAppsParam> paramList = paasAppsParamDao.queryPaasAppsParamList(param);
        HashMap<String, Object> appsParam = new HashMap<String, Object>();
        if (CollectionUtils.isNotEmpty(paramList)) {
            for (PaasAppsParam p : paramList) {
                appsParam.put(p.getParamCode(), p.getParamValue());
            }
        }
        return appsParam;
    }
}

