/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.deploy;

import com.irdstudio.allinapaas.deliver.console.facade.PluginMysqlConfService;
import com.irdstudio.allinapaas.deliver.console.facade.dto.PluginMysqlConfDTO;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.BatInstBatchDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsParamDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsSqlDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasDeployInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEcsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEnvInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasTemplateInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.BatInstBatch;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsParam;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsSql;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasDeployInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasEcsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasEnvInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.AbstractPlugin;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.db.TdpAgentCommonUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.util.date.CurrentDateUtil;
import com.irdstudio.allinapaas.executor.facade.dto.ValidateRtnDTO;
import com.irdstudio.allinapaas.portal.console.types.ExecuteStage;
import com.irdstudio.allinapaas.portal.console.types.YesOrNO;
import com.irdstudio.sdk.beans.core.util.KeyUtil;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import com.irdstudio.sdk.beans.db.util.MyJdbcUtil;
import java.io.BufferedReader;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.jdbc.ScriptRunner;

public class DBAppMysqlSQLDeployPlugin
extends AbstractPlugin {
    private PaasAppsInfo appInfo = null;
    private BatInstBatch batchInst;
    private Map<String, Object> extParam;
    private static final String systemTmpDir = System.getProperty("java.io.tmpdir");

    @Override
    public boolean validate(String batchId, String taskId, ValidateRtnDTO message) {
        PluginMysqlConfService service = (PluginMysqlConfService)SpringContextUtils.getBean(PluginMysqlConfService.class);
        PluginMysqlConfDTO param = new PluginMysqlConfDTO();
        param.setPluginConfId(taskId);
        param = (PluginMysqlConfDTO)service.queryByPk((Object)param);
        if (param == null) {
            return false;
        }
        message.getMessage().addAll(param.validate());
        return CollectionUtils.isEmpty((Collection)message.getMessage());
    }

    @Override
    public boolean copyConfig(String batchId, String taskId, String newTaskId) {
        PluginMysqlConfService service = (PluginMysqlConfService)SpringContextUtils.getBean(PluginMysqlConfService.class);
        PluginMysqlConfDTO param = new PluginMysqlConfDTO();
        param.setPluginConfId(taskId);
        param = (PluginMysqlConfDTO)service.queryByPk((Object)param);
        if (param == null) {
            return true;
        }
        param.setPluginConfId(newTaskId);
        int re = service.insert((Object)param);
        return re == 1;
    }

    @Override
    protected boolean doReadConfigureFromDB(Connection conn, String szConfIdentify) throws SQLException {
        String batchSerialNo = this.context.getSzBatchSn();
        PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
        this.appInfo = paasAppsInfoDao.queryByBatchSerialNo(batchSerialNo);
        BatInstBatchDao batInstBatchDao = new BatInstBatchDao(conn);
        this.batchInst = batInstBatchDao.queryByBatchSerialNo(batchSerialNo);
        this.extParam = batInstBatchDao.getExtParam(this.batchInst);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        this.logger.info(String.format("\u8c03\u7528\u521d\u59cb\u5316mysql\u6570\u636e\u5e93\u63d2\u4ef6,%s\u5f00\u59cb\u90e8\u7f72\u521d\u59cb\u5316\u6570\u636e\u811a\u672c...", this.appInfo.getAppId()));
        Connection conn = null;
        boolean flag = true;
        String database_name = "";
        String database_username = "root";
        String database_password = "Zaqpwdxsw@2";
        try {
            conn = this.getPluginConnection();
            BatInstBatchDao batInstBatchDao = new BatInstBatchDao(conn);
            PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
            PaasAppsParamDao paasAppsParamDao = new PaasAppsParamDao(conn);
            PaasAppsSqlDao paasAppsSqlDao = new PaasAppsSqlDao(conn);
            PaasTemplateInfoDao paasTemplateInfoDao = new PaasTemplateInfoDao(conn);
            BatInstBatch batInstBatch = batInstBatchDao.queryByBatchSerialNo(this.context.getSzBatchSn());
            String currEnvId = batInstBatch.getEnvId();
            PluginMysqlConfService service = (PluginMysqlConfService)SpringContextUtils.getBean(PluginMysqlConfService.class);
            PluginMysqlConfDTO param = new PluginMysqlConfDTO();
            param.setPluginConfId(this.context.getSzTaskId());
            param = (PluginMysqlConfDTO)service.queryByPk((Object)param);
            if (param == null) {
                this.logger.error("\u83b7\u53d6\u4efb\u52a1\u53c2\u6570\u914d\u7f6e\u4e3a\u7a7a");
                boolean bl = false;
                return bl;
            }
            String initDataFlag = param.getInitData();
            if (StringUtils.isBlank((CharSequence)initDataFlag)) {
                initDataFlag = YesOrNO.NO.getCode();
            }
            PaasAppsInfo refDbAppParam = new PaasAppsInfo();
            refDbAppParam.setRefDbAppid(this.appInfo.getAppId());
            List<PaasAppsInfo> refDbAppList = paasAppsInfoDao.queryPaasAppsInfoList(refDbAppParam);
            Map<String, Object> appsParam = this.queryAppsParam(this.appInfo.getAppId(), conn);
            database_name = TdpAgentCommonUtil.getAppDatabaseName(this.appInfo, appsParam);
            appsParam.put("database_name", database_name);
            PaasEnvInfoDao paasEnvInfoDao = new PaasEnvInfoDao(conn);
            PaasEnvInfo envInfo = paasEnvInfoDao.queryByPk(currEnvId);
            PaasDeployInfoDao paasDeployInfoDao = new PaasDeployInfoDao(conn);
            PaasEcsInfoDao paasEcsInfoDao = new PaasEcsInfoDao(conn);
            PaasEcsInfo ecsParam = new PaasEcsInfo();
            ecsParam.setSubsId(this.appInfo.getSubsId());
            ecsParam.setAppId(this.appInfo.getAppId());
            ecsParam.setEnvId(currEnvId);
            ecsParam.setPaasDuId("G000001");
            List<PaasEcsInfo> ecsList = paasEcsInfoDao.queryPaasEcsInfo(ecsParam);
            if (CollectionUtils.isEmpty(ecsList)) {
                ecsParam = new PaasEcsInfo();
                ecsParam.setSubsId(this.appInfo.getSubsId());
                ecsParam.setEnvId(currEnvId);
                ecsParam.setPaasDuId("G000001");
                ecsList = paasEcsInfoDao.queryPaasEcsInfo(ecsParam);
            }
            if (CollectionUtils.isEmpty(ecsList)) {
                ecsParam = new PaasEcsInfo();
                ecsParam.setEnvId(currEnvId);
                ecsParam.setPaasDuId("G000001");
                ecsList = paasEcsInfoDao.queryPaasEcsInfo(ecsParam);
            }
            if (!StringUtils.equals((CharSequence)initDataFlag, (CharSequence)YesOrNO.YES.getCode())) {
                this.logger.info("\u672c\u6b21\u662f\u5426\u521d\u59cb\u5316\u6570\u636e\u5e93\u6807\u8bc6\u4e3a" + YesOrNO.NO.getName() + " \u4e0d\u6267\u884c\u521d\u59cb\u5316\u6570\u636e\u5e93\u64cd\u4f5c");
                if (CollectionUtils.isNotEmpty(ecsList)) {
                    this.updatePaasDeployInfo(ecsList.get(0), paasDeployInfoDao);
                }
                boolean bl = true;
                return bl;
            }
            this.logger.info("\u672c\u6b21\u662f\u5426\u521d\u59cb\u5316\u6570\u636e\u5e93\u6807\u8bc6\u4e3a" + YesOrNO.YES.getName() + " \u6267\u884c\u521d\u59cb\u5316\u6570\u636e\u5e93\u64cd\u4f5c");
            this.deployAppDb(this.appInfo, envInfo, appsParam, ecsList, conn);
            if (CollectionUtils.isNotEmpty(refDbAppList)) {
                for (PaasAppsInfo refApp : refDbAppList) {
                    this.deployAppDb(refApp, envInfo, appsParam, ecsList, conn);
                }
            }
            if (param != null) {
                param.setInitData(YesOrNO.NO.getCode());
                service.updateByPk((Object)param);
            }
            if (CollectionUtils.isNotEmpty(ecsList)) {
                this.updatePaasDeployInfo(ecsList.get(0), paasDeployInfoDao);
            }
        }
        catch (Exception e) {
            this.logger.error("\u5e94\u7528\u6570\u636e\u521d\u59cb\u5316\u5f02\u5e38 " + e.getMessage(), e);
            flag = false;
        }
        finally {
            if (conn != null) {
                this.closePluginConnection(conn);
            }
        }
        return flag;
    }

    private void updatePaasDeployInfo(PaasEcsInfo ecs, PaasDeployInfoDao paasDeployInfoDao) throws Exception {
        String envId = this.batchInst.getEnvId();
        boolean flag = true;
        PaasDeployInfo deployInfo = paasDeployInfoDao.queryByAppId(this.appInfo.getAppId(), envId);
        if (deployInfo == null) {
            deployInfo = new PaasDeployInfo();
            flag = false;
            deployInfo.setAppDeployId(KeyUtil.createUUIDKey());
        }
        deployInfo.setSubsId(this.appInfo.getSubsId());
        deployInfo.setAppId(this.appInfo.getAppId());
        deployInfo.setAppName(this.appInfo.getAppCode());
        deployInfo.setAppCnname(this.appInfo.getAppName());
        deployInfo.setAppVersion(this.appInfo.getAppVersion());
        deployInfo.setAppType(this.appInfo.getAppType());
        deployInfo.setEnvId(envId);
        deployInfo.setAppOrder(0);
        deployInfo.setEcsId(ecs.getEcsId());
        deployInfo.setEcsIp(ecs.getEcsIp());
        deployInfo.setEcsName(ecs.getEcsName());
        deployInfo.setEcsRegion(ecs.getEcsRegionId());
        deployInfo.setAppPort(ecs.getEcsPort());
        deployInfo.setAppState("R");
        deployInfo.setOperUserid("admin");
        deployInfo.setOperTime(CurrentDateUtil.getTodayDateEx2());
        if (flag) {
            paasDeployInfoDao.updateByPk(deployInfo);
        } else {
            paasDeployInfoDao.insertPaasDeployInfo(deployInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deployAppDb(PaasAppsInfo appInfo, PaasEnvInfo envInfo, Map<String, Object> appsParam, List<PaasEcsInfo> ecsList, Connection conn) throws Exception {
        BatInstBatchDao batInstBatchDao = new BatInstBatchDao(conn);
        PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
        PaasAppsParamDao paasAppsParamDao = new PaasAppsParamDao(conn);
        PaasAppsSqlDao paasAppsSqlDao = new PaasAppsSqlDao(conn);
        PaasTemplateInfoDao paasTemplateInfoDao = new PaasTemplateInfoDao(conn);
        boolean flag = true;
        String database_name = MapUtils.getString(appsParam, (Object)"database_name");
        if (StringUtils.isBlank((CharSequence)database_name)) {
            this.logger.info("\u672a\u914d\u7f6e\u6570\u636e\u5e93\u540d \u6570\u636e\u5e93\u4e0d\u8fdb\u884c\u521d\u59cb\u5316\u540e");
            return true;
        }
        String database_username = MapUtils.getString(appsParam, (Object)"database_username", (String)"root");
        appsParam.put("database_username", database_username);
        String database_password = MapUtils.getString(appsParam, (Object)"database_password", (String)"Zaqpwdxsw@2");
        appsParam.put("database_password", database_password);
        for (PaasEcsInfo ecs : ecsList) {
            this.logger.info(String.format("\u5f00\u59cb\u521b\u5efa\u6570\u636e\u5e93%s\u5230\u670d\u52a1\u5668%s,\u7aef\u53e3%s", database_name, ecs.getEcsIp(), "3306"));
            Connection createConn = null;
            try {
                createConn = TdpAgentCommonUtil.getNativeConnection(appInfo, appsParam);
                flag = this.runScript(createConn, paasAppsSqlDao, null);
            }
            catch (Exception ie) {
                this.logger.error("\u6267\u884c\u6570\u636e\u5e93\u6570\u636e\u521d\u59cb\u5316\u811a\u672c\u5f02\u5e38" + ie.getMessage());
                if (createConn != null) {
                    MyJdbcUtil.close((Connection)createConn);
                }
                flag = false;
            }
            finally {
                if (createConn == null) continue;
                MyJdbcUtil.close((Connection)createConn);
            }
        }
        return flag;
    }

    private boolean runScript(Connection conn, PaasAppsSqlDao paasAppsSqlDao, String initDbSqlContent) throws Exception {
        boolean flag = true;
        PaasAppsSql sqlParam = new PaasAppsSql();
        sqlParam.setAppId(this.appInfo.getAppId());
        sqlParam.setExecuteStage(ExecuteStage.Deploy.getCode());
        List<PaasAppsSql> sqlList = null;
        try {
            sqlList = paasAppsSqlDao.queryPaasAppsSqlList(sqlParam);
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u6570\u636e\u5e93\u521d\u59cb\u5316\u811a\u672c\u5f02\u5e38", e);
            flag = false;
        }
        if (CollectionUtils.isNotEmpty(sqlList)) {
            for (PaasAppsSql sql : sqlList) {
                ScriptRunner sr = new ScriptRunner(conn);
                BufferedReader reader = new BufferedReader(new StringReader(sql.getSqlContent()));
                sr.runScript((Reader)reader);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)initDbSqlContent)) {
            this.logger.info("\u6267\u884c\u521d\u59cb\u5316\u811a\u672c\n" + initDbSqlContent);
            ScriptRunner sr = new ScriptRunner(conn);
            BufferedReader reader = new BufferedReader(new StringReader(initDbSqlContent));
            sr.runScript((Reader)reader);
        }
        return flag;
    }

    public Map<String, Object> queryAppsParam(String appId, Connection conn) throws Exception {
        PaasAppsParamDao paasAppsParamDao = new PaasAppsParamDao(conn);
        PaasAppsParam param = new PaasAppsParam();
        param.setAppId(appId);
        List<PaasAppsParam> paramList = paasAppsParamDao.queryPaasAppsParamList(param);
        HashMap<String, Object> appsParam = new HashMap<String, Object>();
        if (CollectionUtils.isNotEmpty(paramList)) {
            for (PaasAppsParam p : paramList) {
                appsParam.put(p.getParamCode(), p.getParamValue());
            }
        }
        return appsParam;
    }
}

