/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.deploy;

import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsParamDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEcsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEnvInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasEcsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasEnvInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.apps.SdEnvUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.docs.git.queue.AppTemplateRepoPullTask;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.util.MyFileUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.tinycore.jdbc.dbcp.base.IConnPool;
import com.irdstudio.allinapaas.executor.application.executor.core.util.parse.ExpressionUtil;
import com.irdstudio.sdk.beans.core.util.BeanUtility;
import com.irdstudio.sdk.beans.core.util.TmModelUtil;
import com.irdstudio.sdk.beans.freemarker.bo.CodeTemplateDataBo;
import com.irdstudio.sdk.beans.freemarker.util.FreemarkerUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiddleAppConfigFileGenerate {
    private static final Logger logger = LoggerFactory.getLogger(MiddleAppConfigFileGenerate.class);

    public void pullTemplateRepo(String appTemplateId) {
        AppTemplateRepoPullTask templateRepoPullTask = new AppTemplateRepoPullTask(appTemplateId);
        templateRepoPullTask.syncRun();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File obtainConfigFile(String appId, String envId, IConnPool connTool) {
        Connection conn = null;
        File configFile = null;
        try {
            conn = connTool.getConnection();
            PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
            PaasAppsInfo appInfo = paasAppsInfoDao.queryByAppId(appId);
            Map<String, Object> root = this.loadAppData(appInfo, envId, true, conn);
            String configFileName = MapUtils.getString(root, (Object)"config.file.name");
            String configFilePath = MapUtils.getString(root, (Object)"config.file.path");
            String configFileDir = this.getAppConfigFilePath(appInfo);
            File file = new File(configFileDir + File.separator + this.wrapperConfigFileNameWithEnvId(configFileName, envId));
            if (file.exists()) {
                configFile = file;
            } else {
                this.produceCodeFile(configFileName, envId, appInfo, root);
                configFile = file;
            }
        }
        catch (Exception e) {
            logger.error("\u4e2d\u95f4\u4ef6\u5e94\u7528{}\u914d\u7f6e\u6587\u4ef6\u83b7\u53d6\u5f02\u5e38: {}", new Object[]{appId, e.getMessage(), e});
        }
        finally {
            if (conn != null && connTool != null) {
                connTool.releaseConnection(conn);
            }
        }
        return configFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File updateConfigFile(String appId, String envId, String content, IConnPool connTool) {
        Connection conn = null;
        FileOutputStream out = null;
        File configFile = null;
        try {
            conn = connTool.getConnection();
            PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
            PaasAppsInfo appInfo = paasAppsInfoDao.queryByAppId(appId);
            Map<String, Object> root = this.loadAppData(appInfo, envId, false, conn);
            String configFileName = MapUtils.getString(root, (Object)"config.file.name");
            String configFilePath = MapUtils.getString(root, (Object)"config.file.path");
            String configFileDir = this.getAppConfigFilePath(appInfo);
            File file = new File(configFileDir + File.separator + this.wrapperConfigFileNameWithEnvId(configFileName, envId));
            out = new FileOutputStream(file);
            IOUtils.write((String)content, (OutputStream)out, (String)"UTF-8");
            out.flush();
            IOUtils.closeQuietly((OutputStream)out);
            if (conn != null && connTool != null) {
                connTool.releaseConnection(conn);
            }
        }
        catch (Exception e) {
            logger.error("\u4e2d\u95f4\u4ef6\u5e94\u7528{}\u914d\u7f6e\u6587\u4ef6\u66f4\u65b0\u5f02\u5e38: {}", new Object[]{appId, e.getMessage(), e});
        }
        finally {
            IOUtils.closeQuietly(out);
            if (conn != null && connTool != null) {
                connTool.releaseConnection(conn);
            }
        }
        return configFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] obtainDeployConfigFile(String appId, String envId, IConnPool connTool) {
        Connection conn = null;
        FileInputStream input = null;
        String content = null;
        String fileName = null;
        try {
            conn = connTool.getConnection();
            PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
            PaasAppsInfo appInfo = paasAppsInfoDao.queryByAppId(appId);
            Map<String, Object> root = this.loadAppData(appInfo, envId, true, conn);
            String configFileName = MapUtils.getString(root, (Object)"config.file.name");
            String configFilePath = MapUtils.getString(root, (Object)"config.file.path");
            String configFileDir = this.getAppConfigFilePath(appInfo);
            File file = new File(configFileDir + File.separator + this.wrapperConfigFileNameWithEnvId(configFileName, envId));
            input = new FileInputStream(file);
            List configs = IOUtils.readLines((InputStream)input, (String)"UTF-8");
            for (int i = 0; i < configs.size(); ++i) {
                String line = (String)configs.get(i);
                String newList = null;
                try {
                    newList = ExpressionUtil.parse(line, root);
                }
                catch (Exception pe) {
                    logger.error(pe.getMessage(), (Throwable)pe);
                    newList = line;
                }
                configs.set(i, newList);
            }
            content = StringUtils.join((Collection)configs, (String)"\n");
            fileName = this.wrapperConfigFileNameWithEnvId(configFileName, envId);
            IOUtils.closeQuietly((InputStream)input);
            if (conn != null && connTool != null) {
                connTool.releaseConnection(conn);
            }
        }
        catch (Exception e) {
            logger.error("\u4e2d\u95f4\u4ef6\u5e94\u7528{}\u914d\u7f6e\u6587\u4ef6\u66f4\u65b0\u5f02\u5e38: {}", new Object[]{appId, e.getMessage(), e});
        }
        finally {
            IOUtils.closeQuietly(input);
            if (conn != null && connTool != null) {
                connTool.releaseConnection(conn);
            }
        }
        return new String[]{fileName, content};
    }

    public String getFileType(File file) {
        String fileName = file.getName();
        if (StringUtils.lastIndexOf((String)fileName, (String)".") > 0) {
            return fileName.substring(StringUtils.lastIndexOf((String)fileName, (String)".") + 1);
        }
        return "";
    }

    public String getFileType(String fileName) {
        if (StringUtils.lastIndexOf((String)fileName, (String)".") > 0) {
            return fileName.substring(StringUtils.lastIndexOf((String)fileName, (String)".") + 1);
        }
        return "";
    }

    private Map<String, Object> loadAppData(PaasAppsInfo appInfo, String envId, boolean loadEcs, Connection conn) throws Exception {
        PaasAppsParamDao paasAppsParamDao = new PaasAppsParamDao(conn);
        PaasEcsInfoDao paasEcsInfoDao = new PaasEcsInfoDao(conn);
        PaasEnvInfoDao paasEnvInfoDao = new PaasEnvInfoDao(conn);
        HashMap<String, Object> root = new HashMap<String, Object>();
        PaasEnvInfo envInfo = paasEnvInfoDao.queryByPk(envId);
        root.put("env", BeanUtility.bean2Map((Object)((Object)envInfo)));
        root.put("appInfo", BeanUtility.bean2Map((Object)((Object)appInfo)));
        Map<String, Object> appsParam = paasAppsParamDao.queryAppParamMap(appInfo.getAppId(), envId);
        root.putAll(appsParam);
        if (loadEcs) {
            PaasEcsInfo envEcsParam = new PaasEcsInfo();
            envEcsParam.setEnvId(envId);
            List<PaasEcsInfo> notAppEcsList = paasEcsInfoDao.queryPaasEcsInfoNotApp(envEcsParam);
            envEcsParam.setSubsId(appInfo.getSubsId());
            List<PaasEcsInfo> subsEcsList = paasEcsInfoDao.queryPaasEcsInfoNotApp(envEcsParam);
            notAppEcsList.addAll(subsEcsList);
            envEcsParam.setAppId(appInfo.getAppId());
            List<PaasEcsInfo> ecsList = paasEcsInfoDao.queryPaasEcsInfo(envEcsParam);
            notAppEcsList.addAll(ecsList);
            ecsList = notAppEcsList;
            if (CollectionUtils.isNotEmpty(ecsList)) {
                for (PaasEcsInfo ecs : ecsList) {
                    Map ecsMap = BeanUtility.bean2Map((Object)((Object)ecs));
                    HashMap ecsParamMap = new HashMap();
                    for (Map.Entry entry : ecsMap.entrySet()) {
                        String key = TmModelUtil.propertyToField((String)((String)entry.getKey())).toUpperCase();
                        ecsParamMap.put(key, entry.getValue());
                    }
                    root.put(ecs.getPaasDuId(), ecsParamMap);
                }
            }
        }
        return root;
    }

    private String getAppConfigFilePath(PaasAppsInfo appInfo) {
        String targetPath = SdEnvUtil.MIDDLE_CONFIG_PATH + appInfo.getAppId() + File.separator;
        targetPath = this.pathMatchSystem(targetPath);
        return targetPath;
    }

    private String wrapperConfigFileNameWithEnvId(String configFileName, String envId) {
        if (StringUtils.lastIndexOf((String)configFileName, (String)".") > 0) {
            int dotIdx = StringUtils.lastIndexOf((String)configFileName, (String)".");
            StringBuffer sb = new StringBuffer(configFileName);
            sb.insert(dotIdx, "-" + envId);
            return sb.toString();
        }
        return configFileName + "-" + envId;
    }

    private void produceCodeFile(String templateFile, String envId, PaasAppsInfo appInfo, Map<String, Object> mapData) throws Exception {
        CodeTemplateDataBo ctdb = new CodeTemplateDataBo();
        ctdb.getMapData().putAll(mapData);
        String appCode = SdEnvUtil.wrapperAppCode(appInfo.getAppCode());
        String templatePath = SdEnvUtil.getTemplateCodePath(appInfo);
        ctdb.getMapData().put("TEMPLATE_PATH", templatePath);
        String targetPath = this.getAppConfigFilePath(appInfo);
        if (!MyFileUtil.checkFileExist(targetPath).booleanValue()) {
            File targetDic = new File(targetPath);
            targetDic.mkdirs();
        }
        String fileNameResult = templateFile;
        String outputFileName = targetPath + this.wrapperConfigFileNameWithEnvId(fileNameResult, envId);
        ctdb.getMapData().put("TmModelUtil", new TmModelUtil());
        FreemarkerUtil.produceSingleFile((CodeTemplateDataBo)ctdb, (String)templatePath, (String)(templateFile + ".vm"), (String)outputFileName);
    }

    private String pathMatchSystem(String path) {
        String targetSeparetor = File.separator;
        if (targetSeparetor.equals("\\")) {
            if (path.contains("/")) {
                // empty if block
            }
        } else if (targetSeparetor.equals("/") && path.contains("\\")) {
            path = path.replaceAll("\\\\", "/");
        }
        return path;
    }
}

