/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.devops.ant;

import com.irdstudio.allinapaas.executor.application.executor.core.dao.BatInstBatchDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsParamDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.BatInstBatch;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsParam;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.AbstractPlugin;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.apps.SdEnvUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.devops.ant.AntMain;
import com.irdstudio.allinapaas.executor.types.ExecutorInstInfo;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class AntBuildPlugin
extends AbstractPlugin {
    private PaasAppsInfo appInfo = null;
    private BatInstBatch batchInst;
    String antCompiler = "";

    @Override
    protected boolean doReadConfigureFromDB(Connection conn, String szConfIdentify) throws SQLException {
        String batchSerialNo = this.context.getSzBatchSn();
        BatInstBatchDao batInstBatchDao = new BatInstBatchDao(conn);
        this.batchInst = batInstBatchDao.queryByBatchSerialNo(batchSerialNo);
        PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
        this.appInfo = paasAppsInfoDao.queryByAppId(this.batchInst.getAppId());
        PaasAppsParamDao paasAppsParamDao = new PaasAppsParamDao(conn);
        PaasAppsParam paasAppsParam = new PaasAppsParam();
        paasAppsParam.setAppId(this.appInfo.getAppId());
        paasAppsParam.setParamCode("ant_compiler");
        List<PaasAppsParam> paasAppsParamList = paasAppsParamDao.queryPaasAppsParamList(paasAppsParam);
        this.antCompiler = CollectionUtils.isNotEmpty(paasAppsParamList) ? paasAppsParamList.get(0).getParamValue() : "ant -d build";
        return true;
    }

    @Override
    public boolean execute() {
        boolean flag = true;
        this.logger.info("\u8c03\u7528Ant\u7f16\u8bd1\u63d2\u4ef6\uff0c\u7f16\u8bd1\u5e94\u7528: " + this.appInfo.getAppCode());
        String projectBuildXmlPath = SdEnvUtil.BUILD_PATH + SdEnvUtil.wrapperAppCode(this.appInfo.getAppCode()) + File.separator + "build.xml";
        this.logger.info("build.xml \u6587\u4ef6\uff1a" + projectBuildXmlPath);
        this.logger.info("ant \u7f16\u8bd1\u547d\u4ee4\uff1a" + this.antCompiler);
        File buildFile = new File(projectBuildXmlPath);
        String command = this.antCompiler.replace("ant", "");
        String[] commands = StringUtils.split((String)command, (String)" ");
        String[] antArgs = new String[4 + commands.length];
        antArgs[0] = "-buildfile";
        antArgs[1] = buildFile.getAbsolutePath();
        String fullLogFileName = ExecutorInstInfo.BATCH_LOG_PATH + File.separator + this.batchInst.getBatchSerialNo() + ".log";
        antArgs[2] = "-logfile";
        antArgs[3] = fullLogFileName;
        System.arraycopy(commands, 0, antArgs, 4, commands.length);
        AntMain.start(antArgs, null, this.getClass().getClassLoader());
        return flag;
    }
}

