/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.docs.gendoc;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasDocTemplate;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.docs.gendoc.DocGenerate;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.docs.git.queue.DocTemplateRepoPullQueueExecutor;
import com.irdstudio.allinapaas.executor.application.executor.core.tinycore.jdbc.dbcp.base.IConnPool;
import com.irdstudio.allinapaas.executor.application.executor.core.util.date.CurrentDateUtil;
import com.irdstudio.allinrdm.admin.console.facade.RdmWeeklyCalendarService;
import com.irdstudio.allinrdm.dev.console.types.YesOrNO;
import com.irdstudio.allinrdm.project.console.facade.RdmProjectInfoService;
import com.irdstudio.allinrdm.project.console.facade.dto.RdmProjectInfoDTO;
import com.irdstudio.allinrdm.project.console.types.FnBaseRefType;
import com.irdstudio.allinrdm.sam.console.facade.FnBaseInfoService;
import com.irdstudio.allinrdm.sam.console.facade.dto.FnBaseInfoDTO;
import com.irdstudio.allinrdm.sam.console.types.FnBaseState;
import com.irdstudio.allinrdm.sam.console.types.FnCategory;
import com.irdstudio.allinrdm.sam.console.types.FpType;
import com.irdstudio.sdk.beans.core.util.BeanUtility;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import java.io.File;
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class GenFnBaseExcel
implements DocGenerate {
    protected FnBaseInfoService fnBaseInfoService;

    @Override
    public List<File> generateDoc(PaasDocTemplate template, String subsId, File baseDir, IConnPool connTool, Map<String, Object> extParams) {
        return null;
    }

    public void fillFnBaseInfoList(ExcelWriter excelWriter, WriteSheet sheet, FnBaseInfoDTO planParam) {
        List rows = this.fnBaseInfoService.queryList((Object)planParam);
        if (CollectionUtils.isEmpty((Collection)rows)) {
            rows = Collections.emptyList();
        }
        for (int i = 0; i < rows.size(); ++i) {
            FnBaseInfoDTO vo = (FnBaseInfoDTO)rows.get(i);
            vo.setFpCategory(FnCategory.nameByCode((String)vo.getFpCategory()));
            vo.setFpType(FpType.nameByCode((String)vo.getFpType()));
            vo.setRefRoleControl(FnBaseRefType.nameByCode((String)vo.getRefRoleControl()));
            vo.setRefTable(FnBaseRefType.nameByCode((String)vo.getRefTable()));
            vo.setRefFlow(FnBaseRefType.nameByCode((String)vo.getRefFlow()));
            vo.setRefOutsideInf(FnBaseRefType.nameByCode((String)vo.getRefOutsideInf()));
            vo.setRefInnerInf(FnBaseRefType.nameByCode((String)vo.getRefInnerInf()));
            vo.setRefRiskIntercept(FnBaseRefType.nameByCode((String)vo.getRefRiskIntercept()));
            vo.setDesignState(FnBaseState.nameByCode((String)vo.getDesignState()));
            vo.setDevState(FnBaseState.nameByCode((String)vo.getDevState()));
            vo.setTestingState(FnBaseState.nameByCode((String)vo.getTestingState()));
            vo.setDeployState(FnBaseState.nameByCode((String)vo.getDeployState()));
            vo.setSumWorkload(this.sumWorkload(vo));
        }
        excelWriter.fill(rows, sheet);
    }

    private BigDecimal sumWorkload(FnBaseInfoDTO vo) {
        if (vo.getSumWorkload() != null && vo.getSumWorkload().compareTo(BigDecimal.ZERO) > 0) {
            return vo.getSumWorkload();
        }
        BigDecimal total = BigDecimal.ZERO;
        if (vo.getDesignWorkload() != null) {
            total = total.add(vo.getDesignWorkload());
        }
        if (vo.getDevWorkload() != null) {
            total = total.add(vo.getDevWorkload());
        }
        if (vo.getTestingWorkload() != null) {
            total = total.add(vo.getTestingWorkload());
        }
        if (vo.getDeployWorkload() != null) {
            total = total.add(vo.getDeployWorkload());
        }
        return total;
    }

    @Override
    public File generateAppDoc(PaasDocTemplate template, String appId, File baseDir, IConnPool connTool, Map<String, Object> extParams) {
        Connection conn = null;
        try {
            ExcelWriter excelWriter;
            ExcelWriterBuilder writerBuilder;
            this.fnBaseInfoService = (FnBaseInfoService)SpringContextUtils.getBean(FnBaseInfoService.class);
            conn = connTool.getConnection();
            File currentFile = this.getDocDirPath(template, baseDir, conn);
            if (!currentFile.exists()) {
                currentFile.mkdirs();
            }
            String projectId = MapUtils.getString(extParams, (Object)"projectId");
            String subsId = MapUtils.getString(extParams, (Object)"subsId");
            String splitByModule = MapUtils.getString(extParams, (Object)"splitByModule");
            String filterCond = MapUtils.getString(extParams, (Object)"filterCond");
            RdmProjectInfoService rdmProjectInfoService = (RdmProjectInfoService)SpringContextUtils.getBean(RdmProjectInfoService.class);
            RdmWeeklyCalendarService rdmWeeklyCalendarService = (RdmWeeklyCalendarService)SpringContextUtils.getBean(RdmWeeklyCalendarService.class);
            RdmProjectInfoDTO projectInfo = new RdmProjectInfoDTO();
            projectInfo.setProjectId(projectId);
            projectInfo = (RdmProjectInfoDTO)rdmProjectInfoService.queryByPk((Object)projectInfo);
            String viewName = "";
            String userId = template.getLoginUserId();
            String today = CurrentDateUtil.getTodayDate();
            String todayTime = CurrentDateUtil.getTodayDateEx2();
            String time = CurrentDateUtil.getCurrentTime();
            Map rootMap = BeanUtility.bean2Map((Object)projectInfo);
            rootMap.put("today", today);
            rootMap.put("todayTime", todayTime);
            rootMap.put("time", time);
            rootMap.put("viewName", viewName);
            String fileName = template.getDocName();
            if (StringUtils.isNotBlank((CharSequence)template.getDocNameTemplate())) {
                fileName = this.renderDocName(template.getDocNameTemplate(), rootMap);
            }
            DocTemplateRepoPullQueueExecutor.syncRun();
            String excelTemplatePath = DocTemplateRepoPullQueueExecutor.getDocTemplatePath();
            File templateFile = new File(excelTemplatePath, template.getDocFile());
            File targetFile = new File(currentFile, fileName);
            String newTmpTemplateID = UUIDUtil.getShortUUID() + ".xlsx";
            String excelTempFile = currentFile.getAbsolutePath() + File.separator + newTmpTemplateID;
            List<Object> moduleList = new ArrayList();
            if (StringUtils.equals((CharSequence)splitByModule, (CharSequence)YesOrNO.YES.getCode())) {
                FnBaseInfoDTO fnGroupParam = new FnBaseInfoDTO();
                fnGroupParam.setSubsId(subsId);
                fnGroupParam.setProjectId(projectId);
                fnGroupParam.setFilterCond(filterCond);
                fnGroupParam.setGroupBy("moduleName");
                fnGroupParam.setSize(Integer.valueOf(Integer.MAX_VALUE));
                List resultList = this.fnBaseInfoService.queryListByPage((Object)fnGroupParam);
                if (CollectionUtils.isNotEmpty((Collection)resultList)) {
                    moduleList = resultList.stream().map(FnBaseInfoDTO::getModuleName).collect(Collectors.toList());
                }
            }
            if (CollectionUtils.isNotEmpty(moduleList)) {
                writerBuilder = EasyExcel.write((String)excelTempFile);
                excelWriter = writerBuilder.withTemplate(templateFile).build();
                Workbook workbook = excelWriter.writeContext().writeWorkbookHolder().getCachedWorkbook();
                int sheetCount = moduleList.size();
                for (int i = 0; i < sheetCount; ++i) {
                    if (i > 0) {
                        Sheet sheet = excelWriter.writeContext().writeWorkbookHolder().getCachedWorkbook().cloneSheet(i - 1);
                    }
                    String moduleName = (String)moduleList.get(i);
                    try {
                        workbook.setSheetName(i, moduleName);
                        continue;
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
                excelWriter.finish();
            } else {
                FileUtils.copyFile((File)templateFile, (File)new File(excelTempFile));
            }
            writerBuilder = EasyExcel.write((File)targetFile);
            excelWriter = writerBuilder.withTemplate(excelTempFile).build();
            if (CollectionUtils.isNotEmpty(moduleList)) {
                for (int i = 0; i < moduleList.size(); ++i) {
                    String moduleName = (String)moduleList.get(i);
                    WriteSheet sheet = EasyExcel.writerSheet((Integer)i, (String)moduleName).build();
                    FnBaseInfoDTO fnBaseParam = new FnBaseInfoDTO();
                    fnBaseParam.setProjectId(projectId);
                    fnBaseParam.setSubsId(subsId);
                    fnBaseParam.setModuleName(moduleName);
                    fnBaseParam.setFilterCond(filterCond);
                    this.fillFnBaseInfoList(excelWriter, sheet, fnBaseParam);
                }
            } else {
                WriteSheet sheet = EasyExcel.writerSheet((Integer)0, null).build();
                FnBaseInfoDTO fnBaseParam = new FnBaseInfoDTO();
                fnBaseParam.setProjectId(projectId);
                fnBaseParam.setSubsId(subsId);
                fnBaseParam.setFilterCond(filterCond);
                this.fillFnBaseInfoList(excelWriter, sheet, fnBaseParam);
            }
            excelWriter.finish();
            FileUtils.deleteQuietly((File)new File(excelTempFile));
            File file = targetFile;
            connTool.releaseConnection(conn);
            return file;
        }
        catch (Exception e) {
            try {
                logger.error("\u529f\u80fd\u70b9\u5bfc\u51fa\u5f02\u5e38 " + e.getMessage(), (Throwable)e);
                throw new RuntimeException("\u529f\u80fd\u70b9\u5bfc\u51fa\u5f02\u5e38 " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                connTool.releaseConnection(conn);
                throw throwable;
            }
        }
    }
}

