/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.docs.gendoc;

import com.deepoove.poi.XWPFTemplate;
import com.deepoove.poi.config.Configure;
import com.deepoove.poi.data.PictureType;
import com.deepoove.poi.data.Pictures;
import com.deepoove.poi.data.RowRenderData;
import com.deepoove.poi.data.Rows;
import com.deepoove.poi.data.Tables;
import com.deepoove.poi.util.ByteUtils;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.TclComponentSubsDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasDocTemplate;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.TclComponentSubs;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.WikiSubsPage;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.common.SSubsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.common.SSubsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.docs.gendoc.DocGenerate;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.docs.git.queue.DocTemplateRepoPullQueueExecutor;
import com.irdstudio.allinapaas.executor.application.executor.core.tinycore.jdbc.dbcp.base.IConnPool;
import com.irdstudio.allinapaas.executor.application.executor.core.util.date.CurrentDateUtil;
import com.irdstudio.allinapaas.portal.console.types.ArchivingCycle;
import com.irdstudio.allinapaas.portal.console.types.ArchivingMode;
import com.irdstudio.allinapaas.portal.console.types.CapacityType;
import com.irdstudio.allinapaas.portal.console.types.StorageType;
import com.irdstudio.allinapaas.portal.console.types.YesOrNO;
import com.irdstudio.allinrdm.dev.console.facade.HldCapacityInfoService;
import com.irdstudio.allinrdm.dev.console.facade.HldDataArchivingInfoService;
import com.irdstudio.allinrdm.dev.console.facade.HldDataflowInfoService;
import com.irdstudio.allinrdm.dev.console.facade.HldFileArchivingInfoService;
import com.irdstudio.allinrdm.dev.console.facade.dto.HldCapacityInfoDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.HldDataArchivingInfoDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.HldDataflowInfoDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.HldFileArchivingInfoDTO;
import com.irdstudio.allinrdm.sam.console.facade.FnModelInfoService;
import com.irdstudio.allinrdm.sam.console.facade.dto.FnModelInfoDTO;
import com.irdstudio.sdk.beans.core.spring.SpringPropertyUtils;
import com.irdstudio.sdk.beans.core.util.BeanUtility;
import com.irdstudio.sdk.beans.core.util.ReflectUtility;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import com.irdstudio.sdk.beans.word.util.WordResourceCloseUtil;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.openxml4j.util.ZipSecureFile;
import org.apache.poi.xwpf.usermodel.XWPFAbstractNum;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFNum;
import org.apache.poi.xwpf.usermodel.XWPFNumbering;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFStyle;
import org.apache.poi.xwpf.usermodel.XWPFStyles;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTLvl;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTNum;

public class GenRdmHLDWord
implements DocGenerate {
    @Override
    public List<File> generateDoc(PaasDocTemplate template, String subsId, File baseDir, IConnPool connTool, @Nullable Map<String, Object> extParams) {
        Connection conn = null;
        try {
            File currentFile;
            conn = connTool.getConnection();
            SSubsInfoDao sSubsInfoDao = new SSubsInfoDao(conn);
            PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
            String today = CurrentDateUtil.getTodayDate();
            String todayTime = CurrentDateUtil.getTodayDateEx2();
            SSubsInfo subsInfo = sSubsInfoDao.querySSubsInfoWithKeys(subsId);
            Map subsInfoMap = BeanUtility.bean2Map((Object)((Object)subsInfo));
            subsInfoMap.put("today", today);
            subsInfoMap.put("todayTime", todayTime);
            String fileName = template.getDocName();
            if (StringUtils.isNotBlank((CharSequence)template.getDocNameTemplate())) {
                fileName = this.renderDocName(template.getDocNameTemplate(), subsInfoMap);
            }
            if ((currentFile = this.getDocDirPath(template, baseDir, conn)) == null) {
                logger.error("\u751f\u6210\u6587\u4ef6\u4fdd\u5b58\u76ee\u5f55\u8def\u5f84\u5931\u8d25");
                List<File> list = null;
                return list;
            }
            if (!currentFile.exists()) {
                currentFile.mkdirs();
            }
            String currentFilePath = currentFile.getAbsolutePath();
            try {
                DocTemplateRepoPullQueueExecutor.syncRun();
                String templateRootPath = DocTemplateRepoPullQueueExecutor.getDocTemplatePath();
                String hldDocx = this.generateHldDoc(subsInfo, templateRootPath + File.separator + template.getDocFile(), currentFilePath + File.separator + fileName, conn);
                File srcFile = new File(hldDocx);
                String docName = srcFile.getName();
                WikiSubsPage appDoc = new WikiSubsPage();
                appDoc.setDocType("docx");
                appDoc.setDocTitle(fileName.replace(".docx", ""));
                appDoc.setSubsId(subsId);
                appDoc.setLoginUserId(template.getLoginUserId());
                this.saveToWikiConsole(subsId, template, srcFile, appDoc, conn);
                List<File> list = Arrays.asList(srcFile);
                return list;
            }
            catch (Exception e) {
                try {
                    logger.error(e.getMessage(), (Throwable)e);
                    connTool.releaseConnection(conn);
                }
                catch (Exception e2) {
                    logger.error(e2.getMessage(), (Throwable)e2);
                    throw new RuntimeException(e2.getMessage(), e2);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            connTool.releaseConnection(conn);
        }
        return null;
    }

    @Override
    public File generateAppDoc(PaasDocTemplate template, String appId, File baseDir, IConnPool connTool, Map<String, Object> extParams) {
        return null;
    }

    public String generateHldDoc(SSubsInfo subsInfo, String templateFilePath, String currentFilePath, Connection conn) throws Exception {
        String resultFilePath = currentFilePath;
        HashMap<String, Object> data = new HashMap<String, Object>();
        Map subsInfoMap = BeanUtility.bean2Map((Object)((Object)subsInfo));
        data.putAll(subsInfoMap);
        this.fillTsTable(subsInfo, data, conn);
        this.fillFnModelInfo(subsInfo, data, conn);
        this.fillHldDataflowInfo(subsInfo, data, conn);
        this.fillHldCapacityInfo(subsInfo, data, conn);
        this.fillHldFileArchivingInfo(subsInfo, data, conn);
        this.fillHldDataArchivingInfo(subsInfo, data, conn);
        this.fillSubsLogicFlowView(subsInfo, data, conn);
        this.fillPaasDuLogicFlowView(subsInfo, data, conn);
        this.fillPaasDuEcsLogicFlowView(subsInfo, data, conn);
        this.fillHldNfdInfo(subsInfo, data, conn);
        XWPFTemplate template = null;
        FileOutputStream out = null;
        try {
            ZipSecureFile.setMinInflateRatio((double)0.0);
            Configure config = Configure.builder().useSpringEL().build();
            template = XWPFTemplate.compile((String)templateFilePath, (Configure)config).render(data);
            out = new FileOutputStream(currentFilePath);
            template.write((OutputStream)out);
            out.flush();
            resultFilePath = currentFilePath;
            resultFilePath = this.fixWordFormat(resultFilePath);
        }
        catch (Exception e) {
            try {
                throw new RuntimeException("docx\u6a21\u677f\u6e32\u67d3\u5f02\u5e38 " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                WordResourceCloseUtil.closeXWPFTemplate(template);
                WordResourceCloseUtil.closeOutputStream(out);
                throw throwable;
            }
        }
        WordResourceCloseUtil.closeXWPFTemplate((XWPFTemplate)template);
        WordResourceCloseUtil.closeOutputStream((OutputStream)out);
        return resultFilePath;
    }

    private void fillTsTable(SSubsInfo subsInfo, Map<String, Object> data, Connection conn) throws Exception {
        TclComponentSubsDao tclComponentSubsDao = new TclComponentSubsDao(conn);
        TclComponentSubs param = new TclComponentSubs();
        param.setSubsId(subsInfo.getSubsId());
        List<TclComponentSubs> list = tclComponentSubsDao.queryList(param);
        RowRenderData row0 = Rows.of((String[])new String[]{"\u8f6f\u4ef6\u540d\u79f0", "\u7248\u672c\u4fe1\u606f", "\u8f6f\u4ef6\u7c7b\u578b", "\u5f00\u53d1\u8bed\u8a00", "\u8f6f\u4ef6\u529f\u80fd\u8bf4\u660e", "\u5f15\u5165\u5fc5\u8981\u6027\u5206\u6790", "\u51c6\u5165\u60c5\u51b5"}).textColor("000000").textBold().bgColor("bfbfbf").center().create();
        ArrayList<RowRenderData> rows = new ArrayList<RowRenderData>(list.size() + 1);
        rows.add(row0);
        rows.addAll(list.stream().map(ts -> {
            RowRenderData row = Rows.of((String[])new String[]{ts.getTclCmpName(), ts.getTclCmpVersion(), ts.getTclCmpSecondCatalogName(), "", ts.getTclCmpDesc(), "", ""}).textColor("000000").center().create();
            return row;
        }).collect(Collectors.toList()));
        data.put("tsTable", Tables.create((RowRenderData[])rows.toArray(new RowRenderData[0])));
    }

    private void fillFnModelInfo(SSubsInfo subsInfo, Map<String, Object> data, Connection conn) throws Exception {
        FnModelInfoService fnModelInfoService = (FnModelInfoService)SpringContextUtils.getBean(FnModelInfoService.class);
        FnModelInfoDTO fnParam = new FnModelInfoDTO();
        fnParam.setSubsId(subsInfo.getSubsId());
        List fnList = fnModelInfoService.queryList((Object)fnParam);
        if (CollectionUtils.isNotEmpty((Collection)fnList)) {
            ArrayList root = new ArrayList();
            ArrayList<Map> list = new ArrayList<Map>();
            HashMap<String, Map> map = new HashMap<String, Map>();
            for (FnModelInfoDTO fn : fnList) {
                Map map2 = BeanUtility.bean2Map((Object)fn);
                list.add(map2);
                map.put(fn.getFnId(), map2);
            }
            for (Map fnMap : list) {
                String string = MapUtils.getString((Map)fnMap, (Object)"fnAbvId");
                String moduleId = MapUtils.getString((Map)fnMap, (Object)"moduleId");
                Map fnAbvMap = MapUtils.getMap(map, (Object)string);
                if (fnAbvMap == null) {
                    ArrayList<Map> children;
                    HashMap module;
                    if (StringUtils.isBlank((CharSequence)moduleId)) {
                        moduleId = "root";
                    }
                    if ((module = MapUtils.getMap(map, (Object)moduleId)) == null) {
                        module = new HashMap();
                        module.put("moduleId", fnMap.get("moduleId"));
                        module.put("fnName", fnMap.get("moduleName"));
                        module.put("fnList", new ArrayList());
                        root.add(module);
                        map.put(moduleId, module);
                    }
                    if ((children = (ArrayList<Map>)module.get("fnList")) == null) {
                        children = new ArrayList<Map>();
                        module.put("fnList", children);
                    }
                    children.add(fnMap);
                    continue;
                }
                ArrayList<Map> children = (ArrayList<Map>)fnAbvMap.get("fnList");
                if (children == null) {
                    children = new ArrayList<Map>();
                    fnAbvMap.put("fnList", children);
                }
                children.add(fnMap);
            }
            ArrayList<Map<String, Object>> renderList = new ArrayList<Map<String, Object>>();
            for (Map map3 : root) {
                this.recursionFnFind(map3, renderList, 3);
            }
            data.put("fnList", renderList);
        }
    }

    private void recursionFnFind(Map<String, Object> map, List<Map<String, Object>> list, int level) {
        if (map == null) {
            return;
        }
        list.add(map);
        map.put("titleLevel", String.format("p%s", level));
        List children = (List)map.get("fnList");
        if (CollectionUtils.isNotEmpty((Collection)children)) {
            map.put("hasFnDesc", false);
            map.put("hasFnFlowDesc", false);
            map.put("hasFnRuleDesc", false);
            for (Map c : children) {
                this.recursionFnFind(c, list, level + 1);
            }
        } else {
            map.put("hasFnDesc", true);
            map.put("hasFnFlowDesc", true);
            map.put("hasFnRuleDesc", true);
            map.put("subTitleLevel", String.format("p%s", level + 1));
        }
    }

    private String fixWordFormat(String filePath) throws IOException {
        FileInputStream is = null;
        try {
            is = new FileInputStream(filePath);
            XWPFDocument doc = new XWPFDocument((InputStream)is);
            List paras = doc.getParagraphs();
            Map<String, String> styleMap = this.createStyleMap(doc);
            Pattern ppTextReg = Pattern.compile(".+?(p\\d+)$");
            for (XWPFParagraph pp : paras) {
                String ppText = pp.getParagraphText();
                Matcher m = ppTextReg.matcher(ppText);
                if (!m.matches()) continue;
                String levelStr = m.group(1);
                String levelNumStr = StringUtils.replace((String)levelStr, (String)"p", (String)"");
                String styleId = styleMap.get(levelStr);
                if (StringUtils.isNotBlank((CharSequence)styleId)) {
                    pp.setStyle(styleId);
                }
                List runs = pp.getRuns();
                while (runs.size() > 1) {
                    pp.removeRun(1);
                }
                XWPFRun run = (XWPFRun)runs.get(0);
                run.setText(ppText.replace(levelStr, ""), 0);
                int level = Integer.parseInt(levelNumStr);
                if (level == 1) {
                    run.setFontFamily("\u9ed1\u4f53");
                    run.setFontSize(18);
                    run.setBold(false);
                    continue;
                }
                if (level == 2) {
                    run.setFontFamily("\u9ed1\u4f53");
                    run.setFontSize(16);
                    run.setBold(false);
                    continue;
                }
                if (level == 3) {
                    run.setFontFamily("\u9ed1\u4f53");
                    run.setFontSize(15);
                    run.setBold(false);
                    continue;
                }
                if (level == 4) {
                    run.setFontFamily("\u9ed1\u4f53");
                    run.setFontSize(14);
                    run.setBold(false);
                    continue;
                }
                run.setFontFamily("\u9ed1\u4f53");
                run.setFontSize(12);
                run.setBold(false);
            }
            try (FileOutputStream output = new FileOutputStream(filePath);){
                doc.write((OutputStream)output);
            }
        }
        catch (IOException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        return filePath;
    }

    private Map<String, BigInteger> createTitleCTNum(XWPFDocument doc) {
        HashMap<String, BigInteger> map = new HashMap<String, BigInteger>();
        try {
            XWPFNumbering numbering = doc.getNumbering();
            List styles = doc.getStyle().getStyleList();
            List numList = Collections.emptyList();
            Field numsField = XWPFNumbering.class.getDeclaredField("nums");
            numList = (List)ReflectUtility.getObjectFieldValue((Object)numbering, (Field)numsField);
            Pattern lvlTextReg = Pattern.compile("(%\\d+\\.)+(%\\d+)");
            block2: for (XWPFNum num : numList) {
                BigInteger abstractNumId;
                XWPFAbstractNum absNum;
                List ctLvlList;
                BigInteger numId;
                XWPFNum xwpfNum;
                CTNum ctNum = num.getCTNum();
                if (ctNum == null || ctNum.getNumId() == null || (xwpfNum = numbering.getNum(numId = ctNum.getNumId())) == null || xwpfNum.getCTNum().getAbstractNumId() == null || !CollectionUtils.isNotEmpty((Collection)(ctLvlList = (absNum = numbering.getAbstractNum(abstractNumId = xwpfNum.getCTNum().getAbstractNumId().getVal())).getCTAbstractNum().getLvlList()))) continue;
                for (CTLvl lvl : ctLvlList) {
                    String lvlText = lvl.getLvlText().getVal();
                    if (!lvlTextReg.matcher(lvlText).matches()) continue;
                    String[] lvlStrs = StringUtils.split((String)lvlText, (String)".");
                    int level = lvlStrs.length;
                    map.put(String.format("p%s", level), numId);
                    continue block2;
                }
            }
        }
        catch (Exception e) {
            logger.error("\u5904\u7406Numbering\u5f02\u5e38 {}", (Object)e.getMessage(), (Object)e);
        }
        return map;
    }

    private Map<String, String> createStyleMap(XWPFDocument doc) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            XWPFStyles xwpfStyles = doc.getStyles();
            Field styleField = XWPFStyles.class.getDeclaredField("listStyle");
            List listStyle = (List)ReflectUtility.getObjectFieldValue((Object)xwpfStyles, (Field)styleField);
            if (CollectionUtils.isNotEmpty((Collection)listStyle)) {
                Pattern styleNameReg = Pattern.compile("(heading|Heading)\\s*(\\d+)");
                for (XWPFStyle style : listStyle) {
                    String name = style.getName();
                    Matcher m = styleNameReg.matcher(name);
                    if (!m.matches()) continue;
                    String num = m.group(2);
                    map.put(String.format("p%s", num), style.getStyleId());
                }
            }
        }
        catch (Exception e) {
            logger.error("\u5904\u7406\u6807\u9898\u6837\u5f0f\u5f02\u5e38 {}", (Object)e.getMessage(), (Object)e);
        }
        return map;
    }

    private void fillHldDataflowInfo(SSubsInfo subsInfo, Map<String, Object> data, Connection conn) throws Exception {
        HldDataflowInfoService hldDataflowInfoService = (HldDataflowInfoService)SpringContextUtils.getBean(HldDataflowInfoService.class);
        HldDataflowInfoDTO flowParam = new HldDataflowInfoDTO();
        flowParam.setSubsId(subsInfo.getSubsId());
        List flowList = hldDataflowInfoService.queryList((Object)flowParam);
        if (CollectionUtils.isNotEmpty((Collection)flowList)) {
            RowRenderData row0 = Rows.of((String[])new String[]{"\u4ea4\u6362\u6570\u636e\u5b9e\u4f53", "\u6e90\u7cfb\u7edf", "\u76ee\u5f55\u7cfb\u7edf"}).textColor("000000").textBold().bgColor("bfbfbf").center().create();
            ArrayList<RowRenderData> rows = new ArrayList<RowRenderData>(flowList.size() + 1);
            rows.add(row0);
            rows.addAll(flowList.stream().map(ts -> {
                RowRenderData row = Rows.of((String[])new String[]{ts.getTableModelName(), ts.getSourceSubsName(), ts.getTargetSubsName()}).textColor("000000").center().create();
                return row;
            }).collect(Collectors.toList()));
            data.put("dataFlowTable", Tables.create((RowRenderData[])rows.toArray(new RowRenderData[0])));
        }
    }

    private void fillHldCapacityInfo(SSubsInfo subsInfo, Map<String, Object> data, Connection conn) throws Exception {
        HldCapacityInfoService hldCapacityInfoService = (HldCapacityInfoService)SpringContextUtils.getBean(HldCapacityInfoService.class);
        HldCapacityInfoDTO param = new HldCapacityInfoDTO();
        param.setSubsId(subsInfo.getSubsId());
        param.setSize(Integer.valueOf(Integer.MAX_VALUE));
        List list = hldCapacityInfoService.queryAllOwnerGroupByPage(param);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            RowRenderData row0 = Rows.of((String[])new String[]{"\u6570\u636e\u7c7b\u578b", "\u5b58\u50a8\u65b9\u5f0f", "\u7b2c\u4e00\u5e74", "\u7b2c\u4e8c\u5e74", "\u7b2c\u4e09\u5e74", "\u7b2c\u56db\u5e74", "\u7b2c\u4e94\u5e74"}).textColor("FFFFFF").textBold().bgColor("0070c0").center().create();
            ArrayList<RowRenderData> rows = new ArrayList<RowRenderData>(list.size() + 1);
            rows.add(row0);
            rows.addAll(list.stream().map(ts -> {
                RowRenderData row = Rows.of((String[])new String[]{CapacityType.nameByCode((String)ts.getCapacityType()), StorageType.nameByCode((String)ts.getStorageMode()), this.wrapperCapacity(ts.getCapacity1()), this.wrapperCapacity(ts.getCapacity2()), this.wrapperCapacity(ts.getCapacity3()), this.wrapperCapacity(ts.getCapacity4()), this.wrapperCapacity(ts.getCapacity5())}).textColor("000000").center().create();
                return row;
            }).collect(Collectors.toList()));
            data.put("capacityTable", Tables.create((RowRenderData[])rows.toArray(new RowRenderData[0])));
        }
    }

    private String wrapperCapacity(BigDecimal num) {
        if (num == null) {
            return "0G";
        }
        String cap = num.toString();
        if (StringUtils.isBlank((CharSequence)cap)) {
            return "0G";
        }
        return String.format("%sG", cap);
    }

    private void fillHldFileArchivingInfo(SSubsInfo subsInfo, Map<String, Object> data, Connection conn) throws Exception {
        HldFileArchivingInfoService hldFileArchivingInfoService = (HldFileArchivingInfoService)SpringContextUtils.getBean(HldFileArchivingInfoService.class);
        HldFileArchivingInfoDTO param = new HldFileArchivingInfoDTO();
        param.setSubsId(subsInfo.getSubsId());
        List list = hldFileArchivingInfoService.queryList((Object)param);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            RowRenderData row0 = Rows.of((String[])new String[]{"\u65e5\u5fd7\u6216\u6587\u4ef6", "\u662f\u5426\u538b\u7f29", "\u5f52\u6863\u65b9\u5f0f", "\u5f52\u6863\u5468\u671f"}).textColor("FFFFFF").textBold().bgColor("0070c0").center().create();
            ArrayList<RowRenderData> rows = new ArrayList<RowRenderData>(list.size() + 1);
            rows.add(row0);
            rows.addAll(list.stream().map(ts -> {
                RowRenderData row = Rows.of((String[])new String[]{ts.getFileName(), StringUtils.equals((CharSequence)ts.getCompressionFlag(), (CharSequence)YesOrNO.YES.getCode()) ? YesOrNO.YES.getName() : YesOrNO.NO.getName(), ArchivingMode.nameByCode((String)ts.getFileArchivingMode()), ArchivingCycle.nameByCode((String)ts.getArchivingCycle())}).textColor("000000").center().create();
                return row;
            }).collect(Collectors.toList()));
            data.put("fileArchivingTable", Tables.create((RowRenderData[])rows.toArray(new RowRenderData[0])));
        }
    }

    private void fillHldDataArchivingInfo(SSubsInfo subsInfo, Map<String, Object> data, Connection conn) throws Exception {
        HldDataArchivingInfoService hldDataArchivingInfoService = (HldDataArchivingInfoService)SpringContextUtils.getBean(HldDataArchivingInfoService.class);
        HldDataArchivingInfoDTO param = new HldDataArchivingInfoDTO();
        param.setSubsId(subsInfo.getSubsId());
        List list = hldDataArchivingInfoService.queryList((Object)param);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            RowRenderData row0 = Rows.of((String[])new String[]{"\u6570\u636e\u5b9e\u4f53", "\u5f52\u6863\u65b9\u5f0f", "\u5f52\u6863\u5468\u671f"}).textColor("FFFFFF").textBold().bgColor("0070c0").center().create();
            ArrayList<RowRenderData> rows = new ArrayList<RowRenderData>(list.size() + 1);
            rows.add(row0);
            rows.addAll(list.stream().map(ts -> {
                RowRenderData row = Rows.of((String[])new String[]{ts.getTableModelName(), ArchivingMode.nameByCode((String)ts.getArchivingMode()), ArchivingCycle.nameByCode((String)ts.getArchivingCycle())}).textColor("000000").center().create();
                return row;
            }).collect(Collectors.toList()));
            data.put("dataArchivingTable", Tables.create((RowRenderData[])rows.toArray(new RowRenderData[0])));
        }
    }

    private void fillSubsLogicFlowView(SSubsInfo subsInfo, Map<String, Object> data, Connection conn) throws Exception {
        String url = String.format("allinpaas-rdm/page/rdm-console/SubsInfoLogicFlowView.html?subsId=%s", subsInfo.getSubsId());
        String viewBase64 = this.requestHostLogicFlowView(url);
        if (StringUtils.isBlank((CharSequence)viewBase64)) {
            logger.error("\u83b7\u53d6\u4e0d\u5230\u5e94\u7528\u67b6\u6784\u56fe {}", (Object)subsInfo.getSubsId());
            data.put("subsLogicFlowView", null);
            return;
        }
        BufferedImage img = ImageIO.read(new ByteArrayInputStream(ByteUtils.getBase64ByteArray((String)viewBase64)));
        data.put("subsLogicFlowView", Pictures.ofBufferedImage((BufferedImage)img, (PictureType)PictureType.PNG).size(Double.valueOf((double)img.getWidth() * 0.2).intValue(), Double.valueOf((double)img.getHeight() * 0.2).intValue()).create());
    }

    private void fillPaasDuLogicFlowView(SSubsInfo subsInfo, Map<String, Object> data, Connection conn) throws Exception {
        String url = String.format("allinapaas-portal/page/allinpaas-console-apopaas/PaasAppsDuSubsLogicFlowView.html?subsId=%s&envId=dev", subsInfo.getSubsId());
        String viewBase64 = this.requestHostLogicFlowView(url);
        if (StringUtils.isBlank((CharSequence)viewBase64)) {
            logger.error("\u83b7\u53d6\u4e0d\u5230\u5e94\u7528\u67b6\u6784\u56fe {}", (Object)subsInfo.getSubsId());
            data.put("paasDuLogicFlowView", null);
            return;
        }
        BufferedImage img = ImageIO.read(new ByteArrayInputStream(ByteUtils.getBase64ByteArray((String)viewBase64)));
        data.put("paasDuLogicFlowView", Pictures.ofBufferedImage((BufferedImage)img, (PictureType)PictureType.PNG).size(Double.valueOf((double)img.getWidth() * 0.2).intValue(), Double.valueOf((double)img.getHeight() * 0.2).intValue()).create());
    }

    private void fillPaasDuEcsLogicFlowView(SSubsInfo subsInfo, Map<String, Object> data, Connection conn) throws Exception {
        String url = String.format("allinapaas-portal/page/allinpaas-console-apopaas/PaasAppsDuEcsLogicFlowView.html?subsId=%s&envId=dev", subsInfo.getSubsId());
        String viewBase64 = this.requestHostLogicFlowView(url);
        if (StringUtils.isBlank((CharSequence)viewBase64)) {
            logger.error("\u83b7\u53d6\u4e0d\u5230\u5e94\u7528\u67b6\u6784\u56fe {}", (Object)subsInfo.getSubsId());
            data.put("paasDuEcsLogicFlowView", null);
            return;
        }
        BufferedImage img = ImageIO.read(new ByteArrayInputStream(ByteUtils.getBase64ByteArray((String)viewBase64)));
        data.put("paasDuEcsLogicFlowView", Pictures.ofBufferedImage((BufferedImage)img, (PictureType)PictureType.PNG).size(Double.valueOf((double)img.getWidth() * 0.2).intValue(), Double.valueOf((double)img.getHeight() * 0.2).intValue()).create());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String requestHostLogicFlowView(String url) {
        ChromeDriver driver = null;
        try {
            String webDriver = SpringPropertyUtils.getProperty((String)"chromium.webdriver");
            String webRoot = SpringPropertyUtils.getProperty((String)"cas.client-host-url");
            System.setProperty("webdriver.chrome.driver", webDriver);
            ChromeOptions options = new ChromeOptions();
            options.addArguments(new String[]{"--headless"});
            options.addArguments(new String[]{"--no-sandbox"});
            options.addArguments(new String[]{"headless", "no-sandbox"});
            options.addArguments(new String[]{"--disable-gpu"});
            options.addArguments(new String[]{"--window-size=1300,768"});
            options.addArguments(new String[]{"--remote-allow-origins=*"});
            driver = new ChromeDriver(options);
            driver.get(String.format("%s%s", webRoot, url));
            driver.manage().timeouts().implicitlyWait(Duration.ofSeconds(1L));
            WebElement el = driver.findElement(By.id((String)"flowImg"));
            String base64 = el.getAttribute("src");
            String string = base64 = StringUtils.replaceOnce((String)base64, (String)"data:image/png;base64,", (String)"");
            return string;
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u67b6\u6784\u56fe\u5f02\u5e38 {}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            if (driver != null) {
                driver.quit();
            }
        }
        return null;
    }

    private void fillHldNfdInfo(SSubsInfo subsInfo, Map<String, Object> data, Connection conn) throws Exception {
        data.put("nfdList", Collections.emptyList());
    }

    private void recursionNfdFind(Map<String, Object> map, List<Map<String, Object>> list, int level) {
        if (map == null) {
            return;
        }
        map.put("titleLevel", String.format("p%s", level));
        List children = (List)map.get("list");
        if (CollectionUtils.isNotEmpty((Collection)children)) {
            list.add(map);
            for (Map c : children) {
                this.recursionNfdFind(c, list, level + 1);
            }
        } else {
            String nfdSchemeDesc = MapUtils.getString(map, (Object)"nfdSchemeDesc");
            if (StringUtils.isNotBlank((CharSequence)nfdSchemeDesc)) {
                list.add(map);
            }
        }
    }
}

