/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.docs.gendoc;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasDocTemplate;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.docs.gendoc.DocGenerate;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.docs.git.queue.DocTemplateRepoPullQueueExecutor;
import com.irdstudio.allinapaas.executor.application.executor.core.tinycore.jdbc.dbcp.base.IConnPool;
import com.irdstudio.allinapaas.executor.application.executor.core.util.date.CurrentDateUtil;
import com.irdstudio.allinrdm.dev.console.types.YesOrNO;
import com.irdstudio.allinrdm.project.console.facade.RdmProjectInfoService;
import com.irdstudio.allinrdm.project.console.facade.RdmTaskInfoService;
import com.irdstudio.allinrdm.project.console.facade.dto.RdmProjectInfoDTO;
import com.irdstudio.allinrdm.project.console.facade.dto.RdmTaskInfoDTO;
import com.irdstudio.allinrdm.project.console.types.TaskCategory;
import com.irdstudio.allinrdm.project.console.types.TaskState;
import com.irdstudio.allinrdm.project.console.types.TaskType;
import com.irdstudio.sdk.beans.core.util.BeanUtility;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import java.io.File;
import java.sql.Connection;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class GenRdmTaskAnalysisExcel
implements DocGenerate {
    protected RdmTaskInfoService rdmTaskInfoService;

    @Override
    public List<File> generateDoc(PaasDocTemplate template, String subsId, File baseDir, IConnPool connTool, Map<String, Object> extParams) {
        this.rdmTaskInfoService = (RdmTaskInfoService)SpringContextUtils.getBean(RdmTaskInfoService.class);
        return null;
    }

    public void fillRdmTaskList(ExcelWriter excelWriter, WriteSheet sheet, RdmTaskInfoDTO taskParam) {
        List rows = this.rdmTaskInfoService.queryList((Object)taskParam);
        if (CollectionUtils.isEmpty((Collection)rows)) {
            rows = Collections.emptyList();
        }
        for (int i = 0; i < rows.size(); ++i) {
            RdmTaskInfoDTO task = (RdmTaskInfoDTO)rows.get(i);
            task.setSeq(Integer.valueOf(i + 1));
            task.setTaskCategory(TaskCategory.nameByCode((String)task.getTaskCategory()));
            task.setTaskType(TaskType.nameByCode((String)task.getTaskType()));
            task.setTaskState(TaskState.nameByCode((String)task.getTaskState()));
        }
        excelWriter.fill(rows, sheet);
    }

    @Override
    public File generateAppDoc(PaasDocTemplate template, String appId, File baseDir, IConnPool connTool, Map<String, Object> extParams) {
        Connection conn = null;
        try {
            this.rdmTaskInfoService = (RdmTaskInfoService)SpringContextUtils.getBean(RdmTaskInfoService.class);
            conn = connTool.getConnection();
            File currentFile = this.getDocDirPath(template, baseDir, conn);
            if (!currentFile.exists()) {
                currentFile.mkdirs();
            }
            String projectId = MapUtils.getString(extParams, (Object)"projectId");
            String planId = MapUtils.getString(extParams, (Object)"planId");
            String splitUser = MapUtils.getString(extParams, (Object)"splitUser");
            RdmProjectInfoService rdmProjectInfoService = (RdmProjectInfoService)SpringContextUtils.getBean(RdmProjectInfoService.class);
            RdmProjectInfoDTO projectInfo = new RdmProjectInfoDTO();
            projectInfo.setProjectId(projectId);
            projectInfo = (RdmProjectInfoDTO)rdmProjectInfoService.queryByPk((Object)projectInfo);
            String userId = template.getLoginUserId();
            String today = CurrentDateUtil.getTodayDate();
            String todayTime = CurrentDateUtil.getTodayDateEx2();
            String time = CurrentDateUtil.getCurrentTime();
            Map rootMap = BeanUtility.bean2Map((Object)projectInfo);
            rootMap.put("today", today);
            rootMap.put("todayTime", todayTime);
            rootMap.put("time", time);
            String fileName = template.getDocName();
            if (StringUtils.isNotBlank((CharSequence)template.getDocNameTemplate())) {
                fileName = this.renderDocName(template.getDocNameTemplate(), rootMap);
            }
            DocTemplateRepoPullQueueExecutor.syncRun();
            String excelTemplatePath = DocTemplateRepoPullQueueExecutor.getDocTemplatePath();
            File templateFile = new File(excelTemplatePath, template.getDocFile());
            File targetFile = new File(currentFile, fileName);
            RdmTaskInfoDTO taskAnalysisParam = new RdmTaskInfoDTO();
            taskAnalysisParam.setProjectId(projectId);
            taskAnalysisParam.setPlanId(planId);
            taskAnalysisParam.setSize(Integer.valueOf(Integer.MAX_VALUE));
            List analysisList = this.rdmTaskInfoService.queryRdmTaskInchargeGroupByPage(taskAnalysisParam);
            if (StringUtils.equals((CharSequence)splitUser, (CharSequence)YesOrNO.YES.getCode())) {
                String sheetName;
                ExcelWriter excelWriter;
                ExcelWriterBuilder writerBuilder;
                String newTmpTemplateID = UUIDUtil.getShortUUID() + ".xlsx";
                String excelTempFile = currentFile.getAbsolutePath() + File.separator + newTmpTemplateID;
                if (CollectionUtils.isNotEmpty((Collection)analysisList)) {
                    writerBuilder = EasyExcel.write((String)excelTempFile);
                    excelWriter = writerBuilder.withTemplate(templateFile).build();
                    Workbook workbook = excelWriter.writeContext().writeWorkbookHolder().getCachedWorkbook();
                    int sheetCount = analysisList.size();
                    for (int i = 0; i < sheetCount; ++i) {
                        if (i > 0) {
                            Sheet sheet = excelWriter.writeContext().writeWorkbookHolder().getCachedWorkbook().cloneSheet(i);
                        }
                        Map currentInfo = (Map)analysisList.get(i);
                        try {
                            sheetName = MapUtils.getString((Map)currentInfo, (Object)"incharge_name");
                            workbook.setSheetName(i + 1, sheetName);
                            continue;
                        }
                        catch (Exception e) {
                            logger.error(e.getMessage(), (Throwable)e);
                        }
                    }
                    excelWriter.finish();
                } else {
                    excelTempFile = templateFile.getAbsolutePath();
                }
                writerBuilder = EasyExcel.write((File)targetFile);
                excelWriter = writerBuilder.withTemplate(excelTempFile).build();
                WriteSheet firstSheet = EasyExcel.writerSheet((Integer)0, null).build();
                excelWriter.fill((Object)analysisList, firstSheet);
                if (CollectionUtils.isNotEmpty((Collection)analysisList)) {
                    for (int i = 0; i < analysisList.size(); ++i) {
                        Map currentInfo = (Map)analysisList.get(i);
                        String incharge = MapUtils.getString((Map)currentInfo, (Object)"incharge");
                        sheetName = MapUtils.getString((Map)currentInfo, (Object)"incharge_name");
                        WriteSheet sheet = EasyExcel.writerSheet((Integer)(i + 1), (String)sheetName).build();
                        RdmTaskInfoDTO taskParam = new RdmTaskInfoDTO();
                        taskParam.setProjectId(projectId);
                        taskParam.setPlanId(planId);
                        taskParam.setIncharge(incharge);
                        this.fillRdmTaskList(excelWriter, sheet, taskParam);
                    }
                    excelWriter.finish();
                } else {
                    WriteSheet sheet = EasyExcel.writerSheet((Integer)1, null).build();
                    RdmTaskInfoDTO taskParam = new RdmTaskInfoDTO();
                    taskParam.setProjectId(projectId);
                    taskParam.setPlanId(planId);
                    this.fillRdmTaskList(excelWriter, sheet, taskParam);
                    excelWriter.finish();
                }
            } else {
                ExcelWriter excelWriter = EasyExcel.write((File)targetFile).withTemplate(templateFile).build();
                WriteSheet firstSheet = EasyExcel.writerSheet((Integer)0, null).build();
                excelWriter.fill((Object)analysisList, firstSheet);
                WriteSheet sheet = EasyExcel.writerSheet((Integer)1, null).build();
                RdmTaskInfoDTO taskParam = new RdmTaskInfoDTO();
                taskParam.setProjectId(projectId);
                taskParam.setPlanId(planId);
                this.fillRdmTaskList(excelWriter, sheet, taskParam);
                excelWriter.finish();
            }
            File file = targetFile;
            connTool.releaseConnection(conn);
            return file;
        }
        catch (Exception e) {
            try {
                logger.error("\u9879\u76ee\u4efb\u52a1\u5206\u5e03\u6e05\u5355\u5f02\u5e38 " + e.getMessage(), (Throwable)e);
                throw new RuntimeException("\u9879\u76ee\u4efb\u52a1\u5206\u5e03\u6e05\u5355\u5f02\u5e38 " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                connTool.releaseConnection(conn);
                throw throwable;
            }
        }
    }
}

