/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.excel.export;

import com.irdstudio.allinapaas.executor.application.executor.core.plugin.excel.util.ExcelUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.tinycore.log.ILogger;
import com.irdstudio.allinapaas.executor.application.executor.core.tinycore.log.TLogger;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageInputStream;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelTemplateBuilder {
    private FileOutputStream fileOutputStream = null;
    private Workbook workbook = null;
    private Sheet sheet = null;
    private int excelFileVerion;
    private ILogger logger = null;
    private int currentSheetNo;
    HSSFPatriarch patriarch = null;

    public ExcelTemplateBuilder(String templateURL) {
        this.excelFileVerion = ExcelUtil.getExcelFileVersion(templateURL);
        if (0 == this.excelFileVerion) {
            System.out.println("\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a\u6216\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
        } else {
            this.logger = TLogger.getLogger("ExcelTemplateBuilder");
            try {
                FileInputStream templateFileInput = new FileInputStream(templateURL);
                if (1 == this.excelFileVerion) {
                    this.workbook = new HSSFWorkbook(new POIFSFileSystem((InputStream)templateFileInput));
                    this.sheet = (HSSFSheet)this.workbook.getSheetAt(0);
                } else {
                    this.workbook = new XSSFWorkbook((InputStream)templateFileInput);
                    this.sheet = (XSSFSheet)this.workbook.getSheetAt(0);
                }
                this.currentSheetNo = 0;
                this.logger.info("========" + templateURL + "\u6587\u4ef6\u52a0\u8f7d\u5df2\u5b8c\u6210========");
            }
            catch (Exception e) {
                this.logger.error("Load Template Erro\uff0c\u6587\u4ef6\u52a0\u8f7d\u5931\u8d25\uff01\uff01", e);
            }
        }
    }

    public void writeIn(String newContent, int sheetNo, int beginRow, int beginCell) {
        Cell cell;
        this.positionToSheet(sheetNo);
        Row row = this.sheet.getRow(beginRow);
        if (null == row) {
            row = this.sheet.createRow(beginRow);
        }
        if (null == (cell = row.getCell(beginCell))) {
            cell = row.createCell(beginCell);
        }
        cell.setCellValue(newContent);
    }

    private void positionToSheet(int sheetNo) {
        if (sheetNo != this.currentSheetNo) {
            this.sheet = 1 == this.excelFileVerion ? (HSSFSheet)this.workbook.getSheetAt(sheetNo) : (XSSFSheet)this.workbook.getSheetAt(sheetNo);
            this.currentSheetNo = sheetNo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeIn(String imageFileURL, int dx1, int dy1, int dx2, int dy2, short col1, int row1, short col2, int row2) {
        BufferedImage bufferImage = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            File fileImage = new File(imageFileURL);
            bufferImage = ImageIO.read(fileImage);
            ImageIO.write((RenderedImage)bufferImage, "JPG", byteArrayOutputStream);
            System.out.println("ImageIO \u5199\u5165\u5b8c\u6210");
            HSSFPatriarch patriarch = (HSSFPatriarch)this.sheet.createDrawingPatriarch();
            HSSFClientAnchor anchor = new HSSFClientAnchor(dx1, dy1, dx2, dy2, col1, row1, col2, row2);
            byte[] pictureData = byteArrayOutputStream.toByteArray();
            int pictureFormat = 5;
            int pictureIndex = this.workbook.addPicture(pictureData, pictureFormat);
            patriarch.createPicture(anchor, pictureIndex);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
        finally {
            if (this.fileOutputStream != null) {
                try {
                    this.fileOutputStream.close();
                }
                catch (IOException io) {
                    this.logger.error(io.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeIn(ImageInputStream imageInputStream, int dx1, int dy1, int dx2, int dy2, short col1, int row1, short col2, int row2) {
        BufferedImage bufferImage = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            bufferImage = ImageIO.read(imageInputStream);
            ImageIO.write((RenderedImage)bufferImage, "JPG", byteArrayOutputStream);
            System.out.println("ImageIO \u5199\u5165\u5b8c\u6210");
            HSSFPatriarch patriarch = (HSSFPatriarch)this.sheet.createDrawingPatriarch();
            HSSFClientAnchor anchor = new HSSFClientAnchor(dx1, dy1, dx2, dy2, col1, row1, col2, row2);
            byte[] pictureData = byteArrayOutputStream.toByteArray();
            int pictureFormat = 5;
            int pictureIndex = this.workbook.addPicture(pictureData, pictureFormat);
            patriarch.createPicture(anchor, pictureIndex);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
        finally {
            if (this.fileOutputStream != null) {
                try {
                    this.fileOutputStream.close();
                }
                catch (IOException e) {
                    this.logger.error(e.getMessage());
                }
            }
        }
    }

    public void saveAsTargetExcel(String targetExcelFile) {
        try {
            this.fileOutputStream = new FileOutputStream(targetExcelFile);
            this.workbook.write((OutputStream)this.fileOutputStream);
        }
        catch (Exception e) {
            this.logger.info("IO Erro" + e.getMessage());
        }
        finally {
            if (this.fileOutputStream != null) {
                try {
                    this.fileOutputStream.close();
                }
                catch (IOException e) {
                    this.logger.error(e.getMessage());
                }
            }
        }
    }
}

