/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.market;

import com.alibaba.fastjson.JSON;
import com.irdstudio.allinapaas.design.console.types.MarketSource;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEnvParamDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasMarketAppinfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasMarketAppinfo;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.market.AbstractMarketTask;
import com.irdstudio.allinapaas.portal.console.types.YesOrNO;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class CPSqliteRefProdTask
extends AbstractMarketTask {
    private PaasMarketAppinfo appInfo = null;
    private Map<String, Object> extParam = null;

    @Override
    public boolean initTask(Map<String, Object> extParam, Connection conn) throws SQLException {
        this.extParam = extParam;
        PaasMarketAppinfoDao paasAppsInfoDao = new PaasMarketAppinfoDao(conn);
        this.appInfo = paasAppsInfoDao.queryPaasMarketAppinfo(MapUtils.getString(extParam, (Object)"marketAppId"));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        boolean flag = true;
        Connection conn = null;
        Connection sqliteConn = null;
        try {
            conn = this.getConnection();
            PaasEnvParamDao paasEnvParamDao = new PaasEnvParamDao(conn);
            String subsFlag = MapUtils.getString(this.extParam, (Object)"subsFlag");
            String marketSource = MapUtils.getString(this.extParam, (Object)"marketSource");
            String subsId = MapUtils.getString(this.extParam, (Object)"marketSubsId");
            ArrayList<PaasMarketAppinfo> appInfoList = new ArrayList<PaasMarketAppinfo>();
            if (StringUtils.equals((CharSequence)marketSource, (CharSequence)MarketSource.Inside.getCode())) {
                if (StringUtils.equals((CharSequence)subsFlag, (CharSequence)YesOrNO.YES.getCode())) {
                    PaasMarketAppinfoDao paasAppsInfoDao = new PaasMarketAppinfoDao(conn);
                    PaasMarketAppinfo appParam = new PaasMarketAppinfo();
                    appParam.setSubsId(subsId);
                    List<PaasMarketAppinfo> sysApps = paasAppsInfoDao.queryPaasMarketAppinfoList(appParam);
                    appInfoList.addAll(sysApps);
                } else {
                    appInfoList.add(this.appInfo);
                }
            } else {
                String apiUrl = paasEnvParamDao.queryByCodeReturnValue("allinpaas.open.api.http.url");
                if (StringUtils.equals((CharSequence)subsFlag, (CharSequence)YesOrNO.YES.getCode())) {
                    PaasMarketAppinfo param = new PaasMarketAppinfo();
                    param.setSubsId(subsId);
                    String respJson = this.requestOpenApi(apiUrl + "/om/paas/market/appinfo/index", (Object)param);
                    if (StringUtils.isBlank((CharSequence)respJson)) {
                        boolean bl = flag = false;
                        return bl;
                    }
                    List sysApps = JSON.parseArray((String)respJson, PaasMarketAppinfo.class);
                    appInfoList.addAll(sysApps);
                } else {
                    PaasMarketAppinfo param = new PaasMarketAppinfo();
                    param.setMarketAppId(MapUtils.getString(this.extParam, (Object)"marketAppId"));
                    String respJson = this.requestOpenApi(apiUrl + "/om/paas/market/appinfo", (Object)param);
                    if (StringUtils.isBlank((CharSequence)respJson)) {
                        boolean sysApps = flag = false;
                        return sysApps;
                    }
                    PaasMarketAppinfo marketApp = (PaasMarketAppinfo)((Object)JSON.parseObject((String)respJson, PaasMarketAppinfo.class));
                    appInfoList.add(marketApp);
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u4ecesqlite\u590d\u5236\u7ec4\u5408\u670d\u52a1\u5230\u5e73\u53f0", (Throwable)e);
            flag = false;
        }
        finally {
            if (conn != null) {
                this.closeConnection(conn);
            }
            if (sqliteConn != null) {
                this.closeSqliteConnection(sqliteConn);
            }
        }
        return flag;
    }
}

