/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.market;

import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEnvParamDao;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.git.JGitUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.market.AbstractMarketTask;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FileUtils;

public class StdPushRepoTask
extends AbstractMarketTask {
    private Map<String, Object> extParam = null;

    @Override
    public boolean initTask(Map<String, Object> extParam, Connection conn) throws SQLException {
        this.extParam = extParam;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        boolean flag = true;
        Connection conn = null;
        try {
            conn = this.getConnection();
            PaasEnvParamDao paasEnvParamDao = new PaasEnvParamDao(conn);
            String username = paasEnvParamDao.queryByCodeReturnValue("git.username");
            String password = paasEnvParamDao.queryByCodeReturnValue("git.password");
            String marketUrl = paasEnvParamDao.queryByCodeReturnValue("git.market.remote.path");
            String branchName = paasEnvParamDao.queryByCodeReturnValue("git.market.branch.name");
            String stdCode = MapUtils.getString(this.extParam, (Object)"marketStdCode");
            File sqliteFile = this.getStdSqliteFile(this.extParam);
            File parentDir = sqliteFile.getParentFile();
            File repoDir = new File(parentDir, stdCode + "-repo");
            FileUtils.deleteDirectory((File)repoDir);
            this.logger.info("\u51c6\u5907\u672c\u5730\u4ed3\u5e93\u5730\u5740\uff1a" + repoDir.getAbsolutePath());
            JGitUtil jGitUtil = new JGitUtil(repoDir.getAbsolutePath(), marketUrl, username, password);
            jGitUtil.cloneBranch(branchName);
            this.logger.info("\u62c9\u53d6\u4ed3\u5e93\u5b8c\u6210\uff1a" + marketUrl);
            File targetDir = new File(repoDir, "data-std");
            File destSqliteFile = new File(targetDir, sqliteFile.getName());
            if (!targetDir.exists()) {
                targetDir.mkdir();
            }
            FileUtils.copyFile((File)sqliteFile, (File)destSqliteFile);
            this.logger.info("\u590d\u5236sqlite\u5b8c\u6210\uff1a" + destSqliteFile.getAbsolutePath());
            jGitUtil.addAll();
            jGitUtil.commit(String.format("\u53d1\u5e03%s", sqliteFile.getName()));
            jGitUtil.push();
            jGitUtil.close();
            this.logger.info("\u63a8\u9001\u4ed3\u5e93\u5b8c\u6210\uff1a" + marketUrl);
        }
        catch (Exception e) {
            this.logger.error("\u63d0\u4ea4sqlite\u5230\u5e94\u7528\u5e02\u573a\u4ed3\u5e93", (Throwable)e);
        }
        finally {
            if (conn != null) {
                this.closeConnection(conn);
            }
        }
        return flag;
    }
}

