/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.market;

import com.irdstudio.allinapaas.design.console.types.AppType;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.DictItemInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.DictOptionEnumDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.DictOptionInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.ModelFolderInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.ModelTableFieldDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.ModelTableIndexDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.ModelTableInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.OsrvArrangeTableDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.OsrvArrangeVarDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.OsrvEvalIsrvDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.OsrvEvalVarDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsParamDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsPropertiesDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsSqlDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.SrvEvalFuncDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.SrvFieldFlagDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.SrvModelFeatureDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.SrvModelInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.SrvModelInoutDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.SrvModelPackageDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.DictItemInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.DictOptionEnum;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.DictOptionInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.ModelFolderInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.ModelTableField;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.ModelTableIndex;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.ModelTableInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsParam;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsProperties;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsSql;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SrvFieldFlag;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SrvModelInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SrvModelInout;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SrvModelPackage;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.market.AbstractMarketTask;
import com.irdstudio.allinrdm.dev.console.types.SrvModelCatalogEnum;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class SysMarketCpRefCpnTask
extends AbstractMarketTask {
    private Map<String, Object> extParam = null;

    @Override
    public boolean initTask(Map<String, Object> extParam, Connection conn) throws SQLException {
        this.extParam = extParam;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        boolean flag = true;
        Connection conn = null;
        Connection sqliteConn = null;
        try {
            conn = this.getConnection();
            String subsId = MapUtils.getString(this.extParam, (Object)"marketSubsId");
            PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
            List<PaasAppsInfo> appList = paasAppsInfoDao.queryPaasAppsInfoListBySysCode(subsId);
            List<String> cpnAppTypes = Arrays.asList(AppType.A10.getCode());
            if (CollectionUtils.isNotEmpty(appList)) {
                File sqliteFile = this.getSysSqliteFile(this.extParam, null);
                sqliteConn = this.getSqliteConnection(sqliteFile);
                for (PaasAppsInfo appInfo : appList) {
                    if (cpnAppTypes.indexOf(appInfo.getAppType()) < 0) continue;
                    String refAppId = appInfo.getRefAppId();
                    ArrayList<String> projectIds = new ArrayList<String>();
                    if (appInfo != null) {
                        ModelFolderInfoDao projectTmPackageDao = new ModelFolderInfoDao(conn);
                        ModelFolderInfo packageParam = new ModelFolderInfo();
                        packageParam.setAppId(appInfo.getAppId());
                        List<ModelFolderInfo> packageList = projectTmPackageDao.queryModelFolderInfo(packageParam);
                        this.batchInsert("model_folder_info", packageList, sqliteConn);
                        ModelTableInfoDao modelTableInfoDao = new ModelTableInfoDao(conn);
                        List<ModelTableInfo> tables = modelTableInfoDao.queryModelTableInfoList(appInfo.getAppId());
                        this.batchInsertPage("model_table_info", tables, sqliteConn);
                        ModelTableIndexDao modelTableIndexDao = new ModelTableIndexDao(conn);
                        List<ModelTableIndex> indexs = modelTableIndexDao.queryModelTableInfos(appInfo.getAppId());
                        this.batchInsertPage("model_table_index", indexs, sqliteConn);
                        ModelTableFieldDao modelTableFieldDao = new ModelTableFieldDao(conn);
                        List<ModelTableField> fields = modelTableFieldDao.queryFieldByAppId(appInfo.getAppId());
                        this.batchInsertPage("model_table_field", fields, sqliteConn);
                        SrvFieldFlagDao srvFieldFlagDao = new SrvFieldFlagDao(conn);
                        List<SrvFieldFlag> fieldFlags = srvFieldFlagDao.queryFieldFlagByAppId(appInfo.getAppId());
                        this.batchInsertPage("srv_field_flag", fieldFlags, sqliteConn);
                        projectIds.add(appInfo.getAppId());
                        DictOptionInfoDao dictOptionInfoDao = new DictOptionInfoDao(conn);
                        DictOptionEnumDao dictOptionEnumDao = new DictOptionEnumDao(conn);
                        HashMap<String, DictOptionInfo> optionInfoMap = new HashMap<String, DictOptionInfo>();
                        ArrayList<DictOptionInfo> optionInfoList = new ArrayList<DictOptionInfo>();
                        ArrayList<DictOptionEnum> optionEnumList = new ArrayList<DictOptionEnum>();
                        List<ModelTableField> optionsList = modelTableFieldDao.queryModelTableFieldAllOptions(appInfo.getAppId());
                        if (CollectionUtils.isNotEmpty(optionsList)) {
                            ArrayList codeBoList = new ArrayList(optionsList.size());
                            for (ModelTableField option : optionsList) {
                                if (StringUtils.isBlank((CharSequence)option.getDictId()) || optionInfoMap.get(option.getDictId()) != null) continue;
                                List<DictOptionEnum> dicts = dictOptionEnumDao.queryDictOptionEnumListByDictId(option.getDictId());
                                DictOptionInfo optionInfo = dictOptionInfoDao.queryByPk(option.getDictId());
                                optionInfoMap.put(optionInfo.getDictId(), optionInfo);
                                optionInfoList.add(optionInfo);
                                optionEnumList.addAll(dicts);
                            }
                        }
                        this.batchInsertPage("dict_option_info", optionInfoList, sqliteConn);
                        this.batchInsertPage("dict_option_enum", optionEnumList, sqliteConn);
                    }
                    DictItemInfoDao dictItemInfoDao = new DictItemInfoDao(conn);
                    List<DictItemInfo> items = dictItemInfoDao.queryDictItemInfoList(projectIds);
                    this.batchInsertPage("dict_item_info", items, sqliteConn);
                    SrvModelInfoDao srvModelInfoDao = new SrvModelInfoDao(conn);
                    PaasAppsParamDao paasAppsParamDao = new PaasAppsParamDao(conn);
                    PaasAppsSqlDao paasAppsSqlDao = new PaasAppsSqlDao(conn);
                    PaasAppsPropertiesDao paasAppsPropertiesDao = new PaasAppsPropertiesDao(conn);
                    SrvModelInoutDao srvModelInoutDao = new SrvModelInoutDao(conn);
                    SrvModelPackageDao srvModelPackageDao = new SrvModelPackageDao(conn);
                    OsrvArrangeTableDao osrvArrangeTableDao = new OsrvArrangeTableDao(conn);
                    OsrvArrangeVarDao osrvArrangeVarDao = new OsrvArrangeVarDao(conn);
                    OsrvEvalIsrvDao osrvEvalIsrvDao = new OsrvEvalIsrvDao(conn);
                    OsrvEvalVarDao osrvEvalVarDao = new OsrvEvalVarDao(conn);
                    SrvEvalFuncDao srvEvalFuncDao = new SrvEvalFuncDao(conn);
                    SrvModelFeatureDao srvModelFeatureDao = new SrvModelFeatureDao(conn);
                    PaasAppsInfoDao sqlitePaasAppsInfoDao = new PaasAppsInfoDao(sqliteConn);
                    PaasAppsInfo refApp = paasAppsInfoDao.queryByAppId(refAppId);
                    sqlitePaasAppsInfoDao.insertPaasAppsInfo(refApp);
                    PaasAppsParam paasAppsParam = new PaasAppsParam();
                    paasAppsParam.setAppId(refAppId);
                    List<PaasAppsParam> appsParamList = paasAppsParamDao.queryPaasAppsParamList(paasAppsParam);
                    this.batchInsertPage("paas_apps_param", appsParamList, sqliteConn);
                    PaasAppsSql paasSqlParam = new PaasAppsSql();
                    paasSqlParam.setAppId(appInfo.getAppId());
                    List<PaasAppsSql> appsSqlList = paasAppsSqlDao.queryPaasAppsSqlList(paasSqlParam);
                    this.batchInsertPage("paas_apps_sql", appsSqlList, sqliteConn);
                    PaasAppsProperties paasAppsProp = new PaasAppsProperties();
                    paasAppsProp.setAppId(appInfo.getAppId());
                    List<PaasAppsProperties> appsPropList = paasAppsPropertiesDao.queryPaasAppsPropertiesList(paasAppsProp);
                    this.batchInsertPage("paas_apps_properties", appsPropList, sqliteConn);
                    SrvModelInfo srvParam = new SrvModelInfo();
                    srvParam.setAppId(refAppId);
                    List<SrvModelInfo> srvModelList = srvModelInfoDao.querySrvModelInfoList(srvParam, Arrays.asList(SrvModelCatalogEnum.ComponentServer.getCode(), SrvModelCatalogEnum.TradeServer.getCode(), SrvModelCatalogEnum.BackServer.getCode(), SrvModelCatalogEnum.SdkServer.getCode()));
                    this.batchInsertPage("srv_model_info", srvModelList, sqliteConn);
                    SrvModelPackage srvModelPackage = new SrvModelPackage();
                    srvModelPackage.setAppId(refAppId);
                    List<SrvModelPackage> packageList = srvModelPackageDao.querySrvModelPackageList(srvModelPackage);
                    this.batchInsertPage("srv_model_package", packageList, sqliteConn);
                    for (SrvModelInfo modelInfo : srvModelList) {
                        SrvModelInout inoutParam = new SrvModelInout();
                        inoutParam.setSrvModelId(modelInfo.getSrvModelId());
                        List<SrvModelInout> inoutList = srvModelInoutDao.querySrvModelInoutList(inoutParam);
                        this.batchInsertPage("srv_model_inout", inoutList, sqliteConn);
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u590d\u5236\u5f15\u7528\u7ec4\u4ef6\u5e94\u7528\u6570\u636e\u5230sqlite\u5931\u8d25", (Throwable)e);
            flag = false;
        }
        finally {
            if (conn != null) {
                this.closeConnection(conn);
            }
            if (sqliteConn != null) {
                this.closeSqliteConnection(sqliteConn);
            }
        }
        return flag;
    }
}

