/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.scan;

import com.irdstudio.allinapaas.executor.application.executor.core.tinycore.log.ILogger;
import com.irdstudio.allinapaas.quality.console.facade.dto.PluginCoverageRptDTO;
import com.irdstudio.allinapaas.quality.console.types.PluginReportStat;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Base64;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class JacocoReportParser {
    public static PluginCoverageRptDTO parse(String reportId, String appId, File rootDir, File reportFile, ILogger logger) {
        PluginCoverageRptDTO reportInfo;
        block45: {
            reportInfo = null;
            try {
                reportInfo = new PluginCoverageRptDTO();
                if (reportFile.exists()) {
                    Document doc = Jsoup.parse((File)reportFile.getAbsoluteFile(), (String)"UTF-8", (String)"");
                    Elements list = doc.getElementById("coveragetable").getElementsByTag("tfoot").first().getElementsByTag("td");
                    for (int i = 0; i < list.size(); ++i) {
                        System.out.println(((Element)list.get(i)).text());
                        if (i == 2) {
                            reportInfo.setInstCov(JacocoReportParser.parseRate(((Element)list.get(i)).text()));
                        }
                        if (i == 4) {
                            reportInfo.setBranchCov(JacocoReportParser.parseRate(((Element)list.get(i)).text()));
                        }
                        if (i == 5) {
                            BigDecimal cxtyNumerator = new BigDecimal(((Element)list.get(i)).text().replace(",", ""));
                            BigDecimal cxtyDenominator = new BigDecimal(((Element)list.get(i + 1)).text().replace(",", ""));
                            BigDecimal cxtyCoverage = cxtyDenominator.subtract(cxtyNumerator).divide(cxtyDenominator, 4, RoundingMode.HALF_UP);
                            reportInfo.setCxtyCov(cxtyCoverage);
                        }
                        if (i == 7) {
                            BigDecimal lineNumerator = new BigDecimal(((Element)list.get(i)).text().replace(",", ""));
                            BigDecimal lineDenominator = new BigDecimal(((Element)list.get(i + 1)).text().replace(",", ""));
                            BigDecimal lineCoverage = lineDenominator.subtract(lineNumerator).divide(lineDenominator, 4, RoundingMode.HALF_UP);
                            reportInfo.setLineCov(lineCoverage);
                        }
                        if (i == 9) {
                            BigDecimal mtdNumerator = new BigDecimal(((Element)list.get(i)).text().replace(",", ""));
                            BigDecimal mtdDenominator = new BigDecimal(((Element)list.get(i + 1)).text().replace(",", ""));
                            BigDecimal mtdCoverage = mtdDenominator.subtract(mtdNumerator).divide(mtdDenominator, 4, RoundingMode.HALF_UP);
                            reportInfo.setMtdCov(mtdCoverage);
                        }
                        if (i != 11) continue;
                        BigDecimal clsNumerator = new BigDecimal(((Element)list.get(i)).text().replace(",", ""));
                        BigDecimal clsDenominator = new BigDecimal(((Element)list.get(i + 1)).text().replace(",", ""));
                        BigDecimal clsCoverage = clsDenominator.subtract(clsNumerator).divide(clsDenominator, 4, RoundingMode.HALF_UP);
                        reportInfo.setClsCov(clsCoverage);
                    }
                    reportInfo.setReqSts(PluginReportStat.DONE.getCode());
                    File surefireReport = new File(rootDir, "target/site/surefire-report.html");
                    try {
                        if (reportFile.exists()) {
                            Document surefireReport_doc = Jsoup.parse((File)surefireReport.getAbsoluteFile(), (String)"UTF-8", (String)"");
                            Elements surefireReport_elements = ((Element)surefireReport_doc.getElementsByClass("b").get(0)).getElementsByTag("td");
                            for (int i = 0; i < surefireReport_elements.size(); ++i) {
                                if (i == 0) {
                                    logger.info("\u5355\u5143\u6d4b\u8bd5 \u7528\u4f8b\u603b\u6570\u7edf\u8ba1\u6267\u884c\u7ed3\u679c:" + ((Element)surefireReport_elements.get(i)).text());
                                    reportInfo.setTestCaseTotal(Integer.valueOf(((Element)surefireReport_elements.get(i)).text()));
                                    continue;
                                }
                                if (i == 1) {
                                    logger.info("\u5355\u5143\u6d4b\u8bd5 \u5931\u8d25\u6570\u7edf\u8ba1\u6267\u884c\u7ed3\u679c:" + ((Element)surefireReport_elements.get(i)).text());
                                    reportInfo.setTestCaseErrors(Integer.valueOf(((Element)surefireReport_elements.get(i)).text()));
                                    continue;
                                }
                                if (i == 2) {
                                    logger.info("\u5355\u5143\u6d4b\u8bd5 \u7edf\u8ba1\u6267\u884c\u7ed3\u679c:" + ((Element)surefireReport_elements.get(i)).text());
                                    reportInfo.setTestCaseFailures(Integer.valueOf(((Element)surefireReport_elements.get(i)).text()));
                                    continue;
                                }
                                if (i == 3) {
                                    logger.info("\u5355\u5143\u6d4b\u8bd5 \u5ffd\u7565\u6570\u7edf\u8ba1\u6267\u884c\u7ed3\u679c:" + ((Element)surefireReport_elements.get(i)).text());
                                    reportInfo.setTestCaseSkipped(Integer.valueOf(((Element)surefireReport_elements.get(i)).text()));
                                    continue;
                                }
                                logger.info("\u5355\u5143\u6d4b\u8bd5 \u6210\u529f\u7387\u7edf\u8ba1\u6267\u884c\u7ed3\u679c:" + ((Element)surefireReport_elements.get(i)).text());
                                reportInfo.setTestCaseSucRate(JacocoReportParser.parseRate(((Element)surefireReport_elements.get(i)).text()));
                            }
                            reportInfo.setReqSts(PluginReportStat.DONE.getCode());
                        } else {
                            reportInfo.setReqSts(PluginReportStat.DONE.getCode());
                            logger.error("reportId:" + reportInfo.getReportId() + " \u6d4b\u8bd5\u7528\u4f8b\u6267\u884c\u60c5\u51b5\u7edf\u8ba1\u62a5\u544a\u4e0d\u5b58\u5728 " + surefireReport);
                            reportInfo.setErrInf("\u9879\u76ee\u6ca1\u6709\u5355\u5143\u6d4b\u8bd5case");
                        }
                    }
                    catch (Exception e) {
                        logger.error("\u89e3\u6790\u62a5\u544a\u53d1\u751f\u5f02\u5e38: " + reportInfo.getReportId(), e);
                        reportInfo.setErrInf("\u89e3\u6790\u62a5\u544a\u53d1\u751f\u5f02\u5e38:" + e.getMessage());
                        reportInfo.setReqSts(PluginReportStat.FAIL.getCode());
                    }
                    String directoryPath = reportFile.getParentFile().getAbsolutePath();
                    boolean cpExitCode = false;
                    try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
                         ZipOutputStream zos = new ZipOutputStream(baos);){
                        Path directory = Paths.get(directoryPath, new String[0]);
                        PluginCoverageRptDTO finalReportInfo = reportInfo;
                        Files.walk(directory, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> {
                            try {
                                String entryName = directory.relativize((Path)file).toString();
                                zos.putNextEntry(new ZipEntry(entryName));
                                Files.copy(file, zos);
                                zos.closeEntry();
                            }
                            catch (IOException e) {
                                logger.error("\u89e3\u6790\u62a5\u544a\u6570\u636e\u53d1\u751f\u5f02\u5e38:" + finalReportInfo.getReportId(), e);
                                finalReportInfo.setErrInf("\u89e3\u6790\u62a5\u544a\u6570\u636e\u53d1\u751f\u5f02\u5e38:" + e.getMessage());
                                finalReportInfo.setReqSts(PluginReportStat.FAIL.getCode());
                            }
                        });
                        zos.finish();
                        byte[] zipData = baos.toByteArray();
                        String base64String = Base64.getEncoder().encodeToString(zipData);
                        reportInfo.setRptData(base64String);
                    }
                    catch (Exception e) {
                        logger.error("\u89e3\u6790\u62a5\u544a\u6570\u636e\u53d1\u751f\u5f02\u5e38:" + reportInfo.getReportId(), e);
                        reportInfo.setErrInf("\u89e3\u6790\u62a5\u544a\u6570\u636e\u53d1\u751f\u5f02\u5e38:" + e.getMessage());
                        reportInfo.setReqSts(PluginReportStat.FAIL.getCode());
                    }
                    reportInfo.setReqSts(PluginReportStat.DONE.getCode());
                    break block45;
                }
                reportInfo.setReqSts(PluginReportStat.FAIL.getCode());
                logger.error("reportId:" + reportInfo.getReportId() + " html\u62a5\u544a\u4e0d\u5b58\u5728");
                reportInfo.setErrInf("html\u62a5\u544a\u4e0d\u5b58\u5728");
            }
            catch (Exception e) {
                logger.error("\u89e3\u6790\u62a5\u544a\u53d1\u751f\u5f02\u5e38:" + reportInfo.getReportId(), e);
                reportInfo.setErrInf("\u89e3\u6790\u62a5\u544a\u53d1\u751f\u5f02\u5e38:" + e.getMessage());
                reportInfo.setReqSts(PluginReportStat.FAIL.getCode());
            }
        }
        return reportInfo;
    }

    private static BigDecimal parseRate(String rate) {
        try {
            String numStr = StringUtils.replace((String)rate, (String)"%", (String)"");
            BigDecimal num = new BigDecimal(numStr);
            BigDecimal rateNum = num.divide(new BigDecimal(100), 4, RoundingMode.HALF_UP);
            return rateNum;
        }
        catch (Exception e) {
            return null;
        }
    }
}

