/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.service.impl;

import com.irdstudio.allinapaas.deliver.console.facade.BatInstBatchService;
import com.irdstudio.allinapaas.deliver.console.facade.dto.BatInstBatchDTO;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.AbstractPlugin;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.PluginContext;
import com.irdstudio.allinapaas.executor.application.executor.core.tinycore.jdbc.dbcp.TConnPool;
import com.irdstudio.allinapaas.executor.application.executor.core.tinycore.log.Slf4jAdapter;
import com.irdstudio.allinapaas.executor.facade.BatchExecutorService;
import com.irdstudio.framework.beans.core.util.UUIDUtil;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="batchExecutorServiceImpl")
public class BatchExecutorServiceImpl
implements BatchExecutorService {
    public static Logger logger = LoggerFactory.getLogger(BatchExecutorServiceImpl.class);
    @Autowired
    private BatInstBatchService batInstBatchService;

    public BatInstBatchDTO startExecPluginDirect(BatInstBatchDTO batInst) {
        if (StringUtils.isBlank((CharSequence)batInst.getBatchSerialNo())) {
            batInst.setBatchSerialNo(UUIDUtil.getUUID());
        }
        this.batInstBatchService.insert((Object)batInst);
        return batInst;
    }

    public BatInstBatchDTO runExecPluginDirect(BatInstBatchDTO batInst) {
        try {
            Slf4jAdapter iLogger = Slf4jAdapter.wrap(logger);
            PluginContext ctx = new PluginContext();
            ctx.setnPluginConfType(1);
            ctx.setSzSubsCode(batInst.getSubsId());
            ctx.setSzBatchSn(batInst.getBatchSerialNo());
            ctx.setConnPool(TConnPool.getDefaultPool());
            if (CollectionUtils.isNotEmpty((Collection)batInst.getPluginClazzList())) {
                for (Class pluginClazz : batInst.getPluginClazzList()) {
                    AbstractPlugin pluginInst = (AbstractPlugin)pluginClazz.newInstance();
                    pluginInst.setPluginContext(ctx, iLogger);
                    boolean flag = pluginInst.readPluginConfigureFromDB(batInst.getBatchSerialNo());
                    if (flag) {
                        flag = pluginInst.execute();
                    }
                    if (flag) continue;
                    logger.info("{} \u6267\u884c {} \u5931\u8d25", (Object)batInst.getAppId(), (Object)pluginClazz);
                }
            }
            batInst.setBatchState("9");
        }
        catch (Exception e) {
            logger.error("\u8fd0\u884c\u6d41\u6c34\u7ebf\u63d2\u4ef6\u5f02\u5e38 {}", (Object)e.getMessage(), (Object)e);
            batInst.setBatchState("1");
        }
        return batInst;
    }

    public BatInstBatchDTO endExecPluginDirect(BatInstBatchDTO batInst) {
        this.batInstBatchService.deleteByPk((Object)batInst);
        return batInst;
    }
}

