/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.dao;

import com.irdstudio.allinapaas.executor.application.executor.core.dao.AbstractPortalPageDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.AppsCheckLog;
import com.irdstudio.allinapaas.executor.application.executor.core.util.db.ProxySQL;
import com.irdstudio.sdk.beans.core.util.POJOUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppsCheckLogDao
extends AbstractPortalPageDao {
    private static final Logger logger = LoggerFactory.getLogger(AppsCheckLogDao.class);
    Connection conn = null;

    public AppsCheckLogDao(Connection conn) {
        super(conn);
        this.conn = conn;
    }

    public List<AppsCheckLog> queryListByPage(final AppsCheckLog paramVO) {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("*");
                this.FROM("`allinpaas_db`.apps_check_log");
                List vals = POJOUtils.getPOJOValues((Object)((Object)paramVO));
                for (Object[] val : vals) {
                    this.WHERE(String.format("%s = ?", val[0].toString()));
                    param.add(val[1]);
                }
                this.ORDER_BY("oper_time desc");
            }
        }.toString();
        this.queryTotalRecord(sql, paramVO, param);
        paramVO.checkAndSetPageInfo();
        String limitSql = this.buildPageSql(paramVO, sql);
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<AppsCheckLog> list = new ArrayList<AppsCheckLog>();
        try {
            ps = this.conn.prepareStatement(limitSql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                AppsCheckLog bean = (AppsCheckLog)((Object)POJOUtils.generatePOJO((ResultSet)rs, AppsCheckLog.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("queryListByPage is wrong", e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return list;
    }

    public List<AppsCheckLog> queryAppsCheckLogList(final AppsCheckLog paramVO) throws Exception {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("*");
                this.FROM("`allinpaas_db`.apps_check_log");
                List vals = POJOUtils.getPOJOValues((Object)((Object)paramVO));
                for (Object[] val : vals) {
                    this.WHERE(String.format("%s = ?", val[0].toString()));
                    param.add(val[1]);
                }
                this.ORDER_BY("oper_time desc");
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<AppsCheckLog> list = new ArrayList<AppsCheckLog>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                AppsCheckLog bean = (AppsCheckLog)((Object)POJOUtils.generatePOJO((ResultSet)rs, AppsCheckLog.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("query queryAppsCheckLogList is wrong", e);
        }
        return list;
    }

    public AppsCheckLog queryByPk(final String recordKeyId) throws Exception {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("*");
                this.FROM("`allinpaas_db`.apps_check_log");
                this.WHERE("record_key_id = ?");
                param.add(recordKeyId);
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<AppsCheckLog> list = new ArrayList<AppsCheckLog>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                AppsCheckLog bean = (AppsCheckLog)((Object)POJOUtils.generatePOJO((ResultSet)rs, AppsCheckLog.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("query queryByPk is wrong", e);
        }
        return list.isEmpty() ? null : (AppsCheckLog)((Object)list.get(0));
    }

    public boolean insert(final AppsCheckLog obj) throws SQLException {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.INSERT_INTO("`allinpaas_db`.apps_check_log");
                List vals = POJOUtils.getPOJOValues((Object)((Object)obj));
                for (Object[] val : vals) {
                    this.VALUES(val[0].toString(), "?");
                    param.add(val[1]);
                }
            }
        }.toString();
        PreparedStatement ps = null;
        Object rs = null;
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            int re = ps.executeUpdate();
            if (re == 1) {
                return true;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("insert is wrong", e);
        }
        return false;
    }

    public int deleteByPk(final String recordKeyId) throws SQLException {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.DELETE_FROM("`allinpaas_db`.apps_check_log");
                this.WHERE("record_key_id = ?");
                param.add(recordKeyId);
            }
        }.toString();
        PreparedStatement ps = null;
        Object rs = null;
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            int re = ps.executeUpdate();
            return re;
        }
        catch (Exception e) {
            throw new RuntimeException("insert is wrong", e);
        }
    }

    public int updateByPk(final AppsCheckLog field) throws SQLException {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.UPDATE("`allinpaas_db`.apps_check_log");
                List vals = POJOUtils.getPOJOValues((Object)((Object)field));
                for (Object[] val : vals) {
                    if (val[0].toString().equals("record_key_id")) continue;
                    this.SET(String.format("%s = ?", val[0].toString()));
                    param.add(val[1]);
                }
                this.WHERE("record_key_id = ?");
                param.add(field.getRecordKeyId());
            }
        }.toString();
        if (param.size() < 2) {
            return 0;
        }
        PreparedStatement ps = null;
        Object rs = null;
        int result = 0;
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            result = ps.executeUpdate();
        }
        catch (Exception e) {
            throw new RuntimeException("updateByPk is wrong", e);
        }
        return result;
    }
}

