/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.dao;

import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.DictOptionInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.util.db.ProxySQL;
import com.irdstudio.sdk.beans.core.util.POJOUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DictOptionInfoDao {
    private static final Logger logger = LoggerFactory.getLogger(DictOptionInfoDao.class);
    Connection conn = null;

    public DictOptionInfoDao(Connection conn) {
        this.conn = conn;
    }

    public List<DictOptionInfo> queryDictOptionInfoListByAppId(final String appId) throws Exception {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("*");
                this.FROM("`allinrdm_db`.dict_option_info");
                this.WHERE("dict_id in(  select dict_id from `allinrdm_db`.dict_item_info where item_id in (      select item_id from `allinrdm_db`.model_table_field where object_id in(          select object_id from `allinrdm_db`.model_table_info where app_id = ?  )) and dict_id != '')");
                param.add(appId);
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<DictOptionInfo> list = new ArrayList<DictOptionInfo>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                DictOptionInfo bean = (DictOptionInfo)((Object)POJOUtils.generatePOJO((ResultSet)rs, DictOptionInfo.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("query queryDictOptionInfoList is wrong", e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return list;
    }

    public List<DictOptionInfo> queryByItemNames(final List<String> names) {
        if (names == null || names.isEmpty()) {
            return new ArrayList<DictOptionInfo>(0);
        }
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("*");
                this.FROM("`allinrdm_db`.dict_option_info");
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < names.size(); ++i) {
                    param.add(names.get(i));
                    sb.append("?");
                    if (i >= names.size() - 1) continue;
                    sb.append(",");
                }
                this.WHERE(String.format("dict_name in (%s)", sb.toString()));
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<DictOptionInfo> list = new ArrayList<DictOptionInfo>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                DictOptionInfo bean = (DictOptionInfo)((Object)POJOUtils.generatePOJO((ResultSet)rs, DictOptionInfo.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("query queryByItemNames is wrong", e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return list;
    }

    public DictOptionInfo queryByPk(final String dictId) {
        if (dictId == null) {
            return null;
        }
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("*");
                this.FROM("`allinrdm_db`.dict_option_info");
                this.WHERE("dict_id = ? ");
                param.add(dictId);
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<DictOptionInfo> list = new ArrayList<DictOptionInfo>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            if (rs.next()) {
                DictOptionInfo bean = (DictOptionInfo)((Object)POJOUtils.generatePOJO((ResultSet)rs, DictOptionInfo.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("query queryByItemNames is wrong", e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return list.isEmpty() ? null : (DictOptionInfo)((Object)list.get(0));
    }
}

