/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.dao.domain;

import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.OsrvArrangeContext;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.OsrvArrangeImport;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsInfo;
import com.irdstudio.allinrdm.dev.console.types.SrvModelCatalogEnum;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class OsrvArrangeClassContext {
    private Connection conn;
    private PaasAppsInfo appInfo;
    private List<OsrvArrangeImport> importList;
    private Map<String, OsrvArrangeImport> importMap;
    private String srvModelCatalog;
    private String className;
    private String serviceSuffix;
    List<OsrvArrangeContext> methodCtxList;
    List<Map<String, String>> technicalComponents = new ArrayList<Map<String, String>>();
    private Boolean hasErrorMapping = false;
    private String errorClassName;

    public OsrvArrangeClassContext() {
        this.importList = new ArrayList<OsrvArrangeImport>();
        this.importMap = new HashMap<String, OsrvArrangeImport>();
        this.methodCtxList = new ArrayList<OsrvArrangeContext>();
    }

    public OsrvArrangeClassContext(PaasAppsInfo appInfo, String srvModelCatalog, Connection conn) {
        this();
        this.appInfo = appInfo;
        this.srvModelCatalog = srvModelCatalog;
        this.conn = conn;
        if (StringUtils.equals((CharSequence)srvModelCatalog, (CharSequence)SrvModelCatalogEnum.BackServer.getCode())) {
            this.serviceSuffix = SrvModelCatalogEnum.BackServer.getSuffix();
        } else if (StringUtils.equals((CharSequence)srvModelCatalog, (CharSequence)SrvModelCatalogEnum.TradeServer.getCode())) {
            this.serviceSuffix = SrvModelCatalogEnum.TradeServer.getSuffix();
        } else if (StringUtils.equals((CharSequence)srvModelCatalog, (CharSequence)SrvModelCatalogEnum.ComponentServer.getCode())) {
            this.serviceSuffix = SrvModelCatalogEnum.ComponentServer.getSuffix();
        }
    }

    public void addImport(List<OsrvArrangeImport> importVOList) {
        if (CollectionUtils.isNotEmpty(importVOList)) {
            for (OsrvArrangeImport importVO : importVOList) {
                this.addImport(importVO);
            }
        }
    }

    public boolean addImport(OsrvArrangeImport importVO) {
        String key = importVO.getClassName();
        String importType = importVO.getImportType();
        if (StringUtils.isBlank((CharSequence)importType)) {
            importType = "";
        }
        if (StringUtils.isNotBlank((CharSequence)importVO.getProjectCode())) {
            key = importVO.getProjectCode() + importType + key;
        }
        if (this.importMap.get(key) == null) {
            this.importList.add(importVO);
            this.importMap.put(key, importVO);
            return true;
        }
        return false;
    }

    public List<OsrvArrangeImport> getImportList() {
        return this.importList;
    }

    public void setImportList(List<OsrvArrangeImport> importList) {
        this.importList = importList;
    }

    public Map<String, OsrvArrangeImport> getImportMap() {
        return this.importMap;
    }

    public void setImportMap(Map<String, OsrvArrangeImport> importMap) {
        this.importMap = importMap;
    }

    public List<OsrvArrangeContext> getMethodCtxList() {
        return this.methodCtxList;
    }

    public void setMethodCtxList(List<OsrvArrangeContext> methodCtxList) {
        this.methodCtxList = methodCtxList;
    }

    public String getSrvModelCatalog() {
        return this.srvModelCatalog;
    }

    public void setSrvModelCatalog(String srvModelCatalog) {
        this.srvModelCatalog = srvModelCatalog;
    }

    public String getServiceSuffix() {
        return this.serviceSuffix;
    }

    public void setServiceSuffix(String serviceSuffix) {
        this.serviceSuffix = serviceSuffix;
    }

    public Connection getConn() {
        return this.conn;
    }

    public void setConn(Connection conn) {
        this.conn = conn;
    }

    public PaasAppsInfo getAppInfo() {
        return this.appInfo;
    }

    public void setAppInfo(PaasAppsInfo appInfo) {
        this.appInfo = appInfo;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public Boolean getHasErrorMapping() {
        return this.hasErrorMapping;
    }

    public void setHasErrorMapping(Boolean hasErrorMapping) {
        this.hasErrorMapping = hasErrorMapping;
    }

    public String getErrorClassName() {
        return this.errorClassName;
    }

    public void setErrorClassName(String errorClassName) {
        this.errorClassName = errorClassName;
    }
}

