/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.aplpaas;

import com.irdstudio.allinapaas.executor.application.executor.core.dao.BatBatchInfoConfigDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.BatInstBatchDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasDeployInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEcsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEnvParamDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.BatBatchInfoConfig;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.BatInstBatch;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasEcsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasEnvParam;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.AbstractPlugin;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.apps.SdEnvUtil;
import com.irdstudio.allinapaas.portal.console.types.YesOrNO;
import com.irdstudio.sdk.beans.ssh.io.SSHOutputPrinter;
import com.irdstudio.sdk.beans.ssh.utils.RemoteSSHClient;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class FileBeatsDeployPlugin
extends AbstractPlugin {
    private BatInstBatch paasOpsLog = null;
    private String id = "filebeats8.3.3";
    protected SSHOutputPrinter sshPrinter = new SSHOutputPrinter(){

        public void print(String line) {
            if (FileBeatsDeployPlugin.this.logger != null) {
                FileBeatsDeployPlugin.this.logger.info(line);
            } else {
                System.out.println(line);
            }
        }

        public void printError(String line) {
            if (FileBeatsDeployPlugin.this.logger != null) {
                FileBeatsDeployPlugin.this.logger.error(line);
            } else {
                System.err.println(line);
            }
        }
    };

    @Override
    protected boolean doReadConfigureFromDB(Connection conn, String szConfIdentify) throws SQLException {
        String batchSerialNo = this.context.getSzBatchSn();
        BatInstBatchDao batInstBatchDao = new BatInstBatchDao(conn);
        this.paasOpsLog = batInstBatchDao.queryByBatchSerialNo(batchSerialNo);
        BatBatchInfoConfigDao batBatchInfoConfigDao = new BatBatchInfoConfigDao(conn);
        BatBatchInfoConfig batchInfo = batBatchInfoConfigDao.queryWithKeys(this.context.getSzBatchId());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        this.logger.info("\u90e8\u7f72 Filebeats ");
        Connection conn = null;
        try {
            conn = this.getPluginConnection();
            BatInstBatchDao batInstBatchDao = new BatInstBatchDao(conn);
            BatInstBatch batInstBatch = batInstBatchDao.queryByBatchSerialNo(this.context.getSzBatchSn());
            String currEnvId = batInstBatch.getEnvId();
            PaasEnvParamDao paasEnvParamDao = new PaasEnvParamDao(conn);
            PaasEcsInfoDao paasEcsInfoDao = new PaasEcsInfoDao(conn);
            PaasDeployInfoDao paasDeployInfoDao = new PaasDeployInfoDao(conn);
            PaasEnvParam deployRoot = paasEnvParamDao.queryByCode("deploy_root", currEnvId);
            String deployRootDir = deployRoot.getParamValue();
            PaasEcsInfo ecsParam = new PaasEcsInfo();
            ecsParam.setEcsId(this.paasOpsLog.getEcsId());
            List<PaasEcsInfo> ecsList = paasEcsInfoDao.queryPaasEcsInfo(ecsParam);
            for (PaasEcsInfo paasEcsInfo : ecsList) {
                File dir;
                this.logger.info(String.format("\u5f00\u59cb\u90e8\u7f72\u5e94\u7528%s\u5230\u670d\u52a1\u5668%s,\u7aef\u53e3%s", "FileBeats", paasEcsInfo.getEcsIp(), paasEcsInfo.getEcsPort()));
                RemoteSSHClient rsc = new RemoteSSHClient(paasEcsInfo.getEcsIp(), paasEcsInfo.getEcsLoginUser(), paasEcsInfo.getEcsLoginPwd());
                boolean loginFlag = rsc.connect();
                if (!loginFlag) {
                    this.logger.error("\u767b\u9646\u670d\u52a1\u5668\u5931\u8d25");
                    boolean bl = loginFlag;
                    return bl;
                }
                String opsPath = SdEnvUtil.TEMPLATE_PATH + this.id + "-medium";
                if (StringUtils.isBlank((String)opsPath)) {
                    this.logger.error("\u65e0\u6cd5\u83b7\u53d6\u8fd0\u7ef4\u6a21\u677f\u6240\u5728\u76ee\u5f55\uff0c\u8bf7\u68c0\u67e5\u8fd0\u7ef4\u6a21\u677f\u4ed3\u5e93\u914d\u7f6e");
                    boolean bl = false;
                    return bl;
                }
                String localAgentPath = opsPath + File.separator;
                String softName = "filebeats";
                String installEs = localAgentPath + softName;
                if (!new File(installEs).exists()) {
                    this.logger.error(softName + " \u5b89\u88c5\u811a\u672c\u4e0d\u5b58\u5728");
                    throw new RuntimeException(softName + " \u5b89\u88c5\u811a\u672c\u4e0d\u5b58\u5728");
                }
                if (!rsc.fileExists(deployRootDir + "/" + softName)) {
                    rsc.executeCommand("mkdir -p " + deployRootDir + "/" + softName, this.sshPrinter);
                }
                PaasEcsInfo esParam = new PaasEcsInfo();
                esParam.setPaasDuId("G000005");
                esParam.setEnvId(this.paasOpsLog.getEnvId());
                List<PaasEcsInfo> esList = paasEcsInfoDao.queryPaasEcsInfo(esParam);
                String esHost = "localhost:9200";
                if (CollectionUtils.isNotEmpty(esList)) {
                    PaasEcsInfo es = (PaasEcsInfo)((Object)esList.stream().findFirst().get());
                    esHost = String.format("%s:%s", es.getEcsIp(), es.getEcsPort());
                }
                PaasEcsInfo kibanaParam = new PaasEcsInfo();
                kibanaParam.setPaasDuId("G000005");
                kibanaParam.setEnvId(this.paasOpsLog.getEnvId());
                List<PaasEcsInfo> kibanaList = paasEcsInfoDao.queryPaasEcsInfo(kibanaParam);
                String kibanaHost = "localhost:5601";
                if (CollectionUtils.isNotEmpty(kibanaList)) {
                    PaasEcsInfo kibana = (PaasEcsInfo)((Object)kibanaList.stream().findFirst().get());
                    kibanaHost = String.format("%s:%s", kibana.getEcsIp(), kibana.getEcsPort());
                }
                if ((dir = new File(installEs)).exists()) {
                    File[] files;
                    for (File file : files = dir.listFiles()) {
                        if (!file.isFile()) continue;
                        rsc.upload(file.getAbsolutePath(), deployRootDir + "/" + softName);
                    }
                    rsc.executeCommand(String.format("chmod 777 %s/%s/install.sh", deployRootDir, softName), this.sshPrinter);
                    this.logger.info(String.format("\u6267\u884c\u811a\u672c %s/%s/install.sh %s/%s %s %s", deployRootDir, softName, deployRootDir, softName, kibanaHost, esHost));
                    rsc.executeCommand(String.format("bash %s/%s/install.sh %s/%s %s %s", deployRootDir, softName, deployRootDir, softName, kibanaHost, esHost), this.sshPrinter);
                } else {
                    this.logger.error(softName + " \u5b89\u88c5\u5305\u4e0d\u5b58\u5728");
                }
                paasEcsInfo.setLogAgent(YesOrNO.YES.getCode());
                paasEcsInfoDao.updateByPk(paasEcsInfo);
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (conn != null) {
                this.closePluginConnection(conn);
            }
        }
        return true;
    }
}

