/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.builder;

import com.irdstudio.allinapaas.executor.application.executor.core.dao.BatInstBatchDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.ModelTableFieldDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.ModelTableInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.OsrvArrangeVarDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.SrvModelFeatureDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.SrvModelInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.SrvModelInoutDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.BatInstBatch;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.ModelTableInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.OsrvArrangeVar;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SrvModelFeature;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SrvModelInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SrvModelInout;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.builder.AbstractBuilderPlugin;
import com.irdstudio.allinapaas.executor.application.executor.core.util.date.CurrentDateUtil;
import com.irdstudio.allinapaas.portal.console.types.VarType;
import com.irdstudio.allinapaas.portal.console.types.YesOrNO;
import com.irdstudio.allinrdm.dev.console.types.CondCompareSign;
import com.irdstudio.allinrdm.dev.console.types.CondLogicRelation;
import com.irdstudio.allinrdm.dev.console.types.DomainVarType;
import com.irdstudio.allinrdm.dev.console.types.IOType;
import com.irdstudio.allinrdm.dev.console.types.SrvModelCatalogEnum;
import com.irdstudio.allinrdm.dev.console.types.SrvModelTypeEnum;
import com.irdstudio.sdk.beans.core.util.MapBeanUtil;
import com.irdstudio.sdk.beans.core.util.TmModelUtil;
import com.irdstudio.sdk.beans.freemarker.bo.CodeTemplateDataBo;
import com.irdstudio.sdk.beans.freemarker.bo.ModelTableFieldBo;
import com.irdstudio.sdk.beans.freemarker.bo.ModelTableInfoBo;
import com.irdstudio.sdk.beans.freemarker.bo.TmProjectInfoBo;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class TdpRuleServicePlugin
extends AbstractBuilderPlugin {
    private PaasAppsInfo appInfo = null;
    private BatInstBatch batchInst;
    private Map<String, Object> extParam;
    private String loginUserId = "";
    private TmProjectInfoBo tpib = null;
    private SAXReader saxReader = new SAXReader();

    @Override
    protected boolean doReadConfigureFromDB(Connection conn, String szConfIdentify) throws SQLException {
        String batchSerialNo = this.context.getSzBatchSn();
        BatInstBatchDao batInstBatchDao = new BatInstBatchDao(conn);
        this.batchInst = batInstBatchDao.queryByBatchSerialNo(batchSerialNo);
        PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
        this.appInfo = paasAppsInfoDao.queryByAppId(this.batchInst.getAppId());
        this.extParam = batInstBatchDao.getExtParam(this.batchInst);
        this.loginUserId = MapUtils.getString(this.extParam, (Object)"createUserId");
        this.tpib = new TmProjectInfoBo();
        this.tpib.setProjectId(this.appInfo.getAppCode());
        this.tpib.setProjectCode(this.appInfo.getAppCode());
        this.tpib.setProjectName(this.appInfo.getAppName());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        this.logger.info("\u751f\u6210\u89c4\u5219\u7ec4\u4ef6\u670d\u52a1\u4ee3\u7801");
        boolean result = true;
        Connection conn = null;
        try {
            conn = this.getPluginConnection();
            SrvModelInfoDao srvModelInfoDao = new SrvModelInfoDao(conn);
            SrvModelInfo srvParam = new SrvModelInfo();
            srvParam.setAppId(this.appInfo.getAppId());
            List<SrvModelInfo> srvModelList = srvModelInfoDao.querySrvModelInfoList(srvParam, Arrays.asList(SrvModelCatalogEnum.SdkServer.getCode()));
            ArrayList<CodeTemplateDataBo> ctdbList = new ArrayList<CodeTemplateDataBo>();
            if (CollectionUtils.isNotEmpty(srvModelList)) {
                block9: for (SrvModelInfo srvModelInfo : srvModelList) {
                    HashMap<String, Object> method = new HashMap<String, Object>();
                    if (StringUtils.isNotBlank((CharSequence)srvModelInfo.getSrvModelMethod())) {
                        method.put("methodName", srvModelInfo.getSrvModelMethod());
                    } else {
                        method.put("methodName", "handle");
                    }
                    SrvModelTypeEnum modelType = SrvModelTypeEnum.getModelByType((String)srvModelInfo.getSrvModelType());
                    switch (modelType) {
                        case ExpressionRule: {
                            CodeTemplateDataBo bo = this.parseExpressionRule(srvModelInfo, method, conn);
                            if (bo == null) continue block9;
                            ctdbList.add(bo);
                            break;
                        }
                        case FreeRule: {
                            CodeTemplateDataBo bo = this.parseFreeRule(srvModelInfo, method, conn);
                            if (bo == null) continue block9;
                            ctdbList.add(bo);
                            break;
                        }
                    }
                }
            }
            for (CodeTemplateDataBo ctdb : ctdbList) {
                this.wrapAppsParam(this.appInfo.getAppId(), ctdb, conn);
                Map appsParam = MapUtils.getMap((Map)ctdb.getMapData(), (Object)"appsParam");
                appsParam.put("package_prefix", "com.irdstudio");
                String package_prefix = this.getPackagePrefix(ctdb);
                String templateFile = MapUtils.getString((Map)ctdb.getMapData(), (Object)"templateFile");
                this.produceCodeFile(templateFile + ".java", templateFile, null, "src/main/java/" + package_prefix + "/" + TdpRuleServicePlugin.formatClassPath(this.appInfo.getAppCode()) + "/", this.appInfo, ctdb);
            }
            CodeTemplateDataBo pomBo = new CodeTemplateDataBo();
            TmProjectInfoBo pomTp = new TmProjectInfoBo();
            pomTp.setProjectId(this.appInfo.getAppCode());
            pomTp.setProjectCode(this.appInfo.getAppCode());
            pomTp.setProjectName(this.appInfo.getAppName());
            pomBo.setTmProjectInfo(pomTp);
            this.wrapAppsParam(this.appInfo.getAppId(), pomBo, conn);
            String package_prefix = this.getPackagePrefix(pomBo);
            this.produceCodeFile("pom.xml", "", "", null, "", this.appInfo, pomBo);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), e);
            result = false;
        }
        finally {
            if (conn != null) {
                this.closePluginConnection(conn);
            }
        }
        return result;
    }

    public CodeTemplateDataBo parseExpressionRule(SrvModelInfo srvModelInfo, Map<String, Object> method, Connection conn) throws Exception {
        ArrayList<Map<String, Object>> noMatchMapList;
        ArrayList<Map<String, Object>> matchMapList;
        ArrayList<Map<String, Object>> ruleMapList;
        CodeTemplateDataBo bo = new CodeTemplateDataBo();
        bo.setTmProjectInfo(this.tpib);
        bo.getEnvBo().setAuthor(this.loginUserId);
        bo.getEnvBo().setCurrentDate(CurrentDateUtil.getTodayDate());
        bo.getEnvBo().setDesc(String.format("%s %s", this.appInfo.getAppName(), srvModelInfo.getSrvModelName()));
        Map dataMap = bo.getMapData();
        String serverClass = TmModelUtil.modelCodeToClassName((String)srvModelInfo.getSrvModelCode());
        dataMap.put("tableModelCode", serverClass);
        dataMap.put("tableClassName", serverClass);
        HashMap<String, Object> domainImports = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> vars = new ArrayList<Map<String, Object>>();
        HashMap<String, ModelTableInfoBo> modelTableMap = new HashMap<String, ModelTableInfoBo>();
        SrvModelFeatureDao srvModelFeatureDao = new SrvModelFeatureDao(conn);
        SrvModelInoutDao srvModelInoutDao = new SrvModelInoutDao(conn);
        OsrvArrangeVarDao osrvArrangeVarDao = new OsrvArrangeVarDao(conn);
        ModelTableInfoDao modelTableInfoDao = new ModelTableInfoDao(conn);
        ModelTableFieldDao modelTableFieldDao = new ModelTableFieldDao(conn);
        OsrvArrangeVar varParam = new OsrvArrangeVar();
        varParam.setSrvModelId(srvModelInfo.getSrvModelId());
        List<OsrvArrangeVar> varList = osrvArrangeVarDao.queryOsrvArrangeVarList(varParam);
        Map<String, Map<String, Object>> varHelpMap = this.getSrvModelInfoVarMapHelper(varList, domainImports, vars, modelTableMap, false, conn);
        this.getMethodInfo(method, domainImports, srvModelInfo, serverClass, srvModelInoutDao);
        SrvModelFeature srvModelFeature = srvModelFeatureDao.queryByPk(srvModelInfo.getSrvModelId());
        if (srvModelFeature != null && StringUtils.isNotBlank((CharSequence)srvModelFeature.getFeatureXml())) {
            String xml = srvModelFeature.getFeatureXml();
            ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes("UTF-8"));
            Document dom = this.saxReader.read((InputStream)in);
            Element rule = dom.getRootElement();
            Element ruleSet = rule.element("ruleSet");
            Element matchResult = rule.element("matchResult");
            Element noMatchResult = rule.element("noMatchResult");
            String matchCondType = rule.attributeValue("matchCondType");
            dataMap.put("matchCondType", matchCondType);
            List ruleList = ruleSet.elements();
            ruleMapList = new ArrayList<Map<String, Object>>();
            if (CollectionUtils.isNotEmpty((Collection)ruleList)) {
                for (Element el : ruleList) {
                    String tagName = el.getQualifiedName();
                    if (tagName.equalsIgnoreCase("condition")) {
                        Map<String, Object> cond = this.parseCondition(el, method, varHelpMap, conn);
                        cond.put("groupFlag", YesOrNO.NO.getCode());
                        ruleMapList.add(cond);
                        continue;
                    }
                    if (!tagName.equalsIgnoreCase("conditionGroup")) continue;
                    String relateOp = el.attributeValue("relateOp");
                    HashMap<String, Object> condG = new HashMap<String, Object>();
                    condG.put("groupFlag", YesOrNO.YES.getCode());
                    List gRuleList = el.elements();
                    ArrayList<Map<String, Object>> groups = new ArrayList<Map<String, Object>>();
                    condG.put("groups", groups);
                    condG.put("relateOp", relateOp.equalsIgnoreCase("and") ? "&&" : "||");
                    ruleMapList.add(condG);
                    for (Element gEl : gRuleList) {
                        Map<String, Object> cond = this.parseCondition(gEl, method, varHelpMap, conn);
                        cond.put("groupFlag", YesOrNO.NO.getCode());
                        groups.add(cond);
                    }
                }
            }
            List matchList = matchResult.elements();
            matchMapList = new ArrayList<Map<String, Object>>();
            if (CollectionUtils.isNotEmpty((Collection)matchList)) {
                for (Element el : matchList) {
                    String tagName = el.getQualifiedName();
                    Map<String, Object> re = this.parseResult(el, method, varHelpMap, conn);
                    matchMapList.add(re);
                }
            }
            List noMatchList = noMatchResult.elements();
            noMatchMapList = new ArrayList<Map<String, Object>>();
            if (CollectionUtils.isNotEmpty((Collection)noMatchList)) {
                for (Element el : noMatchList) {
                    String tagName = el.getQualifiedName();
                    Map<String, Object> re = this.parseResult(el, method, varHelpMap, conn);
                    noMatchMapList.add(re);
                }
            }
        } else {
            return null;
        }
        dataMap.put("ruleSet", ruleMapList);
        dataMap.put("ruleSize", ruleMapList.size());
        dataMap.put("domainImports", domainImports.values());
        dataMap.put("matchSet", matchMapList);
        dataMap.put("noMatchSet", noMatchMapList);
        dataMap.put("vars", vars);
        dataMap.put("method", method);
        dataMap.put("templateFile", "XXXServiceImpl");
        return bo;
    }

    public CodeTemplateDataBo parseFreeRule(SrvModelInfo srvModelInfo, Map<String, Object> method, Connection conn) throws Exception {
        CodeTemplateDataBo bo = new CodeTemplateDataBo();
        bo.setTmProjectInfo(this.tpib);
        bo.getEnvBo().setAuthor(this.loginUserId);
        bo.getEnvBo().setCurrentDate(CurrentDateUtil.getTodayDate());
        bo.getEnvBo().setDesc(String.format("%s %s", this.appInfo.getAppName(), srvModelInfo.getSrvModelName()));
        Map dataMap = bo.getMapData();
        String serverClass = TmModelUtil.modelCodeToClassName((String)srvModelInfo.getSrvModelCode());
        dataMap.put("tableModelCode", serverClass);
        dataMap.put("tableClassName", serverClass);
        HashMap<String, Object> domainImports = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> vars = new ArrayList<Map<String, Object>>();
        HashMap<String, ModelTableInfoBo> modelTableMap = new HashMap<String, ModelTableInfoBo>();
        SrvModelFeatureDao srvModelFeatureDao = new SrvModelFeatureDao(conn);
        SrvModelInoutDao srvModelInoutDao = new SrvModelInoutDao(conn);
        OsrvArrangeVarDao osrvArrangeVarDao = new OsrvArrangeVarDao(conn);
        ModelTableInfoDao modelTableInfoDao = new ModelTableInfoDao(conn);
        ModelTableFieldDao modelTableFieldDao = new ModelTableFieldDao(conn);
        OsrvArrangeVar varParam = new OsrvArrangeVar();
        varParam.setSrvModelId(srvModelInfo.getSrvModelId());
        List<OsrvArrangeVar> varList = osrvArrangeVarDao.queryOsrvArrangeVarList(varParam);
        Map<String, Map<String, Object>> varHelpMap = this.getSrvModelInfoVarMapHelper(varList, domainImports, vars, modelTableMap, true, conn);
        this.getMethodInfo(method, domainImports, srvModelInfo, serverClass, srvModelInoutDao);
        SrvModelFeature srvModelFeature = srvModelFeatureDao.queryByPk(srvModelInfo.getSrvModelId());
        if (srvModelFeature == null || !StringUtils.isNotBlank((CharSequence)srvModelFeature.getFeatureXml())) {
            return null;
        }
        String xml = srvModelFeature.getFeatureXml();
        ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes("UTF-8"));
        Document dom = this.saxReader.read((InputStream)in);
        Element rule = dom.getRootElement();
        Element ruleCode = rule.element("ruleCode");
        String freeCode = ruleCode.getText();
        RuleContext ruleContext = new RuleContext(method, varHelpMap, conn);
        ruleContext.start = 0;
        ruleContext.pos = 0;
        ruleContext.len = freeCode.length();
        Map<String, Object> ruleMap = this.parseRuleCode(freeCode, ruleContext);
        dataMap.putAll(ruleMap);
        dataMap.put("domainImports", domainImports.values());
        dataMap.put("vars", vars);
        dataMap.put("method", method);
        dataMap.put("templateFile", "XXX51ServiceImpl");
        return bo;
    }

    private void getMethodInfo(Map<String, Object> method, Map<String, Object> domainImports, SrvModelInfo model, String tableClassName, SrvModelInoutDao srvModelInoutDao) throws SQLException, Exception {
        SrvModelInout inoutParam = new SrvModelInout();
        inoutParam.setSrvModelId(model.getSrvModelId());
        inoutParam.setIoType(IOType.Input.getCode());
        List<SrvModelInout> inputParams = srvModelInoutDao.querySrvModelInoutList(inoutParam);
        String input = this.getMethodParam(domainImports, inputParams, tableClassName, "Input");
        method.put("inputListFlag", YesOrNO.NO.getCode());
        if (CollectionUtils.isNotEmpty(inputParams) && inputParams.size() > 1) {
            method.put("inputBigFlag", "Y");
        } else {
            SrvModelInout inout;
            method.put("inputBigFlag", "N");
            if (CollectionUtils.isNotEmpty(inputParams) && (inout = inputParams.get(0)).getListFlag().equals(YesOrNO.YES.getCode())) {
                method.put("inputListFlag", YesOrNO.YES.getCode());
            }
        }
        method.put("input", input);
        inoutParam.setIoType(IOType.Output.getCode());
        List<SrvModelInout> outputParams = srvModelInoutDao.querySrvModelInoutList(inoutParam);
        String output = this.getMethodParam(domainImports, outputParams, tableClassName, "Output");
        method.put("outputListFlag", YesOrNO.NO.getCode());
        if (CollectionUtils.isNotEmpty(outputParams) && outputParams.size() > 1) {
            method.put("outputBigFlag", "Y");
        } else {
            SrvModelInout inout;
            method.put("outputBigFlag", "N");
            if (CollectionUtils.isNotEmpty(outputParams) && (inout = outputParams.get(0)).getListFlag().equals(YesOrNO.YES.getCode())) {
                method.put("outputListFlag", YesOrNO.YES.getCode());
            }
        }
        method.put("output", output);
    }

    private String getMethodParam(Map<String, Object> dataMap, List<SrvModelInout> params, String tableClassName, String suffix) {
        if (CollectionUtils.isNotEmpty(params) && params.size() == 1) {
            String className = params.get(0).getTableModelCode();
            className = TmModelUtil.tableCodeToClassName((String)className);
            dataMap.put(className, className);
            return className;
        }
        if (CollectionUtils.isNotEmpty(params) && params.size() > 1) {
            String name = tableClassName + "Service" + suffix;
            dataMap.put(name, name);
            return name;
        }
        return null;
    }

    private String wrapperAssignVarName(String varType, String varName, String tableModelCode, Map<String, Object> method) {
        if (varType.equals(VarType.Input.getCode())) {
            String inputBigFlag = MapUtils.getString(method, (Object)"inputBigFlag");
            varName = inputBigFlag.equals(YesOrNO.YES.getCode()) ? "input." + StringUtils.uncapitalize((String)TmModelUtil.tableCodeToClassName((String)tableModelCode)) : "input";
        } else if (varType.equals(VarType.Output.getCode())) {
            String outputBigFlag = MapUtils.getString(method, (Object)"outputBigFlag");
            varName = outputBigFlag.equals(YesOrNO.YES.getCode()) ? "output." + StringUtils.uncapitalize((String)TmModelUtil.tableCodeToClassName((String)tableModelCode)) : "output";
        }
        return varName;
    }

    private Map<String, Object> parseFieldElement(Element field) {
        if (field == null) {
            return null;
        }
        List list = field.elements();
        if (CollectionUtils.isNotEmpty((Collection)list) && field.getQualifiedName().equalsIgnoreCase("field")) {
            HashMap<String, Object> fieldMap = new HashMap<String, Object>();
            for (Element el : list) {
                String key = el.getQualifiedName();
                String value = el.getText();
                fieldMap.put(key, value);
            }
            return fieldMap;
        }
        return null;
    }

    private Map<String, Object> parseCondition(Element condition, Map<String, Object> method, Map<String, Map<String, Object>> varHelpMap, Connection conn) {
        List list = condition.elements();
        if (CollectionUtils.isNotEmpty((Collection)list) && condition.getQualifiedName().equalsIgnoreCase("condition")) {
            HashMap<String, Object> condMap = new HashMap<String, Object>();
            Element left = condition.element("left");
            Element right = condition.element("right");
            Element op = condition.element("op");
            String operator = op.getTextTrim();
            Map<String, Object> leftField = this.parseFieldElement(left.element("field"));
            String leftValue = left.element("value").getText();
            Map<String, Object> rightField = this.parseFieldElement(right.element("field"));
            String rightValue = right.element("value").getText();
            StringBuffer leftExpSb = new StringBuffer();
            Class leftCls = null;
            if (leftField != null) {
                String domainVarId = MapUtils.getString(leftField, (Object)"domainVarId");
                String domainVarType = MapUtils.getString(leftField, (Object)"domainVarType");
                String tableModelId = MapUtils.getString(leftField, (Object)"tableModelId");
                String fieldId = MapUtils.getString(leftField, (Object)"fieldId");
                String fieldCode = MapUtils.getString(leftField, (Object)"fieldCode");
                String fieldName = MapUtils.getString(leftField, (Object)"fieldName");
                String fieldType = MapUtils.getString(leftField, (Object)"fieldType");
                leftCls = TmModelUtil.fieldTypeToJavaClass((String)fieldType);
                Map var = MapUtils.getMap(varHelpMap, (Object)domainVarId);
                if (var != null) {
                    String tableModelCode = MapUtils.getString((Map)var, (Object)"tableModelCode");
                    String targetVarName = MapUtils.getString((Map)var, (Object)"varName");
                    targetVarName = this.wrapperAssignVarName(domainVarType, targetVarName, tableModelCode, method);
                    leftExpSb.append(targetVarName).append(".get");
                    fieldCode = TmModelUtil.fieldToProperty((String)fieldCode);
                    fieldCode = StringUtils.capitalize((String)fieldCode);
                    leftExpSb.append(fieldCode).append("()");
                }
            }
            StringBuffer rightExpSb = new StringBuffer();
            Class rightCls = null;
            if (rightField != null) {
                String domainVarId = MapUtils.getString(rightField, (Object)"domainVarId");
                String domainVarType = MapUtils.getString(rightField, (Object)"domainVarType");
                String tableModelId = MapUtils.getString(rightField, (Object)"tableModelId");
                String fieldId = MapUtils.getString(rightField, (Object)"fieldId");
                String fieldCode = MapUtils.getString(rightField, (Object)"fieldCode");
                String fieldName = MapUtils.getString(rightField, (Object)"fieldName");
                String fieldType = MapUtils.getString(rightField, (Object)"fieldType");
                leftCls = TmModelUtil.fieldTypeToJavaClass((String)fieldType);
                Map var = MapUtils.getMap(varHelpMap, (Object)domainVarId);
                if (var != null) {
                    String tableModelCode = MapUtils.getString((Map)var, (Object)"tableModelCode");
                    String targetVarName = MapUtils.getString((Map)var, (Object)"varName");
                    targetVarName = this.wrapperAssignVarName(domainVarType, targetVarName, tableModelCode, method);
                    leftExpSb.append(targetVarName).append(".get");
                    fieldCode = TmModelUtil.fieldToProperty((String)fieldCode);
                    fieldCode = StringUtils.capitalize((String)fieldCode);
                    leftExpSb.append(fieldCode).append("()");
                }
            }
            if (leftCls == null || rightCls == null) {
                if (leftCls != null && rightCls == null) {
                    rightCls = leftCls;
                    this.handleConstValue(rightExpSb, rightValue, rightCls);
                } else if (leftCls == null && rightCls != null) {
                    leftCls = rightCls;
                    this.handleConstValue(leftExpSb, leftValue, leftCls);
                } else {
                    leftCls = String.class;
                    rightCls = String.class;
                    this.handleConstValue(leftExpSb, leftValue, leftCls);
                    this.handleConstValue(rightExpSb, rightValue, rightCls);
                }
            }
            String expression = leftExpSb.append(".compareTo(").append(rightExpSb.toString()).append(")").append(operator).append(" 0").toString();
            condMap.put("exp", expression);
            return condMap;
        }
        return null;
    }

    private Map<String, Object> parseResult(Element condition, Map<String, Object> method, Map<String, Map<String, Object>> varHelpMap, Connection conn) {
        List list = condition.elements();
        if (CollectionUtils.isNotEmpty((Collection)list) && condition.getQualifiedName().equalsIgnoreCase("result")) {
            HashMap<String, Object> condMap = new HashMap<String, Object>();
            Element left = condition.element("left");
            Element right = condition.element("right");
            Element op = condition.element("op");
            String operator = op.getTextTrim();
            Map<String, Object> leftField = this.parseFieldElement(left.element("field"));
            String leftValue = left.element("value").getText();
            Map<String, Object> rightField = this.parseFieldElement(right.element("field"));
            String rightValue = right.element("value").getText();
            StringBuffer leftExpSb = new StringBuffer();
            Class leftCls = null;
            if (leftField != null) {
                String domainVarId = MapUtils.getString(leftField, (Object)"domainVarId");
                String domainVarType = MapUtils.getString(leftField, (Object)"domainVarType");
                String tableModelId = MapUtils.getString(leftField, (Object)"tableModelId");
                String fieldId = MapUtils.getString(leftField, (Object)"fieldId");
                String fieldCode = MapUtils.getString(leftField, (Object)"fieldCode");
                String fieldName = MapUtils.getString(leftField, (Object)"fieldName");
                String fieldType = MapUtils.getString(leftField, (Object)"fieldType");
                leftCls = TmModelUtil.fieldTypeToJavaClass((String)fieldType);
                Map var = MapUtils.getMap(varHelpMap, (Object)domainVarId);
                if (var != null) {
                    String tableModelCode = MapUtils.getString((Map)var, (Object)"tableModelCode");
                    String targetVarName = MapUtils.getString((Map)var, (Object)"varName");
                    targetVarName = this.wrapperAssignVarName(domainVarType, targetVarName, tableModelCode, method);
                    leftExpSb.append(targetVarName).append(".set");
                    fieldCode = TmModelUtil.fieldToProperty((String)fieldCode);
                    fieldCode = StringUtils.capitalize((String)fieldCode);
                    leftExpSb.append(fieldCode);
                }
            }
            StringBuffer rightExpSb = new StringBuffer();
            Class rightCls = null;
            if (rightField != null) {
                String domainVarId = MapUtils.getString(rightField, (Object)"domainVarId");
                String domainVarType = MapUtils.getString(rightField, (Object)"domainVarType");
                String tableModelId = MapUtils.getString(rightField, (Object)"tableModelId");
                String fieldId = MapUtils.getString(rightField, (Object)"fieldId");
                String fieldCode = MapUtils.getString(rightField, (Object)"fieldCode");
                String fieldName = MapUtils.getString(rightField, (Object)"fieldName");
                String fieldType = MapUtils.getString(rightField, (Object)"fieldType");
                leftCls = TmModelUtil.fieldTypeToJavaClass((String)fieldType);
                Map var = MapUtils.getMap(varHelpMap, (Object)domainVarId);
                if (var != null) {
                    String tableModelCode = MapUtils.getString((Map)var, (Object)"tableModelCode");
                    String targetVarName = MapUtils.getString((Map)var, (Object)"varName");
                    targetVarName = this.wrapperAssignVarName(domainVarType, targetVarName, tableModelCode, method);
                    leftExpSb.append(targetVarName).append(".get");
                    fieldCode = TmModelUtil.fieldToProperty((String)fieldCode);
                    fieldCode = StringUtils.capitalize((String)fieldCode);
                    leftExpSb.append(fieldCode).append("()");
                }
            }
            if ((leftCls == null || rightCls == null) && leftCls != null && rightCls == null) {
                rightCls = leftCls;
                this.handleConstValue(rightExpSb, rightValue, rightCls);
            }
            String expression = leftExpSb.append("(").append(rightExpSb.toString()).append(")").toString();
            condMap.put("exp", expression);
            return condMap;
        }
        return null;
    }

    private Map<String, Map<String, Object>> getSrvModelInfoVarMapHelper(List<OsrvArrangeVar> varList, Map<String, Object> domainImports, List<Map<String, Object>> vars, Map<String, ModelTableInfoBo> modelTableMap, boolean createFieldKey, Connection conn) throws Exception {
        ModelTableInfoDao modelTableInfoDao = new ModelTableInfoDao(conn);
        HashMap<String, Map<String, Object>> varHelpMap = new HashMap<String, Map<String, Object>>();
        for (OsrvArrangeVar v : varList) {
            ModelTableInfoBo tbBo;
            Map varMap = MapBeanUtil.beanToMap((Object)((Object)v));
            ModelTableInfo modelTable = modelTableInfoDao.queryModelTableInfo(v.getTableModelId());
            String varName = StringUtils.uncapitalize((String)TmModelUtil.tableCodeToClassName((String)v.getDomainVarCode()));
            String varClassName = TmModelUtil.tableCodeToClassName((String)modelTable.getObjectCode());
            varMap.put("varName", varName);
            ModelTableInfo tableInfo = modelTableInfoDao.queryModelTableInfo(v.getTableModelId());
            varMap.put("tableModelCode", tableInfo.getObjectCode());
            modelTableMap.put(modelTable.getObjectId(), this.generateTableBO(modelTable, conn));
            if (v.getDomainVarType().equals(VarType.Input.getCode())) {
                if (varMap.get("listFlag") == null) {
                    varMap.put("listFlag", "");
                }
                varMap.put("varClassName", varClassName);
                domainImports.put(varClassName, varClassName);
            } else if (v.getDomainVarType().equals(VarType.Output.getCode())) {
                if (varMap.get("listFlag") == null) {
                    varMap.put("listFlag", "");
                }
                varMap.put("varClassName", varClassName);
                domainImports.put(varClassName, varClassName);
            } else if (v.getDomainVarType().equals(VarType.Result.getCode())) {
                if (varMap.get("listFlag") == null) {
                    varMap.put("listFlag", "");
                }
                vars.add(varMap);
                varMap.put("varClassName", varClassName);
                domainImports.put(varClassName, varClassName);
                varMap.put("varName", varName);
                varHelpMap.put(v.getDomainVarType(), varMap);
            } else if (v.getDomainVarType().equals(VarType.Middle.getCode())) {
                if (varMap.get("listFlag") == null) {
                    varMap.put("listFlag", "");
                }
                varMap.put("newInstance", true);
                vars.add(varMap);
                varMap.put("varClassName", varClassName);
                domainImports.put(varClassName, varClassName);
                varMap.put("varName", varName);
            }
            if (createFieldKey && (tbBo = modelTableMap.get(tableInfo.getObjectId())) != null && tbBo.getFieldList() != null) {
                for (ModelTableFieldBo field : tbBo.getFieldList()) {
                    HashMap<String, Object> fieldMap = new HashMap<String, Object>();
                    DomainVarType varType = DomainVarType.getType((String)v.getDomainVarType());
                    String varTypeName = varType != null ? varType.getName() : "";
                    String domainVarName = v.getDomainVarName();
                    String fieldName = field.getFieldName();
                    String fieldKey = String.format("[%s][%s][%s]", varTypeName, domainVarName, fieldName);
                    fieldMap.put("key", fieldKey);
                    fieldMap.put("domainVarId", v.getDomainVarId());
                    fieldMap.put("domainVarCode", v.getDomainVarCode());
                    fieldMap.put("domainVarName", v.getDomainVarName());
                    fieldMap.put("domainVarType", v.getDomainVarType());
                    fieldMap.put("listFlag", v.getListFlag());
                    fieldMap.put("tableModelId", v.getTableModelId());
                    fieldMap.put("fieldId", field.getFieldId());
                    fieldMap.put("fieldCode", field.getFieldCode());
                    fieldMap.put("fieldName", field.getFieldName());
                    fieldMap.put("fieldType", field.getFieldType());
                    fieldMap.put("fieldLength", field.getFieldLength());
                    fieldMap.put("fieldPrecision", field.getFieldPrecision());
                    varHelpMap.put(fieldKey, fieldMap);
                }
            }
            varHelpMap.put(v.getTableModelId(), varMap);
            varHelpMap.put(v.getTableModelId() + v.getDomainVarType(), varMap);
            varHelpMap.put(v.getDomainVarId(), varMap);
            varHelpMap.put(v.getTableRowId() + "-" + v.getTableModelId(), varMap);
        }
        return varHelpMap;
    }

    private void handleConstValue(StringBuffer sb, String value, Class<?> cls) {
        String val = value;
        val = StringUtils.unwrap((String)val, (String)"'");
        if (cls == String.class) {
            sb.append("\"").append(val).append("\"");
        } else if (cls == Integer.class) {
            sb.append("Integer.valueOf(").append(val).append(")");
        } else if (cls == BigDecimal.class) {
            sb.append("new BigDecimal(\"").append(val).append("\")");
        }
    }

    private Map<String, Object> parseRuleCode(String freeCode, RuleContext ruleContext) {
        HashMap<String, Object> ruleMap = new HashMap<String, Object>();
        StringBuffer javaRuleCodeSb = this.parseBlockCode(freeCode, ruleContext);
        StringReader reader = new StringReader(javaRuleCodeSb.toString());
        try {
            List lines = IOUtils.readLines((Reader)reader);
            for (int i = 0; i < lines.size(); ++i) {
                lines.set(i, "        " + (String)lines.get(i));
            }
            String leftPdCode = StringUtils.join((Iterable)lines, (String)"\n");
            javaRuleCodeSb.setLength(0);
            javaRuleCodeSb.append(leftPdCode);
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), e);
        }
        ruleMap.put("ruleCode", javaRuleCodeSb.toString());
        return ruleMap;
    }

    private StringBuffer parseBlockCode(String code, RuleContext ruleContext) {
        StringBuffer javaRuleCodeSb = new StringBuffer();
        int freeCodeLen = code.length();
        if (StringUtils.isNotBlank((CharSequence)code)) {
            for (int i = 0; i < freeCodeLen; ++i) {
                StringBuffer blockExpSb;
                RuleContext innerContext;
                String exp;
                String nextS;
                String s = String.valueOf(code.charAt(i));
                String string = nextS = i + 1 < freeCodeLen ? String.valueOf(code.charAt(i + 1)) : "";
                if ((s + nextS).equals("\u5982\u679c")) {
                    ruleContext.pos += 2;
                    exp = this.eatBlock(code, i + 2, "\u5982\u679c", ruleContext);
                    StringBuffer blExpSb = this.parseBooleanExp(exp, ruleContext);
                    javaRuleCodeSb.append("if (").append(blExpSb).append(")");
                    i = ruleContext.pos - 1;
                    continue;
                }
                if ((s + nextS).equals("\u90a3\u4e48")) {
                    ruleContext.pos += 2;
                    exp = this.eatBlock(code, i + 2, "\u90a3\u4e48", ruleContext);
                    if (ruleContext.blockParse) {
                        javaRuleCodeSb.append(exp);
                        ruleContext.blockParse = false;
                    } else {
                        innerContext = ruleContext.clone();
                        innerContext.start = 0;
                        innerContext.pos = 0;
                        innerContext.len = exp.length();
                        innerContext.innerBlock = true;
                        blockExpSb = this.parseBlockCode(exp, innerContext);
                        javaRuleCodeSb.append(blockExpSb);
                    }
                    i = ruleContext.pos - 1;
                    continue;
                }
                if ((s + nextS).equals("\u5426\u5219")) {
                    ruleContext.pos += 2;
                    exp = this.eatBlock(code, i + 2, "\u5426\u5219", ruleContext);
                    if (ruleContext.blockParse) {
                        javaRuleCodeSb.append("else").append(exp);
                        ruleContext.blockParse = false;
                        ruleContext.innerBlock = false;
                    } else {
                        innerContext = ruleContext.clone();
                        innerContext.start = 0;
                        innerContext.pos = 0;
                        innerContext.len = exp.length();
                        innerContext.innerBlock = true;
                        blockExpSb = this.parseBlockCode(exp, innerContext);
                        javaRuleCodeSb.append("else").append(blockExpSb);
                    }
                    i = ruleContext.pos - 1;
                    if (!ruleContext.innerBlock) continue;
                    ruleContext.innerBlock = false;
                    return javaRuleCodeSb;
                }
                if (s.equals("{")) {
                    ++ruleContext.pos;
                    javaRuleCodeSb.append(s);
                    continue;
                }
                if (s.equals("}")) {
                    if (!ruleContext.innerBlock) continue;
                    ++ruleContext.pos;
                    javaRuleCodeSb.append(s);
                    ruleContext.innerBlock = false;
                    return javaRuleCodeSb;
                }
                if (s.equals("$") && ruleContext.innerBlock) {
                    exp = this.eatBlock(code, i, "{", ruleContext);
                    javaRuleCodeSb.append(exp);
                    ruleContext.blockParse = false;
                    i = ruleContext.pos - 1;
                    continue;
                }
                ++ruleContext.pos;
                javaRuleCodeSb.append(s);
            }
        }
        return javaRuleCodeSb;
    }

    private StringBuffer parseBooleanExp(String code, RuleContext ruleContext) {
        this.logger.debug("\u8bfb\u53d6\u5230\u7684\u5e03\u5c14\u8868\u8fbe\u5f0f\uff1a " + code);
        StringBuffer eatSb = new StringBuffer();
        int codeLen = code.length();
        code = this.replaceCNKey(code);
        int firstNonWhitespace = 0;
        for (int i = 0; i < codeLen; ++i) {
            String s = String.valueOf(code.charAt(i));
            if (!s.matches("\\S")) continue;
            firstNonWhitespace = i;
            break;
        }
        List<String> tokens = this.createTokenList(code, firstNonWhitespace);
        List<String> tags = this.parseFormula(tokens);
        Stack stack = new Stack();
        for (int i = 0; i < tags.size(); ++i) {
            Class opType2;
            Class opType1;
            String opStr2;
            String opStr1;
            Map operator1;
            Map operator2;
            StringBuffer state;
            HashMap<String, Object> resultOp;
            String tag = tags.get(i);
            HashMap<String, Object> tagMap = new HashMap<String, Object>();
            if (tag.startsWith("$[")) {
                Map tagFieldMap = MapUtils.getMap(ruleContext.varHelpMap, (Object)tag.substring(1));
                tagMap.putAll(tagFieldMap);
                tagMap.put("tag", tag);
                tagMap.put("tagType", "F");
                String fieldType = MapUtils.getString((Map)tagFieldMap, (Object)"fieldType");
                tagMap.put("javaClass", TmModelUtil.fieldTypeToJavaClass((String)fieldType));
                stack.push(tagMap);
                continue;
            }
            if (tag.startsWith("'") || tag.substring(0, 1).matches("\\d")) {
                tagMap.put("tag", tag);
                tagMap.put("tagType", "const");
                tagMap.put("value", StringUtils.unwrap((String)tag, (String)"'"));
                stack.push(tagMap);
                continue;
            }
            if (tag.startsWith("$") && !tag.startsWith("$[")) {
                if (!"$isNotEmpty".equals(tag) && !"$isEmpty".equals(tag)) continue;
                StringBuffer state2 = new StringBuffer();
                Map operator = (Map)stack.pop();
                String opStr = this.genJavaGetterStat(operator, ruleContext);
                if (StringUtils.isNotBlank((CharSequence)opStr) && MapUtils.getObject((Map)operator, (Object)"javaClass", null) != String.class) {
                    opStr = String.format("String.valueOf(%s)", opStr);
                } else {
                    String val = MapUtils.getString((Map)operator, (Object)"value");
                    opStr = String.format("\"%s\"", val);
                }
                HashMap<String, Object> resultOp2 = new HashMap<String, Object>();
                state2.append("StringUtils.").append(tag.substring(1)).append("(").append(opStr).append(")");
                resultOp2.put("tagType", "statement");
                resultOp2.put("statement", state2.toString());
                resultOp2.put("javaClass", Boolean.class);
                stack.push(resultOp2);
                continue;
            }
            if (tag.equals("and") || tag.equals("or") || tag.equals("not")) {
                resultOp = new HashMap<String, Object>();
                state = new StringBuffer();
                if (CondLogicRelation.NOT.getCode().equals(tag)) {
                    Map operator = (Map)stack.pop();
                    String opStr = this.genJavaGetterStat(operator, ruleContext);
                    state.append("!(").append(opStr).append(")");
                    stack.push(resultOp);
                } else {
                    operator2 = (Map)stack.pop();
                    operator1 = (Map)stack.pop();
                    opStr1 = this.genJavaGetterStat(operator1, ruleContext);
                    opStr2 = this.genJavaGetterStat(operator2, ruleContext);
                    String op = null;
                    if (CondLogicRelation.AND.getCode().equals(tag)) {
                        op = " && ";
                    } else if (CondLogicRelation.OR.getCode().equals(tag)) {
                        op = " || ";
                    }
                    state.append("(").append(opStr1).append(op).append(opStr2).append(")");
                }
                resultOp.put("tagType", "statement");
                resultOp.put("statement", state.toString());
                resultOp.put("javaClass", Boolean.class);
                stack.push(resultOp);
                continue;
            }
            if (Arrays.asList("!=", "<", "<=", "==", ">", ">=").indexOf(tag) == -1) continue;
            resultOp = new HashMap();
            state = new StringBuffer();
            operator2 = (Map)stack.pop();
            operator1 = (Map)stack.pop();
            opStr1 = this.genJavaGetterStat(operator1, ruleContext);
            opStr2 = this.genJavaGetterStat(operator2, ruleContext);
            Boolean op1Const = MapUtils.getString((Map)operator1, (Object)"tagType", (String)"").equals("const");
            Boolean op2Const = MapUtils.getString((Map)operator2, (Object)"tagType", (String)"").equals("const");
            if (op1Const.booleanValue()) {
                opStr1 = MapUtils.getString((Map)operator1, (Object)"value");
            }
            if (op2Const.booleanValue()) {
                opStr2 = MapUtils.getString((Map)operator2, (Object)"value");
            }
            if ((opType1 = (Class)MapUtils.getObject((Map)operator1, (Object)"javaClass", null)) != (opType2 = (Class)MapUtils.getObject((Map)operator2, (Object)"javaClass", null))) {
                if (opType1 == BigDecimal.class || opType2 == BigDecimal.class) {
                    if (opType1 != BigDecimal.class) {
                        opStr1 = String.format("new BigDecimal(%s)", opStr1);
                    }
                    if (opType2 != BigDecimal.class) {
                        opStr2 = String.format("new BigDecimal(%s)", opStr2);
                    }
                } else if (opType1 == Integer.class || opType2 == Integer.class) {
                    if (opType1 != Integer.class) {
                        String string = opStr1 = op1Const != false ? opStr1 : String.format("new Integer(%s)", opStr1);
                    }
                    if (opType2 != Integer.class) {
                        opStr2 = op2Const != false ? opStr2 : String.format("new Integer(%s)", opStr2);
                    }
                } else {
                    if (opType1 != String.class) {
                        String string = opStr1 = op1Const != false ? String.format("\"%s\"", opStr1) : String.format("String.valueOf(%s)", opStr1);
                    }
                    if (opType2 != String.class) {
                        String string = opStr2 = op2Const != false ? String.format("\"%s\"", opStr2) : String.format("String.valueOf(%s)", opStr2);
                    }
                }
            }
            if (CondCompareSign.L.getCode().equals(tag)) {
                state.append(String.format("%s.compareTo(%s) < 0", opStr1, opStr2));
            } else if (CondCompareSign.LE.getCode().equals(tag)) {
                state.append(String.format("%s.compareTo(%s) <= 0", opStr1, opStr2));
            } else if (CondCompareSign.ED.getCode().equals(tag)) {
                state.append(String.format("%s.compareTo(%s) == 0", opStr1, opStr2));
            } else if (CondCompareSign.NE.getCode().equals(tag)) {
                state.append(String.format("%s.compareTo(%s) != 0", opStr1, opStr2));
            } else if (CondCompareSign.G.getCode().equals(tag)) {
                state.append(String.format("%s.compareTo(%s) > 0", opStr1, opStr2));
            } else if (CondCompareSign.GE.getCode().equals(tag)) {
                state.append(String.format("%s.compareTo(%s) >= 0", opStr1, opStr2));
            }
            resultOp.put("tagType", "statement");
            resultOp.put("statement", state.toString());
            resultOp.put("javaClass", Boolean.class);
            stack.push(resultOp);
        }
        if (!stack.isEmpty()) {
            Map operator = (Map)stack.pop();
            String opStr = this.genJavaGetterStat(operator, ruleContext);
            eatSb.append(opStr);
        }
        return eatSb;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private StringBuffer parseAssignExp(String code, RuleContext ruleContext) {
        this.logger.debug("\u8bfb\u53d6\u5230\u7684\u8d4b\u503c\u8868\u8fbe\u5f0f\uff1a " + code);
        StringBuffer eatSb = new StringBuffer();
        int codeLen = code.length();
        String leftToken = "";
        String rightToken = "";
        String op = "";
        if (code.contains(" \u7b49\u4e8e ")) {
            code = code.replaceAll(" \u7b49\u4e8e ", " = ");
        }
        int firstNonWhitespace = 0;
        for (int i = 0; i < codeLen; ++i) {
            String s = String.valueOf(code.charAt(i));
            if (!s.matches("\\S")) continue;
            firstNonWhitespace = i;
            break;
        }
        eatSb.append(code.substring(0, firstNonWhitespace));
        int semicolon = code.lastIndexOf(";");
        String expression = code.substring(firstNonWhitespace, semicolon);
        String[] exps = StringUtils.split((String)expression, (String)" = ");
        if (exps.length == 2) {
            leftToken = exps[0];
            rightToken = exps[1];
        }
        if (StringUtils.isNotBlank((CharSequence)leftToken) && StringUtils.isNotBlank((CharSequence)rightToken)) {
            Class leftCls = null;
            if (!leftToken.startsWith("$")) throw new RuntimeException("\u89e3\u6790\u81ea\u7531\u89c4\u5219\u8d4b\u503c\u8bed\u53e5\u5931\u8d25 " + code + " \u5de6\u8fb9\u5e94\u662f\u53ef\u8d4b\u503c\u5b57\u6bb5");
            Map leftVar = MapUtils.getMap(ruleContext.varHelpMap, (Object)(leftToken = leftToken.substring(1)).trim());
            if (leftVar == null) throw new RuntimeException("\u89e3\u6790\u81ea\u7531\u89c4\u5219\u8d4b\u503c\u8bed\u53e5\u5931\u8d25 " + code + " \u627e\u4e0d\u5230$" + leftToken);
            String domainVarId = MapUtils.getString((Map)leftVar, (Object)"domainVarId");
            String domainVarType = MapUtils.getString((Map)leftVar, (Object)"domainVarType");
            String tableModelId = MapUtils.getString((Map)leftVar, (Object)"tableModelId");
            String fieldId = MapUtils.getString((Map)leftVar, (Object)"fieldId");
            String fieldCode = MapUtils.getString((Map)leftVar, (Object)"fieldCode");
            String fieldName = MapUtils.getString((Map)leftVar, (Object)"fieldName");
            String fieldType = MapUtils.getString((Map)leftVar, (Object)"fieldType");
            leftCls = TmModelUtil.fieldTypeToJavaClass((String)fieldType);
            Map var = MapUtils.getMap(ruleContext.varHelpMap, (Object)domainVarId);
            if (var != null) {
                String tableModelCode = MapUtils.getString((Map)var, (Object)"tableModelCode");
                String targetVarName = MapUtils.getString((Map)var, (Object)"varName");
                targetVarName = this.wrapperAssignVarName(domainVarType, targetVarName, tableModelCode, ruleContext.method);
                eatSb.append(targetVarName).append(".set");
                fieldCode = TmModelUtil.fieldToProperty((String)fieldCode);
                fieldCode = StringUtils.capitalize((String)fieldCode);
                eatSb.append(fieldCode).append("(");
            }
            if (rightToken.startsWith("$")) {
                leftVar = MapUtils.getMap(ruleContext.varHelpMap, (Object)(rightToken = rightToken.substring(1)).trim());
                if (leftVar == null) throw new RuntimeException("\u89e3\u6790\u81ea\u7531\u89c4\u5219\u8d4b\u503c\u8bed\u53e5\u5931\u8d25 " + code + " \u627e\u4e0d\u5230$" + rightToken);
                domainVarId = MapUtils.getString((Map)leftVar, (Object)"domainVarId");
                domainVarType = MapUtils.getString((Map)leftVar, (Object)"domainVarType");
                tableModelId = MapUtils.getString((Map)leftVar, (Object)"tableModelId");
                fieldId = MapUtils.getString((Map)leftVar, (Object)"fieldId");
                fieldCode = MapUtils.getString((Map)leftVar, (Object)"fieldCode");
                fieldName = MapUtils.getString((Map)leftVar, (Object)"fieldName");
                fieldType = MapUtils.getString((Map)leftVar, (Object)"fieldType");
                Class rightCls = TmModelUtil.fieldTypeToJavaClass((String)fieldType);
                Map var2 = MapUtils.getMap(ruleContext.varHelpMap, (Object)domainVarId);
                if (var2 != null) {
                    String tableModelCode = MapUtils.getString((Map)var2, (Object)"tableModelCode");
                    String targetVarName = MapUtils.getString((Map)var2, (Object)"varName");
                    targetVarName = this.wrapperAssignVarName(domainVarType, targetVarName, tableModelCode, ruleContext.method);
                    eatSb.append(targetVarName).append(".get");
                    fieldCode = TmModelUtil.fieldToProperty((String)fieldCode);
                    fieldCode = StringUtils.capitalize((String)fieldCode);
                    eatSb.append(fieldCode).append("()");
                }
            } else {
                this.handleConstValue(eatSb, rightToken.trim(), leftCls);
            }
        }
        eatSb.append(")").append(code.substring(semicolon));
        return eatSb;
    }

    private String eatBlock(String code, int start, String blockType, RuleContext ruleContext) {
        StringBuffer eatSb = new StringBuffer();
        int codeLen = code.length();
        if (blockType.equals("\u5982\u679c")) {
            String endCode = "\u90a3\u4e48";
            int endCodeLen = endCode.length();
            for (int i = start; i < codeLen; ++i) {
                String s = String.valueOf(code.charAt(i));
                StringBuffer tryStr = new StringBuffer(s);
                int tryIdx = i + 1;
                for (int e = 1; e < endCodeLen && tryIdx < codeLen; ++e, ++tryIdx) {
                    tryStr.append(code.charAt(tryIdx));
                }
                if (!tryStr.toString().equals(endCode)) {
                    ++ruleContext.pos;
                    eatSb.append(s);
                    continue;
                }
                break;
            }
        } else if (blockType.equals("\u90a3\u4e48") || blockType.equals("\u5426\u5219") || blockType.equals("{")) {
            String subCode;
            String nonWhitespaceReg = "\\S";
            String firstWord = null;
            int firstWordIdx = start;
            for (int i = start; i < codeLen; ++i) {
                String s = String.valueOf(code.charAt(i));
                if (s.matches(nonWhitespaceReg)) {
                    firstWord = s;
                    firstWordIdx = i;
                    break;
                }
                ++ruleContext.pos;
                eatSb.append(s);
            }
            if (firstWord.equals("\u5982")) {
                RuleContext innerContext = ruleContext.clone();
                subCode = code.substring(firstWordIdx);
                innerContext.start = 0;
                innerContext.pos = 0;
                innerContext.len = subCode.length();
                innerContext.innerBlock = true;
                StringBuffer eat = this.parseBlockCode(subCode, innerContext);
                ruleContext.pos += innerContext.pos;
                ruleContext.blockParse = true;
                eatSb.append(eat);
            } else if (firstWord.equals("{")) {
                RuleContext innerContext = ruleContext.clone();
                subCode = code.substring(firstWordIdx);
                innerContext.start = 0;
                innerContext.pos = 0;
                innerContext.len = subCode.length();
                innerContext.innerBlock = true;
                StringBuffer eat = this.parseBlockCode(subCode, innerContext);
                ruleContext.pos += innerContext.pos;
                ruleContext.blockParse = true;
                eatSb.append(eat);
            } else if (firstWord.equals("}")) {
                if (ruleContext.innerBlock) {
                    ruleContext.innerBlock = false;
                }
                ++ruleContext.pos;
                eatSb.append(firstWord);
            } else {
                StringBuffer eat = this.eatCodeEndSingleWord(code, firstWordIdx, ';', ruleContext);
                eatSb.append(eat);
                if (ruleContext.innerBlock && blockType.equals("\u5426\u5219")) {
                    ruleContext.innerBlock = false;
                }
            }
        }
        return eatSb.toString();
    }

    private StringBuffer eatCodeEndSingleWord(String code, int start, char endCode, RuleContext ruleContext) {
        int codeLen = code.length();
        StringBuffer eatSb = new StringBuffer();
        String end = String.valueOf(endCode);
        for (int i = start; i < codeLen; ++i) {
            String s = String.valueOf(code.charAt(i));
            eatSb.append(s);
            if (s.equals(end)) break;
        }
        ruleContext.pos += eatSb.length();
        eatSb = this.parseAssignExp(eatSb.toString(), ruleContext);
        ruleContext.blockParse = true;
        return eatSb;
    }

    private List<String> createTokenList(String code, int firstNonWhitespace) {
        int i;
        String expression = code.substring(firstNonWhitespace);
        ArrayList<String> tokens = new ArrayList<String>();
        boolean tokenFlag = false;
        StringBuffer token = new StringBuffer();
        int expLen = expression.length();
        block0: for (i = 0; i < expLen; ++i) {
            String c2;
            String c1;
            int j;
            String s = String.valueOf(expression.charAt(i));
            if (s.equals("(") || s.equals(")")) {
                if (tokenFlag) {
                    tokens.add(token.toString());
                    tokenFlag = false;
                }
                tokens.add(s);
                token.setLength(0);
                continue;
            }
            if (s.equals("!") && i + 1 < expLen && expression.substring(i, i + 2).equals("!=")) {
                if (tokenFlag) {
                    tokens.add(token.toString());
                    tokenFlag = false;
                }
                s = expression.substring(i, i + 2);
                tokens.add(s);
                token.setLength(0);
                ++i;
                continue;
            }
            if (s.equals("<") && i + 1 < expLen && expression.substring(i, i + 2).equals("<=")) {
                if (tokenFlag) {
                    tokens.add(token.toString());
                    tokenFlag = false;
                }
                s = expression.substring(i, i + 2);
                tokens.add(s);
                token.setLength(0);
                ++i;
                continue;
            }
            if (s.equals("<") && i + 1 < expLen && !expression.substring(i, i + 2).equals("<=")) {
                if (tokenFlag) {
                    tokens.add(token.toString());
                    token.setLength(0);
                    tokenFlag = false;
                }
                tokens.add(s);
                token.setLength(0);
                continue;
            }
            if (s.equals(">") && i + 1 < expLen && expression.substring(i, i + 2).equals(">=")) {
                if (tokenFlag) {
                    tokens.add(token.toString());
                    tokenFlag = false;
                }
                s = expression.substring(i, i + 2);
                tokens.add(s);
                token.setLength(0);
                ++i;
                continue;
            }
            if (s.equals(">") && i + 1 < expLen && !expression.substring(i, i + 2).equals(">=")) {
                if (tokenFlag) {
                    tokens.add(token.toString());
                    token.setLength(0);
                    tokenFlag = false;
                }
                tokens.add(s);
                token.setLength(0);
                continue;
            }
            if (s.equals("=") && i + 1 < expLen && expression.substring(i, i + 2).equals("==")) {
                if (tokenFlag) {
                    tokens.add(token.toString());
                    tokenFlag = false;
                }
                s = expression.substring(i, i + 2);
                tokens.add(s);
                token.setLength(0);
                ++i;
                continue;
            }
            if (s.equals("$") || s.equals("\u5e76") || s.equals("\u975e") || s.equals("\u6216")) {
                if (tokenFlag) {
                    tokens.add(token.toString());
                    token.setLength(0);
                    tokenFlag = false;
                }
                tokenFlag = true;
                token.append(s);
                continue;
            }
            if (s.equals("'")) {
                if (tokenFlag) {
                    tokens.add(token.toString());
                    tokenFlag = false;
                }
                token.setLength(0);
                token.append(s);
                for (j = i + 1; j < expLen; ++j) {
                    c1 = String.valueOf(expression.charAt(j));
                    String string = c2 = j + 1 < expLen ? String.valueOf(code.charAt(i + 1)) : "";
                    if ("\\".equals(c1) && "'".equals(c2)) {
                        token.append(c1);
                        continue;
                    }
                    if ("'".equals(c1)) {
                        token.append(c1);
                        tokens.add(token.toString());
                        i += token.length();
                        token.setLength(0);
                        continue block0;
                    }
                    token.append(c1);
                }
                continue;
            }
            if (s.matches("\\d")) {
                if (tokenFlag) {
                    tokens.add(token.toString());
                    tokenFlag = false;
                }
                token.setLength(0);
                token.append(s);
                for (j = i + 1; j < expLen; ++j) {
                    c1 = String.valueOf(expression.charAt(j));
                    String string = c2 = j + 1 < expLen ? String.valueOf(code.charAt(i + 1)) : "";
                    if (c1.matches("\\d") || ".".equals(c1)) {
                        token.append(c1);
                        continue;
                    }
                    if (c1.matches("\\s") || !c1.matches("\\d")) {
                        tokens.add(token.toString());
                        i += token.length();
                        token.setLength(0);
                        continue block0;
                    }
                    token.append(c1);
                }
                continue;
            }
            if (s.matches("\\s")) {
                if (!tokenFlag) continue;
                tokens.add(token.toString());
                token.setLength(0);
                tokenFlag = false;
                continue;
            }
            token.append(s);
        }
        for (i = 0; i < tokens.size(); ++i) {
            String t = (String)tokens.get(i);
            if (t.trim().equals("\u5e76\u4e14")) {
                t = "and";
            } else if (t.trim().equals("\u6216")) {
                t = "or";
            } else if (t.trim().equals("\u975e")) {
                t = "not";
            }
            tokens.set(i, t);
        }
        return tokens;
    }

    private String replaceCNKey(String code) {
        if (code.contains(" \u4e0d\u7b49\u4e8e ")) {
            code = code.replaceAll(" \u4e0d\u7b49\u4e8e ", " != ");
        }
        if (code.contains(" \u5c0f\u4e8e ")) {
            code = code.replaceAll(" \u5c0f\u4e8e ", " < ");
        }
        if (code.contains(" \u5c0f\u4e8e\u7b49\u4e8e ")) {
            code = code.replaceAll(" \u5c0f\u4e8e\u7b49\u4e8e ", " <= ");
        }
        if (code.contains(" \u7b49\u4e8e ")) {
            code = code.replaceAll(" \u7b49\u4e8e ", " == ");
        }
        if (code.contains(" \u7b49\u4e8e ")) {
            code = code.replaceAll(" \u5927\u4e8e ", " > ");
        }
        if (code.contains(" \u7b49\u4e8e ")) {
            code = code.replaceAll(" \u5927\u4e8e\u7b49\u4e8e ", " >= ");
        }
        if (code.contains("$\u5b57\u7b26\u4e32\u4e0d\u4e3a\u7a7a")) {
            code = code.replaceAll("$\u5b57\u7b26\u4e32\u4e0d\u4e3a\u7a7a", "$isNotEmpty");
        }
        if (code.contains("$\u5b57\u7b26\u4e32\u4e3a\u7a7a")) {
            code = code.replaceAll("$\u5b57\u7b26\u4e32\u4e3a\u7a7a", "$isEmpty");
        }
        return code;
    }

    private List<String> parseFormula(List<String> tags) {
        Stack<String> suffixStack = new Stack<String>();
        Stack<String> opStack = new Stack<String>();
        if (CollectionUtils.isNotEmpty(tags)) {
            for (String tag : tags) {
                if (tag.startsWith("$[")) {
                    suffixStack.push(tag);
                    continue;
                }
                if (tag.startsWith("'") || tag.substring(0, 1).matches("\\d")) {
                    suffixStack.push(tag);
                    continue;
                }
                if (this.bracket(tag, suffixStack, opStack)) continue;
                if (opStack.isEmpty()) {
                    opStack.push(tag);
                    continue;
                }
                if (this.compare(tag, opStack.peek()) < 0) {
                    opStack.push(tag);
                    continue;
                }
                while (!opStack.isEmpty() && this.compare(tag, opStack.peek()) >= 0) {
                    suffixStack.push(opStack.pop());
                }
                opStack.push(tag);
            }
            while (!opStack.isEmpty()) {
                suffixStack.push((String)opStack.pop());
            }
        }
        return Arrays.asList(suffixStack.toArray(new String[0]));
    }

    private boolean bracket(String tag, Stack<String> suffixStack, Stack<String> opStack) {
        boolean done = false;
        String enname = tag;
        if ("(".equals(enname)) {
            opStack.push(tag);
            done = true;
        } else if (")".equals(enname)) {
            while (!opStack.isEmpty()) {
                String topOp = opStack.peek();
                if ("(".equals(topOp)) {
                    opStack.pop();
                    if (opStack.isEmpty() || !opStack.peek().startsWith("$") || !opStack.peek().startsWith("$[")) break;
                    suffixStack.push(opStack.pop());
                    break;
                }
                suffixStack.push(opStack.pop());
            }
            done = true;
        }
        return done;
    }

    private int compare(String t1, String t2) {
        return Integer.compare(this.priority(t1), this.priority(t2));
    }

    private int priority(String tag) {
        String code = tag;
        int pt = 0;
        switch (code) {
            case "(": 
            case ")": {
                pt = 1;
                break;
            }
            case "*": 
            case "/": {
                pt = 2;
                break;
            }
            case "+": 
            case "-": {
                pt = 3;
                break;
            }
            case "!=": 
            case "<": 
            case "<=": 
            case "==": 
            case ">": 
            case ">=": {
                pt = 4;
                break;
            }
            case "not": {
                pt = 5;
                break;
            }
            case "and": 
            case "or": {
                pt = 6;
                break;
            }
            default: {
                pt = 7;
            }
        }
        return pt;
    }

    private String genJavaGetterStat(Map<String, Object> fieldVar, RuleContext ruleContext) {
        StringBuffer eatSb = new StringBuffer();
        String tagType = MapUtils.getString(fieldVar, (Object)"tagType", (String)"");
        if (tagType.equals("statement")) {
            String statement = MapUtils.getString(fieldVar, (Object)"statement");
            eatSb.append(statement);
        } else if (tagType.equals("const")) {
            String value = MapUtils.getString(fieldVar, (Object)"value");
            eatSb.append(value);
        } else if (tagType.equals("F")) {
            String domainVarId = MapUtils.getString(fieldVar, (Object)"domainVarId");
            String domainVarType = MapUtils.getString(fieldVar, (Object)"domainVarType");
            String tableModelId = MapUtils.getString(fieldVar, (Object)"tableModelId");
            String fieldId = MapUtils.getString(fieldVar, (Object)"fieldId");
            String fieldCode = MapUtils.getString(fieldVar, (Object)"fieldCode");
            String fieldName = MapUtils.getString(fieldVar, (Object)"fieldName");
            String fieldType = MapUtils.getString(fieldVar, (Object)"fieldType");
            Map var = MapUtils.getMap(ruleContext.varHelpMap, (Object)domainVarId);
            if (var != null) {
                String tableModelCode = MapUtils.getString((Map)var, (Object)"tableModelCode");
                String targetVarName = MapUtils.getString((Map)var, (Object)"varName");
                targetVarName = this.wrapperAssignVarName(domainVarType, targetVarName, tableModelCode, ruleContext.method);
                eatSb.append(targetVarName).append(".get");
                fieldCode = TmModelUtil.fieldToProperty((String)fieldCode);
                fieldCode = StringUtils.capitalize((String)fieldCode);
                eatSb.append(fieldCode).append("()");
            }
        }
        return eatSb.toString();
    }

    public static class RuleContext {
        Map<String, Object> method;
        Map<String, Map<String, Object>> varHelpMap;
        Connection conn;
        int start = 0;
        int pos = 0;
        int len = 0;
        boolean blockParse = false;
        boolean innerBlock = false;

        public RuleContext() {
        }

        public RuleContext(Map<String, Object> method, Map<String, Map<String, Object>> varHelpMap, Connection conn) {
            this.method = method;
            this.varHelpMap = varHelpMap;
            this.conn = conn;
        }

        public RuleContext clone() {
            RuleContext cloneObj = new RuleContext(this.method, this.varHelpMap, this.conn);
            return cloneObj;
        }
    }
}

