/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.builder;

import com.irdstudio.allinapaas.executor.application.executor.core.dao.BatInstBatchDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.ModelTableInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.OsrvArrangeSectionDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.OsrvArrangeTableDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.SrvErrorMappingDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.SrvModelInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.SrvModelInoutDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.BatInstBatch;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.OsrvArrangeBlockAssign;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.OsrvArrangeClassContext;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.OsrvArrangeContext;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.OsrvArrangeDeclareVar;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.OsrvArrangeDependency;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.OsrvArrangeImport;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.OsrvArrangeMethod;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.OsrvArrangeSection;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.OsrvArrangeTable;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SrvErrorMapping;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SrvModelInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SrvModelInout;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.builder.AbstractBuilderPlugin;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.common.SSubsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.common.SSubsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.util.date.CurrentDateUtil;
import com.irdstudio.allinapaas.portal.console.types.ArchType;
import com.irdstudio.allinapaas.portal.console.types.YesOrNO;
import com.irdstudio.allinrdm.dam.console.types.ObjectType;
import com.irdstudio.allinrdm.dev.console.types.DataServiceModelEnum;
import com.irdstudio.allinrdm.dev.console.types.IOType;
import com.irdstudio.allinrdm.dev.console.types.SectionType;
import com.irdstudio.allinrdm.dev.console.types.SrvModelCatalogEnum;
import com.irdstudio.allinrdm.dev.console.types.SrvModelTypeEnum;
import com.irdstudio.sdk.beans.core.util.TmModelUtil;
import com.irdstudio.sdk.beans.freemarker.bo.CodeTemplateDataBo;
import com.irdstudio.sdk.beans.freemarker.bo.TmProjectInfoBo;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class TdpWebPlugin
extends AbstractBuilderPlugin {
    private PaasAppsInfo appInfo = null;
    private BatInstBatch batchInst;
    private Map<String, Object> extParam;
    private String loginUserId = "";
    private String srvModelId = null;

    @Override
    protected boolean doReadConfigureFromDB(Connection conn, String szConfIdentify) throws SQLException {
        String batchSerialNo = this.context.getSzBatchSn();
        BatInstBatchDao batInstBatchDao = new BatInstBatchDao(conn);
        this.batchInst = batInstBatchDao.queryByBatchSerialNo(batchSerialNo);
        PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
        this.appInfo = paasAppsInfoDao.queryByAppId(this.batchInst.getAppId());
        this.extParam = batInstBatchDao.getExtParam(this.batchInst);
        this.loginUserId = MapUtils.getString(this.extParam, (Object)"createUserId");
        this.srvModelId = MapUtils.getString(this.extParam, (Object)"srvModelId");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        this.logger.info("\u751f\u6210web\u5b50\u5de5\u7a0b\u4ee3\u7801");
        boolean result = true;
        Connection conn = null;
        try {
            conn = this.getPluginConnection();
            this.generateOsrvAppService(conn);
        }
        catch (SQLException e) {
            this.logger.error(" \u6267\u884c sql \u5f02\u5e38 " + e.getMessage(), e);
            result = false;
        }
        catch (Exception e) {
            this.logger.error("\u751f\u6210 web \u5b50\u5de5\u7a0b\u4ee3\u7801\u9519\u8bef", e);
            result = false;
        }
        finally {
            if (conn != null) {
                this.closePluginConnection(conn);
            }
        }
        return result;
    }

    private void generateOsrvAppService(Connection conn) throws Exception, SQLException {
        String subsCode = this.appInfo.getAppCode();
        conn = this.getPluginConnection();
        ModelTableInfoDao modelTableInfoDao = new ModelTableInfoDao(conn);
        SrvModelInfoDao srvModelInfoDao = new SrvModelInfoDao(conn);
        SrvModelInoutDao srvModelInoutDao = new SrvModelInoutDao(conn);
        PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
        SrvErrorMappingDao srvErrorMappingDao = new SrvErrorMappingDao(conn);
        ArrayList<CodeTemplateDataBo> ctdbList = new ArrayList<CodeTemplateDataBo>();
        SrvModelInfo modelParam = new SrvModelInfo();
        modelParam.setAppId(this.appInfo.getAppId());
        modelParam.setSrvModelId(this.srvModelId);
        List<SrvModelInfo> modelList = srvModelInfoDao.querySrvModelInfoList(modelParam, Arrays.asList(SrvModelCatalogEnum.TradeServer.getCode(), SrvModelCatalogEnum.BackServer.getCode()));
        List<SrvErrorMapping> errorCodeList = srvErrorMappingDao.queryDictErrorInfoList(this.appInfo.getAppId());
        boolean hasErrorMapping = CollectionUtils.isNotEmpty(errorCodeList);
        String errorClassName = TmModelUtil.tableCodeToClassName((String)this.appInfo.getAppCode());
        TmProjectInfoBo tpib = new TmProjectInfoBo();
        tpib.setProjectId(this.appInfo.getAppCode());
        tpib.setProjectCode(this.appInfo.getAppCode());
        tpib.setProjectName(this.appInfo.getAppName());
        HashMap<String, OsrvArrangeClassContext> clsCtxMap = new HashMap<String, OsrvArrangeClassContext>();
        if (CollectionUtils.isNotEmpty(modelList)) {
            OsrvArrangeClassContext clsCtx;
            for (SrvModelInfo srvModelInfo : modelList) {
                String className = TmModelUtil.modelCodeToClassName((String)srvModelInfo.getSrvModelCode());
                OsrvArrangeClassContext clsCtx2 = (OsrvArrangeClassContext)clsCtxMap.get(className + srvModelInfo.getSrvModelCatalog());
                if (clsCtx2 == null) {
                    clsCtx2 = new OsrvArrangeClassContext(this.appInfo, srvModelInfo.getSrvModelCatalog(), conn);
                    clsCtx2.setClassName(className);
                    clsCtxMap.put(className + srvModelInfo.getSrvModelCatalog(), clsCtx2);
                }
                OsrvArrangeContext osrvCtx = new OsrvArrangeContext(this.appInfo, srvModelInfo, conn);
                osrvCtx.setTableClassName(className);
                SrvModelInout inoutParam = new SrvModelInout();
                inoutParam.setSrvModelId(srvModelInfo.getSrvModelId());
                inoutParam.setIoType(IOType.Input.getCode());
                List<SrvModelInout> inputParams = srvModelInoutDao.querySrvModelInoutList(inoutParam);
                inoutParam.setIoType(IOType.Output.getCode());
                List<SrvModelInout> outputParams = srvModelInoutDao.querySrvModelInoutList(inoutParam);
                this.initOsrvCtx(osrvCtx, inputParams, outputParams);
                OsrvArrangeImport serviceImport = new OsrvArrangeImport();
                serviceImport.setImportType(OsrvArrangeImport.ImportType.Facade.getCode());
                serviceImport.setProjectCode(osrvCtx.getAppInfo().getAppCode());
                serviceImport.setClassName(className + clsCtx2.getServiceSuffix());
                osrvCtx.addImport(serviceImport);
                clsCtx2.getMethodCtxList().add(osrvCtx);
            }
            for (Map.Entry entry : clsCtxMap.entrySet()) {
                clsCtx = (OsrvArrangeClassContext)entry.getValue();
                CodeTemplateDataBo bo = new CodeTemplateDataBo();
                bo.setTmProjectInfo(tpib);
                bo.getEnvBo().setAuthor(this.loginUserId);
                bo.getEnvBo().setCurrentDate(CurrentDateUtil.getTodayDate());
                bo.getEnvBo().setDesc(String.format("%s %s", this.appInfo.getAppName(), clsCtx.getClassName()));
                bo.getMapData().put("clsCtx", clsCtx);
                for (OsrvArrangeContext osrvCtx : clsCtx.getMethodCtxList()) {
                    clsCtx.addImport(osrvCtx.getImportList());
                }
                ctdbList.add(bo);
            }
            for (CodeTemplateDataBo codeTemplateDataBo : ctdbList) {
                clsCtx = (OsrvArrangeClassContext)codeTemplateDataBo.getMapData().get("clsCtx");
                clsCtx.setHasErrorMapping(hasErrorMapping);
                clsCtx.setErrorClassName(errorClassName);
                OsrvArrangeImport serviceInput_import = new OsrvArrangeImport();
                serviceInput_import.setClassName("ServiceInput");
                serviceInput_import.setProjectCode(tpib.getProjectCode());
                serviceInput_import.setImportType(this.judgeTableToClassName("ServiceInput", ObjectType.Common.getCode(), null));
                clsCtx.addImport(serviceInput_import);
                OsrvArrangeImport serviceOutput_import = new OsrvArrangeImport();
                serviceOutput_import.setClassName("ServiceOutput");
                serviceOutput_import.setProjectCode(tpib.getProjectCode());
                serviceOutput_import.setImportType(this.judgeTableToClassName("ServiceOutput", ObjectType.Common.getCode(), null));
                clsCtx.addImport(serviceOutput_import);
                this.wrapAppsParam(this.appInfo.getAppId(), codeTemplateDataBo, conn);
                String package_prefix = this.getPackagePrefix(codeTemplateDataBo);
                if (!StringUtils.equals((CharSequence)ArchType.SpringCloud.getCode(), (CharSequence)this.appInfo.getArchType())) continue;
                this.produceCodeFile("XXXOsrvAppAPIController.java", clsCtx.getClassName() + clsCtx.getServiceSuffix(), "XXXOsrvAppAPI", "web", "src/main/java/" + package_prefix + "/" + TdpWebPlugin.formatClassPath(subsCode).replaceAll("_|-", ".") + "/web/controller/api/", this.appInfo, codeTemplateDataBo);
            }
        }
        SSubsInfoDao sSubsInfoDao = new SSubsInfoDao(conn);
        SSubsInfo sSubsInfo = sSubsInfoDao.querySSubsInfoWithKeys(this.appInfo.getSubsId());
        List<OsrvArrangeDependency> dependencies = this.querySubsSDKDependencies(sSubsInfo, conn);
        CodeTemplateDataBo pomBo = new CodeTemplateDataBo();
        pomBo.setTmProjectInfo(tpib);
        pomBo.getMapData().put("sdkList", dependencies);
        this.wrapAppsParam(this.appInfo.getAppId(), pomBo, conn);
        String package_prefix = this.getPackagePrefix(pomBo);
        this.produceCodeFile("web-pom.xml", "", "web-", "web", "", this.appInfo, pomBo);
    }

    private void initOsrvCtx(OsrvArrangeContext osrvCtx, List<SrvModelInout> inputParams, List<SrvModelInout> outputParams) throws Exception {
        OsrvArrangeMethod method = new OsrvArrangeMethod();
        osrvCtx.setMethod(method);
        if (StringUtils.isNotBlank((CharSequence)osrvCtx.getSrvModelInfo().getSrvModelMethod())) {
            method.setMethodName(osrvCtx.getSrvModelInfo().getSrvModelMethod());
        } else {
            method.setMethodName("handle");
        }
        this.getOsrvMethod(osrvCtx, inputParams, outputParams);
        this.bServiceHandler(osrvCtx);
    }

    private void getOsrvMethod(OsrvArrangeContext osrvCtx, List<SrvModelInout> inputParams, List<SrvModelInout> outputParams) throws SQLException, Exception {
        SrvModelInoutDao srvModelInoutDao = new SrvModelInoutDao(osrvCtx.getConn());
        OsrvArrangeMethod method = osrvCtx.getMethod();
        SrvModelInout inoutParam = new SrvModelInout();
        inoutParam.setSrvModelId(osrvCtx.getSrvModelInfo().getSrvModelId());
        String input = this.getMethodParam(inputParams, osrvCtx, "Input");
        method.setInputListFlag(YesOrNO.NO.getCode());
        method.setInputBigFlag(YesOrNO.YES.getCode());
        String mainParam = this.getDefaultParameterClassName(osrvCtx.getSrvModelInfo().getSrvModelCode(), method.getMethodName(), IOType.Input);
        SrvModelInout inputInout = null;
        for (SrvModelInout inout : inputParams) {
            if (!StringUtils.equals((CharSequence)inout.getTableModelCode(), (CharSequence)mainParam)) continue;
            inputInout = inout;
        }
        mainParam = inputInout != null ? this.wrapperTableToClassName(inputInout.getTableModelCode(), inputInout.getObjectType().toString(), inputInout.getTableModelId()) : this.wrapperTableToClassName(mainParam, ObjectType.Inout.getCode(), null);
        method.setMainInput("input.getInput()");
        method.setInput(input);
        if (StringUtils.equals((CharSequence)osrvCtx.getSrvModelInfo().getSrvModelCatalog(), (CharSequence)SrvModelCatalogEnum.BackServer.getCode())) {
            OsrvArrangeBlockAssign setUserInfoToVOStat = new OsrvArrangeBlockAssign();
            setUserInfoToVOStat.setComment("\u5f53\u524d\u7528\u6237\u4fe1\u606f");
            setUserInfoToVOStat.setStatement(String.format("setUserInfoToVO(input.get%sVO());", "UserTokenInfo"));
            setUserInfoToVOStat.setAppendSemicolon(false);
            osrvCtx.getCommFieldAssignList().add(setUserInfoToVOStat);
        }
        String mainOutputParam = this.getDefaultParameterClassName(osrvCtx.getSrvModelInfo().getSrvModelCode(), method.getMethodName(), IOType.Output);
        String output = this.getMethodParam(outputParams, osrvCtx, "Output");
        method.setOutputListFlag(YesOrNO.NO.getCode());
        method.setOutputBigFlag(YesOrNO.YES.getCode());
        SrvModelInout outputInout = null;
        for (SrvModelInout inout : outputParams) {
            if (!StringUtils.equals((CharSequence)inout.getTableModelCode(), (CharSequence)mainOutputParam)) continue;
            outputInout = inout;
        }
        mainOutputParam = outputInout != null ? this.wrapperTableToClassName(outputInout.getTableModelCode(), outputInout.getObjectType().toString(), outputInout.getTableModelId()) : this.wrapperTableToClassName(mainOutputParam, ObjectType.Inout.getCode(), null);
        method.setOutput(output);
    }

    private void bServiceHandler(OsrvArrangeContext osrvCtx) throws Exception {
        SrvModelInfoDao srvModelInfoDao = new SrvModelInfoDao(osrvCtx.getConn());
        SrvModelInoutDao srvModelInoutDao = new SrvModelInoutDao(osrvCtx.getConn());
        OsrvArrangeSectionDao osrvArrangeSectionDao = new OsrvArrangeSectionDao(osrvCtx.getConn());
        OsrvArrangeTableDao osrvArrangeTableDao = new OsrvArrangeTableDao(osrvCtx.getConn());
        SrvModelInfo model = osrvCtx.getSrvModelInfo();
        if (!StringUtils.equals((CharSequence)model.getSrvModelCatalog(), (CharSequence)SrvModelCatalogEnum.BackServer.getCode()) || StringUtils.equals((CharSequence)model.getSrvModelType(), (CharSequence)SrvModelTypeEnum.CUSTOM_BACK_SERVICE.getType())) {
            return;
        }
        OsrvArrangeSection sectionParam = new OsrvArrangeSection();
        sectionParam.setAppId(this.appInfo.getAppId());
        sectionParam.setSrvModelId(model.getSrvModelId());
        List<OsrvArrangeSection> sectionList = osrvArrangeSectionDao.queryOsrvArrangeTableList(sectionParam);
        ArrayList<OsrvArrangeSection> rootList = new ArrayList<OsrvArrangeSection>(sectionList.size());
        for (OsrvArrangeSection s : sectionList) {
            if (s.getSectionType().equals(SectionType.ReferenceSection.getCode()) || StringUtils.isNotBlank((CharSequence)s.getSectionAbvId())) continue;
            rootList.add(s);
        }
        if (rootList.isEmpty()) {
            return;
        }
        OsrvArrangeSection rootSection = (OsrvArrangeSection)((Object)rootList.get(0));
        OsrvArrangeTable osrvTableParam = new OsrvArrangeTable();
        osrvTableParam.setSrvModelId(model.getSrvModelId());
        osrvTableParam.setSectionId(rootSection.getSectionId());
        List<OsrvArrangeTable> osrvTableList = osrvArrangeTableDao.queryOsrvArrangeTableList(osrvTableParam);
        if (osrvTableList.size() < 2) {
            return;
        }
        String dId = osrvTableList.get(0).getRowOpTargetId();
        SrvModelInfo dService = srvModelInfoDao.queryBySrvModelId(dId);
        if (!StringUtils.equals((CharSequence)dService.getSrvModelCatalog(), (CharSequence)SrvModelCatalogEnum.SrvServer.getCode())) {
            return;
        }
        OsrvArrangeDeclareVar defaultInput = null;
        OsrvArrangeDeclareVar dServiceInput = null;
        OsrvArrangeDeclareVar dServiceOutput = null;
        OsrvArrangeDeclareVar dataServicePageInfo = null;
        String mainParam = this.getDefaultParameterClassName(osrvCtx.getSrvModelInfo().getSrvModelCode(), osrvCtx.getMethod().getMethodName(), IOType.Input);
        if (StringUtils.equals((CharSequence)osrvCtx.getSrvModelInfo().getSrvModelCatalog(), (CharSequence)SrvModelCatalogEnum.BackServer.getCode())) {
            String tableModelCode = osrvCtx.getSrvModelInfo().getTableModelCode() + "_input";
            mainParam = TmModelUtil.tableCodeToClassName((String)tableModelCode);
        }
        SrvModelInout inoutParam = new SrvModelInout();
        inoutParam.setSrvModelId(model.getSrvModelId());
        List<SrvModelInout> inoutList = srvModelInoutDao.querySrvModelInoutList(inoutParam);
        for (SrvModelInout inout : inoutList) {
            if (!StringUtils.equals((CharSequence)inout.getTableModelCode(), (CharSequence)mainParam)) continue;
            defaultInput = new OsrvArrangeDeclareVar(inout);
            String className = this.wrapperTableToClassName(inout.getTableModelCode(), inout.getObjectType().toString(), inout.getTableModelId());
            String varName = "input";
            defaultInput.setVarName(varName);
            defaultInput.setVarClassName(className);
        }
        inoutParam.setSrvModelId(dService.getSrvModelId());
        List<SrvModelInout> dInoutList = srvModelInoutDao.querySrvModelInoutList(inoutParam);
        DataServiceModelEnum modelEnum = DataServiceModelEnum.getModelByType((String)dService.getSrvModelType());
        for (SrvModelInout inout : dInoutList) {
            OsrvArrangeImport domainImport;
            String varName;
            String varClassName = this.wrapperTableToClassName(inout.getTableModelCode(), inout.getObjectType().toString(), inout.getTableModelId());
            String importType = this.judgeTableToClassName(inout.getTableModelCode(), inout.getObjectType().toString(), inout.getTableModelId());
            if (StringUtils.equals((CharSequence)inout.getIoType(), (CharSequence)IOType.Input.getCode()) && !inout.getObjectType().equals(ObjectType.Common.getIntCode())) {
                dServiceInput = new OsrvArrangeDeclareVar(inout);
                String className = varClassName;
                String varName2 = StringUtils.uncapitalize((String)className);
                dServiceInput.setVarName(varName2);
                dServiceInput.setVarClassName(className);
                OsrvArrangeImport domainImport2 = new OsrvArrangeImport();
                domainImport2.setImportType(importType);
                domainImport2.setClassName(className);
                domainImport2.setProjectCode(osrvCtx.getAppInfo().getAppCode());
                osrvCtx.addImport(domainImport2);
                continue;
            }
            if (StringUtils.equals((CharSequence)inout.getIoType(), (CharSequence)IOType.Input.getCode()) && StringUtils.equals((CharSequence)"PageInfo", (CharSequence)inout.getTableModelCode())) {
                dataServicePageInfo = new OsrvArrangeDeclareVar(inout);
                varName = StringUtils.uncapitalize((String)varClassName);
                dataServicePageInfo.setVarName(varName);
                dataServicePageInfo.setVarClassName(varClassName);
                domainImport = new OsrvArrangeImport();
                domainImport.setImportType(importType);
                domainImport.setClassName(varClassName);
                domainImport.setProjectCode(osrvCtx.getAppInfo().getAppCode());
                osrvCtx.addImport(domainImport);
                continue;
            }
            if (!StringUtils.equals((CharSequence)inout.getIoType(), (CharSequence)IOType.Output.getCode())) continue;
            dServiceOutput = new OsrvArrangeDeclareVar(inout);
            varName = "output";
            dServiceOutput.setVarName(varName);
            dServiceOutput.setVarClassName(varClassName);
            domainImport = new OsrvArrangeImport();
            domainImport.setImportType(importType);
            domainImport.setClassName(varClassName);
            domainImport.setProjectCode(osrvCtx.getAppInfo().getAppCode());
            osrvCtx.addImport(domainImport);
        }
        osrvCtx.getMethod().setDefaultInput(defaultInput);
        osrvCtx.getMethod().setDataServiceInput(dServiceInput);
        osrvCtx.getMethod().setDataServiceOutput(dServiceOutput);
        osrvCtx.getMethod().setDataServicePageInfo(dataServicePageInfo);
    }
}

