/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.dataload;

import com.irdstudio.allinapaas.executor.application.executor.core.plugin.dataload.PluginLoadResult;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginLoadResultDao {
    private static final Logger logger = LoggerFactory.getLogger(PluginLoadResultDao.class);
    Connection conn = null;

    public PluginLoadResultDao(Connection conn) {
        this.conn = conn;
    }

    public PluginLoadResult queryWithKeys(String batchSerialNo, String tableName) throws SQLException {
        PluginLoadResult dc = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("SELECT * FROM plugin_load_result WHERE batch_serial_no=?,table_name=?");
            ps.setString(1, batchSerialNo);
            ps.setString(2, tableName);
            rs = ps.executeQuery();
            if (rs.next()) {
                dc = new PluginLoadResult();
                dc.setBatchSerialNo(rs.getString("batch_serial_no"));
                dc.setBatchDate(rs.getString("batch_date"));
                dc.setBatchId(rs.getString("batch_id"));
                dc.setUpSysname(rs.getString("up_sysname"));
                dc.setTableName(rs.getString("table_name"));
                dc.setTableCnname(rs.getString("table_cnname"));
                dc.setTableType(rs.getString("table_type"));
                dc.setTableLoadMode(rs.getString("table_load_mode"));
                dc.setLoadFromFile(rs.getString("load_from_file"));
                dc.setFileSize(rs.getBigDecimal("file_size"));
                dc.setStartTime(rs.getString("start_time"));
                dc.setCostTime(rs.getBigDecimal("cost_time"));
                dc.setEndTime(rs.getString("end_time"));
                dc.setReadRows(rs.getInt("read_rows"));
                dc.setLoadRows(rs.getInt("load_rows"));
                dc.setRejectRows(rs.getInt("reject_rows"));
                dc.setLoadResult(rs.getString("load_result"));
                dc.setRemark(rs.getString("remark"));
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("queryPluginLoadResultWithKeys is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return dc;
    }

    protected void close(ResultSet theRs, Statement theStmt, PreparedStatement thePs) {
        try {
            if (theRs != null) {
                theRs.close();
            }
            if (theStmt != null) {
                theStmt.close();
            }
            if (thePs != null) {
                thePs.close();
            }
        }
        catch (SQLException e) {
            logger.error(e.getMessage());
        }
    }
}

