/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.deliver;

import com.irdstudio.allinapaas.executor.application.executor.core.dao.BatBatchInfoConfigDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.BatInstBatchDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEcsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEnvInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEnvParamDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasTemplateSqlDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.BatBatchInfoConfig;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.BatInstBatch;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasEcsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasEnvInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasEnvParam;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.AbstractPlugin;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.apps.SdEnvUtil;
import com.irdstudio.sdk.beans.ssh.io.SSHOutputPrinter;
import com.irdstudio.sdk.beans.ssh.utils.RemoteSSHClient;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class DAInstallPlugin
extends AbstractPlugin {
    private BatInstBatch opsLog;
    private String id = "dubbo-admin0.3.0";
    protected SSHOutputPrinter sshPrinter = new SSHOutputPrinter(){

        public void print(String line) {
            if (DAInstallPlugin.this.logger != null) {
                DAInstallPlugin.this.logger.info(line);
            } else {
                System.out.println(line);
            }
        }

        public void printError(String line) {
            if (DAInstallPlugin.this.logger != null) {
                DAInstallPlugin.this.logger.error(line);
            } else {
                System.err.println(line);
            }
        }
    };

    @Override
    protected boolean doReadConfigureFromDB(Connection conn, String szConfIdentify) throws SQLException {
        String batchSerialNo = this.context.getSzBatchSn();
        BatInstBatchDao batInstBatchDao = new BatInstBatchDao(conn);
        this.opsLog = batInstBatchDao.queryByBatchSerialNo(batchSerialNo);
        BatBatchInfoConfigDao batBatchInfoConfigDao = new BatBatchInfoConfigDao(conn);
        BatBatchInfoConfig batchInfo = batBatchInfoConfigDao.queryWithKeys(this.opsLog.getBatchId());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        boolean flag = true;
        Connection conn = null;
        try {
            String paasArchType;
            conn = this.getPluginConnection();
            PaasEcsInfoDao paasEcsInfoDao = new PaasEcsInfoDao(conn);
            PaasEnvParamDao paasEnvParamDao = new PaasEnvParamDao(conn);
            PaasEnvInfoDao paasEnvInfoDao = new PaasEnvInfoDao(conn);
            BatInstBatchDao batInstBatchDao = new BatInstBatchDao(conn);
            PaasTemplateSqlDao paasTemplateSqlDao = new PaasTemplateSqlDao(conn);
            BatInstBatch batInstBatch = batInstBatchDao.queryByBatchSerialNo(this.context.getSzBatchSn());
            String currEnvId = batInstBatch.getEnvId();
            PaasEnvInfo envInfo = paasEnvInfoDao.queryByPk(currEnvId);
            PaasEnvParam deployRoot = paasEnvParamDao.queryByCode("deploy_root", currEnvId);
            String deployRootDir = deployRoot.getParamValue();
            PaasEcsInfo ecsParam = new PaasEcsInfo();
            ecsParam.setEnvId(currEnvId);
            List<PaasEcsInfo> ecsList = paasEcsInfoDao.queryPaasEcsInfo(ecsParam);
            if (CollectionUtils.isEmpty(ecsList)) {
                this.logger.error("\u6ce8\u518c\u4e2d\u5fc3\u5730\u5740\u4e3a\u7a7a\uff0c\u8bf7\u5148\u914d\u7f6e registry_address");
                flag = false;
                throw new RuntimeException("\u6ce8\u518c\u4e2d\u5fc3\u5730\u5740\u4e3a\u7a7a\uff0c\u8bf7\u5148\u914d\u7f6e registry_address");
            }
            String registerAdd = ecsList.get(0).getEcsIp();
            if (StringUtils.isBlank((String)registerAdd)) {
                this.logger.error("\u6ce8\u518c\u4e2d\u5fc3\u5730\u5740\u4e3a\u7a7a\uff0c\u8bf7\u5148\u914d\u7f6e registry_address");
                flag = false;
                throw new RuntimeException("\u6ce8\u518c\u4e2d\u5fc3\u5730\u5740\u4e3a\u7a7a\uff0c\u8bf7\u5148\u914d\u7f6e registry_address");
            }
            registerAdd = registerAdd + ":2181";
            PaasEcsInfo ecsInfo = paasEcsInfoDao.queryByPk(this.opsLog.getEcsId());
            String opsPath = SdEnvUtil.TEMPLATE_PATH + this.id + "-medium";
            if (StringUtils.isBlank((String)opsPath)) {
                this.logger.error("\u65e0\u6cd5\u83b7\u53d6\u8fd0\u7ef4\u6a21\u677f\u6240\u5728\u76ee\u5f55\uff0c\u8bf7\u68c0\u67e5\u8fd0\u7ef4\u6a21\u677f\u4ed3\u5e93\u914d\u7f6e");
                flag = false;
                throw new RuntimeException("\u65e0\u6cd5\u83b7\u53d6\u8fd0\u7ef4\u6a21\u677f\u6240\u5728\u76ee\u5f55\uff0c\u8bf7\u68c0\u67e5\u8fd0\u7ef4\u6a21\u677f\u4ed3\u5e93\u914d\u7f6e");
            }
            String daPath = opsPath + File.separator;
            String daFileName = "dubbo-admin-0.3.0.jar";
            if (!new File(daPath + daFileName).exists()) {
                this.logger.error("\u5b89\u88c5\u5305\u4e0d\u5b58\u5728" + daFileName);
                flag = false;
                throw new RuntimeException("\u5b89\u88c5\u5305\u4e0d\u5b58\u5728" + daFileName);
            }
            this.logger.info("\u8fdc\u7a0b\u64cd\u4f5cLinux\u670d\u52a1\u5668 " + ecsInfo.getEcsIp());
            RemoteSSHClient rsc = new RemoteSSHClient(ecsInfo.getEcsIp(), ecsInfo.getEcsLoginUser(), ecsInfo.getEcsLoginPwd());
            boolean loginFlag = rsc.connect();
            if (!loginFlag) {
                this.logger.error("\u767b\u9646\u670d\u52a1\u5668\u5931\u8d25");
                throw new RuntimeException("\u767b\u9646\u670d\u52a1\u5668\u5931\u8d25");
            }
            if (!rsc.fileExists(deployRootDir + "/dubbo-admin")) {
                rsc.executeCommand("mkdir -p " + deployRootDir + "/dubbo-admin", this.sshPrinter);
            }
            if (!rsc.fileExists(deployRootDir + "/dubbo-admin/config")) {
                rsc.executeCommand("mkdir -p " + deployRootDir + "/dubbo-admin/config", this.sshPrinter);
            }
            rsc.upload(daPath + daFileName, deployRootDir + "/dubbo-admin");
            String configPath = daPath + "config" + File.separator + "application.properties";
            rsc.upload(configPath, deployRootDir + "/dubbo-admin/config");
            if (registerAdd.startsWith(this.opsLog.getEcsIp())) {
                registerAdd = registerAdd.replaceFirst(this.opsLog.getEcsIp(), "127.0.0.1");
            }
            if (StringUtils.equals((String)(paasArchType = envInfo.getArchType()), (String)"D02")) {
                rsc.executeCommand(String.format("sed -i 's/127.0.0.1:2181/%s/' " + deployRootDir + "/dubbo-admin/config/application.properties ", registerAdd), this.sshPrinter);
                rsc.executeCommand(String.format("sed -i 's/group=sofa-rpc/%s/' " + deployRootDir + "/dubbo-admin/config/application.properties ", "group=dubbo"), this.sshPrinter);
            }
            rsc.executeCommand(String.format("sed -i 's/server.port=8081/%s/' " + deployRootDir + "/dubbo-admin/config/application.properties ", String.format("server.port=%s", ecsInfo.getEcsPort())), this.sshPrinter);
            rsc.executeCommand("cd " + deployRootDir + "/dubbo-admin/ ; nohup java -jar " + daFileName + " > /dev/null &", this.sshPrinter);
        }
        catch (Exception e) {
            this.logger.error("\u5b89\u88c5dubbo-admin\u5230\u670d\u52a1\u5668" + e.getMessage(), e);
            flag = false;
        }
        finally {
            if (conn != null) {
                this.closePluginConnection(conn);
            }
        }
        return flag;
    }
}

