/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.docs.gendoc;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.util.DateUtils;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasDocTemplate;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.docs.gendoc.DocGenerate;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.docs.git.queue.DocTemplateRepoPullQueueExecutor;
import com.irdstudio.allinapaas.executor.application.executor.core.tinycore.jdbc.dbcp.base.IConnPool;
import com.irdstudio.allinapaas.executor.application.executor.core.util.date.CurrentDateUtil;
import com.irdstudio.allinrdm.admin.console.facade.RdmWeeklyCalendarService;
import com.irdstudio.allinrdm.admin.console.facade.dto.RdmWeeklyCalendarDTO;
import com.irdstudio.allinrdm.project.console.facade.RdmObjectiveInfoService;
import com.irdstudio.allinrdm.project.console.facade.RdmProjectInfoService;
import com.irdstudio.allinrdm.project.console.facade.dto.RdmObjectiveInfoDTO;
import com.irdstudio.allinrdm.project.console.facade.dto.RdmProjectInfoDTO;
import com.irdstudio.allinrdm.project.console.types.RdmProgress;
import com.irdstudio.allinrdm.project.console.types.TaskState;
import com.irdstudio.sdk.beans.core.util.BeanUtility;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import java.io.File;
import java.sql.Connection;
import java.text.ParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.time.DateFormatUtils;

public class GenRdmObjectiveExcel
implements DocGenerate {
    protected RdmObjectiveInfoService rdmObjectiveInfoService;

    @Override
    public List<File> generateDoc(PaasDocTemplate template, String subsId, File baseDir, IConnPool connTool, Map<String, Object> extParams) {
        return null;
    }

    public void fillRdmObjectiveList(ExcelWriter excelWriter, WriteSheet sheet, RdmObjectiveInfoDTO objectiveParam) {
        List rows = this.rdmObjectiveInfoService.queryList((Object)objectiveParam);
        if (CollectionUtils.isEmpty((Collection)rows)) {
            rows = Collections.emptyList();
        }
        for (int i = 0; i < rows.size(); ++i) {
            RdmObjectiveInfoDTO objective = (RdmObjectiveInfoDTO)rows.get(i);
            objective.setObjectiveState(TaskState.nameByCode((String)objective.getObjectiveState()));
        }
        excelWriter.fill(rows, sheet);
    }

    @Override
    public File generateAppDoc(PaasDocTemplate template, String appId, File baseDir, IConnPool connTool, Map<String, Object> extParams) {
        Connection conn = null;
        try {
            String viewName;
            RdmProjectInfoDTO projectInfo;
            String filterCond;
            String state;
            String takePartIn;
            String objectiveState;
            String objectiveIncharge;
            String createUser;
            String objectiveCategory;
            String projectId;
            File currentFile;
            block17: {
                this.rdmObjectiveInfoService = (RdmObjectiveInfoService)SpringContextUtils.getBean(RdmObjectiveInfoService.class);
                conn = connTool.getConnection();
                currentFile = this.getDocDirPath(template, baseDir, conn);
                if (!currentFile.exists()) {
                    currentFile.mkdirs();
                }
                projectId = MapUtils.getString(extParams, (Object)"projectId");
                objectiveCategory = MapUtils.getString(extParams, (Object)"objectiveCategory");
                createUser = MapUtils.getString(extParams, (Object)"createUser");
                objectiveIncharge = MapUtils.getString(extParams, (Object)"objectiveIncharge");
                objectiveState = MapUtils.getString(extParams, (Object)"objectiveState");
                takePartIn = MapUtils.getString(extParams, (Object)"takePartIn");
                String dateType = MapUtils.getString(extParams, (Object)"dateType");
                String weekId = MapUtils.getString(extParams, (Object)"weekId");
                String month = MapUtils.getString(extParams, (Object)"month");
                String startDate = MapUtils.getString(extParams, (Object)"startDate");
                state = MapUtils.getString(extParams, (Object)"state");
                filterCond = MapUtils.getString(extParams, (Object)"filterCond");
                RdmProjectInfoService rdmProjectInfoService = (RdmProjectInfoService)SpringContextUtils.getBean(RdmProjectInfoService.class);
                RdmWeeklyCalendarService rdmWeeklyCalendarService = (RdmWeeklyCalendarService)SpringContextUtils.getBean(RdmWeeklyCalendarService.class);
                projectInfo = new RdmProjectInfoDTO();
                projectInfo.setProjectId(projectId);
                projectInfo = (RdmProjectInfoDTO)rdmProjectInfoService.queryByPk((Object)projectInfo);
                viewName = "";
                if (StringUtils.isNotBlank((CharSequence)state)) {
                    viewName = "-" + RdmProgress.nameByCode((String)state);
                } else {
                    if (StringUtils.equals((CharSequence)dateType, (CharSequence)"month")) {
                        try {
                            Date monthObj = DateUtils.parseDate((String)month, (String)"yyyy-MM");
                            viewName = DateFormatUtils.format((Date)monthObj, (String)"-yyyy\u5e74MM\u6708");
                        }
                        catch (ParseException e) {
                            String[] months = StringUtils.split((String)month, (String)"-");
                            if (months.length > 2) {
                                viewName = String.format("-%s\u5e74%s\u6708", months[0], months[1]);
                            }
                            break block17;
                        }
                    }
                    if (StringUtils.equals((CharSequence)dateType, (CharSequence)"week")) {
                        RdmWeeklyCalendarDTO weeklyInfo = new RdmWeeklyCalendarDTO();
                        weeklyInfo.setWeekId(Integer.valueOf(NumberUtils.toInt((String)weekId)));
                        weeklyInfo = (RdmWeeklyCalendarDTO)rdmWeeklyCalendarService.queryByPk((Object)weeklyInfo);
                        viewName = String.format("-%s\u5e74\u7b2c%s\u5468", weeklyInfo.getYear(), weeklyInfo.getWeekNumber());
                    } else if (StringUtils.equals((CharSequence)dateType, (CharSequence)"day")) {
                        try {
                            Date dayObj = DateUtils.parseDate((String)startDate, (String)"yyyy-MM-dd");
                            viewName = DateFormatUtils.format((Date)dayObj, (String)"-yyyy\u5e74MM\u6708dd\u65e5");
                        }
                        catch (ParseException e) {
                            String[] days = StringUtils.split((String)startDate, (String)"-");
                            if (days.length <= 2) break block17;
                            viewName = String.format("-%s\u5e74%s\u6708%s", days[0], days[1], days[2]);
                        }
                    }
                }
            }
            String userId = template.getLoginUserId();
            String today = CurrentDateUtil.getTodayDate();
            String todayTime = CurrentDateUtil.getTodayDateEx2();
            String time = CurrentDateUtil.getCurrentTime();
            Map rootMap = BeanUtility.bean2Map((Object)projectInfo);
            rootMap.put("today", today);
            rootMap.put("todayTime", todayTime);
            rootMap.put("time", time);
            rootMap.put("viewName", viewName);
            String fileName = template.getDocName();
            if (StringUtils.isNotBlank((CharSequence)template.getDocNameTemplate())) {
                fileName = this.renderDocName(template.getDocNameTemplate(), rootMap);
            }
            DocTemplateRepoPullQueueExecutor.syncRun();
            String excelTemplatePath = DocTemplateRepoPullQueueExecutor.getDocTemplatePath();
            File templateFile = new File(excelTemplatePath, template.getDocFile());
            File targetFile = new File(currentFile, fileName);
            ExcelWriter excelWriter = EasyExcel.write((File)targetFile).withTemplate(templateFile).build();
            WriteSheet sheet = EasyExcel.writerSheet((Integer)0, null).build();
            RdmObjectiveInfoDTO objectiveParam = new RdmObjectiveInfoDTO();
            objectiveParam.setProjectId(projectId);
            objectiveParam.setObjectiveCategory(objectiveCategory);
            objectiveParam.setCreateUser(createUser);
            objectiveParam.setObjectiveIncharge(objectiveIncharge);
            objectiveParam.setObjectiveState(objectiveState);
            objectiveParam.setTakePartIn(takePartIn);
            objectiveParam.setState(state);
            objectiveParam.setFilterCond(filterCond);
            this.fillRdmObjectiveList(excelWriter, sheet, objectiveParam);
            excelWriter.finish();
            File file = targetFile;
            connTool.releaseConnection(conn);
            return file;
        }
        catch (Exception e) {
            try {
                logger.error("\u9879\u76ee\u8ba1\u5212\u5bfc\u51fa\u5f02\u5e38 " + e.getMessage(), (Throwable)e);
                throw new RuntimeException("\u9879\u76ee\u8ba1\u5212\u5bfc\u51fa\u5f02\u5e38 " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                connTool.releaseConnection(conn);
                throw throwable;
            }
        }
    }
}

