/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.docs.gendoc;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.util.DateUtils;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.excel.write.metadata.style.WriteCellStyle;
import com.alibaba.excel.write.metadata.style.WriteFont;
import com.alibaba.excel.write.style.HorizontalCellStyleStrategy;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import com.alibaba.fastjson.JSON;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasDocTemplate;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.docs.gendoc.DocGenerate;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.docs.git.queue.DocTemplateRepoPullQueueExecutor;
import com.irdstudio.allinapaas.executor.application.executor.core.tinycore.jdbc.dbcp.base.IConnPool;
import com.irdstudio.allinapaas.executor.application.executor.core.util.date.CurrentDateUtil;
import com.irdstudio.allinrdm.admin.console.facade.RdmWeeklyCalendarService;
import com.irdstudio.allinrdm.admin.console.facade.dto.RdmWeeklyCalendarDTO;
import com.irdstudio.allinrdm.dev.console.types.YesOrNO;
import com.irdstudio.allinrdm.project.console.facade.RdmPlanInfoService;
import com.irdstudio.allinrdm.project.console.facade.RdmProjectInfoService;
import com.irdstudio.allinrdm.project.console.facade.RdmTaskInfoService;
import com.irdstudio.allinrdm.project.console.facade.RdmTeamInfoService;
import com.irdstudio.allinrdm.project.console.facade.dto.RdmPlanInfoDTO;
import com.irdstudio.allinrdm.project.console.facade.dto.RdmProjectInfoDTO;
import com.irdstudio.allinrdm.project.console.facade.dto.RdmTaskInfoDTO;
import com.irdstudio.allinrdm.project.console.facade.dto.RdmTeamInfoDTO;
import com.irdstudio.allinrdm.project.console.types.ProjectState;
import com.irdstudio.allinrdm.project.console.types.RdmProgress;
import com.irdstudio.allinrdm.project.console.types.TaskCategory;
import com.irdstudio.allinrdm.project.console.types.TaskState;
import com.irdstudio.allinrdm.project.console.types.TaskType;
import com.irdstudio.sdk.beans.core.util.BeanUtility;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.FilterItem;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class GenRdmTaskTeamExcel
implements DocGenerate {
    protected RdmTaskInfoService rdmTaskInfoService;
    protected RdmTeamInfoService rdmTeamInfoService;

    @Override
    public List<File> generateDoc(PaasDocTemplate template, String subsId, File baseDir, IConnPool connTool, Map<String, Object> extParams) {
        String viewName;
        RdmProjectInfoDTO projectInfo;
        ArrayList<File> teamFileList;
        block21: {
            this.rdmTaskInfoService = (RdmTaskInfoService)SpringContextUtils.getBean(RdmTaskInfoService.class);
            this.rdmTeamInfoService = (RdmTeamInfoService)SpringContextUtils.getBean(RdmTeamInfoService.class);
            String loginUserId = MapUtils.getString(extParams, (Object)"loginUserId");
            String projectId = MapUtils.getString(extParams, (Object)"projectId");
            String planId = MapUtils.getString(extParams, (Object)"planId");
            String dateType = MapUtils.getString(extParams, (Object)"dateType");
            String weekId = MapUtils.getString(extParams, (Object)"weekId");
            String month = MapUtils.getString(extParams, (Object)"month");
            String startDate = MapUtils.getString(extParams, (Object)"startDate");
            String state = MapUtils.getString(extParams, (Object)"state");
            String filterCond = MapUtils.getString(extParams, (Object)"filterCond");
            List userList = new ArrayList();
            RdmTaskInfoDTO taskParam = new RdmTaskInfoDTO();
            taskParam.setProjectId(projectId);
            if (StringUtils.isNotBlank((CharSequence)planId)) {
                taskParam.setPlanIdList(Arrays.asList(StringUtils.split((String)planId, (String)",")));
            }
            taskParam.setState(state);
            taskParam.setGroupBy("incharge,incharge_name");
            taskParam.setSize(Integer.valueOf(Integer.MAX_VALUE));
            taskParam.setFilterCond(filterCond);
            userList = this.rdmTaskInfoService.queryListByPage((Object)taskParam);
            teamFileList = new ArrayList<File>();
            if (CollectionUtils.isNotEmpty(userList)) {
                ArrayList<RdmTeamInfoDTO> teamList = new ArrayList<RdmTeamInfoDTO>(userList.size());
                HashMap<String, RdmTeamInfoDTO> teamMap = new HashMap<String, RdmTeamInfoDTO>();
                for (RdmTaskInfoDTO user : userList) {
                    String taskUserId = user.getIncharge();
                    String taskUserName = user.getInchargeName();
                    RdmTeamInfoDTO teamParam = new RdmTeamInfoDTO();
                    teamParam.setProjectId(projectId);
                    teamParam.setLoginUserId(taskUserId);
                    List userTeamList = this.rdmTeamInfoService.queryList((Object)teamParam);
                    if (!CollectionUtils.isNotEmpty((Collection)userTeamList)) continue;
                    for (RdmTeamInfoDTO team : userTeamList) {
                        if (teamMap.get(team.getTeamId()) != null) continue;
                        teamMap.put(team.getTeamId(), team);
                        teamList.add(team);
                    }
                    teamList.sort((o1, o2) -> o1.getTeamId().compareTo(o2.getTeamId()));
                }
                for (RdmTeamInfoDTO team : teamList) {
                    String teamId = team.getTeamId();
                    String teamName = team.getTeamName();
                    extParams.put("teamId", teamId);
                    extParams.put("teamName", teamName);
                    File userFile = this.generateAppDoc(template, subsId, baseDir, connTool, extParams);
                    if (userFile == null || !userFile.exists()) continue;
                    teamFileList.add(userFile);
                }
            }
            RdmProjectInfoService rdmProjectInfoService = (RdmProjectInfoService)SpringContextUtils.getBean(RdmProjectInfoService.class);
            RdmWeeklyCalendarService rdmWeeklyCalendarService = (RdmWeeklyCalendarService)SpringContextUtils.getBean(RdmWeeklyCalendarService.class);
            projectInfo = new RdmProjectInfoDTO();
            projectInfo.setProjectId(projectId);
            projectInfo = (RdmProjectInfoDTO)rdmProjectInfoService.queryByPk((Object)projectInfo);
            viewName = "";
            if (StringUtils.isNotBlank((CharSequence)state)) {
                viewName = "-" + RdmProgress.nameByCode((String)state);
            } else {
                if (StringUtils.equals((CharSequence)dateType, (CharSequence)"month")) {
                    try {
                        Date monthObj = DateUtils.parseDate((String)month, (String)"yyyy-MM");
                        viewName = DateFormatUtils.format((Date)monthObj, (String)"-yyyy\u5e74MM\u6708");
                    }
                    catch (ParseException e) {
                        String[] months = StringUtils.split((String)month, (String)"-");
                        if (months.length > 2) {
                            viewName = String.format("-%s\u5e74%s\u6708", months[0], months[1]);
                        }
                        break block21;
                    }
                }
                if (StringUtils.equals((CharSequence)dateType, (CharSequence)"week")) {
                    RdmWeeklyCalendarDTO weeklyInfo = new RdmWeeklyCalendarDTO();
                    weeklyInfo.setWeekId(Integer.valueOf(NumberUtils.toInt((String)weekId)));
                    weeklyInfo = (RdmWeeklyCalendarDTO)rdmWeeklyCalendarService.queryByPk((Object)weeklyInfo);
                    viewName = String.format("-%s\u5e74\u7b2c%s\u5468", weeklyInfo.getYear(), weeklyInfo.getWeekNumber());
                } else if (StringUtils.equals((CharSequence)dateType, (CharSequence)"day")) {
                    try {
                        Date dayObj = DateUtils.parseDate((String)startDate, (String)"yyyy-MM-dd");
                        viewName = DateFormatUtils.format((Date)dayObj, (String)"-yyyy\u5e74MM\u6708dd\u65e5");
                    }
                    catch (ParseException e) {
                        String[] days = StringUtils.split((String)startDate, (String)"-");
                        if (days.length <= 2) break block21;
                        viewName = String.format("-%s\u5e74%s\u6708%s", days[0], days[1], days[2]);
                    }
                }
            }
        }
        viewName = StringUtils.isNotBlank((CharSequence)viewName) ? "-\u6309\u56e2\u961f\u5bfc\u51fa-" + viewName : "-\u6309\u56e2\u961f\u5bfc\u51fa";
        String today = CurrentDateUtil.getTodayDate();
        String todayTime = CurrentDateUtil.getTodayDateEx2();
        String time = CurrentDateUtil.getCurrentTime();
        Map rootMap = BeanUtility.bean2Map((Object)projectInfo);
        rootMap.put("today", today);
        rootMap.put("todayTime", todayTime);
        rootMap.put("time", time);
        rootMap.put("viewName", viewName);
        String fileName = template.getDocName();
        if (StringUtils.isNotBlank((CharSequence)template.getDocNameTemplate())) {
            fileName = this.renderDocName(template.getDocNameTemplate(), rootMap);
        }
        fileName = StringUtils.replace((String)fileName, (String)".xlsx", (String)".zip");
        File teamZipFile = new File(baseDir, fileName);
        if (CollectionUtils.isNotEmpty(teamFileList)) {
            try {
                ZipArchiveOutputStream zipOutput = new ZipArchiveOutputStream(teamZipFile);
                for (File file : teamFileList) {
                    ZipArchiveEntry entry = new ZipArchiveEntry(file.getName());
                    zipOutput.putArchiveEntry((ArchiveEntry)entry);
                    zipOutput.write(IOUtils.toByteArray((InputStream)new FileInputStream(file)));
                }
                zipOutput.closeArchiveEntry();
                zipOutput.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return Arrays.asList(teamZipFile);
    }

    public void fillRdmTaskList(ExcelWriter excelWriter, WriteSheet sheet, RdmTaskInfoDTO taskParam) {
        List rows = this.rdmTaskInfoService.queryList((Object)taskParam);
        if (CollectionUtils.isEmpty((Collection)rows)) {
            rows = Collections.emptyList();
        }
        ArrayList itemList = new ArrayList();
        for (int i = 0; i < rows.size(); ++i) {
            RdmTaskInfoDTO task = (RdmTaskInfoDTO)rows.get(i);
            task.setSeq(Integer.valueOf(i + 1));
            task.setTaskCategory(TaskCategory.nameByCode((String)task.getTaskCategory()));
            task.setTaskType(TaskType.nameByCode((String)task.getTaskType()));
            task.setTaskState(TaskState.nameByCode((String)task.getTaskState()));
        }
        excelWriter.fill(rows, sheet);
        excelWriter.write(itemList, sheet);
    }

    @Override
    public File generateAppDoc(PaasDocTemplate template, String appId, File baseDir, IConnPool connTool, Map<String, Object> extParams) {
        Connection conn = null;
        try {
            ExcelWriter excelWriter;
            ExcelWriterBuilder writerBuilder;
            List<Object> planIdList;
            String viewName;
            RdmProjectInfoDTO projectInfo;
            RdmPlanInfoService rdmPlanInfoService;
            String putGroupOnFront;
            String groupByPlan;
            String groupByTeam;
            String filterCond;
            String teamName;
            String teamId;
            String state;
            String splitPlan;
            String planId;
            String projectId;
            String viewNameFromParam;
            File currentFile;
            block47: {
                this.rdmTaskInfoService = (RdmTaskInfoService)SpringContextUtils.getBean(RdmTaskInfoService.class);
                conn = connTool.getConnection();
                currentFile = this.getDocDirPath(template, baseDir, conn);
                if (!currentFile.exists()) {
                    currentFile.mkdirs();
                }
                viewNameFromParam = MapUtils.getString(extParams, (Object)"viewName");
                projectId = MapUtils.getString(extParams, (Object)"projectId");
                planId = MapUtils.getString(extParams, (Object)"planId");
                String dateType = MapUtils.getString(extParams, (Object)"dateType");
                String weekId = MapUtils.getString(extParams, (Object)"weekId");
                String month = MapUtils.getString(extParams, (Object)"month");
                String startDate = MapUtils.getString(extParams, (Object)"startDate");
                splitPlan = MapUtils.getString(extParams, (Object)"splitPlan");
                state = MapUtils.getString(extParams, (Object)"state");
                teamId = MapUtils.getString(extParams, (Object)"teamId");
                teamName = MapUtils.getString(extParams, (Object)"teamName");
                filterCond = MapUtils.getString(extParams, (Object)"filterCond");
                groupByTeam = MapUtils.getString(extParams, (Object)"groupByTeam");
                groupByPlan = MapUtils.getString(extParams, (Object)"groupByPlan");
                putGroupOnFront = MapUtils.getString(extParams, (Object)"putGroupOnFront");
                RdmProjectInfoService rdmProjectInfoService = (RdmProjectInfoService)SpringContextUtils.getBean(RdmProjectInfoService.class);
                rdmPlanInfoService = (RdmPlanInfoService)SpringContextUtils.getBean(RdmPlanInfoService.class);
                RdmWeeklyCalendarService rdmWeeklyCalendarService = (RdmWeeklyCalendarService)SpringContextUtils.getBean(RdmWeeklyCalendarService.class);
                projectInfo = new RdmProjectInfoDTO();
                projectInfo.setProjectId(projectId);
                projectInfo = (RdmProjectInfoDTO)rdmProjectInfoService.queryByPk((Object)projectInfo);
                viewName = "";
                if (StringUtils.isNotBlank((CharSequence)state)) {
                    viewName = "-" + RdmProgress.nameByCode((String)state);
                } else {
                    if (StringUtils.equals((CharSequence)dateType, (CharSequence)"month")) {
                        try {
                            Date monthObj = DateUtils.parseDate((String)month, (String)"yyyy-MM");
                            viewName = DateFormatUtils.format((Date)monthObj, (String)"-yyyy\u5e74MM\u6708");
                        }
                        catch (ParseException e) {
                            String[] months = StringUtils.split((String)month, (String)"-");
                            if (months.length > 2) {
                                viewName = String.format("-%s\u5e74%s\u6708", months[0], months[1]);
                            }
                            break block47;
                        }
                    }
                    if (StringUtils.equals((CharSequence)dateType, (CharSequence)"week")) {
                        RdmWeeklyCalendarDTO weeklyInfo = new RdmWeeklyCalendarDTO();
                        weeklyInfo.setWeekId(Integer.valueOf(NumberUtils.toInt((String)weekId)));
                        weeklyInfo = (RdmWeeklyCalendarDTO)rdmWeeklyCalendarService.queryByPk((Object)weeklyInfo);
                        viewName = String.format("-%s\u5e74\u7b2c%s\u5468", weeklyInfo.getYear(), weeklyInfo.getWeekNumber());
                    } else if (StringUtils.equals((CharSequence)dateType, (CharSequence)"day")) {
                        try {
                            Date dayObj = DateUtils.parseDate((String)startDate, (String)"yyyy-MM-dd");
                            viewName = DateFormatUtils.format((Date)dayObj, (String)"-yyyy\u5e74MM\u6708dd\u65e5");
                        }
                        catch (ParseException e) {
                            String[] days = StringUtils.split((String)startDate, (String)"-");
                            if (days.length <= 2) break block47;
                            viewName = String.format("-%s\u5e74%s\u6708%s", days[0], days[1], days[2]);
                        }
                    }
                }
            }
            if (StringUtils.isNotBlank((CharSequence)teamName)) {
                viewName = StringUtils.isNotBlank((CharSequence)viewName) ? "-" + teamName + "-" + viewName : "-" + teamName;
            }
            if (StringUtils.isNotBlank((CharSequence)viewNameFromParam)) {
                viewName = "-" + viewNameFromParam + (StringUtils.isNotBlank((CharSequence)viewName) ? "" : "-") + viewName;
            }
            String userId = template.getLoginUserId();
            String today = CurrentDateUtil.getTodayDate();
            String todayTime = CurrentDateUtil.getTodayDateEx2();
            String time = CurrentDateUtil.getCurrentTime();
            Map rootMap = BeanUtility.bean2Map((Object)projectInfo);
            rootMap.put("today", today);
            rootMap.put("todayTime", todayTime);
            rootMap.put("time", time);
            rootMap.put("viewName", viewName);
            String fileName = template.getDocName();
            if (StringUtils.isNotBlank((CharSequence)template.getDocNameTemplate())) {
                fileName = this.renderDocName(template.getDocNameTemplate(), rootMap);
            }
            DocTemplateRepoPullQueueExecutor.syncRun();
            String excelTemplatePath = DocTemplateRepoPullQueueExecutor.getDocTemplatePath();
            File templateFile = new File(excelTemplatePath, template.getDocFile());
            File targetFile = new File(currentFile, fileName);
            String newTmpTemplateID = UUIDUtil.getShortUUID() + ".xlsx";
            String excelTempFile = currentFile.getAbsolutePath() + File.separator + newTmpTemplateID;
            List planList = new ArrayList();
            if (StringUtils.equals((CharSequence)splitPlan, (CharSequence)YesOrNO.YES.getCode())) {
                planIdList = null;
                if (StringUtils.isBlank((CharSequence)planId)) {
                    RdmTaskInfoDTO taskParam = new RdmTaskInfoDTO();
                    taskParam.setProjectId(projectId);
                    if (StringUtils.isNotBlank((CharSequence)planId)) {
                        taskParam.setPlanIdList(Arrays.asList(StringUtils.split((String)planId, (String)",")));
                    }
                    taskParam.setTeamId(teamId);
                    taskParam.setState(state);
                    taskParam.setGroupBy("planId");
                    taskParam.setSize(Integer.valueOf(Integer.MAX_VALUE));
                    taskParam.setFilterCond(filterCond);
                    List taskObjectiveList = this.rdmTaskInfoService.queryListByPage((Object)taskParam);
                    if (CollectionUtils.isNotEmpty((Collection)taskObjectiveList)) {
                        planIdList = taskObjectiveList.stream().map(RdmTaskInfoDTO::getPlanId).collect(Collectors.toList());
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)planId)) {
                    planIdList = Arrays.asList(StringUtils.split((String)planId, (String)","));
                }
                if (CollectionUtils.isNotEmpty(planIdList)) {
                    RdmPlanInfoDTO planParam = new RdmPlanInfoDTO();
                    FilterItem filterItem = new FilterItem();
                    filterItem.setKey("planId");
                    filterItem.setValues(planIdList);
                    filterItem.setOp(FilterItem.FilterOpEnum.In.getCode());
                    filterItem.setLogicOp("and");
                    List<FilterItem> filterItems = Arrays.asList(filterItem);
                    planParam.setFilterCond(JSON.toJSONString(filterItems));
                    planList = rdmPlanInfoService.queryList((Object)planParam);
                }
            }
            if (CollectionUtils.isNotEmpty(planList)) {
                planIdList = planList.stream().map(RdmPlanInfoDTO::getPlanId).collect(Collectors.toList());
                extParams.put("planIdList", planIdList);
                ExcelWriterBuilder writerBuilder2 = EasyExcel.write((String)excelTempFile);
                ExcelWriter excelWriter2 = writerBuilder2.withTemplate(templateFile).build();
                Workbook workbook = excelWriter2.writeContext().writeWorkbookHolder().getCachedWorkbook();
                int sheetCount = planList.size();
                for (int i = 0; i < sheetCount; ++i) {
                    if (i > 0) {
                        Sheet sheet = excelWriter2.writeContext().writeWorkbookHolder().getCachedWorkbook().cloneSheet(i - 1);
                    }
                    RdmPlanInfoDTO currentInfo = (RdmPlanInfoDTO)planList.get(i);
                    try {
                        workbook.setSheetName(i, currentInfo.getPlanName());
                        continue;
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
                if (StringUtils.equals((CharSequence)groupByTeam, (CharSequence)YesOrNO.YES.getCode())) {
                    excelWriter2.writeContext().writeWorkbookHolder().getCachedWorkbook().createSheet("\u56e2\u961f\u5de5\u65f6\u504f\u5dee");
                }
                if (StringUtils.equals((CharSequence)groupByPlan, (CharSequence)YesOrNO.YES.getCode())) {
                    excelWriter2.writeContext().writeWorkbookHolder().getCachedWorkbook().createSheet("\u8ba1\u5212\u8fdb\u5ea6\u7edf\u8ba1");
                }
                excelWriter2.finish();
            } else {
                writerBuilder = EasyExcel.write((String)excelTempFile);
                excelWriter = writerBuilder.withTemplate(templateFile).build();
                Workbook workbook = excelWriter.writeContext().writeWorkbookHolder().getCachedWorkbook();
                if (StringUtils.equals((CharSequence)groupByTeam, (CharSequence)YesOrNO.YES.getCode())) {
                    excelWriter.writeContext().writeWorkbookHolder().getCachedWorkbook().createSheet("\u56e2\u961f\u5de5\u65f6\u504f\u5dee");
                }
                if (StringUtils.equals((CharSequence)groupByPlan, (CharSequence)YesOrNO.YES.getCode())) {
                    excelWriter.writeContext().writeWorkbookHolder().getCachedWorkbook().createSheet("\u8ba1\u5212\u8fdb\u5ea6\u7edf\u8ba1");
                }
                excelWriter.finish();
            }
            writerBuilder = EasyExcel.write((File)targetFile);
            excelWriter = writerBuilder.withTemplate(excelTempFile).build();
            if (CollectionUtils.isNotEmpty(planList)) {
                for (int i = 0; i < planList.size(); ++i) {
                    RdmPlanInfoDTO plan = (RdmPlanInfoDTO)planList.get(i);
                    WriteSheet sheet = EasyExcel.writerSheet((Integer)i, (String)plan.getPlanName()).build();
                    RdmTaskInfoDTO taskParam = new RdmTaskInfoDTO();
                    taskParam.setProjectId(projectId);
                    taskParam.setPlanId(plan.getPlanId());
                    taskParam.setState(state);
                    taskParam.setFilterCond(filterCond);
                    taskParam.setTeamId(teamId);
                    this.fillRdmTaskList(excelWriter, sheet, taskParam);
                }
                if (StringUtils.equals((CharSequence)putGroupOnFront, (CharSequence)YesOrNO.YES.getCode())) {
                    if (StringUtils.equals((CharSequence)groupByPlan, (CharSequence)YesOrNO.YES.getCode())) {
                        excelWriter.writeContext().writeWorkbookHolder().getCachedWorkbook().setSheetOrder("\u8ba1\u5212\u8fdb\u5ea6\u7edf\u8ba1", 0);
                    }
                    excelWriter.writeContext().writeWorkbookHolder().getCachedWorkbook().setActiveSheet(0);
                }
                if (StringUtils.equals((CharSequence)groupByPlan, (CharSequence)YesOrNO.YES.getCode())) {
                    this.writeGroupByPlan(excelWriter, extParams);
                }
                if (StringUtils.equals((CharSequence)groupByTeam, (CharSequence)YesOrNO.YES.getCode())) {
                    this.writeGroupByUser(excelWriter, extParams);
                }
                excelWriter.finish();
            } else {
                WriteSheet sheet = EasyExcel.writerSheet((Integer)0, null).build();
                RdmTaskInfoDTO taskParam = new RdmTaskInfoDTO();
                taskParam.setProjectId(projectId);
                if (StringUtils.isNotBlank((CharSequence)planId)) {
                    taskParam.setPlanIdList(Arrays.asList(StringUtils.split((String)planId, (String)",")));
                }
                taskParam.setState(state);
                taskParam.setFilterCond(filterCond);
                taskParam.setLoginUserId(teamId);
                this.fillRdmTaskList(excelWriter, sheet, taskParam);
                if (StringUtils.equals((CharSequence)putGroupOnFront, (CharSequence)YesOrNO.YES.getCode())) {
                    if (StringUtils.equals((CharSequence)groupByPlan, (CharSequence)YesOrNO.YES.getCode())) {
                        excelWriter.writeContext().writeWorkbookHolder().getCachedWorkbook().setSheetOrder("\u8ba1\u5212\u8fdb\u5ea6\u7edf\u8ba1", 0);
                    }
                    excelWriter.writeContext().writeWorkbookHolder().getCachedWorkbook().setActiveSheet(0);
                }
                if (StringUtils.equals((CharSequence)groupByPlan, (CharSequence)YesOrNO.YES.getCode())) {
                    this.writeGroupByPlan(excelWriter, extParams);
                }
                if (StringUtils.equals((CharSequence)groupByTeam, (CharSequence)YesOrNO.YES.getCode())) {
                    this.writeGroupByUser(excelWriter, extParams);
                }
                excelWriter.finish();
            }
            FileUtils.deleteQuietly((File)new File(excelTempFile));
            File file = targetFile;
            connTool.releaseConnection(conn);
            return file;
        }
        catch (Exception e) {
            try {
                logger.error("\u9879\u76ee\u8ba1\u5212\u5bfc\u51fa\u5f02\u5e38 " + e.getMessage(), (Throwable)e);
                throw new RuntimeException("\u9879\u76ee\u8ba1\u5212\u5bfc\u51fa\u5f02\u5e38 " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                connTool.releaseConnection(conn);
                throw throwable;
            }
        }
    }

    private void writeGroupByUser(ExcelWriter excelWriter, Map<String, Object> extParams) {
        ArrayList<List<String>> head = new ArrayList<List<String>>();
        head.add(Arrays.asList("\u9879\u76ee\u6210\u5458"));
        head.add(Arrays.asList("\u52a0\u5165\u65e5\u671f"));
        head.add(Arrays.asList("\u5de5\u4f5c\u65e5\u5de5\u65f6"));
        head.add(Arrays.asList("\u4efb\u52a1\u8bc4\u4f30\u5de5\u65f6"));
        head.add(Arrays.asList("\u4efb\u52a1\u6267\u884c\u5de5\u65f6"));
        head.add(Arrays.asList("\u9884\u4f30\u504f\u5dee\u7387"));
        head.add(Arrays.asList("\u5de5\u4f5c\u9971\u548c\u7387"));
        ArrayList<List<Object>> data = new ArrayList<List<Object>>();
        String projectId = MapUtils.getString(extParams, (Object)"projectId");
        String teamId = MapUtils.getString(extParams, (Object)"teamId");
        String filterCond = MapUtils.getString(extParams, (Object)"filterCond");
        String dateType = MapUtils.getString(extParams, (Object)"dateType");
        RdmTaskInfoDTO param = new RdmTaskInfoDTO();
        param.setProjectId(projectId);
        param.setTeamId(teamId);
        try {
            List filterCondList = JSON.parseArray((String)filterCond, Map.class);
            if (CollectionUtils.isNotEmpty((Collection)filterCondList)) {
                for (Map item : filterCondList) {
                    String name = MapUtils.getString((Map)item, (Object)"name");
                    if (!StringUtils.equalsAny((CharSequence)name, (CharSequence[])new CharSequence[]{"\u6240\u5c5e\u65e5\u62a5", "\u6240\u5c5e\u5468\u62a5", "\u6240\u5c5e\u6708\u62a5"})) continue;
                    List values = (List)MapUtils.getObject((Map)item, (Object)"values");
                    String startDate = values.get(0).toString();
                    param.setStartDate(startDate);
                    if (values.size() <= 1) continue;
                    String endDate = values.get(1).toString();
                    param.setEndDate(endDate);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790\u8fc7\u6ee4\u6761\u4ef6\u5f02\u5e38 {}", (Object)e.getMessage(), (Object)e);
        }
        param.setSize(Integer.valueOf(Integer.MAX_VALUE));
        List result = this.rdmTaskInfoService.queryRdmTaskWorkloadUserByPage(param);
        if (CollectionUtils.isNotEmpty((Collection)result)) {
            for (Map item : result) {
                data.add(Arrays.asList(item.get("incharge_name"), item.get("join_date"), item.get("join_workload"), item.get("est_workload"), item.get("real_workload"), this.formatterRate(item.get("exec_rate")), this.formatterRate(item.get("satura_rate"))));
            }
        }
        WriteSheet sheet = ((ExcelWriterSheetBuilder)((ExcelWriterSheetBuilder)((ExcelWriterSheetBuilder)EasyExcel.writerSheet((String)"\u56e2\u961f\u5de5\u65f6\u504f\u5dee").head(head)).registerWriteHandler(this.createWriteHandler())).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).build();
        excelWriter.write(data, sheet);
    }

    private String formatterRate(Object rate) {
        if (rate == null) {
            return "\u6682\u65e0";
        }
        String val = rate.toString();
        BigDecimal rateBig = new BigDecimal(val);
        rateBig = rateBig.multiply(new BigDecimal(100));
        rateBig = rateBig.setScale(2, RoundingMode.HALF_UP);
        return rateBig.toString() + "%";
    }

    private void writeGroupByPlan(ExcelWriter excelWriter, Map<String, Object> extParams) {
        ArrayList<List<String>> head = new ArrayList<List<String>>();
        head.add(Arrays.asList("\u8ba1\u5212\u7f16\u53f7"));
        head.add(Arrays.asList("\u8ba1\u5212\u540d\u79f0"));
        head.add(Arrays.asList("\u8d1f\u8d23\u4eba"));
        head.add(Arrays.asList("\u8ba1\u5212\u5f00\u59cb"));
        head.add(Arrays.asList("\u8ba1\u5212\u5b8c\u6210"));
        head.add(Arrays.asList("\u8ba1\u5212\u72b6\u6001"));
        head.add(Arrays.asList("\u8ba1\u5212\u5de5\u65f6"));
        head.add(Arrays.asList("\u6267\u884c\u5de5\u65f6"));
        head.add(Arrays.asList("\u4efb\u52a1\u6570"));
        head.add(Arrays.asList("\u5de5\u65f6\u6267\u884c\u6bd4"));
        head.add(Arrays.asList("\u4efb\u52a1\u6267\u884c\u6bd4"));
        ArrayList<List<Object>> data = new ArrayList<List<Object>>();
        RdmPlanInfoService rdmPlanInfoService = (RdmPlanInfoService)SpringContextUtils.getBean(RdmPlanInfoService.class);
        RdmPlanInfoDTO param = new RdmPlanInfoDTO();
        String projectId = MapUtils.getString(extParams, (Object)"projectId");
        String filterCond = MapUtils.getString(extParams, (Object)"filterCond");
        String dateType = MapUtils.getString(extParams, (Object)"dateType");
        List planIdList = (List)MapUtils.getObject(extParams, (Object)"planIdList");
        String viewName = MapUtils.getString(extParams, (Object)"viewName");
        if (CollectionUtils.isNotEmpty((Collection)planIdList)) {
            FilterItem planIdFilter = new FilterItem();
            planIdFilter.setOp(FilterItem.FilterOpEnum.In.getCode());
            planIdFilter.setKey("planId");
            planIdFilter.setValues(planIdList);
            param.setFilterCond(JSON.toJSONString(Arrays.asList(planIdFilter)));
        }
        param.setProjectId(projectId);
        try {
            List filterCondList = JSON.parseArray((String)filterCond, Map.class);
            if (CollectionUtils.isNotEmpty((Collection)filterCondList)) {
                for (Map item : filterCondList) {
                    String name = MapUtils.getString((Map)item, (Object)"name");
                    if (!StringUtils.equalsAny((CharSequence)name, (CharSequence[])new CharSequence[]{"\u6240\u5c5e\u65e5\u62a5", "\u6240\u5c5e\u5468\u62a5", "\u6240\u5c5e\u6708\u62a5"}) || StringUtils.equals((CharSequence)viewName, (CharSequence)"\u6309\u8ba1\u5212\u5bfc\u51fa")) continue;
                    List values = (List)MapUtils.getObject((Map)item, (Object)"values");
                    String startDate = values.get(0).toString();
                    param.setStartDate(startDate);
                    if (values.size() <= 1) continue;
                    String endDate = values.get(1).toString();
                    param.setEndDate(endDate);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790\u8fc7\u6ee4\u6761\u4ef6\u5f02\u5e38 {}", (Object)e.getMessage(), (Object)e);
        }
        param.setSize(Integer.valueOf(Integer.MAX_VALUE));
        List result = rdmPlanInfoService.queryRdmPlanWorkloadUserByPage(param);
        if (CollectionUtils.isNotEmpty((Collection)result)) {
            for (Map item : result) {
                data.add(Arrays.asList(item.get("plan_id"), item.get("plan_name"), item.get("plan_incharge_name"), item.get("plan_begin_date"), item.get("plan_end_date"), ProjectState.nameByCode(item.get("plan_state") == null ? null : item.get("plan_state").toString()), item.get("est_workload"), item.get("real_workload"), item.get("task_num"), this.formatterRate(item.get("workload_rate")), this.formatterRate(item.get("task_rate"))));
            }
        }
        WriteSheet sheet = ((ExcelWriterSheetBuilder)((ExcelWriterSheetBuilder)((ExcelWriterSheetBuilder)EasyExcel.writerSheet((String)"\u8ba1\u5212\u8fdb\u5ea6\u7edf\u8ba1").head(head)).registerWriteHandler(this.createWriteHandler())).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).build();
        excelWriter.write(data, sheet);
    }

    private WriteHandler createWriteHandler() {
        WriteCellStyle headWriteCellStyle = new WriteCellStyle();
        headWriteCellStyle.setFillForegroundColor(Short.valueOf(IndexedColors.WHITE.getIndex()));
        WriteFont headWriteFont = new WriteFont();
        headWriteFont.setFontName("\u5b8b\u4f53");
        headWriteFont.setFontHeightInPoints(Short.valueOf((short)9));
        headWriteCellStyle.setWriteFont(headWriteFont);
        WriteCellStyle contentWriteCellStyle = new WriteCellStyle();
        contentWriteCellStyle.setFillPatternType(FillPatternType.SOLID_FOREGROUND);
        contentWriteCellStyle.setFillForegroundColor(Short.valueOf(IndexedColors.WHITE.getIndex()));
        WriteFont contentWriteFont = new WriteFont();
        contentWriteFont.setFontName("DejaVu Sans");
        contentWriteFont.setFontHeightInPoints(Short.valueOf((short)9));
        contentWriteCellStyle.setWriteFont(contentWriteFont);
        contentWriteCellStyle.setBorderBottom(BorderStyle.THIN);
        contentWriteCellStyle.setBorderTop(BorderStyle.THIN);
        contentWriteCellStyle.setBorderLeft(BorderStyle.THIN);
        contentWriteCellStyle.setBorderRight(BorderStyle.THIN);
        HorizontalCellStyleStrategy horizontalCellStyleStrategy = new HorizontalCellStyleStrategy(headWriteCellStyle, contentWriteCellStyle);
        return horizontalCellStyleStrategy;
    }

    private void writeGroupByObjUser(ExcelWriter excelWriter, Map<String, Object> extParams) {
        ArrayList<List<String>> head = new ArrayList<List<String>>();
        head.add(Arrays.asList("\u8d1f\u8d23\u4eba"));
        head.add(Arrays.asList("\u603b\u6570"));
        head.add(Arrays.asList("\u5f85\u5f00\u59cb"));
        head.add(Arrays.asList("\u8fdb\u884c\u4e2d"));
        head.add(Arrays.asList("\u903e\u671f\u4e2d"));
        head.add(Arrays.asList("\u5df2\u6302\u8d77"));
        head.add(Arrays.asList("\u6b63\u5e38\u5b8c\u6210"));
        head.add(Arrays.asList("\u903e\u671f\u5b8c\u6210"));
        ArrayList<List<Object>> data = new ArrayList<List<Object>>();
        RdmPlanInfoService rdmPlanInfoService = (RdmPlanInfoService)SpringContextUtils.getBean(RdmPlanInfoService.class);
        RdmPlanInfoDTO param = new RdmPlanInfoDTO();
        String projectId = MapUtils.getString(extParams, (Object)"projectId");
        String filterCond = MapUtils.getString(extParams, (Object)"filterCond");
        String dateType = MapUtils.getString(extParams, (Object)"dateType");
        String viewName = MapUtils.getString(extParams, (Object)"viewName");
        param.setProjectId(projectId);
        try {
            List filterCondList = JSON.parseArray((String)filterCond, Map.class);
            if (CollectionUtils.isNotEmpty((Collection)filterCondList)) {
                for (Map item : filterCondList) {
                    String name = MapUtils.getString((Map)item, (Object)"name");
                    if (!StringUtils.equalsAny((CharSequence)name, (CharSequence[])new CharSequence[]{"\u6240\u5c5e\u65e5\u62a5", "\u6240\u5c5e\u5468\u62a5", "\u6240\u5c5e\u6708\u62a5"}) || StringUtils.equals((CharSequence)viewName, (CharSequence)"\u6309\u8ba1\u5212\u5bfc\u51fa")) continue;
                    List values = (List)MapUtils.getObject((Map)item, (Object)"values");
                    String startDate = values.get(0).toString();
                    param.setStartDate(startDate);
                    if (values.size() <= 1) continue;
                    String endDate = values.get(1).toString();
                    param.setEndDate(endDate);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790\u8fc7\u6ee4\u6761\u4ef6\u5f02\u5e38 {}", (Object)e.getMessage(), (Object)e);
        }
        param.setSize(Integer.valueOf(Integer.MAX_VALUE));
        List result = rdmPlanInfoService.queryPlanInchargeGroupByPage(param);
        if (CollectionUtils.isNotEmpty((Collection)result)) {
            for (Map item : result) {
                data.add(Arrays.asList(item.get("planInchargeName"), item.get("totality"), item.get("s10"), item.get("s11"), item.get("s12"), item.get("s13"), item.get("s14"), item.get("s15")));
            }
        }
        WriteSheet sheet = ((ExcelWriterSheetBuilder)((ExcelWriterSheetBuilder)((ExcelWriterSheetBuilder)EasyExcel.writerSheet((String)"\u8ba1\u5212\u4eba\u5458\u5206\u5e03").head(head)).registerWriteHandler(this.createWriteHandler())).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).build();
        excelWriter.write(data, sheet);
    }
}

