/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.ftp;

import com.irdstudio.allinapaas.executor.application.executor.core.plugin.ftp.PluginFtpConf;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class PluginFtpConfDao {
    Connection conn = null;

    public PluginFtpConfDao(Connection conn) {
        this.conn = conn;
    }

    public PluginFtpConf queryWithKeys(String pluginConfId, String confSort) throws SQLException {
        PluginFtpConf fc = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("SELECT * FROM plugin_load_conf WHERE plugin_conf_id=? and conf_sort=?");
            ps.setString(1, pluginConfId);
            ps.setString(2, confSort);
            rs = ps.executeQuery();
            if (rs.next()) {
                fc = new PluginFtpConf();
                fc.setPluginConfId(rs.getString("plugin_conf_id"));
                fc.setConfSort(rs.getInt("conf_sort"));
                fc.setSftpServerIp(rs.getString("sftp_server_ip"));
                fc.setFtpServerPort(rs.getInt("ftp_server_port"));
                fc.setFtpServerUser(rs.getString("ftp_server_user"));
                fc.setFtpServerPwd(rs.getString("ftp_server_pwd"));
                fc.setLoadType(rs.getString("load_type"));
                fc.setRemoteFileName(rs.getString("remote_file_name"));
                fc.setLocalFileName(rs.getString("local_file_name"));
                fc.setFtpFilePath(rs.getString("ftp_file_path"));
                fc.setLocalFilePath(rs.getString("local_file_path"));
                fc.setCheckExist(rs.getString("check_exist"));
                fc.setServerType(rs.getString("server_type"));
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("queryPluginFtpConfWithKeys is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return fc;
    }

    public List<PluginFtpConf> queryWithCond(String szCondition, String szOrderBy) throws SQLException {
        ArrayList<PluginFtpConf> fcList = new ArrayList<PluginFtpConf>();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("SELECT * FROM plugin_ftp_conf " + szCondition + " " + szOrderBy);
            rs = ps.executeQuery();
            while (rs.next()) {
                PluginFtpConf fc = new PluginFtpConf();
                fc.setPluginConfId(rs.getString("plugin_conf_id"));
                fc.setConfSort(rs.getInt("conf_sort"));
                fc.setSftpServerIp(rs.getString("sftp_server_ip"));
                fc.setFtpServerPort(rs.getInt("ftp_server_port"));
                fc.setFtpServerUser(rs.getString("ftp_server_user"));
                fc.setFtpServerPwd(rs.getString("ftp_server_pwd"));
                fc.setLoadType(rs.getString("load_type"));
                fc.setRemoteFileName(rs.getString("remote_file_name"));
                fc.setLocalFileName(rs.getString("local_file_name"));
                fc.setFtpFilePath(rs.getString("ftp_file_path"));
                fc.setLocalFilePath(rs.getString("local_file_path"));
                fc.setCheckExist(rs.getString("check_exist"));
                fc.setServerType(rs.getString("server_type"));
                fcList.add(fc);
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("queryPluginFtpConfWithCond is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return fcList;
    }

    protected void close(ResultSet theRs, Statement theStmt, PreparedStatement thePs) {
        try {
            if (theRs != null) {
                theRs.close();
            }
            if (theStmt != null) {
                theStmt.close();
            }
            if (thePs != null) {
                thePs.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

