/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.market;

import com.alibaba.fastjson.JSON;
import com.irdstudio.allinapaas.design.console.types.MarketSource;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.DictItemInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.DictOptionEnumDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.DictOptionInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.ModelFolderInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.ModelTableFieldDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.ModelTableIndexDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.ModelTableInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEnvParamDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasMarketAppinfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.SrvFieldFlagDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.DictItemInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.DictOptionEnum;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.DictOptionInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.ModelFolderInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.ModelTableField;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.ModelTableIndex;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.ModelTableInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasMarketAppinfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SrvFieldFlag;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.market.AbstractMarketTask;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class CPNSqliteCPModelTask
extends AbstractMarketTask {
    private PaasMarketAppinfo appInfo = null;
    private Map<String, Object> extParam = null;

    @Override
    public boolean initTask(Map<String, Object> extParam, Connection conn) throws SQLException {
        this.extParam = extParam;
        PaasMarketAppinfoDao paasAppsInfoDao = new PaasMarketAppinfoDao(conn);
        this.appInfo = paasAppsInfoDao.queryPaasMarketAppinfo(MapUtils.getString(extParam, (Object)"marketAppId"));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        boolean flag = true;
        Connection conn = null;
        Connection sqliteConn = null;
        try {
            conn = this.getConnection();
            PaasEnvParamDao paasEnvParamDao = new PaasEnvParamDao(conn);
            String marketSource = MapUtils.getString(this.extParam, (Object)"marketSource");
            ArrayList<PaasMarketAppinfo> appInfoList = new ArrayList<PaasMarketAppinfo>();
            if (StringUtils.equals((CharSequence)marketSource, (CharSequence)MarketSource.Inside.getCode())) {
                appInfoList.add(this.appInfo);
            } else {
                String apiUrl = paasEnvParamDao.queryByCodeReturnValue("allinpaas.open.api.http.url");
                PaasMarketAppinfo param = new PaasMarketAppinfo();
                param.setMarketAppId(MapUtils.getString(this.extParam, (Object)"marketAppId"));
                String respJson = this.requestOpenApi(apiUrl + "/om/paas/market/appinfo", (Object)param);
                if (StringUtils.isBlank((CharSequence)respJson)) {
                    boolean bl = flag = false;
                    return bl;
                }
                PaasMarketAppinfo marketApp = (PaasMarketAppinfo)((Object)JSON.parseObject((String)respJson, PaasMarketAppinfo.class));
                appInfoList.add(marketApp);
            }
            PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
            ModelTableInfoDao modelTableInfoDao = new ModelTableInfoDao(conn);
            ModelTableIndexDao modelTableIndexDao = new ModelTableIndexDao(conn);
            ModelTableFieldDao modelTableFieldDao = new ModelTableFieldDao(conn);
            ModelFolderInfoDao projectTmPackageDao = new ModelFolderInfoDao(conn);
            DictOptionEnumDao descDB_dictOptionEnumDao = new DictOptionEnumDao(conn);
            DictOptionInfoDao descDB_dictOptionInfoDao = new DictOptionInfoDao(conn);
            for (PaasMarketAppinfo srcApp : appInfoList) {
                File sqliteFile = this.getSqliteFile(srcApp);
                sqliteConn = this.getSqliteConnection(sqliteFile);
                PaasMarketAppinfoDao keyMapDao = new PaasMarketAppinfoDao(sqliteConn);
                String appId = keyMapDao.queryKeyMap(srcApp.getAppId());
                if (srcApp == null) continue;
                ModelFolderInfoDao sqlite_projectTmPackageDao = new ModelFolderInfoDao(sqliteConn);
                ModelFolderInfo packageParam = new ModelFolderInfo();
                packageParam.setAppId(appId);
                List<ModelFolderInfo> packageList = sqlite_projectTmPackageDao.queryModelFolderInfo(packageParam);
                this.batchInsert("`allinrdm_db`.model_folder_info", packageList, conn);
                ModelTableInfoDao sqlite_modelTableInfoDao = new ModelTableInfoDao(sqliteConn);
                List<ModelTableInfo> tables = sqlite_modelTableInfoDao.queryModelTableInfoList(appId);
                this.batchInsertPage("`allinrdm_db`.model_table_info", tables, conn);
                ModelTableIndexDao sqlite_modelTableIndexDao = new ModelTableIndexDao(sqliteConn);
                List<ModelTableIndex> indexs = sqlite_modelTableIndexDao.queryModelTableInfos(appId);
                this.batchInsertPage("`allinrdm_db`.model_table_index", indexs, conn);
                ModelTableFieldDao sqlite_modelTableFieldDao = new ModelTableFieldDao(sqliteConn);
                List<ModelTableField> fields = sqlite_modelTableFieldDao.queryFieldByAppId(appId);
                this.batchInsertPage("`allinrdm_db`.model_table_field", fields, conn);
                SrvFieldFlagDao srvFieldFlagDao = new SrvFieldFlagDao(sqliteConn);
                List<SrvFieldFlag> fieldFlags = srvFieldFlagDao.queryFieldFlagByAppId(appId);
                this.batchInsertPage("`allinrdm_db`.srv_field_flag", fieldFlags, conn);
                DictItemInfoDao dictItemInfoDao = new DictItemInfoDao(sqliteConn);
                DictItemInfoDao destDBDictItemInfoDao = new DictItemInfoDao(conn);
                List<DictItemInfo> items = dictItemInfoDao.queryDictItemInfoList(appId);
                if (CollectionUtils.isNotEmpty(items)) {
                    ArrayList<DictItemInfo> needItems = new ArrayList<DictItemInfo>(items.size());
                    for (DictItemInfo item : items) {
                        if (destDBDictItemInfoDao.queryByPk(item.getItemId()) != null) continue;
                        needItems.add(item);
                    }
                    this.batchInsertPage("`allinrdm_db`.dict_item_info", needItems, conn);
                }
                DictOptionInfoDao dictOptionInfoDao = new DictOptionInfoDao(sqliteConn);
                DictOptionEnumDao dictOptionEnumDao = new DictOptionEnumDao(sqliteConn);
                HashMap<String, DictOptionInfo> optionInfoMap = new HashMap<String, DictOptionInfo>();
                ArrayList<DictOptionInfo> optionInfoList = new ArrayList<DictOptionInfo>();
                ArrayList<DictOptionEnum> optionEnumList = new ArrayList<DictOptionEnum>();
                List<ModelTableField> optionsList = modelTableFieldDao.queryModelTableFieldAllOptions(appId);
                if (CollectionUtils.isNotEmpty(optionsList)) {
                    ArrayList codeBoList = new ArrayList(optionsList.size());
                    for (ModelTableField option : optionsList) {
                        if (StringUtils.isBlank((CharSequence)option.getDictId()) || optionInfoMap.get(option.getDictId()) != null) continue;
                        List<DictOptionEnum> dicts = dictOptionEnumDao.queryDictOptionEnumListByDictId(option.getDictId());
                        DictOptionInfo optionInfo = dictOptionInfoDao.queryByPk(option.getDictId());
                        if (descDB_dictOptionInfoDao.queryByPk(optionInfo.getDictId()) != null) continue;
                        optionInfoMap.put(optionInfo.getDictId(), optionInfo);
                        optionInfoList.add(optionInfo);
                        optionEnumList.addAll(dicts);
                    }
                }
                this.batchInsertPage("`allinrdm_db`.dict_option_info", optionInfoList, conn);
                this.batchInsertPage("`allinrdm_db`.dict_option_enum", optionEnumList, conn);
            }
        }
        catch (Exception e) {
            this.logger.error("\u4ecesqlite\u590d\u5236\u7ec4\u4ef6\u6a21\u578b\u5230\u5e73\u53f0\u5931\u8d25", (Throwable)e);
            flag = false;
        }
        finally {
            if (conn != null) {
                this.closeConnection(conn);
            }
            if (sqliteConn != null) {
                this.closeSqliteConnection(sqliteConn);
            }
        }
        return flag;
    }
}

