/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.market;

import com.alibaba.fastjson.JSON;
import com.irdstudio.allinapaas.design.console.types.MarketSource;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.OsrvArrangeTableDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.OsrvArrangeVarDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.OsrvEvalIsrvDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.OsrvEvalVarDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsParamDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsPropertiesDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsSqlDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEnvParamDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasMarketAppinfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.SrvEvalFuncDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.SrvModelFeatureDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.SrvModelInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.SrvModelInoutDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.SrvModelPackageDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsParam;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsProperties;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsSql;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasMarketAppinfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SrvModelInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SrvModelInout;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SrvModelPackage;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.common.SSubsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.common.SSubsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.market.AbstractMarketTask;
import com.irdstudio.allinapaas.executor.application.executor.core.util.date.CurrentDateUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.util.db.ProxySQL;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class CPNSqliteCPOsrvTask
extends AbstractMarketTask {
    private PaasMarketAppinfo appInfo = null;
    private Map<String, Object> extParam = null;

    @Override
    public boolean initTask(Map<String, Object> extParam, Connection conn) throws SQLException {
        this.extParam = extParam;
        PaasMarketAppinfoDao paasAppsInfoDao = new PaasMarketAppinfoDao(conn);
        this.appInfo = paasAppsInfoDao.queryPaasMarketAppinfo(MapUtils.getString(extParam, (Object)"marketAppId"));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        boolean flag = true;
        Connection conn = null;
        Connection sqliteConn = null;
        try {
            conn = this.getConnection();
            PaasEnvParamDao paasEnvParamDao = new PaasEnvParamDao(conn);
            String marketSource = MapUtils.getString(this.extParam, (Object)"marketSource");
            String destSysId = MapUtils.getString(this.extParam, (Object)"paasSubsId");
            String destSysCode = MapUtils.getString(this.extParam, (Object)"paasSubsCode");
            ArrayList<PaasMarketAppinfo> appInfoList = new ArrayList<PaasMarketAppinfo>();
            if (StringUtils.equals((CharSequence)marketSource, (CharSequence)MarketSource.Inside.getCode())) {
                appInfoList.add(this.appInfo);
            } else {
                String apiUrl = paasEnvParamDao.queryByCodeReturnValue("allinpaas.open.api.http.url");
                PaasMarketAppinfo param = new PaasMarketAppinfo();
                param.setMarketAppId(MapUtils.getString(this.extParam, (Object)"marketAppId"));
                String respJson = this.requestOpenApi(apiUrl + "/om/paas/market/appinfo", (Object)param);
                if (StringUtils.isBlank((CharSequence)respJson)) {
                    boolean bl = flag = false;
                    return bl;
                }
                PaasMarketAppinfo marketApp = (PaasMarketAppinfo)((Object)JSON.parseObject((String)respJson, PaasMarketAppinfo.class));
                appInfoList.add(marketApp);
            }
            PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
            SrvModelInfoDao real_srvModelInfoDao = new SrvModelInfoDao(conn);
            SrvModelPackageDao real_srvModelPackageDao = new SrvModelPackageDao(conn);
            SSubsInfoDao sSubsInfoDao = new SSubsInfoDao(conn);
            String createTime = CurrentDateUtil.getTodayDateEx2();
            for (PaasMarketAppinfo srcApp : appInfoList) {
                File sqliteFile = this.getSqliteFile(srcApp);
                sqliteConn = this.getSqliteConnection(sqliteFile);
                PaasAppsInfoDao sqlitePaasAppsInfoDao = new PaasAppsInfoDao(sqliteConn);
                PaasMarketAppinfoDao keyMapDao = new PaasMarketAppinfoDao(sqliteConn);
                String appId = keyMapDao.queryKeyMap(srcApp.getAppId());
                String newAppId = keyMapDao.queryKeyMap(srcApp.getAppId());
                PaasAppsInfo sqliteSrcApp = sqlitePaasAppsInfoDao.queryByAppId(newAppId);
                PaasAppsInfo destApp = new PaasAppsInfo();
                BeanUtils.copyProperties((Object)((Object)destApp), (Object)((Object)srcApp));
                BeanUtils.copyProperties((Object)((Object)destApp), (Object)((Object)sqliteSrcApp));
                destApp.setAppId(newAppId);
                SSubsInfo sSubsInfo = sSubsInfoDao.querySSubsInfoWithKeys(destSysId);
                if (sSubsInfo != null) {
                    destApp.setSubsId(sSubsInfo.getSubsId());
                    destApp.setSubsCode(sSubsInfo.getSubsCode());
                    destApp.setSubsName(sSubsInfo.getSubsName());
                }
                destApp.setCreateTime(createTime);
                destApp.setLastUpdateTime(createTime);
                destApp.setAppAdminType(sqliteSrcApp.getAppAdminType());
                destApp.setRefMarketAppid(srcApp.getMarketAppId());
                paasAppsInfoDao.insertPaasAppsInfo(destApp);
                PaasAppsParamDao paasAppsParamDao = new PaasAppsParamDao(sqliteConn);
                PaasAppsSqlDao paasAppsSqlDao = new PaasAppsSqlDao(sqliteConn);
                PaasAppsPropertiesDao paasAppsPropertiesDao = new PaasAppsPropertiesDao(sqliteConn);
                SrvModelInfoDao srvModelInfoDao = new SrvModelInfoDao(sqliteConn);
                SrvModelInoutDao srvModelInoutDao = new SrvModelInoutDao(sqliteConn);
                SrvModelPackageDao srvModelPackageDao = new SrvModelPackageDao(sqliteConn);
                OsrvArrangeTableDao osrvArrangeTableDao = new OsrvArrangeTableDao(sqliteConn);
                OsrvArrangeVarDao osrvArrangeVarDao = new OsrvArrangeVarDao(sqliteConn);
                OsrvEvalIsrvDao osrvEvalIsrvDao = new OsrvEvalIsrvDao(sqliteConn);
                OsrvEvalVarDao osrvEvalVarDao = new OsrvEvalVarDao(sqliteConn);
                SrvEvalFuncDao srvEvalFuncDao = new SrvEvalFuncDao(sqliteConn);
                SrvModelFeatureDao srvModelFeatureDao = new SrvModelFeatureDao(sqliteConn);
                PaasAppsParam paasAppsParam = new PaasAppsParam();
                paasAppsParam.setAppId(newAppId);
                List<PaasAppsParam> appsParamList = paasAppsParamDao.queryPaasAppsParamList(paasAppsParam);
                this.batchInsertPage("`allinpaas_db`.paas_apps_param", appsParamList, conn);
                PaasAppsSql paasSqlParam = new PaasAppsSql();
                paasSqlParam.setAppId(newAppId);
                List<PaasAppsSql> appsSqlList = paasAppsSqlDao.queryPaasAppsSqlList(paasSqlParam);
                this.batchInsertPage("paas_apps_sql", appsSqlList, sqliteConn);
                PaasAppsProperties paasAppsProp = new PaasAppsProperties();
                paasAppsProp.setAppId(newAppId);
                List<PaasAppsProperties> appsPropList = paasAppsPropertiesDao.queryPaasAppsPropertiesList(paasAppsProp);
                this.batchInsertPage("paas_apps_properties", appsPropList, sqliteConn);
                SrvModelInfo srvParam = new SrvModelInfo();
                srvParam.setAppId(appId);
                List<SrvModelInfo> srvModelList = srvModelInfoDao.querySrvModelInfoList(srvParam);
                this.batchInsertPage("`allinrdm_db`.srv_model_info", srvModelList, conn);
                SrvModelPackage srvModelPackage = new SrvModelPackage();
                srvModelPackage.setAppId(appId);
                List<SrvModelPackage> packageList = srvModelPackageDao.querySrvModelPackageList(srvModelPackage);
                this.batchInsertPage("`allinrdm_db`.srv_model_package", packageList, conn);
                for (SrvModelInfo modelInfo : srvModelList) {
                    SrvModelInout inoutParam = new SrvModelInout();
                    inoutParam.setSrvModelId(modelInfo.getSrvModelId());
                    List<SrvModelInout> inoutList = srvModelInoutDao.querySrvModelInoutList(inoutParam);
                    this.batchInsertPage("`allinrdm_db`.srv_model_inout", inoutList, conn);
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u4ecesqlite\u590d\u5236\u7ec4\u4ef6\u670d\u52a1\u5230\u5e73\u53f0\u5931\u8d25", (Throwable)e);
            flag = false;
        }
        finally {
            if (conn != null) {
                this.closeConnection(conn);
            }
            if (sqliteConn != null) {
                this.closeSqliteConnection(sqliteConn);
            }
        }
        return flag;
    }

    private int deleteByAppId(final String tableName, final String appId, Connection conn) {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.DELETE_FROM(tableName);
                this.WHERE("srv_model_id in ( select srv_model_id from `allinrdm_db`.srv_model_info where app_id = ?)");
                param.add(appId);
            }
        }.toString();
        PreparedStatement ps = null;
        Object rs = null;
        try {
            ps = conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            int re = ps.executeUpdate();
            return re;
        }
        catch (Exception e) {
            throw new RuntimeException("deleteByAppId is wrong", e);
        }
    }
}

