/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.market;

import com.alibaba.fastjson.JSON;
import com.irdstudio.allinapaas.design.console.types.MarketSource;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEnvParamDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasMarketAppinfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasMarketAppinfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasMarketStdinfo;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.git.JGitUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.market.AbstractMarketTask;
import com.irdstudio.allinapaas.portal.console.types.YesOrNO;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class CPPullSqliteRepoTask
extends AbstractMarketTask {
    private PaasMarketAppinfo appInfo = null;
    private Map<String, Object> extParam = null;

    @Override
    public boolean initTask(Map<String, Object> extParam, Connection conn) throws SQLException {
        this.extParam = extParam;
        PaasMarketAppinfoDao paasAppsInfoDao = new PaasMarketAppinfoDao(conn);
        this.appInfo = paasAppsInfoDao.queryPaasMarketAppinfo(MapUtils.getString(extParam, (Object)"marketAppId"));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        boolean flag;
        block33: {
            flag = true;
            Connection conn = null;
            Connection sqliteConn = null;
            try {
                conn = this.getConnection();
                PaasEnvParamDao paasEnvParamDao = new PaasEnvParamDao(conn);
                String username = paasEnvParamDao.queryByCodeReturnValue("git.username");
                String password = paasEnvParamDao.queryByCodeReturnValue("git.password");
                String marketUrl = paasEnvParamDao.queryByCodeReturnValue("git.market.remote.path");
                String branchName = paasEnvParamDao.queryByCodeReturnValue("git.market.branch.name");
                String marketSource = MapUtils.getString(this.extParam, (Object)"marketSource");
                String subsFlag = MapUtils.getString(this.extParam, (Object)"subsFlag");
                if (StringUtils.equals((CharSequence)marketSource, (CharSequence)MarketSource.Inside.getCode()) || StringUtils.equals((CharSequence)MapUtils.getString(this.extParam, (Object)"marketSubsCode"), (CharSequence)"PROD")) {
                    String repoPath = this.getRepoPath(marketUrl);
                    File repoDir = new File(repoPath);
                    this.logger.info("\u62c9\u53d6Git\u5e94\u7528\u5e02\u573a\u4ed3\u5e93\u5230\u672c\u5730 \u51c6\u5907\u672c\u5730\u4ed3\u5e93\u5730\u5740\uff1a" + repoDir.getAbsolutePath());
                    JGitUtil jGitUtil = new JGitUtil(repoDir.getAbsolutePath(), marketUrl, username, password);
                    try {
                        jGitUtil.pull(branchName);
                    }
                    catch (Exception e) {
                        try {
                            jGitUtil.cloneBranch(branchName);
                        }
                        catch (Exception e1) {
                            jGitUtil.close();
                            File localRepoFile = new File(repoDir.getAbsolutePath());
                            if (localRepoFile.exists()) {
                                FileUtils.deleteQuietly((File)localRepoFile);
                            }
                            try {
                                jGitUtil = new JGitUtil(repoDir.getAbsolutePath(), marketUrl, username, password);
                                jGitUtil.cloneBranch(branchName);
                            }
                            catch (Exception e2) {
                                e2.printStackTrace();
                                boolean bl = false;
                                if (conn != null) {
                                    this.closeConnection(conn);
                                }
                                if (sqliteConn != null) {
                                    this.closeSqliteConnection(sqliteConn);
                                }
                                return bl;
                            }
                        }
                    }
                    jGitUtil.close();
                    this.logger.info("\u62c9\u53d6Git\u5e94\u7528\u5e02\u573a\u4ed3\u5e93\u5230\u672c\u5730\u5b8c\u6210\uff1a" + marketUrl);
                    break block33;
                }
                if (StringUtils.equals((CharSequence)subsFlag, (CharSequence)YesOrNO.YES.getCode())) {
                    String apiUrl = paasEnvParamDao.queryByCodeReturnValue("allinpaas.open.api.http.url");
                    PaasMarketStdinfo param = new PaasMarketStdinfo();
                    param.setDataStdId(MapUtils.getString(this.extParam, (Object)"marketStdId"));
                    String respJson = this.requestOpenApi(apiUrl + "/om/paas/market/stdinfo", (Object)param);
                    if (StringUtils.isBlank((CharSequence)respJson)) {
                        flag = false;
                        this.logger.error("\u5916\u90e8\u5e94\u7528\u8bf7\u6c42\u8fd4\u56de\u7a7a" + apiUrl + "/om/paas/market/stdinfo");
                        boolean e = flag;
                        return e;
                    }
                    PaasMarketStdinfo stdInfo = (PaasMarketStdinfo)((Object)JSON.parseObject((String)respJson, PaasMarketStdinfo.class));
                    String repoPath = this.getRepoPath(stdInfo.getDataStdGiturl());
                    File repoDir = new File(repoPath);
                    this.logger.info("\u62c9\u53d6\u5916\u90e8\u5e94\u7528\u5e02\u573a\u6570\u636e\u6807\u51c6sqlite \u51c6\u5907\u672c\u5730\u4ed3\u5e93\u5730\u5740\uff1a" + repoDir.getAbsolutePath());
                    JGitUtil jGitUtil = new JGitUtil(repoDir.getAbsolutePath(), stdInfo.getDataStdGiturl(), username, password);
                    try {
                        jGitUtil.pull(branchName);
                    }
                    catch (Exception e) {
                        jGitUtil.cloneBranch(branchName);
                    }
                    jGitUtil.close();
                    this.logger.info("\u62c9\u53d6\u5916\u90e8\u5e94\u7528\u5e02\u573a\u6570\u636e\u6807\u51c6sqlite\u5230\u672c\u5730\u5b8c\u6210\uff1a" + stdInfo.getDataStdGiturl());
                    break block33;
                }
                if (StringUtils.equals((CharSequence)subsFlag, (CharSequence)YesOrNO.YES.getCode())) {
                    String apiUrl = paasEnvParamDao.queryByCodeReturnValue("allinpaas.open.api.http.url");
                    PaasMarketAppinfo param = new PaasMarketAppinfo();
                    param.setSubsId(MapUtils.getString(this.extParam, (Object)"marketSubsId"));
                    String respJson = this.requestOpenApi(apiUrl + "/om/paas/market/appinfo/index", (Object)param);
                    if (StringUtils.isBlank((CharSequence)respJson)) {
                        flag = false;
                        this.logger.error("\u5916\u90e8\u5e94\u7528\u8bf7\u6c42\u8fd4\u56de\u7a7a" + apiUrl + "/om/paas/market/appinfo/index");
                        boolean stdInfo = flag;
                        return stdInfo;
                    }
                    List list = JSON.parseArray((String)respJson, PaasMarketAppinfo.class);
                    if (!CollectionUtils.isNotEmpty((Collection)list)) break block33;
                    for (PaasMarketAppinfo appInfo : list) {
                        String repoPath = this.getRepoPath(appInfo.getMarketAppGiturl());
                        File repoDir = new File(repoPath);
                        this.logger.info("\u62c9\u53d6\u5916\u90e8\u5e94\u7528\u5e02\u573asqlite \u51c6\u5907\u672c\u5730\u4ed3\u5e93\u5730\u5740\uff1a" + repoDir.getAbsolutePath());
                        JGitUtil jGitUtil = new JGitUtil(repoDir.getAbsolutePath(), appInfo.getMarketAppGiturl(), username, password);
                        try {
                            jGitUtil.pull(branchName);
                        }
                        catch (Exception e) {
                            jGitUtil.cloneBranch(branchName);
                        }
                        jGitUtil.close();
                        this.logger.info("\u62c9\u53d6\u5916\u90e8\u5e94\u7528\u5e02\u573asqlite\u5230\u672c\u5730\u5b8c\u6210\uff1a" + appInfo.getMarketAppGiturl());
                    }
                    break block33;
                }
                String apiUrl = paasEnvParamDao.queryByCodeReturnValue("allinpaas.open.api.http.url");
                PaasMarketAppinfo param = new PaasMarketAppinfo();
                param.setMarketAppId(MapUtils.getString(this.extParam, (Object)"marketAppId"));
                String respJson = this.requestOpenApi(apiUrl + "/om/paas/market/appinfo", (Object)param);
                if (StringUtils.isBlank((CharSequence)respJson)) {
                    flag = false;
                    this.logger.error("\u5916\u90e8\u5e94\u7528\u8bf7\u6c42\u8fd4\u56de\u7a7a" + apiUrl + "/om/paas/market/appinfo");
                    boolean list = flag;
                    return list;
                }
                PaasMarketAppinfo appInfo = (PaasMarketAppinfo)((Object)JSON.parseObject((String)respJson, PaasMarketAppinfo.class));
                String repoPath = this.getRepoPath(appInfo.getMarketAppGiturl());
                File repoDir = new File(repoPath);
                this.logger.info("\u62c9\u53d6\u5916\u90e8\u5e94\u7528\u5e02\u573asqlite \u51c6\u5907\u672c\u5730\u4ed3\u5e93\u5730\u5740\uff1a" + repoDir.getAbsolutePath());
                JGitUtil jGitUtil = new JGitUtil(repoDir.getAbsolutePath(), appInfo.getMarketAppGiturl(), username, password);
                try {
                    jGitUtil.pull(branchName);
                }
                catch (Exception e) {
                    jGitUtil.cloneBranch(branchName);
                }
                jGitUtil.close();
                this.logger.info("\u62c9\u53d6\u5916\u90e8\u5e94\u7528\u5e02\u573asqlite\u5230\u672c\u5730\u5b8c\u6210\uff1a" + appInfo.getMarketAppGiturl());
            }
            catch (Exception e) {
                this.logger.error("\u62c9\u53d6Git\u5e94\u7528\u5e02\u573a\u4ed3\u5e93\u5230\u672c\u5730", (Throwable)e);
                flag = false;
            }
            finally {
                if (conn != null) {
                    this.closeConnection(conn);
                }
                if (sqliteConn != null) {
                    this.closeSqliteConnection(sqliteConn);
                }
            }
        }
        return flag;
    }
}

