/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.market;

import com.alibaba.fastjson.JSON;
import com.irdstudio.allinapaas.design.console.types.AppType;
import com.irdstudio.allinapaas.design.console.types.MarketSource;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.DictItemInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.ModelFolderInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.ModelTableFieldDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.ModelTableIndexDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.ModelTableInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEnvParamDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasMarketAppinfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.SrvFieldFlagDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.DictItemInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.ModelFolderInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.ModelTableField;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.ModelTableIndex;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.ModelTableInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasMarketAppinfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SrvFieldFlag;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.market.AbstractMarketTask;
import com.irdstudio.allinapaas.portal.console.types.YesOrNO;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class CPSqliteModelTask
extends AbstractMarketTask {
    private PaasMarketAppinfo appInfo = null;
    private Map<String, Object> extParam = null;

    @Override
    public boolean initTask(Map<String, Object> extParam, Connection conn) throws SQLException {
        this.extParam = extParam;
        PaasMarketAppinfoDao paasAppsInfoDao = new PaasMarketAppinfoDao(conn);
        this.appInfo = paasAppsInfoDao.queryPaasMarketAppinfo(MapUtils.getString(extParam, (Object)"marketAppId"));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean execute() {
        boolean sysApps3;
        Connection sqliteConn;
        Connection conn;
        block24: {
            block25: {
                boolean flag = true;
                conn = null;
                sqliteConn = null;
                try {
                    conn = this.getConnection();
                    PaasEnvParamDao paasEnvParamDao = new PaasEnvParamDao(conn);
                    PaasAppsInfoDao real_projectTmInfoDao = new PaasAppsInfoDao(sqliteConn);
                    String subsFlag = MapUtils.getString(this.extParam, (Object)"subsFlag");
                    String marketSource = MapUtils.getString(this.extParam, (Object)"marketSource");
                    String subsId = MapUtils.getString(this.extParam, (Object)"marketSubsId");
                    ArrayList<PaasMarketAppinfo> appInfoList = new ArrayList<PaasMarketAppinfo>();
                    if (StringUtils.equals((CharSequence)marketSource, (CharSequence)MarketSource.Inside.getCode())) {
                        if (StringUtils.equals((CharSequence)subsFlag, (CharSequence)YesOrNO.YES.getCode())) {
                            PaasMarketAppinfoDao paasAppsInfoDao = new PaasMarketAppinfoDao(conn);
                            PaasMarketAppinfo appParam = new PaasMarketAppinfo();
                            appParam.setSubsId(subsId);
                            List<PaasMarketAppinfo> sysApps2 = paasAppsInfoDao.queryPaasMarketAppinfoList(appParam);
                            appInfoList.addAll(sysApps2);
                        } else {
                            appInfoList.add(this.appInfo);
                        }
                    } else {
                        String respJson;
                        PaasMarketAppinfo param;
                        String apiUrl = paasEnvParamDao.queryByCodeReturnValue("allinpaas.open.api.http.url");
                        if (StringUtils.equals((CharSequence)subsFlag, (CharSequence)YesOrNO.YES.getCode())) {
                            param = new PaasMarketAppinfo();
                            param.setSubsId(subsId);
                            respJson = this.requestOpenApi(apiUrl + "/om/paas/market/appinfo/index", (Object)param);
                            if (StringUtils.isBlank((CharSequence)respJson)) {
                                boolean bl = flag = false;
                                return bl;
                            }
                            List sysApps3 = JSON.parseArray((String)respJson, PaasMarketAppinfo.class);
                            appInfoList.addAll(sysApps3);
                        } else {
                            param = new PaasMarketAppinfo();
                            param.setMarketAppId(MapUtils.getString(this.extParam, (Object)"marketAppId"));
                            respJson = this.requestOpenApi(apiUrl + "/om/paas/market/appinfo", (Object)param);
                            if (StringUtils.isBlank((CharSequence)respJson)) {
                                sysApps3 = flag = false;
                                if (conn == null) break block24;
                                break block25;
                            }
                            PaasMarketAppinfo marketApp = (PaasMarketAppinfo)((Object)JSON.parseObject((String)respJson, PaasMarketAppinfo.class));
                            appInfoList.add(marketApp);
                        }
                    }
                    List<String> cpnAppTypes = Arrays.asList(AppType.A10.getCode());
                    Iterator iterator = appInfoList.iterator();
                    while (iterator.hasNext()) {
                        PaasMarketAppinfo srcApp = (PaasMarketAppinfo)((Object)iterator.next());
                        File sqliteFile = null;
                        if (StringUtils.equals((CharSequence)subsFlag, (CharSequence)YesOrNO.YES.getCode())) {
                            String marketUrl = paasEnvParamDao.queryByCodeReturnValue("git.market.remote.path");
                            sqliteFile = this.getIMPSysSqliteFile(this.extParam, marketUrl, null);
                        } else {
                            sqliteFile = this.getSqliteFile(srcApp);
                        }
                        sqliteConn = this.getSqliteConnection(sqliteFile);
                        PaasMarketAppinfoDao keyMapDao = new PaasMarketAppinfoDao(sqliteConn);
                        String appId = keyMapDao.queryKeyMap(srcApp.getAppId());
                        if (srcApp != null) {
                            ModelFolderInfoDao projectTmPackageDao = new ModelFolderInfoDao(sqliteConn);
                            ModelFolderInfo packageParam = new ModelFolderInfo();
                            packageParam.setAppId(appId);
                            List<ModelFolderInfo> packageList = projectTmPackageDao.queryModelFolderInfo(packageParam);
                            this.batchInsert("`allinrdm_db`.model_folder_info", packageList, conn);
                            ModelTableInfoDao modelTableInfoDao = new ModelTableInfoDao(sqliteConn);
                            List<ModelTableInfo> tables = modelTableInfoDao.queryModelTableInfoList(appId);
                            this.batchInsertPage("`allinrdm_db`.model_table_info", tables, conn);
                            ModelTableIndexDao modelTableIndexDao = new ModelTableIndexDao(sqliteConn);
                            List<ModelTableIndex> indexs = modelTableIndexDao.queryModelTableInfos(appId);
                            this.batchInsertPage("`allinrdm_db`.model_table_index", indexs, conn);
                            ModelTableFieldDao modelTableFieldDao = new ModelTableFieldDao(sqliteConn);
                            List<ModelTableField> fields = modelTableFieldDao.queryFieldByAppId(appId);
                            this.batchInsertPage("`allinrdm_db`.model_table_field", fields, conn);
                            SrvFieldFlagDao srvFieldFlagDao = new SrvFieldFlagDao(sqliteConn);
                            List<SrvFieldFlag> fieldFlags = srvFieldFlagDao.queryFieldFlagByAppId(appId);
                            this.batchInsertPage("`allinrdm_db`.srv_field_flag", fieldFlags, conn);
                            DictItemInfoDao dictItemInfoDao = new DictItemInfoDao(sqliteConn);
                            DictItemInfoDao destDBDictItemInfoDao = new DictItemInfoDao(conn);
                            List<DictItemInfo> items = dictItemInfoDao.queryDictItemInfoList(appId);
                            if (CollectionUtils.isNotEmpty(items)) {
                                ArrayList<DictItemInfo> needItems = new ArrayList<DictItemInfo>(items.size());
                                for (DictItemInfo item : items) {
                                    if (destDBDictItemInfoDao.queryByPk(item.getItemId()) != null) continue;
                                    needItems.add(item);
                                }
                                this.batchInsertPage("`allinrdm_db`.dict_item_info", needItems, conn);
                            }
                        }
                        this.closeSqliteConnection(sqliteConn);
                    }
                    return flag;
                }
                catch (Exception e) {
                    this.logger.error("\u4ecesqlite\u590d\u5236\u9886\u57df\u6a21\u578b\u5230\u5e73\u53f0", (Throwable)e);
                    flag = false;
                    return flag;
                }
            }
            this.closeConnection(conn);
        }
        if (sqliteConn == null) return sysApps3;
        this.closeSqliteConnection(sqliteConn);
        return sysApps3;
        finally {
            if (conn != null) {
                this.closeConnection(conn);
            }
            if (sqliteConn != null) {
                this.closeSqliteConnection(sqliteConn);
            }
        }
    }
}

