/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.migrate.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationtabledataUtilDao {
    private static final Logger logger = LoggerFactory.getLogger(MigrationtabledataUtilDao.class);
    Connection conn = null;

    public MigrationtabledataUtilDao(Connection conn) {
        this.conn = conn;
    }

    public boolean addorupdateordeltable(String sql) throws SQLException {
        PreparedStatement ps = null;
        boolean result = true;
        try {
            ps = this.conn.prepareStatement(sql);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new SQLException("inserttable\tys is Wrong!" + e.getMessage());
        }
        finally {
            this.close(null, null, ps);
        }
        return result;
    }

    public boolean datamigration(String sql, List<Map> targetlist) throws SQLException {
        PreparedStatement ps = null;
        boolean result = true;
        try {
            ps = this.conn.prepareStatement(sql);
            for (Map map : targetlist) {
                try {
                    int cuont = 1;
                    for (Object key : map.keySet()) {
                        String value = map.get(key).toString();
                        System.out.println(key + " " + value);
                        ps.setString(cuont, value);
                        ++cuont;
                    }
                    ps.addBatch();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            ps.executeBatch();
        }
        catch (SQLException e) {
            result = false;
            throw new SQLException("datamigration is Wrong!" + e.getMessage());
        }
        finally {
            this.close(null, null, ps);
        }
        return result;
    }

    public List<Map> selecttablelist(String sql) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<Map> result = new ArrayList<Map>();
        try {
            ps = this.conn.prepareStatement(sql);
            rs = ps.executeQuery();
            ResultSetMetaData rsmd = rs.getMetaData();
            int columncount = rsmd.getColumnCount();
            while (rs.next()) {
                LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                for (int i = 0; i < columncount; ++i) {
                    String key = rsmd.getColumnLabel(i + 1);
                    String value = rs.getString(key);
                    map.put(key, value);
                }
                result.add(map);
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("selectyblist is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return result;
    }

    protected void close(ResultSet theRs, Statement theStmt, PreparedStatement thePs) {
        try {
            if (theRs != null) {
                theRs.close();
            }
            if (theStmt != null) {
                theStmt.close();
            }
            if (thePs != null) {
                thePs.close();
            }
        }
        catch (SQLException e) {
            logger.error(e.getMessage());
        }
    }
}

