/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.monitor;

import com.irdstudio.allinapaas.design.console.types.ParamSource;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.BatInstBatchDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEnvParamDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.BatInstBatch;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasEnvParam;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.apps.SdEnvUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.builder.AbstractBuilderPlugin;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class MonitorSettingsPlugin
extends AbstractBuilderPlugin {
    @Override
    protected boolean doReadConfigureFromDB(Connection conn, String szConfIdentify) throws SQLException {
        String batchSerialNo = this.context.getSzBatchSn();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        boolean flag;
        block16: {
            this.logger.info("\u76d1\u63a7\u5e94\u7528\u53c2\u6570\u914d\u7f6e");
            flag = true;
            Connection conn = null;
            try {
                String localBuild;
                block17: {
                    conn = this.getPluginConnection();
                    BatInstBatchDao batInstBatchDao = new BatInstBatchDao(conn);
                    BatInstBatch batInstBatch = batInstBatchDao.queryByBatchSerialNo(this.context.getSzBatchSn());
                    String currEnvId = batInstBatch.getEnvId();
                    PaasEnvParamDao paasEnvParamDao = new PaasEnvParamDao(conn);
                    String monitorIp = this.parseParamValue(ParamSource.Env.getCode(), "MMS.ECS_IP", null, conn);
                    String monitorPort = this.parseParamValue(ParamSource.Env.getCode(), "MMS.ECS_PORT", null, conn);
                    String monitorConsoleUrl = String.format("http://%s:%s/paas/mon/openapi/", monitorIp, monitorPort);
                    monitorConsoleUrl = monitorConsoleUrl.replace("openapi/", "");
                    PaasEnvParam loggingFile = paasEnvParamDao.queryByCode("logging_path", currEnvId);
                    if (loggingFile == null) {
                        loggingFile = new PaasEnvParam();
                        loggingFile.setParamCode("logging_path");
                        loggingFile.setEnvId(currEnvId);
                        loggingFile.setParamValue("/var/tmp/logs/");
                    }
                    String module = this.context.getVv().getValue("module");
                    String gitUrl = paasEnvParamDao.queryByCodeReturnValue("git.worker.remote.path");
                    int firstIndex = gitUrl.lastIndexOf("/");
                    int lastIndex = gitUrl.lastIndexOf(".");
                    String moduleName = gitUrl.substring(firstIndex, lastIndex);
                    localBuild = SdEnvUtil.BUILD_PATH + moduleName;
                    File localBuildFile = new File(localBuild);
                    if (!localBuildFile.exists()) break block17;
                    File[] modules = localBuildFile.listFiles();
                    if (modules == null || modules.length <= 0) break block16;
                    for (File moduleDir : modules) {
                        File applicationFile;
                        if (!moduleDir.getName().equals(module) || !(applicationFile = new File(moduleDir, "src" + File.separator + "main" + File.separator + "resources" + File.separator + "application-" + currEnvId + ".properties")).exists()) continue;
                        FileInputStream configInputStream = null;
                        List configs = null;
                        try {
                            configInputStream = new FileInputStream(applicationFile);
                            configs = IOUtils.readLines((InputStream)configInputStream);
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(configInputStream);
                            throw throwable;
                        }
                        IOUtils.closeQuietly((InputStream)configInputStream);
                        if (configs == null) {
                            this.logger.error("\u8bfb\u53d6application.properties\u5931\u8d25");
                            boolean bl = false;
                            return bl;
                        }
                        int count = 0;
                        for (int i = 0; i < configs.size(); ++i) {
                            String line = (String)configs.get(i);
                            if (StringUtils.startsWith((CharSequence)line, (CharSequence)"rmp.console.web.url=")) {
                                line = "rmp.console.web.url=" + monitorConsoleUrl;
                                configs.set(i, line);
                                ++count;
                                continue;
                            }
                            if (!StringUtils.startsWith((CharSequence)line, (CharSequence)"logging.file.path=")) continue;
                            line = "logging.file.path=" + loggingFile.getParamValue() + module + "/";
                            configs.set(i, line);
                            ++count;
                        }
                        FileOutputStream configOutStream = null;
                        try {
                            FileUtils.forceDelete((File)applicationFile);
                            configOutStream = new FileOutputStream(applicationFile);
                            IOUtils.writeLines((Collection)configs, (String)System.lineSeparator(), (OutputStream)configOutStream, (String)"UTF-8");
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(configOutStream);
                            throw throwable;
                        }
                        IOUtils.closeQuietly((OutputStream)configOutStream);
                    }
                    break block16;
                }
                flag = false;
                this.logger.error("\u7f16\u8bd1\u76ee\u5f55\u4e0d\u5b58\u5728 " + localBuild);
            }
            catch (Exception e) {
                this.logger.error("\u4ea7\u54c1\u5e94\u7528\u8bbe\u7f6e\u5f02\u5e38", e);
                flag = false;
            }
            finally {
                if (conn != null) {
                    this.closePluginConnection(conn);
                }
            }
        }
        return flag;
    }
}

