/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.util.db.plugin;

import com.irdstudio.allinapaas.executor.application.executor.core.plugin.docs.git.queue.DocTemplateRepoPullQueueExecutor;
import com.irdstudio.allinapaas.executor.application.executor.core.util.db.plugin.ModelTableStructVO;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.beetl.core.Configuration;
import org.beetl.core.GroupTemplate;
import org.beetl.core.ResourceLoader;
import org.beetl.core.Template;
import org.beetl.core.resource.FileResourceLoader;

public class DataBaseSQLScriptPlugin {
    private GroupTemplate groupTemplate;

    public DataBaseSQLScriptPlugin() {
        this.init();
    }

    private void init() {
        DocTemplateRepoPullQueueExecutor.syncRun();
        String root = DocTemplateRepoPullQueueExecutor.getDocTemplatePath();
        if (root == null) {
            DocTemplateRepoPullQueueExecutor.syncRun();
            root = DocTemplateRepoPullQueueExecutor.getDocTemplatePath();
        }
        FileResourceLoader resourceLoader = new FileResourceLoader(root, "utf-8");
        Configuration cfg = null;
        try {
            cfg = Configuration.defaultConfiguration();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.groupTemplate = new GroupTemplate((ResourceLoader)resourceLoader, cfg);
    }

    private String getTemplateAll(String templateName, Object bean) {
        Map<String, Object> paramMap = null;
        if (bean != null) {
            paramMap = DataBaseSQLScriptPlugin.beanAll2Map(bean);
        }
        return this.getTemplate(templateName, paramMap);
    }

    public String getTemplate(String templatePath, Map<String, Object> paramMap) {
        if (Objects.isNull(templatePath)) {
            throw new NullPointerException("\u4f20\u5165\u6a21\u677f\u4e3a\u7a7a\uff01");
        }
        Template template = this.groupTemplate.getTemplate(templatePath);
        template.binding(paramMap);
        paramMap.keySet().stream().forEach(s -> {
            if (paramMap.get(s) instanceof List) {
                template.binding(s, paramMap.get(s));
            }
        });
        return template.render();
    }

    public static Map<String, Object> beanAll2Map(Object bean) {
        if (bean == null) {
            return Collections.emptyMap();
        }
        try {
            PropertyDescriptor[] propertyDescriptors;
            TreeMap<String, Object> map = new TreeMap<String, Object>();
            BeanInfo beanInfo = Introspector.getBeanInfo(bean.getClass());
            for (PropertyDescriptor property : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                String key = property.getName();
                if (key.equals("class")) continue;
                Method getter = property.getReadMethod();
                Object value = getter.invoke(bean, new Object[0]);
                map.put(key, value);
            }
            return map;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("bean2Map fail: " + e.getMessage(), e);
        }
    }

    private String getAdaptTemplate(String dbms) {
        String templateName = null;
        switch (dbms) {
            case "425": {
                templateName = "sql-script/mysql.ddl.sql.template";
            }
        }
        return templateName;
    }

    public String generateDDLScript(ModelTableStructVO genSQLScript) {
        String ddl = this.getTemplateAll(this.getAdaptTemplate(genSQLScript.getDbms()), genSQLScript);
        return ddl;
    }

    public String generateDDLScript(String templateName, ModelTableStructVO genSQLScript) {
        String ddl = this.getTemplateAll(templateName, genSQLScript);
        return ddl;
    }
}

