/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.dao;

import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.DictWordInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.util.db.ProxySQL;
import com.irdstudio.sdk.beans.core.util.POJOUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DictWordInfoDao {
    private static final Logger logger = LoggerFactory.getLogger(DictWordInfoDao.class);
    Connection conn = null;

    public DictWordInfoDao(Connection conn) {
        this.conn = conn;
    }

    public List<DictWordInfo> queryDictWordInfoList(final DictWordInfo paramVO) {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("*");
                this.FROM("`allinrdm_db`.dict_word_info");
                List vals = POJOUtils.getPOJOValues((Object)((Object)paramVO));
                for (Object[] val : vals) {
                    this.WHERE(String.format("%s = ?", val[0].toString()));
                    param.add(val[1]);
                }
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<DictWordInfo> list = new ArrayList<DictWordInfo>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                DictWordInfo bean = (DictWordInfo)((Object)POJOUtils.generatePOJO((ResultSet)rs, DictWordInfo.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("query queryDictWordInfoList is wrong", e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return list;
    }

    public DictWordInfo queryByPk(final String wordId) {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("*");
                this.FROM("`allinrdm_db`.dict_word_info");
                this.WHERE("word_id = ? ");
                param.add(wordId);
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<DictWordInfo> list = new ArrayList<DictWordInfo>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                DictWordInfo bean = (DictWordInfo)((Object)POJOUtils.generatePOJO((ResultSet)rs, DictWordInfo.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("query queryByPk is wrong", e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return list.isEmpty() ? null : (DictWordInfo)((Object)list.get(0));
    }

    public List<DictWordInfo> queryByItemNames(final List<String> names) {
        if (names == null || names.isEmpty()) {
            return new ArrayList<DictWordInfo>(0);
        }
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("*");
                this.FROM("`allinrdm_db`.dict_word_info");
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < names.size(); ++i) {
                    param.add(names.get(i));
                    sb.append("?");
                    if (i >= names.size() - 1) continue;
                    sb.append(",");
                }
                this.WHERE(String.format("word_cn_desc in (%s)", sb.toString()));
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<DictWordInfo> list = new ArrayList<DictWordInfo>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                DictWordInfo bean = (DictWordInfo)((Object)POJOUtils.generatePOJO((ResultSet)rs, DictWordInfo.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("query queryByItemNames is wrong", e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return list;
    }
}

