/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.dao;

import com.alibaba.fastjson.JSON;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.AbstractPortalPageDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.ModelTableField;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.ModelTableInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.util.db.ProxySQL;
import com.irdstudio.allinrdm.dam.console.types.ObjectType;
import com.irdstudio.sdk.beans.core.util.POJOUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelTableInfoDao
extends AbstractPortalPageDao {
    private static final Logger logger = LoggerFactory.getLogger(ModelTableInfoDao.class);
    Connection conn = null;

    public ModelTableInfoDao(Connection conn) {
        super(conn);
        this.conn = conn;
    }

    public ModelTableInfo queryCommonTableModelInfo(String appId, String commonTableName) {
        try {
            ModelTableInfo tableParam = new ModelTableInfo();
            tableParam.setAppId(appId);
            tableParam.setObjectCode(commonTableName);
            tableParam.setObjectType(ObjectType.Common.getIntCode());
            List<ModelTableInfo> commonTbList = this.queryTableListWithCond(tableParam);
            if (CollectionUtils.isNotEmpty(commonTbList)) {
                return commonTbList.get(0);
            }
            return null;
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u516c\u5171\u6570\u636e\u5bf9\u8c61\u5f02\u5e38 " + commonTableName + " " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public ModelTableInfo queryInoutTableModelInfo(String appId, String tableName) {
        try {
            ModelTableInfo tableParam = new ModelTableInfo();
            tableParam.setAppId(appId);
            tableParam.setObjectCode(tableName);
            tableParam.setObjectType(ObjectType.Inout.getIntCode());
            List<ModelTableInfo> commonTbList = this.queryTableListWithCond(tableParam);
            if (CollectionUtils.isNotEmpty(commonTbList)) {
                return commonTbList.get(0);
            }
            return null;
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u516c\u5171\u6570\u636e\u5bf9\u8c61\u5f02\u5e38 " + tableName + " " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public List<ModelTableInfo> queryModelTableInfoList(final String appId) throws Exception {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("*");
                this.FROM("`allinrdm_db`.model_table_info");
                this.WHERE("app_id = ?");
                param.add(appId);
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<ModelTableInfo> list = new ArrayList<ModelTableInfo>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                ModelTableInfo bean = (ModelTableInfo)((Object)POJOUtils.generatePOJO((ResultSet)rs, ModelTableInfo.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("query queryModelTableInfoList is wrong", e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return list;
    }

    public List<ModelTableInfo> queryModelTableInfoList(final String appId, final List<Integer> objectTypes) throws Exception {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("*");
                this.FROM("`allinrdm_db`.model_table_info");
                this.WHERE("app_id = ?  OR app_id in ( select ref_db_appid from paas_apps_info where app_id = ? and ifnull(ref_db_appid, '') != '' )");
                param.add(appId);
                param.add(appId);
                if (CollectionUtils.isNotEmpty((Collection)objectTypes)) {
                    ArrayList<String> inSql = new ArrayList<String>(objectTypes.size());
                    for (Integer el : objectTypes) {
                        inSql.add(String.format("%s", el));
                    }
                    this.WHERE("object_type in (" + StringUtils.join(inSql, (String)",") + ")");
                }
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<ModelTableInfo> list = new ArrayList<ModelTableInfo>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                ModelTableInfo bean = (ModelTableInfo)((Object)POJOUtils.generatePOJO((ResultSet)rs, ModelTableInfo.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("query queryModelTableInfoList is wrong", e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return list;
    }

    public ModelTableInfo queryModelTableInfo(final String objectId) throws Exception {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("*");
                this.FROM("`allinrdm_db`.model_table_info");
                this.WHERE("object_id = ?");
                param.add(objectId);
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<ModelTableInfo> list = new ArrayList<ModelTableInfo>(2);
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                ModelTableInfo bean = (ModelTableInfo)((Object)POJOUtils.generatePOJO((ResultSet)rs, ModelTableInfo.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("query queryModelTableInfoList is wrong", e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return list.isEmpty() ? null : (ModelTableInfo)((Object)list.get(0));
    }

    public int countByProjectId(final String appId) throws Exception {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("count(1) as num");
                this.FROM("`allinrdm_db`.model_table_info");
                this.WHERE("app_id = ?");
                param.add(appId);
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        int count = 0;
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                count = rs.getInt(1);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("query countByProjectId is wrong", e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return count;
    }

    public List<ModelTableInfo> queryTableListWithCond(final ModelTableInfo paramVO) throws Exception {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("(select folder_name from `allinrdm_db`.model_folder_info p where t.folder_id = p.folder_id) as folder_name, t.*");
                this.FROM("`allinrdm_db`.model_table_info t");
                List vals = POJOUtils.getPOJOValues((Object)((Object)paramVO));
                for (Object[] val : vals) {
                    this.WHERE(String.format("%s = ?", val[0].toString()));
                    param.add(val[1]);
                }
                this.ORDER_BY("folder_name, order_value");
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<ModelTableInfo> list = new ArrayList<ModelTableInfo>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                ModelTableInfo bean = (ModelTableInfo)((Object)POJOUtils.generatePOJO((ResultSet)rs, ModelTableInfo.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("query queryTableListWithCond is wrong", e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return list;
    }

    public boolean insert(final ModelTableInfo obj) throws SQLException {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.INSERT_INTO("`allinrdm_db`.model_table_info");
                List vals = POJOUtils.getPOJOValues((Object)((Object)obj));
                for (Object[] val : vals) {
                    this.VALUES(val[0].toString(), "?");
                    param.add(val[1]);
                }
            }
        }.toString();
        PreparedStatement ps = null;
        Object rs = null;
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            int re = ps.executeUpdate();
            if (re == 1) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("insert is wrong " + JSON.toJSON(param), e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return false;
    }

    public int deleteByAppId(final String appId) throws SQLException {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.DELETE_FROM("`allinrdm_db`.model_table_info");
                this.WHERE("app_id = ?");
                param.add(appId);
            }
        }.toString();
        PreparedStatement ps = null;
        Object rs = null;
        try {
            int re;
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            int n = re = ps.executeUpdate();
            return n;
        }
        catch (Exception e) {
            throw new RuntimeException("deleteByProjectId is wrong", e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public List<String> queryDuplicateTable(final String appId) throws Exception {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("object_code");
                this.FROM("`allinrdm_db`.model_table_info");
                this.WHERE("app_id = ?");
                param.add(appId);
                this.GROUP_BY("object_code");
                this.HAVING("count(1) > 1");
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<String> list = new ArrayList<String>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                String objectCode = rs.getString(1);
                list.add(objectCode);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("queryDuplicateTable is wrong", e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return list;
    }

    public List<ModelTableInfo> queryWithoutPkTable(final String appId) throws Exception {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("*");
                this.FROM("`allinrdm_db`.model_table_info t");
                this.WHERE("not exists ( select field_code from `allinrdm_db`.model_table_field f where f.object_id = t.object_id and is_pk = 'Y' )");
                this.WHERE("app_id = ?");
                param.add(appId);
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<ModelTableInfo> list = new ArrayList<ModelTableInfo>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                ModelTableInfo bean = (ModelTableInfo)((Object)POJOUtils.generatePOJO((ResultSet)rs, ModelTableInfo.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("queryWithoutPkTable is wrong", e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return list;
    }

    public Integer querySysTableNum(String sysCode, String appId) {
        ArrayList<String> param = new ArrayList<String>();
        String sql = String.format("SELECT    count(1)   FROM `allinrdm_db`.model_table_info t   WHERE app_id in ( SELECT app_id FROM `allinpaas_db`.paas_apps_info WHERE subs_id =  ? )   and object_type in ('1201', '2001', '2002', '2003', '2004') ", new Object[0]);
        param.add(sysCode);
        if (StringUtils.isNotBlank((CharSequence)appId)) {
            sql = sql + " and t.app_id in ( SELECT app_id FROM `allinpaas_db`.paas_apps_info WHERE app_id =  ? ) ";
            param.add(appId);
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            if (rs.next()) {
                Integer obj;
                Integer n = obj = Integer.valueOf(rs.getInt(1));
                return n;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("querySysTableNum is wrong", e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return 0;
    }

    public Integer querySysFieldNum(String sysCode, String appId) {
        ArrayList<String> param = new ArrayList<String>();
        String sql = String.format("SELECT    count(1)   FROM `allinrdm_db`.model_table_field f join `allinrdm_db`.model_table_info t on f.object_id = t.object_id   WHERE app_id in ( SELECT app_id FROM `allinpaas_db`.paas_apps_info WHERE subs_id =  ? )   and object_type in ('1201', '2001', '2002', '2003', '2004')", new Object[0]);
        param.add(sysCode);
        if (StringUtils.isNotBlank((CharSequence)appId)) {
            sql = sql + " and app_id in ( SELECT app_id FROM `allinpaas_db`.paas_apps_info WHERE app_id =  ? ) ";
            param.add(appId);
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            if (rs.next()) {
                Integer obj;
                Integer n = obj = Integer.valueOf(rs.getInt(1));
                return n;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("querySysFieldNum is wrong", e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return 0;
    }

    public Integer querySysFieldItemNum(String sysCode, String appId) {
        ArrayList<String> param = new ArrayList<String>();
        String sql = String.format("SELECT    count(1)   FROM `allinrdm_db`.model_table_field f join `allinrdm_db`.model_table_info t on f.object_id = t.object_id   WHERE app_id in ( SELECT app_id FROM `allinpaas_db`.paas_apps_info WHERE subs_id =  ? )   and object_type in ('1201', '2001', '2002', '2003', '2004')   and ifnull(f.item_id, '') != ''", new Object[0]);
        param.add(sysCode);
        if (StringUtils.isNotBlank((CharSequence)appId)) {
            sql = sql + " and app_id in ( SELECT app_id FROM `allinpaas_db`.paas_apps_info WHERE app_id =  ? ) ";
            param.add(appId);
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            if (rs.next()) {
                Integer obj;
                Integer n = obj = Integer.valueOf(rs.getInt(1));
                return n;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("querySysFieldItemNum is wrong", e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return 0;
    }

    public Integer querySysMissCNNum(String sysCode, String appId) {
        ArrayList<String> param = new ArrayList<String>();
        String sql = String.format("SELECT    count(1)   FROM `allinrdm_db`.model_table_info t   WHERE app_id in ( SELECT app_id FROM `allinpaas_db`.paas_apps_info WHERE subs_id =  ? )   and object_type in ('1201', '2001', '2002', '2003', '2004')   and ifnull(t.object_name, '') = ''", new Object[0]);
        param.add(sysCode);
        if (StringUtils.isNotBlank((CharSequence)appId)) {
            sql = sql + " and app_id in ( SELECT app_id FROM `allinpaas_db`.paas_apps_info WHERE app_id =  ? ) ";
            param.add(appId);
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            if (rs.next()) {
                Integer obj;
                Integer n = obj = Integer.valueOf(rs.getInt(1));
                return n;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("querySysMissCNNum is wrong", e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return 0;
    }

    public Integer querySysMissFieldCNNum(String sysCode, String appId) {
        ArrayList<String> param = new ArrayList<String>();
        String sql = String.format("SELECT    count(1)   FROM `allinrdm_db`.model_table_field f join `allinrdm_db`.model_table_info t on f.object_id = t.object_id   WHERE app_id in ( SELECT app_id FROM `allinpaas_db`.paas_apps_info WHERE subs_id =  ? )   and object_type in ('1201', '2001', '2002', '2003', '2004')   and ifnull(f.field_name, '') = ''", new Object[0]);
        param.add(sysCode);
        if (StringUtils.isNotBlank((CharSequence)appId)) {
            sql = sql + " and app_id in ( SELECT app_id FROM `allinpaas_db`.paas_apps_info WHERE app_id =  ? ) ";
            param.add(appId);
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            if (rs.next()) {
                Integer obj;
                Integer n = obj = Integer.valueOf(rs.getInt(1));
                return n;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("querySysMissFieldCNNum is wrong", e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return 0;
    }

    public Integer querySysMessyTbNum(String sysCode, String appId) {
        ArrayList<String> param = new ArrayList<String>();
        String sql = "SELECT    count(1)   FROM `allinrdm_db`.model_table_info t   WHERE app_id in ( SELECT app_id FROM `allinpaas_db`.paas_apps_info WHERE subs_id =  ? )   and object_type in ('1201', '2001', '2002', '2003', '2004')   and (t.object_name != CONVERT(object_name USING utf8) OR t.object_name like concat('%', ? ,'%') )";
        param.add(sysCode);
        param.add("?");
        if (StringUtils.isNotBlank((CharSequence)appId)) {
            sql = sql + " and app_id in ( SELECT app_id FROM `allinpaas_db`.paas_apps_info WHERE app_id =  ? ) ";
            param.add(appId);
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            if (rs.next()) {
                Integer obj;
                Integer n = obj = Integer.valueOf(rs.getInt(1));
                return n;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("querySysMessyTbNum is wrong", e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return 0;
    }

    public Integer querySysMessyFieldNum(String sysCode, String appId) {
        ArrayList<String> param = new ArrayList<String>();
        String sql = "SELECT    count(1)   FROM `allinrdm_db`.model_table_field f join `allinrdm_db`.model_table_info t on f.object_id = t.object_id   WHERE app_id in ( SELECT app_id FROM `allinpaas_db`.paas_apps_info WHERE subs_id =  ? )   and object_type in ('1201', '2001', '2002', '2003', '2004')   and (f.field_name != CONVERT(f.field_name USING utf8) OR f.field_name like concat('%', ? ,'%') )";
        param.add(sysCode);
        param.add("?");
        if (StringUtils.isNotBlank((CharSequence)appId)) {
            sql = sql + " and app_id in ( SELECT app_id FROM `allinpaas_db`.paas_apps_info WHERE app_id =  ? ) ";
            param.add(appId);
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            if (rs.next()) {
                Integer obj;
                Integer n = obj = Integer.valueOf(rs.getInt(1));
                return n;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("querySysMessyFieldNum is wrong", e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return 0;
    }

    public Integer querySysFieldTypeNum(String sysCode, String appId) {
        ArrayList<String> param = new ArrayList<String>();
        String sql = String.format("SELECT    count(1)   FROM `allinrdm_db`.model_table_field f join `allinrdm_db`.model_table_info t on f.object_id = t.object_id   join `allinrdm_db`.dict_item_info item on f.item_id = item.item_id  join `allinrdm_db`.pub_dbms_datatype dd on item.item_data_type = dd.datatype_id   WHERE t.app_id in ( SELECT app_id FROM `allinpaas_db`.paas_apps_info WHERE subs_id =  ? )   and object_type in ('1201', '2001', '2002', '2003', '2004')   and f.field_type != dd.dbms_datatype_code", new Object[0]);
        param.add(sysCode);
        if (StringUtils.isNotBlank((CharSequence)appId)) {
            sql = sql + " and t.app_id in ( SELECT app_id FROM `allinpaas_db`.paas_apps_info WHERE app_id =  ? ) ";
            param.add(appId);
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            if (rs.next()) {
                Integer obj;
                Integer n = obj = Integer.valueOf(rs.getInt(1));
                return n;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("querySysFieldTypeNum is wrong", e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return 0;
    }

    public Integer querySysFieldLengthNum(String sysCode, String appId) {
        ArrayList<String> param = new ArrayList<String>();
        String sql = String.format("SELECT    count(1)   FROM `allinrdm_db`.model_table_field f join `allinrdm_db`.model_table_info t on f.object_id = t.object_id   join `allinrdm_db`.dict_item_info item on f.item_id = item.item_id   WHERE t.app_id in ( SELECT app_id FROM `allinpaas_db`.paas_apps_info WHERE subs_id =  ? )   and object_type in ('1201', '2001', '2002', '2003', '2004')   and (f.FIELD_LENGTH != item.item_data_length or f.field_precision != item.item_data_precision)", new Object[0]);
        param.add(sysCode);
        if (StringUtils.isNotBlank((CharSequence)appId)) {
            sql = sql + " and t.app_id in ( SELECT app_id FROM `allinpaas_db`.paas_apps_info WHERE app_id =  ? ) ";
            param.add(appId);
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            if (rs.next()) {
                Integer obj;
                Integer n = obj = Integer.valueOf(rs.getInt(1));
                return n;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("querySysFieldLengthNum is wrong", e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return 0;
    }

    public Integer querySysFieldCNNum(String sysCode, String appId) {
        ArrayList<String> param = new ArrayList<String>();
        String sql = String.format("SELECT    count(1)   FROM `allinrdm_db`.model_table_field f join `allinrdm_db`.model_table_info t on f.object_id = t.object_id   join `allinrdm_db`.dict_item_info item on f.item_id = item.item_id   WHERE t.app_id in ( SELECT app_id FROM `allinpaas_db`.paas_apps_info WHERE subs_id =  ? )   and object_type in ('1201', '2001', '2002', '2003', '2004')   and f.field_name != item.item_name", new Object[0]);
        param.add(sysCode);
        if (StringUtils.isNotBlank((CharSequence)appId)) {
            sql = sql + " and t.app_id in ( SELECT app_id FROM `allinpaas_db`.paas_apps_info WHERE app_id =  ? ) ";
            param.add(appId);
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            if (rs.next()) {
                Integer obj;
                Integer n = obj = Integer.valueOf(rs.getInt(1));
                return n;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("querySysFieldCNNum is wrong", e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return 0;
    }

    public Integer querySysFieldStdFlagNum(String sysCode, String appId) {
        ArrayList<String> param = new ArrayList<String>();
        String sql = String.format("SELECT    count(1)   FROM `allinrdm_db`.model_table_field f join `allinrdm_db`.model_table_info t on f.object_id = t.object_id   join `allinrdm_db`.dict_item_info item on f.item_id = item.item_id   WHERE t.app_id in ( SELECT app_id FROM `allinpaas_db`.paas_apps_info WHERE subs_id =  ? )   and object_type in ('1201', '2001', '2002', '2003', '2004')   and ifnull(f.data_std_flag, '') = 'Y' ", new Object[0]);
        param.add(sysCode);
        if (StringUtils.isNotBlank((CharSequence)appId)) {
            sql = sql + " and t.app_id in ( SELECT app_id FROM `allinpaas_db`.paas_apps_info WHERE app_id =  ? ) ";
            param.add(appId);
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            if (rs.next()) {
                Integer obj;
                Integer n = obj = Integer.valueOf(rs.getInt(1));
                return n;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("querySysFieldStdFlagNum is wrong", e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return 0;
    }

    public Integer querySysFieldMarkFlagNum(String sysCode, String appId) {
        ArrayList<String> param = new ArrayList<String>();
        String sql = String.format("SELECT    count(1)   FROM `allinrdm_db`.model_table_field f join `allinrdm_db`.model_table_info t on f.object_id = t.object_id   join `allinrdm_db`.dict_item_info item on f.item_id = item.item_id   WHERE t.app_id in ( SELECT app_id FROM `allinpaas_db`.paas_apps_info WHERE subs_id =  ? )   and object_type in ('1201', '2001', '2002', '2003', '2004')   and ifnull(f.data_mark_flag, '') != '' ", new Object[0]);
        param.add(sysCode);
        if (StringUtils.isNotBlank((CharSequence)appId)) {
            sql = sql + " and t.app_id in ( SELECT app_id FROM `allinpaas_db`.paas_apps_info WHERE app_id =  ? ) ";
            param.add(appId);
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            if (rs.next()) {
                Integer obj;
                Integer n = obj = Integer.valueOf(rs.getInt(1));
                return n;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("querySysFieldMarkFlagNum is wrong", e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return 0;
    }

    public List<ModelTableField> queryFieldBySysCodeByPage(final ModelTableInfo paramVO, final List<Integer> objectType) throws Exception {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("ff.*");
                this.FROM("`allinrdm_db`.model_table_field ff");
                if (StringUtils.isNotBlank((CharSequence)paramVO.getObjectId())) {
                    this.WHERE("object_id = ?");
                    param.add(paramVO.getObjectId());
                } else {
                    param.add(paramVO.getSubsId());
                    ArrayList<String> qus = new ArrayList<String>();
                    for (Integer val : objectType) {
                        qus.add("?");
                    }
                    if (StringUtils.isNotBlank((CharSequence)paramVO.getAppId())) {
                        this.WHERE(String.format("exists ( select tb.object_id from `allinrdm_db`.model_table_info tb where tb.app_id in  ( SELECT app_id FROM `allinpaas_db`.paas_apps_info WHERE subs_id = ? and app_id = ? )  and tb.object_id = ff.object_id and tb.object_type in ( %s ))", StringUtils.join((Object[])qus.toArray(new String[0]), (String)",")));
                        param.add(paramVO.getAppId());
                    } else if (StringUtils.isNotBlank((CharSequence)paramVO.getBizDbName())) {
                        this.WHERE(String.format("exists ( select tb.object_id from `allinrdm_db`.model_table_info tb where tb.app_id in  ( SELECT app_id FROM `allinpaas_db`.paas_apps_info WHERE subs_id = ? and biz_db_name = ? )  and tb.object_id = ff.object_id and tb.object_type in ( %s ))", StringUtils.join((Object[])qus.toArray(new String[0]), (String)",")));
                        param.add(paramVO.getBizDbName());
                    } else {
                        this.WHERE(String.format("exists ( select tb.object_id from `allinrdm_db`.model_table_info tb where tb.app_id in  ( SELECT app_id FROM `allinpaas_db`.paas_apps_info WHERE subs_id = ? )  and tb.object_id = ff.object_id and tb.object_type in ( %s ))", StringUtils.join((Object[])qus.toArray(new String[0]), (String)",")));
                    }
                    for (Integer val : objectType) {
                        param.add(val);
                    }
                }
            }
        }.toString();
        this.queryTotalRecord(sql, paramVO, param);
        paramVO.checkAndSetPageInfo();
        String limitSql = this.buildPageSql(paramVO, sql);
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<ModelTableField> list = new ArrayList<ModelTableField>();
        try {
            ps = this.conn.prepareStatement(limitSql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                ModelTableField bean = (ModelTableField)((Object)POJOUtils.generatePOJO((ResultSet)rs, ModelTableField.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("query queryFieldBySysCodeByPage is wrong" + e.getMessage(), e);
        }
        return list;
    }
}

