/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.dao;

import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.OsrvArrangeVar;
import com.irdstudio.allinapaas.executor.application.executor.core.util.db.ProxySQL;
import com.irdstudio.sdk.beans.core.util.POJOUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsrvArrangeVarDao {
    private static final Logger logger = LoggerFactory.getLogger(OsrvArrangeVarDao.class);
    Connection conn = null;

    public OsrvArrangeVarDao(Connection conn) {
        this.conn = conn;
    }

    public List<OsrvArrangeVar> queryOsrvArrangeVarList(final OsrvArrangeVar paramVO) throws Exception {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("*");
                this.FROM("`allinrdm_db`.osrv_arrange_var");
                if (paramVO.getSrvModelId() != null) {
                    this.WHERE("srv_model_id = ?");
                    param.add(paramVO.getSrvModelId());
                }
                if (paramVO.getTableModelId() != null) {
                    this.WHERE("table_model_id = ?");
                    param.add(paramVO.getTableModelId());
                }
                if (paramVO.getDomainVarType() != null) {
                    this.WHERE("domain_var_type = ?");
                    param.add(paramVO.getDomainVarType());
                }
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<OsrvArrangeVar> list = new ArrayList<OsrvArrangeVar>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                OsrvArrangeVar bean = (OsrvArrangeVar)((Object)POJOUtils.generatePOJO((ResultSet)rs, OsrvArrangeVar.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("query queryOsrvArrangeVarList is wrong", e);
        }
        return list;
    }

    public OsrvArrangeVar queryByDomainVarId(final String srvModelId, final String domainVarId) throws Exception {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("*");
                this.FROM("`allinrdm_db`.osrv_arrange_var");
                if (srvModelId != null) {
                    this.WHERE("srv_model_id = ?");
                    param.add(srvModelId);
                }
                if (domainVarId != null) {
                    this.WHERE("domain_var_id = ?");
                    param.add(domainVarId);
                }
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<OsrvArrangeVar> list = new ArrayList<OsrvArrangeVar>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                OsrvArrangeVar bean = (OsrvArrangeVar)((Object)POJOUtils.generatePOJO((ResultSet)rs, OsrvArrangeVar.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("queryByDomainVarId is wrong", e);
        }
        return list.isEmpty() ? null : (OsrvArrangeVar)((Object)list.get(0));
    }

    public OsrvArrangeVar queryByModelId(final String srvModelId, final String tableModelId, final String domainVarType) throws Exception {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("*");
                this.FROM("`allinrdm_db`.osrv_arrange_var");
                this.WHERE("srv_model_id = ?");
                param.add(srvModelId);
                this.WHERE("table_model_id = ?");
                param.add(tableModelId);
                this.WHERE("domain_var_type = ?");
                param.add(domainVarType);
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<OsrvArrangeVar> list = new ArrayList<OsrvArrangeVar>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                OsrvArrangeVar bean = (OsrvArrangeVar)((Object)POJOUtils.generatePOJO((ResultSet)rs, OsrvArrangeVar.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("queryByDomainVarId is wrong", e);
        }
        return list.isEmpty() ? null : (OsrvArrangeVar)((Object)list.get(0));
    }
}

