/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.dao;

import com.irdstudio.allinapaas.executor.application.executor.core.dao.AbstractPortalPageDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SCheckResult;
import com.irdstudio.allinapaas.executor.application.executor.core.util.db.ProxySQL;
import com.irdstudio.sdk.beans.core.util.POJOUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCheckResultDao
extends AbstractPortalPageDao {
    private static final Logger logger = LoggerFactory.getLogger(SCheckResultDao.class);
    Connection conn = null;

    public SCheckResultDao(Connection conn) {
        super(conn);
        this.conn = conn;
    }

    public List<SCheckResult> queryListByPage(final SCheckResult paramVO) {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("*");
                this.FROM("`allinpaas_db`.s_check_result");
                List vals = POJOUtils.getPOJOValues((Object)((Object)paramVO));
                for (Object[] val : vals) {
                    this.WHERE(String.format("%s = ?", val[0].toString()));
                    param.add(val[1]);
                }
                this.ORDER_BY("create_time asc");
            }
        }.toString();
        this.queryTotalRecord(sql, paramVO, param);
        paramVO.checkAndSetPageInfo();
        String limitSql = this.buildPageSql(paramVO, sql);
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<SCheckResult> list = new ArrayList<SCheckResult>();
        try {
            ps = this.conn.prepareStatement(limitSql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                SCheckResult bean = (SCheckResult)((Object)POJOUtils.generatePOJO((ResultSet)rs, SCheckResult.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("queryListByPage is wrong", e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return list;
    }

    public List<SCheckResult> queryList(final SCheckResult paramVO) throws Exception {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("*");
                this.FROM("`allinpaas_db`.s_check_result");
                List vals = POJOUtils.getPOJOValues((Object)((Object)paramVO));
                for (Object[] val : vals) {
                    this.WHERE(String.format("%s = ?", val[0].toString()));
                    param.add(val[1]);
                }
                this.ORDER_BY("create_time asc");
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<SCheckResult> list = new ArrayList<SCheckResult>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                SCheckResult bean = (SCheckResult)((Object)POJOUtils.generatePOJO((ResultSet)rs, SCheckResult.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("queryList is wrong", e);
        }
        return list;
    }

    public SCheckResult queryByPk(final String serialNo, final String ruleId) throws SQLException {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("*");
                this.FROM("`allinpaas_db`.s_check_result");
                this.WHERE("serial_no = ?");
                param.add(serialNo);
                this.WHERE("rule_id = ?");
                param.add(ruleId);
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<SCheckResult> list = new ArrayList<SCheckResult>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                SCheckResult bean = (SCheckResult)((Object)POJOUtils.generatePOJO((ResultSet)rs, SCheckResult.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("query queryByPk is wrong", e);
        }
        return list.isEmpty() ? null : (SCheckResult)((Object)list.get(0));
    }

    public boolean insert(final SCheckResult obj) throws SQLException {
        SCheckResult checkObj = this.queryByPk(obj.getSerialNo(), obj.getRuleId());
        if (checkObj != null) {
            int num = this.updateByPk(obj);
            return num == 1;
        }
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.INSERT_INTO("`allinpaas_db`.s_check_result");
                List vals = POJOUtils.getPOJOValues((Object)((Object)obj));
                for (Object[] val : vals) {
                    this.VALUES(val[0].toString(), "?");
                    param.add(val[1]);
                }
            }
        }.toString();
        PreparedStatement ps = null;
        Object rs = null;
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            int re = ps.executeUpdate();
            if (re == 1) {
                return true;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("insert is wrong", e);
        }
        return false;
    }

    public int deleteByPk(final String serialNo, final String ruleId) throws SQLException {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.DELETE_FROM("`allinpaas_db`.s_check_result");
                this.WHERE("serial_no = ?");
                param.add(serialNo);
                this.WHERE("rule_id = ?");
                param.add(ruleId);
            }
        }.toString();
        PreparedStatement ps = null;
        Object rs = null;
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            int re = ps.executeUpdate();
            return re;
        }
        catch (Exception e) {
            throw new RuntimeException("deleteByPk is wrong", e);
        }
    }

    public int updateByPk(final SCheckResult field) throws SQLException {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.UPDATE("`allinpaas_db`.s_check_result");
                List vals = POJOUtils.getPOJOValues((Object)((Object)field));
                for (Object[] val : vals) {
                    if (val[0].toString().equals("serial_no") || val[0].toString().equals("rule_id")) continue;
                    this.SET(String.format("%s = ?", val[0].toString()));
                    param.add(val[1]);
                }
                this.WHERE("serial_no = ?");
                param.add(field.getSerialNo());
                this.WHERE("rule_id = ?");
                param.add(field.getRuleId());
            }
        }.toString();
        if (param.size() < 2) {
            return 0;
        }
        PreparedStatement ps = null;
        Object rs = null;
        int result = 0;
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            result = ps.executeUpdate();
        }
        catch (Exception e) {
            throw new RuntimeException("updateByPk is wrong", e);
        }
        return result;
    }

    public Integer queryFailNum(final String serialNo, final String ruleId) throws SQLException {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("count(1) as failNum");
                this.FROM("`allinpaas_db`.s_check_result_dtl");
                this.WHERE("serial_no = ?");
                param.add(serialNo);
                this.WHERE("rule_id = ?");
                param.add(ruleId);
                this.WHERE("check_result = 'F'");
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        Integer num = 0;
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            if (rs.next()) {
                num = rs.getInt("failNum");
            }
        }
        catch (Exception e) {
            throw new RuntimeException("queryFailNum is wrong", e);
        }
        return num;
    }
}

