/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.dao;

import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.IsrvSqlCond;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SrvEvalFunc;
import com.irdstudio.allinapaas.executor.application.executor.core.util.db.ProxySQL;
import com.irdstudio.sdk.beans.core.util.POJOUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SrvEvalFuncDao {
    private static final Logger logger = LoggerFactory.getLogger(SrvEvalFuncDao.class);
    Connection conn = null;

    public SrvEvalFuncDao(Connection conn) {
        this.conn = conn;
    }

    public List<SrvEvalFunc> querySrvEvalFuncList(final SrvEvalFunc paramVO) throws Exception {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("*");
                this.FROM("`allinrdm_db`.srv_eval_func");
                if (paramVO.getTargetRecordKeyid() != null) {
                    this.WHERE("target_record_keyid = ?");
                    param.add(paramVO.getTargetRecordKeyid());
                }
                if (paramVO.getFuncFieldId() != null) {
                    this.WHERE("func_field_id = ?");
                    param.add(paramVO.getFuncFieldId());
                }
                this.ORDER_BY("field_order");
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<SrvEvalFunc> list = new ArrayList<SrvEvalFunc>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                SrvEvalFunc bean = (SrvEvalFunc)((Object)POJOUtils.generatePOJO((ResultSet)rs, SrvEvalFunc.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("query querySrvEvalFuncList is wrong", e);
        }
        return list;
    }

    public List<SrvEvalFunc> querySrvEvalFuncList(final String targetRecordKeyid) throws Exception {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("*");
                this.FROM("`allinrdm_db`.srv_eval_func");
                this.WHERE("target_record_keyid = ?");
                param.add(targetRecordKeyid);
                this.ORDER_BY("field_order");
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<SrvEvalFunc> list = new ArrayList<SrvEvalFunc>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                SrvEvalFunc bean = (SrvEvalFunc)((Object)POJOUtils.generatePOJO((ResultSet)rs, SrvEvalFunc.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("query querySrvEvalFuncList is wrong", e);
        }
        return list;
    }

    public List<SrvEvalFunc> querySrvEvalFuncList(final String srvModelId, final Class<?> relateTbCls) throws Exception {
        String className = relateTbCls.getSimpleName();
        className = StringUtils.uncapitalize((String)className);
        final String tableName = POJOUtils.javaPropToColName((String)className);
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                String rpk = "record_keyid";
                if (relateTbCls == IsrvSqlCond.class) {
                    rpk = "cond_id";
                }
                this.SELECT("*");
                this.FROM("`allinrdm_db`.srv_eval_func");
                this.WHERE(String.format("exists ( select %s from %s where %s = target_record_keyid and srv_model_id = ?)", rpk, tableName, rpk));
                param.add(srvModelId);
                this.ORDER_BY("field_order");
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<SrvEvalFunc> list = new ArrayList<SrvEvalFunc>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                SrvEvalFunc bean = (SrvEvalFunc)((Object)POJOUtils.generatePOJO((ResultSet)rs, SrvEvalFunc.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("query querySrvEvalFuncList is wrong", e);
        }
        return list;
    }
}

