/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.datajob;

import com.irdstudio.allinapaas.executor.application.executor.core.plugin.datajob.PluginJobConf;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginJobConfDao {
    private static final Logger logger = LoggerFactory.getLogger(PluginJobConfDao.class);
    Connection conn = null;

    public PluginJobConfDao(Connection conn) {
        this.conn = conn;
    }

    public PluginJobConf queryWithKeys(String pluginConfId, int confSort) throws SQLException {
        PluginJobConf dc = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("SELECT * FROM plugin_job_conf WHERE plugin_conf_id=?,conf_sort=?");
            ps.setString(1, pluginConfId);
            ps.setInt(2, confSort);
            rs = ps.executeQuery();
            if (rs.next()) {
                dc = new PluginJobConf();
                dc.setPluginConfId(rs.getString("plugin_conf_id"));
                dc.setConfSort(rs.getInt("conf_sort"));
                dc.setJobName(rs.getString("job_name"));
                dc.setParamGroupId(rs.getString("param_group_id"));
                dc.setJobImplement(rs.getString("job_implement"));
                dc.setSqlPurpose(rs.getString("sql_purpose"));
                dc.setSqlContent(rs.getString("sql_content"));
                dc.setJobFaildDeal(rs.getString("job_faild_deal"));
                dc.setLastModifyDate(rs.getString("last_modify_date"));
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("queryPluginJobConfWithKeys is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return dc;
    }

    public List<PluginJobConf> queryWithPluginConfId(String pluginConfId) throws SQLException {
        ArrayList<PluginJobConf> dcList = new ArrayList<PluginJobConf>();
        PluginJobConf dc = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("SELECT * FROM plugin_job_conf WHERE plugin_conf_id=? order by conf_sort");
            ps.setString(1, pluginConfId);
            rs = ps.executeQuery();
            while (rs.next()) {
                dc = new PluginJobConf();
                dc.setPluginConfId(rs.getString("plugin_conf_id"));
                dc.setConfSort(rs.getInt("conf_sort"));
                dc.setJobName(rs.getString("job_name"));
                dc.setParamGroupId(rs.getString("param_group_id"));
                dc.setJobImplement(rs.getString("job_implement"));
                dc.setSqlPurpose(rs.getString("sql_purpose"));
                dc.setSqlContent(rs.getString("sql_content"));
                dc.setJobFaildDeal(rs.getString("job_faild_deal"));
                dc.setLastModifyDate(rs.getString("last_modify_date"));
                dcList.add(dc);
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("queryPluginJobConfWithKeys is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return dcList;
    }

    protected void close(ResultSet theRs, Statement theStmt, PreparedStatement thePs) {
        try {
            if (theRs != null) {
                theRs.close();
            }
            if (theStmt != null) {
                theStmt.close();
            }
            if (thePs != null) {
                thePs.close();
            }
        }
        catch (SQLException e) {
            logger.error(e.getMessage());
        }
    }
}

