/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.deliver;

import com.irdstudio.allinapaas.executor.application.executor.core.dao.BatBatchInfoConfigDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.BatInstBatchDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsParamDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasDeployInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEcsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEnvInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEnvParamDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.BatBatchInfoConfig;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.BatInstBatch;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasDeployInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasEcsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasEnvInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasEnvParam;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.AbstractPlugin;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.apps.SdEnvUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.common.SSubsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.common.SSubsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.util.date.CurrentDateUtil;
import com.irdstudio.allintcp.sdk.sequence.facade.operation.SeqInstInfoService;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import com.irdstudio.sdk.beans.ssh.io.SSHOutputPrinter;
import com.irdstudio.sdk.beans.ssh.utils.RemoteSSHClient;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class MiddleAppConfigFileDeployPlugin
extends AbstractPlugin {
    private BatInstBatch opsLog;
    private PaasAppsInfo appInfo = null;
    protected SSubsInfo sSubsInfo = null;
    protected PaasEnvInfo envInfo = null;
    private Map<String, Object> extParam;
    private String actionId;
    private String actionShell;
    private String envId;
    protected SSHOutputPrinter sshPrinter = new SSHOutputPrinter(){

        public void print(String line) {
            if (MiddleAppConfigFileDeployPlugin.this.logger != null) {
                MiddleAppConfigFileDeployPlugin.this.logger.info(line);
            } else {
                System.out.println(line);
            }
        }

        public void printError(String line) {
            if (MiddleAppConfigFileDeployPlugin.this.logger != null) {
                MiddleAppConfigFileDeployPlugin.this.logger.error(line);
            } else {
                System.err.println(line);
            }
        }
    };

    @Override
    protected boolean doReadConfigureFromDB(Connection conn, String szConfIdentify) throws SQLException {
        String batchSerialNo = this.context.getSzBatchSn();
        BatInstBatchDao batInstBatchDao = new BatInstBatchDao(conn);
        SSubsInfoDao sSubsInfoDao = new SSubsInfoDao(conn);
        PaasEnvInfoDao paasEnvInfoDao = new PaasEnvInfoDao(conn);
        BatBatchInfoConfigDao batBatchInfoConfigDao = new BatBatchInfoConfigDao(conn);
        this.opsLog = batInstBatchDao.queryByBatchSerialNo(batchSerialNo);
        BatBatchInfoConfig batchInfo = batBatchInfoConfigDao.queryWithKeys(this.opsLog.getBatchId());
        PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
        this.appInfo = paasAppsInfoDao.queryByAppId(this.opsLog.getAppId());
        this.sSubsInfo = sSubsInfoDao.querySSubsInfoWithKeys(this.appInfo.getSubsId());
        this.extParam = batInstBatchDao.getExtParam(this.opsLog);
        this.actionId = MapUtils.getString(this.extParam, (Object)"actionId");
        this.actionShell = MapUtils.getString(this.extParam, (Object)"actionShell");
        this.envId = this.opsLog.getEnvId();
        String currEnvId = this.opsLog.getEnvId();
        this.envInfo = paasEnvInfoDao.queryByPk(currEnvId);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        boolean flag = true;
        Connection conn = null;
        try {
            File configFile;
            conn = this.getPluginConnection();
            PaasAppsParamDao paasAppsParamDao = new PaasAppsParamDao(conn);
            Map<String, Object> appsParam = paasAppsParamDao.queryAppParamMap(this.appInfo.getAppId(), this.envId);
            String configFileName = MapUtils.getString(appsParam, (Object)"config.file.name");
            String configFilePath = MapUtils.getString(appsParam, (Object)"config.file.path");
            String appCode = SdEnvUtil.wrapperAppCode(this.appInfo.getAppCode());
            String filePath = SdEnvUtil.PROJECT_PATH + File.separator + this.appInfo.getAppCode() + File.separator + configFileName;
            PaasEcsInfoDao paasEcsInfoDao = new PaasEcsInfoDao(conn);
            PaasEnvParamDao paasEnvParamDao = new PaasEnvParamDao(conn);
            PaasEnvInfoDao paasEnvInfoDao = new PaasEnvInfoDao(conn);
            BatInstBatchDao batInstBatchDao = new BatInstBatchDao(conn);
            BatInstBatch batInstBatch = batInstBatchDao.queryByBatchSerialNo(this.context.getSzBatchSn());
            String currEnvId = batInstBatch.getEnvId();
            PaasEnvInfo envInfo = paasEnvInfoDao.queryByPk(currEnvId);
            PaasEnvParam deployRoot = paasEnvParamDao.queryByCode("deploy_root", currEnvId);
            String deployRootDir = this.getDeployRootDir(deployRoot.getParamValue());
            PaasEcsInfo ecsInfo = this.getEcsInfo(paasEcsInfoDao);
            this.logger.info("\u767b\u9646\u670d\u52a1\u5668 " + ecsInfo.getEcsIp());
            RemoteSSHClient client = new RemoteSSHClient(ecsInfo.getEcsIp(), ecsInfo.getEcsLoginUser(), ecsInfo.getEcsLoginPwd());
            boolean loginFlag = client.connect();
            if (!loginFlag) {
                this.logger.error("\u767b\u9646\u670d\u52a1\u5668\u5931\u8d25");
                throw new RuntimeException("\u767b\u9646\u670d\u52a1\u5668\u5931\u8d25");
            }
            String remoteConfigPath = configFilePath;
            if (!StringUtils.startsWith((CharSequence)remoteConfigPath, (CharSequence)"/")) {
                remoteConfigPath = deployRootDir + "/" + appCode + "/" + configFilePath;
            }
            this.logger.info("\u914d\u7f6e\u6587\u4ef6\u90e8\u7f72\u8def\u5f84 " + remoteConfigPath + "/" + configFileName);
            if (!client.fileExists(remoteConfigPath)) {
                client.executeCommand("mkdir -p " + remoteConfigPath, this.sshPrinter);
            }
            if ((configFile = new File(filePath)).exists()) {
                client.upload(configFile.getAbsolutePath(), remoteConfigPath);
            } else {
                this.logger.error("\u914d\u7f6e\u6587\u4ef6\u4e0d\u5b58\u5728 " + filePath);
                flag = false;
            }
            String opsPath = this.getTemplatePath(conn);
            String deployConfigShell = opsPath + File.separator + "deployConfig.sh";
            File deployConfigFile = new File(deployConfigShell);
            if (!deployConfigFile.exists()) {
                this.logger.error("deployConfig\u4e0d\u5b58\u5728\uff0c \u914d\u7f6e\u65e0\u6cd5\u751f\u6548");
            }
            client.upload(deployConfigFile.getAbsolutePath(), deployRootDir + "/" + appCode + "/");
            client.executeCommand(String.format("chmod 777 %s/deployConfig.sh", deployRootDir + "/" + appCode), this.sshPrinter);
            client.executeCommand(String.format("bash %s/deployConfig.sh %s", deployRootDir + "/" + appCode, deployRootDir + "/" + appCode), this.sshPrinter);
            if (conn.isClosed()) {
                try {
                    this.closePluginConnection(conn);
                }
                catch (Exception e) {
                    this.logger.error("\u6570\u636e\u5e93\u8fde\u63a5\u5173\u95ed\u5f02\u5e38" + e.getMessage());
                }
                conn = this.getPluginConnection();
            }
            PaasDeployInfoDao paasDeployInfoDao = new PaasDeployInfoDao(conn);
            this.updateDeployPath(this.envId, this.appInfo, ecsInfo, deployRootDir + "/" + appCode, paasDeployInfoDao);
        }
        catch (Exception e) {
            this.logger.error("\u751f\u6210\u4e2d\u95f4\u4ef6\u5e94\u7528\u914d\u7f6e\u6587\u4ef6" + e.getMessage(), e);
            flag = false;
        }
        finally {
            if (conn != null) {
                this.closePluginConnection(conn);
            }
        }
        return flag;
    }

    private String getDeployRootDir(String deployRootDir) {
        if (deployRootDir == null) {
            deployRootDir = "/agent";
        }
        return deployRootDir;
    }

    private PaasEcsInfo getEcsInfo(PaasEcsInfoDao paasEcsInfoDao) throws Exception {
        if (this.appInfo != null) {
            PaasEcsInfo ecsParam = new PaasEcsInfo();
            ecsParam.setSubsId(this.appInfo.getSubsId());
            ecsParam.setAppId(this.appInfo.getAppId());
            ecsParam.setEnvId(this.opsLog.getEnvId());
            List<PaasEcsInfo> ecsList = paasEcsInfoDao.queryPaasEcsInfoWithAppDu(ecsParam);
            return CollectionUtils.isEmpty(ecsList) ? null : ecsList.get(0);
        }
        return paasEcsInfoDao.queryByPk(this.opsLog.getEcsId());
    }

    private String getTemplatePath(Connection conn) {
        String srcFilePath = SdEnvUtil.TEMPLATE_PATH + File.separator + this.appInfo.getAppTemplateId() + "-template" + File.separator + this.appInfo.getAppTemplateId() + "-script";
        return srcFilePath;
    }

    public void updateDeployPath(String envId, PaasAppsInfo appInfo, PaasEcsInfo ecs, String deployPath, PaasDeployInfoDao paasDeployInfoDao) throws Exception {
        boolean flag = true;
        PaasDeployInfo deployInfo = paasDeployInfoDao.queryByAppId(appInfo.getAppId(), envId);
        if (deployInfo == null) {
            deployInfo = new PaasDeployInfo();
            flag = false;
            SeqInstInfoService seqService = (SeqInstInfoService)SpringContextUtils.getBean(SeqInstInfoService.class);
            deployInfo.setAppDeployId(seqService.nextSequence("PAAS-INST-ID", appInfo.getSubsId()));
        }
        deployInfo.setSubsId(appInfo.getSubsId());
        deployInfo.setAppId(appInfo.getAppId());
        deployInfo.setAppName(appInfo.getAppCode());
        deployInfo.setAppCnname(appInfo.getAppName());
        deployInfo.setAppVersion(appInfo.getAppVersion());
        deployInfo.setAppType(appInfo.getAppType());
        String appCode = SdEnvUtil.wrapperAppCode(this.appInfo.getAppCode());
        deployInfo.setAppDeployPath(deployPath);
        deployInfo.setEnvId(envId);
        deployInfo.setAppOrder(0);
        deployInfo.setEcsId(ecs.getEcsId());
        deployInfo.setEcsIp(ecs.getEcsIp());
        deployInfo.setEcsName(ecs.getEcsName());
        deployInfo.setEcsRegion(ecs.getEcsRegionId());
        deployInfo.setAppPort(ecs.getEcsPort());
        deployInfo.setAppState("R");
        deployInfo.setOperUserid("admin");
        deployInfo.setOperTime(CurrentDateUtil.getTodayDateEx2());
        if (flag) {
            paasDeployInfoDao.updateByPk(deployInfo);
        } else {
            paasDeployInfoDao.insertPaasDeployInfo(deployInfo);
        }
    }
}

