/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.deploy;

import com.irdstudio.allinapaas.deliver.console.facade.PluginGitConfService;
import com.irdstudio.allinapaas.deliver.console.facade.dto.PluginGitConfDTO;
import com.irdstudio.allinapaas.design.console.types.AppCategory;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.BatInstBatchDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.SUserDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.SUserProfileDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.BatInstBatch;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SUserProfile;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.AbstractPlugin;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.apps.SdEnvUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.deploy.MavenRunner;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.git.JGitUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.git.PluginGitConf;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.git.TerminalExecUtil;
import com.irdstudio.allinapaas.executor.facade.dto.ValidateRtnDTO;
import com.irdstudio.allinapaas.portal.console.facade.PaasTaskComimportService;
import com.irdstudio.allinrdm.sam.console.facade.ComDependInfoService;
import com.irdstudio.allinrdm.sam.console.facade.dto.ComDependInfoDTO;
import com.irdstudio.allinrdm.sam.console.types.ComDependType;
import com.irdstudio.sdk.beans.core.util.PropertiesUtil;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class AppComBaseStaticMavenBuildPlugin
extends AbstractPlugin {
    protected PaasAppsInfo appInfo = null;
    private BatInstBatch batchInst;
    private Map<String, Object> extParam = null;
    private PluginGitConf pluginParam = null;
    private String gitLocalPath = null;

    @Override
    public boolean validate(String batchId, String taskId, ValidateRtnDTO message) {
        PluginGitConfService service = (PluginGitConfService)SpringContextUtils.getBean(PluginGitConfService.class);
        PluginGitConfDTO param = new PluginGitConfDTO();
        param.setPluginConfId(taskId);
        param = (PluginGitConfDTO)service.queryByPk((Object)param);
        if (param == null) {
            return false;
        }
        if (StringUtils.isBlank((CharSequence)param.getUserName())) {
            message.getMessage().add("\u7528\u6237\u540d\u79f0");
        }
        if (StringUtils.isBlank((CharSequence)param.getPassword())) {
            message.getMessage().add("\u7528\u6237\u5bc6\u7801");
        }
        return CollectionUtils.isEmpty((Collection)message.getMessage());
    }

    @Override
    public boolean copyConfig(String batchId, String taskId, String newTaskId) {
        return true;
    }

    @Override
    protected boolean doReadConfigureFromDB(Connection conn, String szConfIdentify) throws SQLException {
        String batchSerialNo = this.context.getSzBatchSn();
        BatInstBatchDao batInstBatchDao = new BatInstBatchDao(conn);
        this.batchInst = batInstBatchDao.queryByBatchSerialNo(batchSerialNo);
        this.extParam = batInstBatchDao.getExtParam(this.batchInst);
        PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
        this.appInfo = paasAppsInfoDao.queryByAppId(this.batchInst.getAppId());
        this.pluginParam = new PluginGitConf();
        PluginGitConfService service = (PluginGitConfService)SpringContextUtils.getBean(PluginGitConfService.class);
        PluginGitConfDTO param = new PluginGitConfDTO();
        param.setPluginConfId(this.context.getSzTaskId());
        param = (PluginGitConfDTO)service.queryByPk((Object)param);
        if (param != null) {
            this.pluginParam.setGitRemotePath(param.getRepoUrl());
            this.pluginParam.setGitBranchName(param.getBranchName());
            if (StringUtils.isNotBlank((CharSequence)param.getUserName()) && StringUtils.isNotBlank((CharSequence)param.getPassword())) {
                this.pluginParam.setGitUserName(param.getUserName());
                this.pluginParam.setGitPassword(param.getPassword());
            } else {
                SUserProfileDao sUserProfileDao = new SUserProfileDao(conn);
                SUserDao sUserDao = new SUserDao(conn);
                String currentUserId = MapUtils.getString(this.extParam, (Object)"createUserId");
                SUserProfile userProfile = sUserProfileDao.queryByPk(currentUserId);
                if (userProfile == null || StringUtils.isBlank((CharSequence)userProfile.getGitUsername()) || !StringUtils.isNotBlank((CharSequence)userProfile.getGitPassword()) && !StringUtils.isNotBlank((CharSequence)userProfile.getGitAccessToken())) {
                    this.logger.error("************************************\u8bf7\u5728\u4e2a\u4eba\u8bbe\u7f6e\u5173\u8054git\u8d26\u53f7\u4fe1\u606f\uff01************************************");
                    return false;
                }
                this.pluginParam.setGitUserName(userProfile.getGitUsername());
                if (StringUtils.isNotBlank((CharSequence)userProfile.getGitAccessToken())) {
                    this.pluginParam.setGitPassword(userProfile.getGitAccessToken());
                } else {
                    this.pluginParam.setGitPassword(userProfile.getGitPassword());
                }
            }
        } else {
            SUserProfileDao sUserProfileDao = new SUserProfileDao(conn);
            SUserDao sUserDao = new SUserDao(conn);
            String currentUserId = MapUtils.getString(this.extParam, (Object)"createUserId");
            SUserProfile userProfile = sUserProfileDao.queryByPk(currentUserId);
            if (userProfile == null || StringUtils.isBlank((CharSequence)userProfile.getGitUsername()) || !StringUtils.isNotBlank((CharSequence)userProfile.getGitPassword()) && !StringUtils.isNotBlank((CharSequence)userProfile.getGitAccessToken())) {
                this.logger.error("************************************\u8bf7\u5728\u4e2a\u4eba\u8bbe\u7f6e\u5173\u8054git\u8d26\u53f7\u4fe1\u606f\uff01************************************");
                return false;
            }
            this.pluginParam.setGitUserName(userProfile.getGitUsername());
            if (StringUtils.isNotBlank((CharSequence)userProfile.getGitAccessToken())) {
                this.pluginParam.setGitPassword(userProfile.getGitAccessToken());
            } else {
                this.pluginParam.setGitPassword(userProfile.getGitPassword());
            }
            this.pluginParam.setGitRemotePath(this.appInfo.getAppGitUrl());
            this.pluginParam.setGitBranchName("master");
        }
        this.gitLocalPath = SdEnvUtil.BUILD_PATH;
        return true;
    }

    @Override
    public boolean execute() {
        PaasTaskComimportService paasTaskComimportService = (PaasTaskComimportService)SpringContextUtils.getBean(PaasTaskComimportService.class);
        ComDependInfoService comDependInfoService = (ComDependInfoService)SpringContextUtils.getBean(ComDependInfoService.class);
        ComDependInfoDTO comParam = new ComDependInfoDTO();
        comParam.setAppId(this.appInfo.getAppId());
        comParam.setSubsId(this.appInfo.getSubsId());
        comParam.setComDependType(ComDependType.Static.getCode());
        comParam.setMenuType(AppCategory.ComponentApp.getCode());
        List comList = comDependInfoService.queryList((Object)comParam);
        if (CollectionUtils.isNotEmpty((Collection)comList)) {
            this.logger.info(String.format("\u5e94\u7528\u7ec4\u4ef6\u6784\u5efa %s %s \u7ec4\u4ef6\u6570\u91cf\uff1a%s", this.appInfo.getAppCode(), this.appInfo.getAppName(), comList.size()));
            MavenRunner mavenRunner = new MavenRunner("mvn -DskipTests=true clean deploy -U", null, this.logger);
            mavenRunner.setMavenHome(SdEnvUtil.MAVEN_PATH);
            mavenRunner.setJavaHome(PropertiesUtil.getPropertyByKey((String)"application", (String)"tdp.maven.java.home.path"));
            mavenRunner.setSetting(PropertiesUtil.getPropertyByKey((String)"application", (String)"tdp.maven.settings.path"));
            boolean flag = true;
            for (ComDependInfoDTO com : comList) {
                if (StringUtils.isBlank((CharSequence)com.getComGitUrl())) {
                    this.logger.info(String.format("\u7ec4\u4ef6%s\u672a\u914d\u7f6e\u4ed3\u5e93\uff0c\u8df3\u8fc7\u53d1\u5e03", com.getComGitUrl()));
                    continue;
                }
                String comLocation = this.gitLocalPath + SdEnvUtil.wrapperAppCode(this.appInfo.getAppCode() + "." + com.getComFeatureCode());
                boolean re = this.repositoryCreate(comLocation, com.getComGitUrl(), this.pluginParam.getGitUserName(), this.pluginParam.getGitPassword(), this.pluginParam.getGitBranchName());
                if (re) {
                    this.logger.info("\u4ee3\u7801\u66f4\u65b0\u6210\u529f\uff0c\u672c\u5730\u66f4\u65b0\u8def\u5f84:" + this.gitLocalPath + " \u8fdc\u7a0b\u8def\u5f84\u4e3a\uff1a" + com.getComGitUrl());
                } else {
                    this.logger.info("\u4ee3\u7801\u66f4\u65b0\u5931\u8d25\uff0c\u672c\u5730\u66f4\u65b0\u8def\u5f84:" + this.gitLocalPath + " n\u8fdc\u7a0b\u8def\u5f84\u4e3a\uff1a" + com.getComGitUrl());
                }
                if (re) {
                    mavenRunner.setLocation(comLocation);
                    re = mavenRunner.run();
                }
                if (!flag) continue;
                flag = re;
            }
            return flag;
        }
        this.logger.info(String.format("\u5e94\u7528 %s %s \u672a\u4f9d\u8d56\u6709\u7ec4\u4ef6", this.appInfo.getAppCode(), this.appInfo.getAppName()));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean repositoryCreate(String localPath, String remotePath, String username, String password, String branchName) {
        if (TerminalExecUtil.isWindows()) {
            JGitUtil.shallowClone(localPath, remotePath, username, password, branchName, this.logger::info);
            return true;
        }
        try (JGitUtil jGitUtil = new JGitUtil(localPath, remotePath, username, password);){
            jGitUtil.pull(branchName);
        }
        return true;
    }
}

