/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.deploy;

import com.alibaba.fastjson.JSON;
import com.irdstudio.allinapaas.deliver.console.facade.BatBatchInfoConfigService;
import com.irdstudio.allinapaas.deliver.console.facade.PaasEcsInfoService;
import com.irdstudio.allinapaas.deliver.console.facade.PaasEnvParamService;
import com.irdstudio.allinapaas.deliver.console.facade.PluginDeployJavaService;
import com.irdstudio.allinapaas.deliver.console.facade.dto.BatBatchInfoConfigDTO;
import com.irdstudio.allinapaas.deliver.console.facade.dto.PaasEcsInfoDTO;
import com.irdstudio.allinapaas.deliver.console.facade.dto.PaasEnvParamDTO;
import com.irdstudio.allinapaas.deliver.console.facade.dto.PluginDeployJavaDTO;
import com.irdstudio.allinapaas.design.console.facade.PaasAppsParamService;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasAppsParamDTO;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.BatInstBatchDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsParamDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasDeployInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEcsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEnvInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEnvParamDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.BatInstBatch;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsParam;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasDeployInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasEcsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasEnvInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasEnvParam;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.AbstractPlugin;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.apps.SdEnvUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.common.SSubsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.common.SSubsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.deploy.AppMysqlDeployPlugin;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.docs.git.queue.AppTemplateRepoPullTask;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.git.TerminalExecUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.util.date.CurrentDateUtil;
import com.irdstudio.allinapaas.executor.facade.dto.ValidateRtnDTO;
import com.irdstudio.allinapaas.portal.console.facade.SummaryService;
import com.irdstudio.allintcp.sdk.sequence.facade.operation.SeqInstInfoService;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import com.irdstudio.sdk.beans.ssh.io.SSHOutputPrinter;
import com.irdstudio.sdk.beans.ssh.utils.RemoteSSHClient;
import java.io.File;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class AppDeployWarJarPlugin
extends AbstractPlugin {
    protected BatInstBatch batchInst = null;
    protected PaasAppsInfo appInfo = null;
    protected SSubsInfo sSubsInfo = null;
    protected PaasEnvInfo envInfo = null;
    protected Map<String, Object> extParam;
    protected String actionId;
    protected String actionShell;
    protected String paasDuId = "D000001";
    protected String ecsId = "";
    private String uploadFolder = "uploadFolder";
    protected SSHOutputPrinter sshPrinter = new SSHOutputPrinter(){

        public void print(String line) {
            if (AppDeployWarJarPlugin.this.logger != null) {
                AppDeployWarJarPlugin.this.logger.info(line);
            } else {
                System.out.println(line);
            }
        }

        public void printError(String line) {
            if (AppDeployWarJarPlugin.this.logger != null) {
                AppDeployWarJarPlugin.this.logger.error(line);
            } else {
                System.err.println(line);
            }
        }
    };

    @Override
    public boolean validate(String batchId, String taskId, ValidateRtnDTO message) {
        PluginDeployJavaService service = (PluginDeployJavaService)SpringContextUtils.getBean(PluginDeployJavaService.class);
        PluginDeployJavaDTO param = new PluginDeployJavaDTO();
        param.setPluginConfId(taskId);
        param = (PluginDeployJavaDTO)service.queryByPk((Object)param);
        if (param == null) {
            return false;
        }
        message.getMessage().addAll(param.validate());
        boolean flag = CollectionUtils.isEmpty((Collection)message.getMessage());
        if (flag) {
            BatBatchInfoConfigService batBatchInfoConfigService = (BatBatchInfoConfigService)SpringContextUtils.getBean(BatBatchInfoConfigService.class);
            BatBatchInfoConfigDTO batchInfo = new BatBatchInfoConfigDTO();
            batchInfo.setBatchId(batchId);
            batchInfo = (BatBatchInfoConfigDTO)batBatchInfoConfigService.queryByPk((Object)batchInfo);
            if (batchInfo == null) {
                return false;
            }
            PaasEcsInfoService paasEcsInfoService = (PaasEcsInfoService)SpringContextUtils.getBean(PaasEcsInfoService.class);
            PaasEcsInfoDTO ecsParam = new PaasEcsInfoDTO();
            ecsParam.setSubsId(batchInfo.getSubsId());
            ecsParam.setAppId(batchInfo.getAppId());
            ecsParam.setEnvId(batchInfo.getEnvId());
            List ecsList = paasEcsInfoService.queryListByPage((Object)ecsParam);
            if (CollectionUtils.isEmpty((Collection)ecsList)) {
                message.getMessage().add("\u670d\u52a1\u5668\u672a\u914d\u7f6e");
                flag = false;
            }
        }
        return flag;
    }

    @Override
    public boolean copyConfig(String batchId, String taskId, String newTaskId) {
        PluginDeployJavaService service = (PluginDeployJavaService)SpringContextUtils.getBean(PluginDeployJavaService.class);
        PluginDeployJavaDTO param = new PluginDeployJavaDTO();
        param.setPluginConfId(taskId);
        param = (PluginDeployJavaDTO)service.queryByPk((Object)param);
        if (param == null) {
            return true;
        }
        param.setPluginConfId(newTaskId);
        int re = service.insert((Object)param);
        return re == 1;
    }

    @Override
    protected boolean doReadConfigureFromDB(Connection conn, String szConfIdentify) throws SQLException {
        String batchSerialNo = this.context.getSzBatchSn();
        PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
        BatInstBatchDao batInstBatchDao = new BatInstBatchDao(conn);
        SSubsInfoDao sSubsInfoDao = new SSubsInfoDao(conn);
        this.batchInst = batInstBatchDao.queryByBatchSerialNo(batchSerialNo);
        this.appInfo = paasAppsInfoDao.queryByAppId(this.batchInst.getAppId());
        this.sSubsInfo = sSubsInfoDao.querySSubsInfoWithKeys(this.appInfo.getSubsId());
        this.extParam = batInstBatchDao.getExtParam(this.batchInst);
        this.actionId = MapUtils.getString(this.extParam, (Object)"actionId");
        this.actionShell = MapUtils.getString(this.extParam, (Object)"actionShell");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deployDB() {
        AppMysqlDeployPlugin plugin = new AppMysqlDeployPlugin();
        plugin.setPluginContext(this.context);
        Connection conn = null;
        try {
            conn = this.getPluginConnection();
            plugin.doReadConfigureFromDB(conn, this.context.getSzBatchSn());
            boolean bl = plugin.execute();
            return bl;
        }
        catch (Exception e) {
            this.logger.error("\u6267\u884c\u6570\u636e\u5e93\u90e8\u7f72\u5931\u8d25" + e.getMessage(), e);
        }
        finally {
            if (conn != null) {
                this.closePluginConnection(conn);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        boolean dbFlag = this.deployDB();
        if (!dbFlag) {
            return dbFlag;
        }
        this.logger.info("\u90e8\u7f72JAR\u5e94\u7528\u670d\u52a1\u5668\uff0c\u90e8\u7f72\u5e94\u7528:" + this.appInfo.getAppCode());
        Connection conn = null;
        try {
            conn = this.getPluginConnection();
            PaasEnvInfoDao paasEnvInfoDao = new PaasEnvInfoDao(conn);
            String currEnvId = this.batchInst.getEnvId();
            this.envInfo = paasEnvInfoDao.queryByPk(currEnvId);
            PaasDeployInfoDao paasDeployInfoDao = new PaasDeployInfoDao(conn);
            PaasEcsInfoDao paasEcsInfoDao = new PaasEcsInfoDao(conn);
            PaasAppsParamDao paasAppsParamDao = new PaasAppsParamDao(conn);
            PaasAppsParam moduleParam = paasAppsParamDao.queryPaasAppsParamByCode(this.appInfo.getAppId(), "module");
            PaasAppsParam targetFileParam = paasAppsParamDao.queryPaasAppsParamByCode(this.appInfo.getAppId(), "targetFile");
            String antTargetFile = targetFileParam != null ? targetFileParam.getParamValue() : null;
            PaasAppsParam jvmOpsParam = paasAppsParamDao.queryPaasAppsParamByCode(this.appInfo.getAppId(), "jvm");
            String jvmOps = "-Xms128M -Xmx1024M -XX:PermSize=2048m -XX:MaxPermSize=2048m";
            if (jvmOpsParam != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)jvmOpsParam.getParamValue())) {
                jvmOps = jvmOpsParam.getParamValue();
            }
            PaasEnvParamDao paasEnvParamDao = new PaasEnvParamDao(conn);
            PaasEnvParam deployRoot = paasEnvParamDao.queryByCode("deploy_root", currEnvId);
            String deployRootDir = deployRoot.getParamValue();
            PaasAppsParam deployParam = paasAppsParamDao.queryPaasAppsParamByCode(this.appInfo.getAppId(), "deploy_type");
            if (deployParam == null) {
                deployParam = new PaasAppsParam();
                deployParam.setParamValue("jar");
            }
            String deployType = deployParam.getParamValue();
            PluginDeployJavaService service = (PluginDeployJavaService)SpringContextUtils.getBean(PluginDeployJavaService.class);
            PluginDeployJavaDTO param = new PluginDeployJavaDTO();
            param.setPluginConfId(this.context.getSzTaskId());
            param = (PluginDeployJavaDTO)service.queryByPk((Object)param);
            if (param != null) {
                if (moduleParam == null) {
                    moduleParam = new PaasAppsParam();
                }
                moduleParam.setParamValue(param.getModule());
                jvmOps = param.getJvmConf();
                deployType = param.getDeployType();
            }
            AppTemplateRepoPullTask templateRepoPullTask = new AppTemplateRepoPullTask(this.appInfo.getAppTemplateId());
            templateRepoPullTask.syncRun();
            PaasEcsInfo ecsParam = new PaasEcsInfo();
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.ecsId)) {
                ecsParam.setEcsId(this.ecsId);
            } else {
                ecsParam.setSubsId(this.appInfo.getSubsId());
                ecsParam.setAppId(this.appInfo.getAppId());
                ecsParam.setEnvId(currEnvId);
            }
            List<PaasEcsInfo> ecsList = paasEcsInfoDao.queryPaasEcsInfo(ecsParam);
            for (PaasEcsInfo paasEcsInfo : ecsList) {
                this.logger.info(String.format("\u5f00\u59cb\u90e8\u7f72\u5e94\u7528%s\u5230\u670d\u52a1\u5668%s,\u7aef\u53e3%s", paasEcsInfo.getAppName(), paasEcsInfo.getEcsIp(), paasEcsInfo.getEcsPort()));
                boolean flag = true;
                flag = org.apache.commons.lang3.StringUtils.equals((CharSequence)deployType, (CharSequence)"jar") ? this.deployJar(paasEcsInfo, moduleParam, jvmOps, antTargetFile, deployRootDir, currEnvId, paasDeployInfoDao, conn) : (org.apache.commons.lang3.StringUtils.equals((CharSequence)deployType, (CharSequence)"jar-with-dependencies") ? this.deployJarWithDependencies(paasEcsInfo, moduleParam, jvmOps, deployRootDir, currEnvId, paasDeployInfoDao, conn) : (org.apache.commons.lang3.StringUtils.equals((CharSequence)deployType, (CharSequence)"jar-with-config") ? this.deployJarWithConfig(paasEcsInfo, moduleParam, jvmOps, deployRootDir, currEnvId, paasDeployInfoDao, conn) : (org.apache.commons.lang3.StringUtils.equals((CharSequence)deployType, (CharSequence)"jar-with-zip") ? this.deployJarWithZip(paasEcsInfo, moduleParam, jvmOps, antTargetFile, deployRootDir, currEnvId, paasDeployInfoDao, conn) : (org.apache.commons.lang3.StringUtils.equals((CharSequence)deployType, (CharSequence)"cas") ? this.deployCasWarWithConfig(paasEcsInfo, moduleParam, jvmOps, deployRootDir, currEnvId, paasDeployInfoDao, conn) : this.deployWar(paasEcsInfo, moduleParam, jvmOps, antTargetFile, deployRootDir, currEnvId, paasDeployInfoDao, conn)))));
                if (flag) continue;
                boolean bl = flag;
                return bl;
            }
            PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
            this.appInfo.setAppActionState("DPL");
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.appInfo.getAppVersion())) {
                String version = this.appInfo.getAppVersion();
                Object[] versions = org.apache.commons.lang3.StringUtils.split((String)version, (String)".");
                versions[versions.length - 1] = String.valueOf(Integer.valueOf(versions[versions.length - 1]) + 1);
                version = org.apache.commons.lang3.StringUtils.join((Object[])versions, (String)".");
                this.appInfo.setAppVersion(version);
            } else {
                this.appInfo.setAppVersion("0.0.1");
            }
            paasAppsInfoDao.updateByPk(this.appInfo);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (conn != null) {
                this.closePluginConnection(conn);
            }
        }
        return true;
    }

    private boolean cleanBuildDir() {
        String rootPath = this.context.getBatBatchSource().getRepoLocalPath();
        String appCode = SdEnvUtil.wrapperAppCode(this.appInfo.getAppCode());
        File targetDir = new File(rootPath + File.separator + appCode + File.separator);
        return FileUtils.deleteQuietly((File)targetDir);
    }

    public boolean deployWar(PaasEcsInfo paasEcsInfo, PaasAppsParam moduleParam, String jvmOps, String antTargetFile, String deployRootDir, String currEnvId, PaasDeployInfoDao paasDeployInfoDao, Connection conn) throws Exception {
        int port = Integer.valueOf(paasEcsInfo.getEcsPort());
        this.logger.info(String.format("\u5f00\u59cb\u90e8\u7f72\u5e94\u7528%s\u5230\u670d\u52a1\u5668%s,\u7aef\u53e3%s", paasEcsInfo.getAppName(), paasEcsInfo.getEcsIp(), port));
        RemoteSSHClient rsc = new RemoteSSHClient(paasEcsInfo.getEcsIp(), paasEcsInfo.getEcsLoginUser(), paasEcsInfo.getEcsLoginPwd());
        boolean loginFlag = rsc.connect();
        if (!loginFlag) {
            this.logger.error("\u767b\u9646\u670d\u52a1\u5668\u5931\u8d25");
            return loginFlag;
        }
        String opsPath = SdEnvUtil.getTemplateScriptPath(this.appInfo);
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)opsPath)) {
            this.logger.error("\u65e0\u6cd5\u83b7\u53d6\u8fd0\u7ef4\u6a21\u677f\u6240\u5728\u76ee\u5f55\uff0c\u8bf7\u68c0\u67e5\u8fd0\u7ef4\u6a21\u677f\u4ed3\u5e93\u914d\u7f6e");
            return false;
        }
        String localAgentPath = opsPath + File.separator;
        if (!rsc.fileExists(deployRootDir)) {
            rsc.executeCommand("mkdir -p " + deployRootDir, this.sshPrinter);
        }
        if (!rsc.fileExists(deployRootDir + "/apache-tomcat-8.0.36.tar.gz")) {
            String tomcatPath = opsPath + File.separator + "install" + File.separator + "tomcat" + File.separator;
            rsc.upload(tomcatPath + "apache-tomcat-8.0.36.tar.gz", deployRootDir);
        }
        if (!rsc.fileExists(deployRootDir + "/startTomcatApp.sh")) {
            rsc.upload(localAgentPath + "startTomcatApp.sh", deployRootDir);
            rsc.executeCommand("chmod 777 " + deployRootDir + "/startTomcatApp.sh", this.sshPrinter);
        }
        String rootPath = this.context.getBatBatchSource().getRepoLocalPath();
        String appCode = SdEnvUtil.wrapperAppCode(this.appInfo.getAppCode());
        File uploadDir = new File(rootPath, this.uploadFolder);
        if (!uploadDir.exists()) {
            uploadDir.mkdirs();
        }
        File warFile = null;
        warFile = org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)antTargetFile) ? new File(appCode, antTargetFile) : this.searchTargetWarFile(rootPath, appCode, moduleParam);
        if (warFile == null || !warFile.exists()) {
            this.logger.error("\u83b7\u53d6\u4e0d\u5230jar " + rootPath + File.separator + appCode);
            return false;
        }
        FileUtils.copyFile((File)warFile, (File)new File(uploadDir, warFile.getName()));
        String startModelName = warFile.getName().substring(0, warFile.getName().length() - 4);
        this.logger.info("\u672c\u5730war\u5305: " + warFile);
        rsc.upload(warFile.toString(), deployRootDir);
        this.logger.info("\u6267\u884c\u547d\u4ee4 " + deployRootDir + String.format("/startTomcatApp.sh %s '%s' %s", startModelName, jvmOps, port));
        String appStartCommand = "cd " + deployRootDir + String.format(" && nohup ./startTomcatApp.sh %s '%s' %s > /dev/null &", startModelName, jvmOps, port);
        int status = rsc.executeCommand(appStartCommand, this.sshPrinter);
        if (status != 0) {
            this.logger.info("\u6267\u884c\u53d1\u5e03\u547d\u4ee4 " + deployRootDir + "/startTomcatApp.sh \u72b6\u6001 " + status);
            return false;
        }
        if (conn.isClosed()) {
            this.closePluginConnection(conn);
            conn = this.getPluginConnection();
            paasDeployInfoDao = new PaasDeployInfoDao(conn);
        }
        this.updateDeployPath(currEnvId, this.appInfo, paasEcsInfo, startModelName, deployRootDir + "/" + startModelName + "/webapps/" + startModelName + ".war", appStartCommand, null, paasDeployInfoDao);
        return true;
    }

    public String requestOpenApi(String url, Object param) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpPost postMethod = new HttpPost(url);
        HttpResponse response = null;
        try {
            String reqJson = JSON.toJSONString((Object)param);
            StringEntity entity = new StringEntity(reqJson, ContentType.APPLICATION_JSON);
            postMethod.setEntity((HttpEntity)entity);
            response = httpClient.execute((HttpUriRequest)postMethod);
            String json = EntityUtils.toString((HttpEntity)response.getEntity());
            return json;
        }
        catch (IOException e) {
            e.printStackTrace();
            this.logger.error(e.getMessage(), e);
            return null;
        }
    }

    private String getAppAccessUrl(PaasAppsInfo appInfo, PaasEcsInfo ecs, String startModelName) {
        String url = "";
        String server_port = "";
        if (StringUtils.isNotBlank((String)ecs.getEcsPort())) {
            server_port = ecs.getEcsPort();
        }
        int port = Integer.valueOf(server_port);
        String serverName = "";
        String ip = ecs.getEcsOutIp();
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)ip)) {
            ip = ecs.getEcsIp();
        }
        url = String.format("http://%s:%s/%s", ip, port, serverName);
        return url;
    }

    public boolean deployJar(PaasEcsInfo paasEcsInfo, PaasAppsParam moduleParam, String jvmOps, String antTargetFile, String deployRootDir, String currEnvId, PaasDeployInfoDao paasDeployInfoDao, Connection conn) throws Exception {
        RemoteSSHClient sshClient = new RemoteSSHClient(paasEcsInfo.getEcsIp(), paasEcsInfo.getEcsLoginUser(), paasEcsInfo.getEcsLoginPwd());
        boolean loginFlag = sshClient.connect();
        if (!loginFlag) {
            this.logger.error("\u767b\u9646\u670d\u52a1\u5668\u5931\u8d25");
            return loginFlag;
        }
        String opsPath = SdEnvUtil.getTemplateScriptPath(this.appInfo);
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)opsPath)) {
            this.logger.error("\u65e0\u6cd5\u83b7\u53d6\u8fd0\u7ef4\u6a21\u677f\u6240\u5728\u76ee\u5f55\uff0c\u8bf7\u68c0\u67e5\u8fd0\u7ef4\u6a21\u677f\u4ed3\u5e93\u914d\u7f6e");
            return false;
        }
        String localAgentPath = opsPath + File.separator;
        if (!sshClient.fileExists(deployRootDir)) {
            sshClient.executeCommand("mkdir -p " + deployRootDir, this.sshPrinter);
            sshClient.upload(localAgentPath + "startJarApp.sh", deployRootDir);
            sshClient.executeCommand("chmod 777 " + deployRootDir + "/startJarApp.sh", this.sshPrinter);
        }
        if (!sshClient.fileExists(deployRootDir + "/startJarApp.sh")) {
            sshClient.upload(localAgentPath + "startJarApp.sh", deployRootDir);
            sshClient.executeCommand("chmod 777 " + deployRootDir + "/startJarApp.sh", this.sshPrinter);
        }
        String rootPath = this.context.getBatBatchSource().getRepoLocalPath();
        String appCode = SdEnvUtil.wrapperAppCode(this.appInfo.getAppCode());
        File uploadDir = new File(rootPath, this.uploadFolder);
        if (!uploadDir.exists()) {
            uploadDir.mkdirs();
        }
        File jarFile = null;
        jarFile = org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)antTargetFile) ? new File(appCode, antTargetFile) : this.searchTargetJarFile(rootPath, appCode, moduleParam);
        if (jarFile == null || !jarFile.exists()) {
            this.logger.error("\u83b7\u53d6\u4e0d\u5230jar " + rootPath + File.separator + appCode);
            return false;
        }
        FileUtils.copyFile((File)jarFile, (File)new File(uploadDir, jarFile.getName()));
        String startModelName = jarFile.getName().substring(0, jarFile.getName().length() - 4);
        String appDeployCommand = "";
        if (this.isLocalMachine(paasEcsInfo.getEcsIp()) || this.isLocalMachine(paasEcsInfo.getEcsOutIp())) {
            this.logger.info("ip\u662f\u672c\u5730\u670d\u52a1\u5668ip\uff0c \u4f7f\u7528\u672c\u5730\u547d\u4ee4\u90e8\u7f72");
            if (new File(deployRootDir, jarFile.getName()).exists()) {
                this.logger.info("\u5907\u4efd\u670d\u52a1\u5668jar: " + jarFile.getName() + ".backup");
                FileUtils.copyFile((File)new File(deployRootDir, jarFile.getName()), (File)new File(deployRootDir, jarFile.getName() + ".backup"));
            }
            FileUtils.copyFile((File)jarFile, (File)new File(deployRootDir, jarFile.getName()));
            this.batchInst.setBatchState(String.valueOf(9));
            BatInstBatchDao batInstBatchDao = new BatInstBatchDao(conn);
            batInstBatchDao.updateBatchToEnd(this.batchInst);
            appDeployCommand = "cd " + deployRootDir + String.format(" && bash ./startJarApp.sh  %s '%s'", startModelName, jvmOps);
            TerminalExecUtil.localTerminalExec(new File(deployRootDir), this.logger::info, appDeployCommand);
        } else {
            this.logger.info("\u672c\u5730jar\u5305: " + jarFile.getAbsolutePath());
            if (sshClient.fileExists(deployRootDir + "/" + jarFile.getName())) {
                this.logger.info("\u5907\u4efd\u670d\u52a1\u5668jar: " + jarFile.getName() + ".backup");
                sshClient.executeCommand(String.format("cp %s/%s %s/%s.backup", deployRootDir, jarFile.getName(), deployRootDir, jarFile.getName()), this.sshPrinter);
            }
            sshClient.upload(jarFile.getAbsolutePath(), deployRootDir);
            this.logger.info("\u6267\u884c\u547d\u4ee4 " + deployRootDir + String.format("/startJarApp.sh %s '%s'", startModelName, jvmOps));
            appDeployCommand = "cd " + deployRootDir + String.format(" && bash ./startJarApp.sh  %s '%s'", startModelName, jvmOps);
            int status = sshClient.executeCommand(appDeployCommand, this.sshPrinter);
            if (status != 0) {
                this.logger.info("\u6267\u884c\u53d1\u5e03\u547d\u4ee4 " + deployRootDir + "/startJarApp.sh \u72b6\u6001 " + status);
                return false;
            }
        }
        if (conn.isClosed()) {
            this.closePluginConnection(conn);
            conn = this.getPluginConnection();
            paasDeployInfoDao = new PaasDeployInfoDao(conn);
        }
        this.updateDeployPath(currEnvId, this.appInfo, paasEcsInfo, startModelName, deployRootDir + "/" + startModelName + ".jar", appDeployCommand, null, paasDeployInfoDao);
        return true;
    }

    public boolean deployJarWithDependencies(PaasEcsInfo paasEcsInfo, PaasAppsParam moduleParam, String jvmOps, String deployRootDir, String currEnvId, PaasDeployInfoDao paasDeployInfoDao, Connection conn) throws Exception {
        File[] libJars;
        File jarFile;
        RemoteSSHClient sshClient = new RemoteSSHClient(paasEcsInfo.getEcsIp(), paasEcsInfo.getEcsLoginUser(), paasEcsInfo.getEcsLoginPwd());
        boolean loginFlag = sshClient.connect();
        if (!loginFlag) {
            this.logger.error("\u767b\u9646\u670d\u52a1\u5668\u5931\u8d25");
            return loginFlag;
        }
        String opsPath = SdEnvUtil.getTemplateScriptPath(this.appInfo);
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)opsPath)) {
            this.logger.error("\u65e0\u6cd5\u83b7\u53d6\u8fd0\u7ef4\u6a21\u677f\u6240\u5728\u76ee\u5f55\uff0c\u8bf7\u68c0\u67e5\u8fd0\u7ef4\u6a21\u677f\u4ed3\u5e93\u914d\u7f6e");
            return false;
        }
        deployRootDir = deployRootDir + "/" + this.appInfo.getAppCode();
        String localAgentPath = opsPath + File.separator;
        if (!sshClient.fileExists(deployRootDir)) {
            sshClient.executeCommand("mkdir -p " + deployRootDir, this.sshPrinter);
            sshClient.upload(localAgentPath + "startJarApp.sh", deployRootDir);
            sshClient.executeCommand("chmod 777 " + deployRootDir + "/startJarApp.sh", this.sshPrinter);
        }
        if (!sshClient.fileExists(deployRootDir + "/lib")) {
            sshClient.executeCommand("mkdir -p " + deployRootDir + "/lib", this.sshPrinter);
        }
        if (!sshClient.fileExists(deployRootDir + "/startJarApp.sh")) {
            sshClient.upload(localAgentPath + "startJarApp.sh", deployRootDir);
            sshClient.executeCommand("chmod 777 " + deployRootDir + "/startJarApp.sh", this.sshPrinter);
        }
        String rootPath = this.context.getBatBatchSource().getRepoLocalPath();
        String appCode = SdEnvUtil.wrapperAppCode(this.appInfo.getAppCode());
        File uploadDir = new File(rootPath, this.uploadFolder);
        if (!uploadDir.exists()) {
            uploadDir.mkdirs();
        }
        if ((jarFile = this.searchTargetJarFile(rootPath, appCode, moduleParam)) == null || !jarFile.exists()) {
            this.logger.error("\u83b7\u53d6\u4e0d\u5230jar " + rootPath + File.separator + appCode);
            return false;
        }
        FileUtils.copyFile((File)jarFile, (File)new File(uploadDir, jarFile.getName()));
        String startModelName = jarFile.getName().substring(0, jarFile.getName().length() - 4);
        this.logger.info("\u672c\u5730jar\u5305: " + jarFile.getAbsolutePath());
        sshClient.upload(jarFile.getAbsolutePath(), deployRootDir);
        File libDir = new File(jarFile.getParentFile(), "lib");
        if (libDir.exists() && (libJars = libDir.listFiles()) != null) {
            for (File jar : libJars) {
                sshClient.upload(jar.getAbsolutePath(), deployRootDir + "/lib/");
            }
        }
        this.logger.info("\u6267\u884c\u547d\u4ee4 " + deployRootDir + String.format("/startJarApp.sh %s '%s'", startModelName, jvmOps));
        String appStartCommand = "cd " + deployRootDir + String.format(" && bash ./startJarApp.sh %s '%s'", startModelName, jvmOps);
        int status = sshClient.executeCommand(appStartCommand, this.sshPrinter);
        if (status != 0) {
            this.logger.info("\u6267\u884c\u53d1\u5e03\u547d\u4ee4 " + deployRootDir + "/startJarApp.sh \u72b6\u6001 " + status);
            return false;
        }
        if (conn.isClosed()) {
            this.closePluginConnection(conn);
            conn = this.getPluginConnection();
            paasDeployInfoDao = new PaasDeployInfoDao(conn);
        }
        this.updateDeployPath(currEnvId, this.appInfo, paasEcsInfo, startModelName, deployRootDir + "/" + startModelName + ".jar", appStartCommand, null, paasDeployInfoDao);
        return true;
    }

    public boolean deployJarWithConfig(PaasEcsInfo paasEcsInfo, PaasAppsParam moduleParam, String jvmOps, String deployRootDir, String currEnvId, PaasDeployInfoDao paasDeployInfoDao, Connection conn) throws Exception {
        File jarFile;
        RemoteSSHClient sshClient = new RemoteSSHClient(paasEcsInfo.getEcsIp(), paasEcsInfo.getEcsLoginUser(), paasEcsInfo.getEcsLoginPwd());
        boolean loginFlag = sshClient.connect();
        if (!loginFlag) {
            this.logger.error("\u767b\u9646\u670d\u52a1\u5668\u5931\u8d25");
            return loginFlag;
        }
        String opsPath = SdEnvUtil.getTemplateScriptPath(this.appInfo);
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)opsPath)) {
            this.logger.error("\u65e0\u6cd5\u83b7\u53d6\u8fd0\u7ef4\u6a21\u677f\u6240\u5728\u76ee\u5f55\uff0c\u8bf7\u68c0\u67e5\u8fd0\u7ef4\u6a21\u677f\u4ed3\u5e93\u914d\u7f6e");
            return false;
        }
        deployRootDir = deployRootDir + "/" + this.appInfo.getAppCode();
        String localAgentPath = opsPath + File.separator;
        if (!sshClient.fileExists(deployRootDir)) {
            sshClient.executeCommand("mkdir -p " + deployRootDir, this.sshPrinter);
            sshClient.upload(localAgentPath + "startJarAppWithConfig.sh", deployRootDir);
            sshClient.executeCommand("chmod 777 " + deployRootDir + "/startJarAppWithConfig.sh", this.sshPrinter);
        }
        sshClient.upload(localAgentPath + "startJarAppWithConfig.sh", deployRootDir);
        sshClient.executeCommand("chmod 777 " + deployRootDir + "/startJarAppWithConfig.sh", this.sshPrinter);
        String rootPath = this.context.getBatBatchSource().getRepoLocalPath();
        String appCode = SdEnvUtil.wrapperAppCode(this.appInfo.getAppCode());
        File uploadDir = new File(rootPath, this.uploadFolder);
        if (!uploadDir.exists()) {
            uploadDir.mkdirs();
        }
        if ((jarFile = this.searchTargetJarFile(rootPath, appCode, moduleParam)) == null || !jarFile.exists()) {
            this.logger.error("\u83b7\u53d6\u4e0d\u5230jar " + rootPath + File.separator + appCode);
            return false;
        }
        String startModelName = jarFile.getName().substring(0, jarFile.getName().length() - 4);
        this.logger.info("\u672c\u5730jar\u5305: " + jarFile.getAbsolutePath());
        sshClient.upload(jarFile.getAbsolutePath(), deployRootDir);
        FileUtils.copyFile((File)jarFile, (File)new File(uploadDir, jarFile.getName()));
        String configOps = "./";
        File appSrcDir = new File(rootPath + File.separator + appCode + File.separator);
        File resourcesDir = null;
        if (moduleParam != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)moduleParam.getParamValue())) {
            String targetModule = moduleParam.getParamValue();
            Object[] modules = org.apache.commons.lang3.StringUtils.split((String)targetModule, (String)"/");
            resourcesDir = new File(appSrcDir, org.apache.commons.lang3.StringUtils.join((Object[])modules, (String)File.separator) + File.separator + "src" + File.separator + "main" + File.separator + "resources");
        } else {
            resourcesDir = new File(appSrcDir, "src" + File.separator + "main" + File.separator + "resources");
        }
        if (resourcesDir.exists() && resourcesDir.isDirectory()) {
            File bootstrap;
            File appProp;
            ArrayList<String> files = new ArrayList<String>();
            File appYml = this.findConfigFile(resourcesDir, "application.yml");
            if (appYml != null) {
                files.add(appYml.getName());
                sshClient.upload(appYml.getAbsolutePath(), deployRootDir);
            }
            if ((appProp = this.findConfigFile(resourcesDir, "application.properties")) != null) {
                files.add(appProp.getName());
                sshClient.upload(appProp.getAbsolutePath(), deployRootDir);
            }
            if ((bootstrap = this.findConfigFile(resourcesDir, "bootstrap.yml")) != null) {
                files.add(bootstrap.getName());
                sshClient.upload(bootstrap.getAbsolutePath(), deployRootDir);
            }
            configOps = configOps + org.apache.commons.lang3.StringUtils.join(files, (String)",");
        }
        String appStartCommand = "cd " + deployRootDir + String.format(" && bash ./startJarAppWithConfig.sh %s '%s' '%s'", startModelName, jvmOps, configOps);
        this.logger.info("\u6267\u884c\u547d\u4ee4 " + deployRootDir + String.format("/startJarAppWithConfig.sh %s '%s' '%s'", startModelName, jvmOps, configOps));
        int status = sshClient.executeCommand(appStartCommand, this.sshPrinter);
        sshClient.executeCommand("cd " + deployRootDir + String.format(" && echo \"startJarAppWithConfig.sh %s '%s' '%s'\" > \u542f\u52a8\u53c2\u6570.txt", startModelName, jvmOps, configOps), this.sshPrinter);
        if (status != 0) {
            this.logger.info("\u6267\u884c\u53d1\u5e03\u547d\u4ee4 " + deployRootDir + "/startJarAppWithConfig.sh \u72b6\u6001 " + status);
            return false;
        }
        if (conn.isClosed()) {
            this.closePluginConnection(conn);
            conn = this.getPluginConnection();
            paasDeployInfoDao = new PaasDeployInfoDao(conn);
        }
        this.updateDeployPath(currEnvId, this.appInfo, paasEcsInfo, startModelName, deployRootDir + "/" + startModelName + ".jar", appStartCommand, null, paasDeployInfoDao);
        return true;
    }

    public boolean deployJarWithZip(PaasEcsInfo paasEcsInfo, PaasAppsParam moduleParam, String jvmOps, String antTargetFile, String deployRootDir, String currEnvId, PaasDeployInfoDao paasDeployInfoDao, Connection conn) throws Exception {
        RemoteSSHClient sshClient = new RemoteSSHClient(paasEcsInfo.getEcsIp(), paasEcsInfo.getEcsLoginUser(), paasEcsInfo.getEcsLoginPwd());
        boolean loginFlag = sshClient.connect();
        if (!loginFlag) {
            this.logger.error("\u767b\u9646\u670d\u52a1\u5668\u5931\u8d25");
            return loginFlag;
        }
        String opsPath = SdEnvUtil.getTemplateScriptPath(this.appInfo);
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)opsPath)) {
            this.logger.error("\u65e0\u6cd5\u83b7\u53d6\u8fd0\u7ef4\u6a21\u677f\u6240\u5728\u76ee\u5f55\uff0c\u8bf7\u68c0\u67e5\u8fd0\u7ef4\u6a21\u677f\u4ed3\u5e93\u914d\u7f6e");
            return false;
        }
        String localAgentPath = opsPath + File.separator;
        if (!sshClient.fileExists(deployRootDir)) {
            sshClient.executeCommand("mkdir -p " + deployRootDir, this.sshPrinter);
            sshClient.upload(localAgentPath + this.actionShell, deployRootDir);
            sshClient.executeCommand("chmod 777 " + deployRootDir + "/" + this.actionShell, this.sshPrinter);
        }
        if (!sshClient.fileExists(deployRootDir + "/" + this.actionShell)) {
            sshClient.upload(localAgentPath + this.actionShell, deployRootDir);
            sshClient.executeCommand("chmod 777 " + deployRootDir + "/" + this.actionShell, this.sshPrinter);
        }
        String rootPath = this.context.getBatBatchSource().getRepoLocalPath();
        String appCode = SdEnvUtil.wrapperAppCode(this.appInfo.getAppCode());
        File uploadDir = new File(rootPath, this.uploadFolder);
        if (!uploadDir.exists()) {
            uploadDir.mkdirs();
        }
        File jarFile = null;
        jarFile = org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)antTargetFile) ? new File(appCode, antTargetFile) : this.searchTargetZipFile(rootPath, appCode, moduleParam);
        if (jarFile == null || !jarFile.exists()) {
            this.logger.error("\u83b7\u53d6\u4e0d\u5230jar " + rootPath + File.separator + appCode);
            return false;
        }
        String startModelName = jarFile.getName().substring(0, jarFile.getName().length() - 4);
        this.logger.info("\u672c\u5730jar\u5305: " + jarFile.getAbsolutePath());
        sshClient.upload(jarFile.getAbsolutePath(), deployRootDir);
        FileUtils.copyFile((File)jarFile, (File)new File(uploadDir, jarFile.getName()));
        this.logger.info("\u6267\u884c\u547d\u4ee4 " + deployRootDir + String.format("/%s %s '%s'", this.actionShell, startModelName, jvmOps));
        String appStartCommand = "cd " + deployRootDir + String.format(" && bash ./%s %s '%s'", this.actionShell, startModelName, jvmOps);
        int status = sshClient.executeCommand(appStartCommand, this.sshPrinter);
        if (status != 0) {
            this.logger.info("\u6267\u884c\u53d1\u5e03\u547d\u4ee4 " + deployRootDir + "/" + this.actionShell + " \u72b6\u6001 " + status);
            return false;
        }
        if (conn.isClosed()) {
            this.closePluginConnection(conn);
            conn = this.getPluginConnection();
            paasDeployInfoDao = new PaasDeployInfoDao(conn);
        }
        this.updateDeployPath(currEnvId, this.appInfo, paasEcsInfo, startModelName, deployRootDir + "/" + startModelName + ".jar", appStartCommand, null, paasDeployInfoDao);
        return true;
    }

    private File searchTargetJarFile(String rootPath, String appCode, PaasAppsParam moduleParam) {
        File targetDir = new File(rootPath);
        if (moduleParam != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)moduleParam.getParamValue())) {
            String targetModule = moduleParam.getParamValue();
            Object[] modules = org.apache.commons.lang3.StringUtils.split((String)targetModule, (String)"/");
            File targetFile = new File(targetDir, org.apache.commons.lang3.StringUtils.join((Object[])modules, (String)File.separator) + File.separator + "target" + File.separator + (String)modules[modules.length - 1] + ".jar");
            if (targetFile.exists() && targetFile.isFile()) {
                return targetFile;
            }
            File moduleDir = new File(targetDir, org.apache.commons.lang3.StringUtils.join((Object[])modules, (String)File.separator) + File.separator + "target");
            if (moduleDir.exists() && moduleDir.isDirectory()) {
                File[] jarFiles;
                for (File jarF : jarFiles = moduleDir.listFiles()) {
                    if (!jarF.isFile() || !jarF.getName().endsWith(".jar.original")) continue;
                    targetFile = new File(jarF.getParentFile(), jarF.getName().substring(0, jarF.getName().length() - 9));
                    return targetFile;
                }
            }
        }
        File jarFile = null;
        if (targetDir.exists() && targetDir.isDirectory()) {
            File[] moduleFiles;
            for (File f : moduleFiles = targetDir.listFiles()) {
                File[] jarFiles;
                if (!f.isDirectory()) continue;
                String name = f.getName();
                if (name.equals("target")) {
                    File[] jarFiles2 = f.listFiles();
                    for (File jarF : jarFiles2) {
                        if (!jarF.isFile() || !jarF.getName().endsWith(".jar.original")) continue;
                        jarFile = new File(jarF.getParentFile(), jarF.getName().substring(0, jarF.getName().length() - 9));
                        return jarFile;
                    }
                    continue;
                }
                File buildTargetF = new File(f, "target");
                if (!buildTargetF.exists()) continue;
                for (File jarF : jarFiles = buildTargetF.listFiles()) {
                    if (!jarF.isFile() || !jarF.getName().endsWith(".jar.original")) continue;
                    jarFile = new File(jarF.getParentFile(), jarF.getName().substring(0, jarF.getName().length() - 9));
                    return jarFile;
                }
            }
        } else {
            this.logger.error("\u5e94\u7528\u7f16\u8bd1\u76ee\u5f55\u4e0d\u5b58\u5728 " + targetDir.getAbsolutePath());
            return null;
        }
        return null;
    }

    private File searchTargetZipFile(String rootPath, String appCode, PaasAppsParam moduleParam) {
        String targetModule;
        Object[] modules;
        File targetFile;
        File targetDir = new File(rootPath + File.separator + appCode + File.separator);
        if (moduleParam != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)moduleParam.getParamValue()) && (targetFile = new File(targetDir, org.apache.commons.lang3.StringUtils.join((Object[])(modules = org.apache.commons.lang3.StringUtils.split((String)(targetModule = moduleParam.getParamValue()), (String)"/")), (String)File.separator) + File.separator + "target" + File.separator)).exists() && targetFile.isDirectory()) {
            File[] moduleFiles;
            for (File f : moduleFiles = targetFile.listFiles()) {
                File[] jarFiles;
                Object name;
                if (!f.isDirectory() || !((String)(name = f.getName())).endsWith("-packages")) continue;
                for (File jarF : jarFiles = f.listFiles()) {
                    if (!jarF.isFile() || !jarF.getName().endsWith(".zip")) continue;
                    return jarF;
                }
            }
        }
        File jarFile = null;
        if (targetDir.exists() && targetDir.isDirectory()) {
            File[] moduleFiles;
            for (File f : moduleFiles = targetDir.listFiles()) {
                File[] jarFiles;
                if (!f.isDirectory()) continue;
                String name = f.getName();
                if (name.equals("target")) {
                    File[] jarFiles2 = f.listFiles();
                    for (File jarF : jarFiles2) {
                        if (!jarF.isFile() || !jarF.getName().endsWith(".zip")) continue;
                        jarFile = jarF;
                        return jarFile;
                    }
                    continue;
                }
                File buildTargetF = new File(f, "target");
                if (!buildTargetF.exists()) continue;
                for (File jarF : jarFiles = buildTargetF.listFiles()) {
                    if (!jarF.isFile() || !jarF.getName().endsWith(".zip")) continue;
                    jarFile = jarF;
                    return jarFile;
                }
            }
        } else {
            this.logger.error("\u5e94\u7528\u7f16\u8bd1\u76ee\u5f55\u4e0d\u5b58\u5728 " + targetDir.getAbsolutePath());
            return null;
        }
        return null;
    }

    private File searchTargetWarFile(String rootPath, String appCode, PaasAppsParam moduleParam) {
        String targetModule;
        File targetFile;
        File targetDir = new File(rootPath + File.separator + appCode + File.separator);
        if (moduleParam != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)moduleParam.getParamValue()) && (targetFile = new File(targetDir, (targetModule = moduleParam.getParamValue()) + File.separator + "target" + File.separator + targetModule + ".war")).exists() && targetFile.isFile()) {
            return targetFile;
        }
        File jarFile = null;
        if (targetDir.exists() && targetDir.isDirectory()) {
            File[] moduleFiles;
            for (File f : moduleFiles = targetDir.listFiles()) {
                File[] jarFiles;
                if (!f.isDirectory()) continue;
                String name = f.getName();
                if (name.equals("target")) {
                    File[] jarFiles2;
                    for (File jarF : jarFiles2 = f.listFiles()) {
                        if (!jarF.isFile() || !jarF.getName().endsWith(".war")) continue;
                        jarFile = jarF;
                        return jarFile;
                    }
                    continue;
                }
                File buildTargetF = new File(f, "target");
                if (!buildTargetF.exists()) continue;
                for (File jarF : jarFiles = buildTargetF.listFiles()) {
                    if (!jarF.isFile() || !jarF.getName().endsWith(".war")) continue;
                    jarFile = jarF;
                    return jarFile;
                }
            }
        } else {
            this.logger.error("\u5e94\u7528\u7f16\u8bd1\u76ee\u5f55\u4e0d\u5b58\u5728 " + targetDir.getAbsolutePath());
            return null;
        }
        return null;
    }

    public void updateDeployPath(String envId, PaasAppsInfo appInfo, PaasEcsInfo ecs, String startModelName, String deployPath, String appDeployCommand, PaasEnvParam loggingFile, PaasDeployInfoDao paasDeployInfoDao) throws Exception {
        boolean flag = true;
        PaasDeployInfo deployInfo = paasDeployInfoDao.queryByAppId(appInfo.getAppId(), envId);
        if (deployInfo == null) {
            deployInfo = new PaasDeployInfo();
            flag = false;
            SeqInstInfoService seqService = (SeqInstInfoService)SpringContextUtils.getBean(SeqInstInfoService.class);
            deployInfo.setAppDeployId(seqService.nextSequence("PAAS-INST-ID", appInfo.getSubsId()));
        }
        deployInfo.setSubsId(appInfo.getSubsId());
        deployInfo.setAppId(appInfo.getAppId());
        deployInfo.setAppName(appInfo.getAppCode());
        deployInfo.setAppCnname(appInfo.getAppName());
        deployInfo.setAppVersion(appInfo.getAppVersion());
        deployInfo.setAppType(appInfo.getAppType());
        String appCode = SdEnvUtil.wrapperAppCode(this.appInfo.getAppCode());
        deployInfo.setAppLogPath(this.getLoggingPath(appInfo.getAppId(), envId) + appCode);
        deployInfo.setAppDeployPath(deployPath);
        deployInfo.setEnvId(envId);
        deployInfo.setAppOrder(0);
        deployInfo.setEcsId(ecs.getEcsId());
        deployInfo.setEcsIp(ecs.getEcsIp());
        deployInfo.setEcsName(ecs.getEcsName());
        deployInfo.setEcsRegion(ecs.getEcsRegionId());
        deployInfo.setAppPort(ecs.getEcsPort());
        deployInfo.setAppState("R");
        deployInfo.setOperUserid("admin");
        deployInfo.setAppStartCommand(appDeployCommand);
        deployInfo.setOperTime(CurrentDateUtil.getTodayDateEx2());
        if (flag) {
            paasDeployInfoDao.updateByPk(deployInfo);
        } else {
            paasDeployInfoDao.insertPaasDeployInfo(deployInfo);
        }
        SummaryService summaryService = (SummaryService)SpringContextUtils.getBean(SummaryService.class);
        HashMap<String, String> summaryParam = new HashMap<String, String>();
        summaryParam.put("appId", appInfo.getAppId());
        summaryParam.put("subsId", appInfo.getSubsId());
        summaryService.updateMeasure("paasDeployAppWithRunSummary", summaryParam);
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)"AllinSaas", (CharSequence)this.appInfo.getSubsCode())) {
            PaasEnvInfo envUpdate = new PaasEnvInfo();
            envUpdate.setEnvId(this.envInfo.getEnvId());
            String ecsIp = ecs.getEcsOutIp();
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)ecsIp)) {
                ecsIp = ecs.getEcsIp();
            }
            String ecsPort = ecs.getEcsPort();
            if (org.apache.commons.lang3.StringUtils.equals((CharSequence)"allinsaas-portal", (CharSequence)this.appInfo.getAppCode())) {
                envUpdate.setEnvAppsPortal(String.format("http://%s:%s/allinsaas-portal-start", ecsIp, ecsPort));
                paasDeployInfoDao.updatePaasEnvInfoByPk(envUpdate);
            } else if (org.apache.commons.lang3.StringUtils.equals((CharSequence)"allinsaas-cas", (CharSequence)this.appInfo.getAppCode())) {
                envUpdate.setEnvCasServer(String.format("http://%s:%s/cas", ecsIp, ecsPort));
                paasDeployInfoDao.updatePaasEnvInfoByPk(envUpdate);
            }
        }
    }

    private String getLoggingPath(String appId, String envId) {
        String loggingPathVal;
        PaasAppsParamService paasAppsParamService = (PaasAppsParamService)SpringContextUtils.getBean(PaasAppsParamService.class);
        PaasEnvParamService paasEnvParamService = (PaasEnvParamService)SpringContextUtils.getBean(PaasEnvParamService.class);
        PaasAppsParamDTO loggingParam = new PaasAppsParamDTO();
        loggingParam.setAppId(appId);
        loggingParam.setParamCode("logging_path");
        List paramList = paasAppsParamService.queryListByPage((Object)loggingParam);
        if (CollectionUtils.isNotEmpty((Collection)paramList) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(loggingPathVal = ((PaasAppsParamDTO)paramList.get(0)).getParamValue()))) {
            return loggingPathVal;
        }
        PaasEnvParamDTO loggingPathParam = paasEnvParamService.queryEnvParamByCodeReturnValue("logging_path", envId);
        if (loggingPathParam != null) {
            String loggingPath = loggingPathParam.getParamValue();
            return loggingPath;
        }
        return "";
    }

    private File findConfigFile(File file, String targetConfigFile) {
        if (file.exists()) {
            File[] subFiles;
            if (file.isFile()) {
                String fileName = file.getName();
                if (fileName.equals(targetConfigFile)) {
                    return file;
                }
                return null;
            }
            if (file.isDirectory() && (subFiles = file.listFiles()) != null) {
                ArrayList<File> dirs = new ArrayList<File>(subFiles.length);
                for (File subFile : subFiles) {
                    if (subFile.isFile()) {
                        String fileName = subFile.getName();
                        if (!fileName.equals(targetConfigFile)) continue;
                        return subFile;
                    }
                    dirs.add(subFile);
                }
                if (CollectionUtils.isNotEmpty(dirs)) {
                    for (File subDir : dirs) {
                        File subRe = this.findConfigFile(subDir, targetConfigFile);
                        if (subRe == null) continue;
                        return subRe;
                    }
                }
            }
        }
        return null;
    }

    public boolean deployCasWarWithConfig(PaasEcsInfo paasEcsInfo, PaasAppsParam moduleParam, String jvmOps, String deployRootDir, String currEnvId, PaasDeployInfoDao paasDeployInfoDao, Connection conn) throws Exception {
        RemoteSSHClient sshClient = new RemoteSSHClient(paasEcsInfo.getEcsIp(), paasEcsInfo.getEcsLoginUser(), paasEcsInfo.getEcsLoginPwd());
        boolean loginFlag = sshClient.connect();
        if (!loginFlag) {
            this.logger.error("\u767b\u9646\u670d\u52a1\u5668\u5931\u8d25");
            return loginFlag;
        }
        String opsPath = SdEnvUtil.getTemplateScriptPath(this.appInfo);
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)opsPath)) {
            this.logger.error("\u65e0\u6cd5\u83b7\u53d6\u8fd0\u7ef4\u6a21\u677f\u6240\u5728\u76ee\u5f55\uff0c\u8bf7\u68c0\u67e5\u8fd0\u7ef4\u6a21\u677f\u4ed3\u5e93\u914d\u7f6e");
            return false;
        }
        String appDeployDir = deployRootDir + "/" + this.appInfo.getAppCode();
        String localAgentPath = opsPath + File.separator;
        if (!sshClient.fileExists(appDeployDir)) {
            sshClient.executeCommand("mkdir -p " + appDeployDir, this.sshPrinter);
            sshClient.upload(localAgentPath + "startCas.sh", deployRootDir);
            sshClient.executeCommand("chmod 777 " + deployRootDir + "/startCas.sh", this.sshPrinter);
        }
        sshClient.upload(localAgentPath + "startCas.sh", deployRootDir);
        sshClient.executeCommand("chmod 777 " + deployRootDir + "/startCas.sh", this.sshPrinter);
        String rootPath = this.context.getBatBatchSource().getRepoLocalPath();
        String appCode = SdEnvUtil.wrapperAppCode(this.appInfo.getAppCode());
        File appSrcDir = new File(rootPath + File.separator + appCode + File.separator);
        File warFile = new File(appSrcDir + File.separator + "build" + File.separator + "libs" + File.separator);
        File[] libsFiles = warFile.listFiles();
        if (libsFiles != null) {
            for (File file : libsFiles) {
                if (!org.apache.commons.lang3.StringUtils.endsWith((CharSequence)file.getName(), (CharSequence)".war")) continue;
                warFile = file;
            }
        } else {
            warFile = null;
        }
        if (warFile == null || !warFile.exists()) {
            this.logger.error("\u83b7\u53d6\u4e0d\u5230war " + rootPath + File.separator + appCode);
            return false;
        }
        String startModelName = this.appInfo.getAppCode();
        this.logger.info("\u672c\u5730war\u5305: " + warFile.getAbsolutePath());
        sshClient.upload(warFile.getAbsolutePath(), appDeployDir);
        sshClient.executeCommand("mv " + appDeployDir + "/" + warFile.getName() + " " + appDeployDir + "/" + startModelName + ".war", this.sshPrinter);
        String configOps = "/etc/cas/config";
        File configDir = new File(appSrcDir, configOps);
        if (configDir.exists() && configDir.isDirectory()) {
            File[] configFiles;
            String remoteConfigDir = appDeployDir + "/config";
            if (!sshClient.fileExists(remoteConfigDir)) {
                sshClient.executeCommand("mkdir -p " + remoteConfigDir, this.sshPrinter);
            }
            for (File file : configFiles = configDir.listFiles()) {
                sshClient.upload(file.getAbsolutePath(), remoteConfigDir);
            }
        }
        String appStartCommand = "cd " + deployRootDir + String.format(" && echo \"startCas.sh %s\" > \u542f\u52a8\u53c2\u6570.txt", startModelName);
        this.logger.info("\u6267\u884c\u547d\u4ee4 " + deployRootDir + String.format("/startCas.sh %s", startModelName));
        int status = sshClient.executeCommand("cd " + deployRootDir + String.format(" && bash ./startCas.sh %s", startModelName), this.sshPrinter);
        sshClient.executeCommand(appStartCommand, this.sshPrinter);
        if (status != 0) {
            this.logger.info("\u6267\u884c\u53d1\u5e03\u547d\u4ee4 " + deployRootDir + "/startCas.sh \u72b6\u6001 " + status);
            return false;
        }
        if (conn.isClosed()) {
            this.closePluginConnection(conn);
            conn = this.getPluginConnection();
            paasDeployInfoDao = new PaasDeployInfoDao(conn);
        }
        this.updateDeployPath(currEnvId, this.appInfo, paasEcsInfo, startModelName, deployRootDir + "/" + startModelName, appStartCommand, null, paasDeployInfoDao);
        return true;
    }

    public boolean isLocalMachine(String ecsIp) {
        List<String> localIpList = this.getIpAddress();
        return localIpList.contains(ecsIp);
    }

    public List<String> getIpAddress() {
        try {
            ArrayList<String> ips = new ArrayList<String>();
            Enumeration<NetworkInterface> allNetInterfaces = NetworkInterface.getNetworkInterfaces();
            while (allNetInterfaces.hasMoreElements()) {
                NetworkInterface netInterface = allNetInterfaces.nextElement();
                if (netInterface.isLoopback() || netInterface.isVirtual() || !netInterface.isUp()) continue;
                Enumeration<InetAddress> addresses = netInterface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress ip = addresses.nextElement();
                    if (!(ip instanceof Inet4Address)) continue;
                    ips.add(ip.getHostAddress());
                }
            }
            return ips;
        }
        catch (Exception e) {
            System.err.println("IP\u5730\u5740\u83b7\u53d6\u5931\u8d25" + e.toString());
            return Collections.emptyList();
        }
    }
}

