/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.docs;

import com.deepoove.poi.XWPFTemplate;
import com.deepoove.poi.config.Configure;
import com.deepoove.poi.data.DocxRenderData;
import com.deepoove.poi.data.PictureType;
import com.deepoove.poi.data.Pictures;
import com.deepoove.poi.policy.DynamicTableRenderPolicy;
import com.deepoove.poi.policy.RenderPolicy;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.BatInstBatchDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.ModelTableFieldDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.OsrvArrangeTableDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.OsrvEvalIsrvDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.SrvModelInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.SrvModelInoutDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.SrvModelPackageDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.BatInstBatch;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.ModelTableField;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.OsrvArrangeTable;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.OsrvEvalIsrv;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SrvModelInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SrvModelInout;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SrvModelPackage;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.WikiSubsPage;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.apps.SdEnvUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.docs.DocAbstractPlugin;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.docs.DrawOsrvArrangeTable;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.docs.poitl.SrvInoutTablePolicy;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.docs.poitl.SrvOsrvArrangeTablePolicy;
import com.irdstudio.allinrdm.dev.console.types.DomainVarType;
import com.irdstudio.allinrdm.dev.console.types.IOType;
import com.irdstudio.allinrdm.dev.console.types.RowOpType;
import com.irdstudio.allinrdm.dev.console.types.SrvModelCatalogEnum;
import com.irdstudio.allinrdm.wiki.console.types.DocMode;
import com.irdstudio.sdk.beans.word.util.WordResourceCloseUtil;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;

public class DocsGenInterfaceWordPlugin
extends DocAbstractPlugin {
    private DrawOsrvArrangeTable drawOsrvArrangeTable = new DrawOsrvArrangeTable();
    private BatInstBatch buildLog;
    private Map<String, Object> extParam;
    String APP_INTERFACE = "app_interface.docx";
    String APP_INT_PACKAGE = "app_inf_package.docx";
    String APP_INT_SRV = "app_inf_srv.docx";
    String APP_INT_SRV_INOUT = "app_inf_srv_inout.docx";
    String APP_INT_SRV_TABLE = "app_inf_srv_table.docx";
    String APP_MERGE_DOC = "multiple_tables_info.docx";
    String APP_BLANK = "blank.docx";

    @Override
    protected boolean doReadConfigureFromDB(Connection conn, String szConfIdentify) throws SQLException {
        String batchSerialNo = this.context.getSzBatchSn();
        BatInstBatchDao batInstBatchDao = new BatInstBatchDao(conn);
        this.buildLog = batInstBatchDao.queryByBatchSerialNo(batchSerialNo);
        this.extParam = batInstBatchDao.getExtParam(this.buildLog);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        String docsRootPath = SdEnvUtil.DOCS_PATH;
        String projectTempDir = SdEnvUtil.PROJECT_TMP_PATH;
        String loginUserId = MapUtils.getString(this.extParam, (Object)"createUserId");
        boolean flag = true;
        Connection conn = null;
        try {
            conn = this.getPluginConnection();
            PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
            String subsId = this.buildLog.getSubsId();
            List<PaasAppsInfo> appList = paasAppsInfoDao.queryPaasAppsInfoListBySysCode(subsId);
            if (CollectionUtils.isNotEmpty(appList)) {
                String wordTemplatePath = this.getClass().getClassLoader().getResource("template/word/").getPath();
                for (PaasAppsInfo appInfo : appList) {
                    String infDocFile = this.generateAppInfDoc(appInfo, wordTemplatePath, projectTempDir, conn);
                    File srcFile = new File(infDocFile);
                    File targetFile = new File(docsRootPath + File.separator + subsId + File.separator + "02_\u6982\u8981\u8bbe\u8ba1" + File.separator + srcFile.getName());
                    FileUtils.copyFile((File)srcFile, (File)targetFile);
                    String docName = srcFile.getName();
                    WikiSubsPage appDoc = new WikiSubsPage();
                    appDoc.setDocType("docx");
                    appDoc.setDocTitle(docName.replace(".docx", ""));
                    appDoc.setAppCode(appInfo.getAppCode());
                    appDoc.setAppId(appInfo.getAppId());
                    appDoc.setAppName(appInfo.getAppName());
                    appDoc.setSubsId(subsId);
                    appDoc.setLoginUserId(loginUserId);
                    appDoc.setDocMode(DocMode.FlowGen.getCode());
                    this.saveToWikiConsole(subsId, appDoc, conn);
                }
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), e);
            flag = false;
        }
        finally {
            if (conn != null) {
                this.closePluginConnection(conn);
            }
        }
        return flag;
    }

    private String generateAppInfDoc(PaasAppsInfo appInfo, String wordTemplatePath, String projectTempDir, Connection conn) throws Exception {
        String pp_outputPath;
        String srvModelId;
        String appId = appInfo.getAppId();
        String tempDir = projectTempDir + File.separator + String.format("%s-infword", appId);
        File tempDirF = new File(tempDir);
        if (!tempDirF.exists()) {
            tempDirF.mkdirs();
        }
        SrvModelPackageDao srvModelPackageDao = new SrvModelPackageDao(conn);
        SrvModelInfoDao srvModelInfoDao = new SrvModelInfoDao(conn);
        SrvModelInoutDao srvModelInoutDao = new SrvModelInoutDao(conn);
        ModelTableFieldDao modelTableFieldDao = new ModelTableFieldDao(conn);
        OsrvArrangeTableDao osrvArrangeTableDao = new OsrvArrangeTableDao(conn);
        OsrvEvalIsrvDao osrvEvalIsrvDao = new OsrvEvalIsrvDao(conn);
        SrvModelPackage packageParam = new SrvModelPackage();
        packageParam.setAppId(appId);
        List<SrvModelPackage> packageList = srvModelPackageDao.querySrvModelPackageList(packageParam);
        SrvModelInfo infoParam = new SrvModelInfo();
        infoParam.setAppId(appId);
        List<SrvModelInfo> srvList = srvModelInfoDao.querySrvModelInfoList(infoParam, Arrays.asList(SrvModelCatalogEnum.ComponentServer.getCode(), SrvModelCatalogEnum.TradeServer.getCode(), SrvModelCatalogEnum.BackServer.getCode()));
        HashMap<String, ArrayList<SrvModelInfo>> packageMap = new HashMap<String, ArrayList<SrvModelInfo>>(packageList.size());
        HashMap<String, Object> srvMap = new HashMap<String, Object>();
        ArrayList inoutMapList = new ArrayList();
        ArrayList osrvTBMapList = new ArrayList();
        if (CollectionUtils.isNotEmpty(srvList)) {
            for (SrvModelInfo srvModelInfo : srvList) {
                List list;
                ArrayList<SrvModelInfo> spList = (ArrayList<SrvModelInfo>)packageMap.get(srvModelInfo.getPackageId());
                if (spList == null) {
                    spList = new ArrayList<SrvModelInfo>();
                    packageMap.put(srvModelInfo.getPackageId(), spList);
                }
                spList.add(srvModelInfo);
                SrvModelInout inoutParam = new SrvModelInout();
                inoutParam.setSrvModelId(srvModelInfo.getSrvModelId());
                List<SrvModelInout> inoutList = srvModelInoutDao.querySrvModelInoutList(inoutParam);
                if (CollectionUtils.isNotEmpty(inoutList)) {
                    for (SrvModelInout inout : inoutList) {
                        if (inout.getIoType().equals(DomainVarType.Var.getCode())) continue;
                        list = (List)srvMap.get(inout.getSrvModelId() + inout.getIoType());
                        if (list == null) {
                            list = new ArrayList();
                            srvMap.put(inout.getSrvModelId() + inout.getIoType(), list);
                        }
                        List<ModelTableField> fieldList = modelTableFieldDao.queryModelTableFieldList(inout.getTableModelId());
                        srvMap.put(inout.getSrvModelId() + inout.getTableModelId() + inout.getIoType() + "H", (Object)inout);
                        HashMap<String, Object> inoutMap = new HashMap<String, Object>();
                        inoutMap.put("inoutName", inout.getTableModelName());
                        inoutMap.put("tableModelCode", inout.getTableModelCode());
                        inoutMap.put("srvModelId", inout.getSrvModelId());
                        inoutMap.put("tableModelId", inout.getTableModelId());
                        inoutMap.put("ioType", inout.getIoType());
                        inoutMap.put("list", fieldList);
                        inoutMapList.add(inoutMap);
                        list.add(inoutMap);
                    }
                }
                OsrvArrangeTable otbParam = new OsrvArrangeTable();
                otbParam.setSrvModelId(srvModelInfo.getSrvModelId());
                List<OsrvArrangeTable> otbList = osrvArrangeTableDao.queryOsrvArrangeTableList(otbParam);
                if (!CollectionUtils.isNotEmpty(otbList)) continue;
                for (OsrvArrangeTable otb : otbList) {
                    ArrayList list2;
                    if (!otb.getRowOpType().equals(RowOpType.Serve.getCode()) && !otb.getRowOpType().equals(RowOpType.TServe.getCode()) && !otb.getRowOpType().equals(RowOpType.BServe.getCode()) && !otb.getRowOpType().equals(RowOpType.RServe.getCode()) && !otb.getRowOpType().equals(RowOpType.SServe.getCode())) continue;
                    OsrvEvalIsrv evalParam = new OsrvEvalIsrv();
                    evalParam.setTableRowId(otb.getTableRowId());
                    evalParam.setSrvModelId(otb.getSrvModelId());
                    List<OsrvEvalIsrv> evalList = osrvEvalIsrvDao.queryOsrvEvalIsrvList(evalParam);
                    ArrayList<OsrvEvalIsrv> newEvalList = new ArrayList<OsrvEvalIsrv>(evalList.size());
                    if (CollectionUtils.isNotEmpty(evalList)) {
                        for (OsrvEvalIsrv vo : evalList) {
                            if (!StringUtils.isNotBlank((CharSequence)vo.getIsrvEvalWay()) || !StringUtils.isNotBlank((CharSequence)vo.getEvalContent())) continue;
                            newEvalList.add(vo);
                        }
                    }
                    if ((list2 = (ArrayList)srvMap.get(otb.getSrvModelId() + "Table")) == null) {
                        list2 = new ArrayList();
                        srvMap.put(otb.getSrvModelId() + "Table", list2);
                    }
                    srvMap.put(otb.getSrvModelId() + otb.getTableRowId() + "Table", (Object)otb);
                    HashMap<String, Object> tbMap = new HashMap<String, Object>();
                    tbMap.put("srvModelName", otb.getRowOpTargetName());
                    tbMap.put("srvModelId", otb.getSrvModelId());
                    tbMap.put("tableRowId", otb.getTableRowId());
                    tbMap.put("list", newEvalList);
                    osrvTBMapList.add(tbMap);
                    list2.add(tbMap);
                }
                list = this.drawOsrvArrangeTable.generateImage(srvModelInfo.getSrvModelId(), otbList, tempDirF);
            }
        }
        for (Map map : inoutMapList) {
            srvModelId = MapUtils.getString((Map)map, (Object)"srvModelId");
            String tableModelId = MapUtils.getString((Map)map, (Object)"tableModelId");
            String ioType = MapUtils.getString((Map)map, (Object)"ioType");
            String outputPath = tempDir + File.separator + String.format("%s-%s-%s-tmp.docx", srvModelId, tableModelId, ioType);
            String result = DocsGenInterfaceWordPlugin.renderOnePiece(wordTemplatePath, this.APP_INT_SRV_INOUT, outputPath, map, "list", new SrvInoutTablePolicy());
            this.logger.info(String.format("\u751f\u6210\u63a5\u53e3\u6587\u6863 \u5206\u5757 %s", result));
        }
        for (Map map : osrvTBMapList) {
            srvModelId = MapUtils.getString((Map)map, (Object)"srvModelId");
            String tableRowId = MapUtils.getString((Map)map, (Object)"tableRowId");
            String outputPath = tempDir + File.separator + String.format("%s-%s-tmp.docx", srvModelId, tableRowId);
            String result = DocsGenInterfaceWordPlugin.renderOnePiece(wordTemplatePath, this.APP_INT_SRV_TABLE, outputPath, map, "list", new SrvOsrvArrangeTablePolicy());
            this.logger.info(String.format("\u751f\u6210\u63a5\u53e3\u6587\u6863 \u7f16\u6392\u5206\u5757 %s", result));
        }
        for (SrvModelInfo srvModelInfo : srvList) {
            HashMap<String, Object> srvRenderData = new HashMap<String, Object>();
            String srv_outputPath = tempDir + File.separator + String.format("%s-%s-tmp.docx", srvModelInfo.getAppId(), srvModelInfo.getSrvModelId());
            srvRenderData.put("srvModelName", srvModelInfo.getSrvModelName());
            List inputs = (List)srvMap.get(srvModelInfo.getSrvModelId() + IOType.Input.getCode());
            ArrayList inputDocs = new ArrayList();
            if (CollectionUtils.isNotEmpty((Collection)inputs)) {
                for (Map map : inputs) {
                    String srvModelId2 = MapUtils.getString((Map)map, (Object)"srvModelId");
                    String tableModelId = MapUtils.getString((Map)map, (Object)"tableModelId");
                    String ioType = MapUtils.getString((Map)map, (Object)"ioType");
                    String outputPath = tempDir + File.separator + String.format("%s-%s-%s-tmp.docx", srvModelId2, tableModelId, ioType);
                    HashMap<String, DocxRenderData> tableData = new HashMap<String, DocxRenderData>();
                    tableData.put("singleTableInfo", new DocxRenderData(new File(outputPath)));
                    inputDocs.add(tableData);
                }
            }
            srvRenderData.put("appInfSrvInoutInput", new DocxRenderData(new File(wordTemplatePath + this.APP_MERGE_DOC), inputDocs));
            List outputs = (List)srvMap.get(srvModelInfo.getSrvModelId() + IOType.Output.getCode());
            ArrayList outputData = new ArrayList();
            if (CollectionUtils.isNotEmpty((Collection)outputs)) {
                for (Map map : outputs) {
                    String srvModelId3 = MapUtils.getString((Map)map, (Object)"srvModelId");
                    String tableModelId = MapUtils.getString((Map)map, (Object)"tableModelId");
                    String ioType = MapUtils.getString((Map)map, (Object)"ioType");
                    String outputPath = tempDir + File.separator + String.format("%s-%s-%s-tmp.docx", srvModelId3, tableModelId, ioType);
                    HashMap<String, DocxRenderData> tableData = new HashMap<String, DocxRenderData>();
                    tableData.put("singleTableInfo", new DocxRenderData(new File(outputPath)));
                    outputData.add(tableData);
                }
            }
            srvRenderData.put("appInfSrvInoutOutput", new DocxRenderData(new File(wordTemplatePath + this.APP_MERGE_DOC), outputData));
            List tables = (List)srvMap.get(srvModelInfo.getSrvModelId() + "Table");
            ArrayList tablesData = new ArrayList();
            if (CollectionUtils.isNotEmpty((Collection)tables)) {
                for (Map map : tables) {
                    String srvModelId4 = MapUtils.getString((Map)map, (Object)"srvModelId");
                    String tableRowId = MapUtils.getString((Map)map, (Object)"tableRowId");
                    String outputPath = tempDir + File.separator + String.format("%s-%s-tmp.docx", srvModelId4, tableRowId);
                    HashMap<String, DocxRenderData> tableData = new HashMap<String, DocxRenderData>();
                    tableData.put("singleTableInfo", new DocxRenderData(new File(outputPath)));
                    tablesData.add(tableData);
                }
            }
            if (CollectionUtils.isEmpty(tablesData)) {
                HashMap<String, DocxRenderData> tableData = new HashMap<String, DocxRenderData>();
                tableData.put("singleTableInfo", new DocxRenderData(new File(wordTemplatePath + File.separator + this.APP_BLANK)));
                tablesData.add(tableData);
            }
            srvRenderData.put("appInfSrvTable", new DocxRenderData(new File(wordTemplatePath + this.APP_MERGE_DOC), tablesData));
            File appInfSrvImgFile = new File(tempDir + File.separator + String.format("%s.png", srvModelInfo.getSrvModelId()));
            if (appInfSrvImgFile.exists()) {
                BufferedImage img = ImageIO.read(appInfSrvImgFile);
                srvRenderData.put("appInfSrvImg", Pictures.ofBufferedImage((BufferedImage)img, (PictureType)PictureType.PNG).size(Double.valueOf((double)img.getWidth() * 0.6).intValue(), Double.valueOf((double)img.getHeight() * 0.6).intValue()).create());
            }
            String result = DocsGenInterfaceWordPlugin.renderMultipleDocx(wordTemplatePath, this.APP_INT_SRV, srv_outputPath, srvRenderData);
            this.logger.info(String.format("\u751f\u6210\u63a5\u53e3\u6587\u6863 \u670d\u52a1\u5206\u5757 %s", result));
        }
        for (SrvModelPackage srvModelPackage : packageList) {
            Object object;
            List ppSrvList = (List)packageMap.get(srvModelPackage.getPackageId());
            HashMap<String, Object> ppData = new HashMap<String, Object>();
            ppData.put("packageName", srvModelPackage.getPackageName());
            pp_outputPath = tempDir + File.separator + String.format("%s-%s-ptmp.docx", srvModelPackage.getAppId(), srvModelPackage.getPackageId());
            ArrayList packageData = new ArrayList();
            if (CollectionUtils.isNotEmpty((Collection)ppSrvList)) {
                object = ppSrvList.iterator();
                while (object.hasNext()) {
                    SrvModelInfo srv = (SrvModelInfo)((Object)object.next());
                    String srv_outputPath = tempDir + File.separator + String.format("%s-%s-tmp.docx", srv.getAppId(), srv.getSrvModelId());
                    HashMap<String, DocxRenderData> tableData = new HashMap<String, DocxRenderData>();
                    tableData.put("singleTableInfo", new DocxRenderData(new File(srv_outputPath)));
                    packageData.add(tableData);
                }
            }
            ppData.put("appInfSrv", new DocxRenderData(new File(wordTemplatePath + this.APP_MERGE_DOC), packageData));
            object = DocsGenInterfaceWordPlugin.renderMultipleDocx(wordTemplatePath, this.APP_INT_PACKAGE, pp_outputPath, ppData);
        }
        HashMap<String, Object> infData = new HashMap<String, Object>();
        infData.put("appName", appInfo.getAppName());
        ArrayList arrayList = new ArrayList();
        for (SrvModelPackage pp : packageList) {
            pp_outputPath = tempDir + File.separator + String.format("%s-%s-ptmp.docx", pp.getAppId(), pp.getPackageId());
            HashMap<String, DocxRenderData> ppData = new HashMap<String, DocxRenderData>();
            ppData.put("singleTableInfo", new DocxRenderData(new File(pp_outputPath)));
            arrayList.add(ppData);
        }
        String finalFileName = String.format("%s\u8be6\u7ec6\u8bbe\u8ba1\u6587\u6863%s.docx", appInfo.getAppName(), StringUtils.isNotBlank((CharSequence)appInfo.getAppVersion()) ? "-" + appInfo.getAppVersion() : "");
        infData.put("appInfPackage", new DocxRenderData(new File(wordTemplatePath + this.APP_MERGE_DOC), arrayList));
        String result = DocsGenInterfaceWordPlugin.renderMultipleDocx(wordTemplatePath, this.APP_INTERFACE, projectTempDir + File.separator + finalFileName, infData);
        this.logger.info(String.format("\u751f\u6210\u63a5\u53e3\u6587\u6863 \u6700\u7ec8\u7ed3\u679c %s", result));
        result = this.fixWordFormat(result);
        return result;
    }

    private String fixWordFormat(String filePath) throws IOException {
        FileInputStream is = null;
        try {
            is = new FileInputStream(filePath);
            XWPFDocument doc = new XWPFDocument((InputStream)is);
            List paras = doc.getParagraphs();
            String p3StyleId = null;
            String p4StyleId = null;
            for (XWPFParagraph pp : paras) {
                XWPFRun run;
                String ppText;
                List runs;
                if (pp.getParagraphText().endsWith("p3")) {
                    if (p3StyleId == null) {
                        p3StyleId = pp.getStyleID();
                    } else {
                        pp.setStyle(p3StyleId);
                    }
                    runs = pp.getRuns();
                    ppText = pp.getParagraphText();
                    while (runs.size() > 1) {
                        pp.removeRun(1);
                    }
                    run = (XWPFRun)runs.get(0);
                    run.setText(ppText.replace("p3", ""), 0);
                    continue;
                }
                if (!pp.getParagraphText().endsWith("p4")) continue;
                if (p4StyleId == null) {
                    p4StyleId = pp.getStyleID();
                } else {
                    pp.setStyle(p4StyleId);
                }
                runs = pp.getRuns();
                ppText = pp.getParagraphText();
                while (runs.size() > 1) {
                    pp.removeRun(1);
                }
                run = (XWPFRun)runs.get(0);
                run.setText(ppText.replace("p4", ""), 0);
            }
            doc.write((OutputStream)new FileOutputStream(filePath));
        }
        catch (IOException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        return filePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static String renderMultipleDocx(String templatePath, String templateName, String resultPath, Map<String, Object> data) {
        String resultFilePath;
        block7: {
            resultFilePath = resultPath;
            XWPFTemplate template = null;
            FileOutputStream out = null;
            try {
                template = XWPFTemplate.compile((String)(templatePath + templateName)).render(data);
                out = new FileOutputStream(resultFilePath);
                template.write((OutputStream)out);
                out.flush();
                WordResourceCloseUtil.closeXWPFTemplate((XWPFTemplate)template);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                break block7;
            }
            catch (IOException e2) {
                e2.printStackTrace();
                break block7;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                WordResourceCloseUtil.closeXWPFTemplate(template);
                WordResourceCloseUtil.closeOutputStream(out);
            }
            WordResourceCloseUtil.closeOutputStream((OutputStream)out);
        }
        return resultFilePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String renderOnePiece(String templatePath, String templateName, String resultPath, Map<String, Object> data, String policyName, DynamicTableRenderPolicy policyInstance) {
        String resultFilePath;
        block7: {
            resultFilePath = resultPath;
            XWPFTemplate template = null;
            FileOutputStream out = null;
            try {
                Configure config = Configure.builder().bind(policyName, (RenderPolicy)policyInstance).build();
                template = XWPFTemplate.compile((String)(templatePath + templateName), (Configure)config).render(data);
                out = new FileOutputStream(resultFilePath);
                template.write((OutputStream)out);
                out.flush();
                WordResourceCloseUtil.closeXWPFTemplate((XWPFTemplate)template);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                break block7;
            }
            catch (IOException e2) {
                e2.printStackTrace();
                break block7;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                WordResourceCloseUtil.closeXWPFTemplate(template);
                WordResourceCloseUtil.closeOutputStream(out);
            }
            WordResourceCloseUtil.closeOutputStream((OutputStream)out);
        }
        return resultFilePath;
    }
}

