/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.docs;

import com.deepoove.poi.data.RowRenderData;
import com.deepoove.poi.data.Rows;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.BatInstBatchDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.ModelTableFieldDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.ModelTableIndexDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.ModelTableInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.BatInstBatch;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.ModelTableField;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.ModelTableIndex;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.ModelTableInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.WikiSubsPage;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.apps.SdEnvUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.docs.DocAbstractPlugin;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.docs.vo.TreeData;
import com.irdstudio.allinapaas.executor.application.executor.core.util.db.plugin.ModelTableStructVO;
import com.irdstudio.allinrdm.dam.console.types.ObjectType;
import com.irdstudio.allinrdm.wiki.console.types.DocMode;
import com.irdstudio.sdk.beans.word.util.TableModelUtil;
import com.irdstudio.sdk.beans.word.vo.tablemodel.ColumnInfo;
import com.irdstudio.sdk.beans.word.vo.tablemodel.PkgTableModelInfo;
import com.irdstudio.sdk.beans.word.vo.tablemodel.TableModelInfo;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class DocsGenTableWordPlugin
extends DocAbstractPlugin {
    private BatInstBatch buildLog;
    private Map<String, Object> extParam;

    @Override
    protected boolean doReadConfigureFromDB(Connection conn, String szConfIdentify) throws SQLException {
        String batchSerialNo = this.context.getSzBatchSn();
        BatInstBatchDao batInstBatchDao = new BatInstBatchDao(conn);
        this.buildLog = batInstBatchDao.queryByBatchSerialNo(batchSerialNo);
        this.extParam = batInstBatchDao.getExtParam(this.buildLog);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        String loginUserId = MapUtils.getString(this.extParam, (Object)"createUserId");
        String docsRootPath = SdEnvUtil.DOCS_PATH;
        boolean flag = true;
        Connection conn = null;
        try {
            conn = this.getPluginConnection();
            PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
            String subsId = this.buildLog.getSubsId();
            List<PaasAppsInfo> appList = paasAppsInfoDao.queryPaasAppsInfoListBySysCode(subsId);
            if (CollectionUtils.isNotEmpty(appList)) {
                for (PaasAppsInfo appInfo : appList) {
                    String currentFilePath = docsRootPath + File.separator + subsId + File.separator + "02_\u6982\u8981\u8bbe\u8ba1" + File.separator;
                    String projectId = appInfo.getAppId();
                    if (StringUtils.isBlank((CharSequence)projectId)) continue;
                    List<TreeData> treeDataList = paasAppsInfoDao.queryTableModelPackage(projectId);
                    for (int i = 0; i < treeDataList.size(); ++i) {
                        if (!projectId.equals(treeDataList.get(i).getParentid())) continue;
                        treeDataList.remove(i);
                        --i;
                    }
                    List<ModelTableStructVO> tableStructs = this.queryModelTableStructByProjectId(projectId, conn);
                    List<PkgTableModelInfo> pkgTableModelInfos = this.tableStruct2GenWordTableBean(treeDataList, tableStructs);
                    String wordTableModelTemplatePath = this.getClass().getClassLoader().getResource("template/word/").getPath();
                    String fileName = TableModelUtil.genWord4AllTableModelInfo((String)projectId, pkgTableModelInfos, (String)wordTableModelTemplatePath, (String)currentFilePath);
                    File appTableDoc = new File(currentFilePath + File.separator + fileName);
                    String resultFileName = String.format("%s\u8868\u8bbe\u8ba1\u6587\u6863.docx", appInfo.getAppName());
                    FileUtils.copyFile((File)appTableDoc, (File)new File(currentFilePath + File.separator + resultFileName));
                    FileUtils.deleteQuietly((File)appTableDoc);
                    FileUtils.deleteQuietly((File)new File(currentFilePath + projectId + "_single_table_model_result.docx"));
                    WikiSubsPage tableDoc = new WikiSubsPage();
                    tableDoc.setDocType("docx");
                    tableDoc.setDocTitle(String.format("%s\u8868\u8bbe\u8ba1\u6587\u6863", appInfo.getAppName()));
                    tableDoc.setAppCode(appInfo.getAppCode());
                    tableDoc.setAppId(appInfo.getAppId());
                    tableDoc.setAppName(appInfo.getAppName());
                    tableDoc.setSubsId(subsId);
                    tableDoc.setLoginUserId(loginUserId);
                    tableDoc.setDocMode(DocMode.FlowGen.getCode());
                    this.saveToWikiConsole(subsId, tableDoc, conn);
                }
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), e);
            flag = false;
        }
        finally {
            if (conn != null) {
                this.closePluginConnection(conn);
            }
        }
        return flag;
    }

    private List<ModelTableStructVO> queryModelTableStructByProjectId(String projectId, Connection conn) throws Exception {
        ModelTableInfoDao modelTableInfoDao = new ModelTableInfoDao(conn);
        ModelTableFieldDao modelTableFieldDao = new ModelTableFieldDao(conn);
        ModelTableIndexDao modelTableIndexDao = new ModelTableIndexDao(conn);
        ArrayList<ModelTableStructVO> sqlScripts = new ArrayList<ModelTableStructVO>();
        ModelTableInfo tableParam = new ModelTableInfo();
        tableParam.setAppId(projectId);
        tableParam.setObjectType(ObjectType.Table.getIntCode());
        List<ModelTableInfo> tableInfoVOs = modelTableInfoDao.queryTableListWithCond(tableParam);
        List<ModelTableField> tableFieldVOs = modelTableFieldDao.queryFieldByAppId(projectId);
        List<ModelTableIndex> tableIndexVOs = modelTableIndexDao.queryModelTableInfos(projectId);
        ModelTableStructVO sqlScript = null;
        ArrayList<ModelTableField> tableFieldVOs2 = null;
        for (ModelTableInfo tableInfoVO : tableInfoVOs) {
            sqlScript = new ModelTableStructVO();
            sqlScript.setTable(tableInfoVO);
            sqlScript.setIndexs(new ArrayList<ModelTableIndex>());
            tableFieldVOs2 = new ArrayList<ModelTableField>();
            for (int i = 0; i < tableFieldVOs.size(); ++i) {
                if (!tableFieldVOs.get(i).getObjectId().equals(tableInfoVO.getObjectId())) continue;
                tableFieldVOs2.add(tableFieldVOs.get(i));
                tableFieldVOs.remove(i);
                --i;
            }
            for (int k = 0; k < tableIndexVOs.size(); ++k) {
                if (!tableInfoVO.getObjectId().equals(tableIndexVOs.get(k).getObjectId())) continue;
                sqlScript.getIndexs().add(tableIndexVOs.get(k));
                tableIndexVOs.remove(k);
                --k;
            }
            sqlScript.setFields(tableFieldVOs2);
            sqlScripts.add(sqlScript);
        }
        return sqlScripts;
    }

    private List<PkgTableModelInfo> tableStruct2GenWordTableBean(List<TreeData> treeDataList, List<ModelTableStructVO> tableStructs) {
        ArrayList<PkgTableModelInfo> pkgTableModelInfos = new ArrayList<PkgTableModelInfo>();
        PkgTableModelInfo pkgTableInfo = null;
        if (Objects.nonNull(treeDataList) && treeDataList.size() > 0) {
            for (TreeData data : treeDataList) {
                pkgTableInfo = new PkgTableModelInfo();
                pkgTableInfo.setPkgName(data.getText());
                ArrayList<TableModelInfo> tableInfos = new ArrayList<TableModelInfo>();
                for (ModelTableStructVO vo : tableStructs) {
                    if (!data.getId().equals(vo.getTable().getFolderId())) continue;
                    tableInfos.add(this.modelTableStruct2TableModelInfo(vo, data.getText()));
                }
                pkgTableInfo.setTableInfos(tableInfos);
                pkgTableModelInfos.add(pkgTableInfo);
            }
        } else {
            pkgTableInfo = new PkgTableModelInfo();
            ArrayList<TableModelInfo> tableInfos = new ArrayList<TableModelInfo>();
            for (ModelTableStructVO vo : tableStructs) {
                tableInfos.add(this.modelTableStruct2TableModelInfo(vo, ""));
            }
            pkgTableInfo.setTableInfos(tableInfos);
            pkgTableModelInfos.add(pkgTableInfo);
        }
        return pkgTableModelInfos;
    }

    private TableModelInfo modelTableStruct2TableModelInfo(ModelTableStructVO vo, String pkgName) {
        TableModelInfo tableModelInfo = new TableModelInfo();
        List<ModelTableField> fields = vo.getFields();
        ColumnInfo columnInfo = new ColumnInfo();
        ArrayList<RowRenderData> columns = new ArrayList<RowRenderData>();
        ArrayList<RowRenderData> indexs = new ArrayList<RowRenderData>();
        int c = 0;
        RowRenderData column = null;
        for (ModelTableField field : fields) {
            if (!"Y".equals(field.getIsPk())) continue;
            column = Rows.of((String[])new String[]{String.valueOf(++c), field.getFieldCode(), field.getFieldName(), this.getDataType(field), "\u4e3b\u952e", this.checkCanNull(field)}).create();
            columns.add(column);
        }
        for (ModelTableField field : fields) {
            if ("Y".equals(field.getIsPk())) continue;
            column = Rows.of((String[])new String[]{String.valueOf(++c), field.getFieldCode(), field.getFieldName(), this.getDataType(field), "", this.checkCanNull(field)}).create();
            columns.add(column);
        }
        indexs.add(Rows.of((String[])new String[]{"", "", ""}).create());
        columnInfo.setColumns(columns);
        columnInfo.setIndexs(indexs);
        tableModelInfo.setColumnInfo(columnInfo);
        tableModelInfo.setTableName(vo.getTable().getObjectCode());
        tableModelInfo.setTableCnName(vo.getTable().getObjectName());
        tableModelInfo.setBelongTo(pkgName);
        return tableModelInfo;
    }

    private String getDataType(ModelTableField fieldVO) {
        String dataType = fieldVO.getFieldType();
        if (fieldVO.getFieldLength() != null && fieldVO.getFieldLength() > 0) {
            dataType = dataType + "(" + fieldVO.getFieldLength();
        }
        if (fieldVO.getFieldPrecision() != null && fieldVO.getFieldPrecision() > 0) {
            dataType = dataType + "," + fieldVO.getFieldPrecision();
        }
        dataType = dataType + ")";
        return dataType;
    }

    private String checkCanNull(ModelTableField fieldVO) {
        String canNull = null;
        canNull = "Y".equals(fieldVO.getIsPk()) ? "N" : ("N".equals(fieldVO.getIsAllowNull()) ? "N" : "Y");
        return canNull;
    }
}

