/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.docs;

import com.irdstudio.allinapaas.executor.application.executor.core.dao.BatInstBatchDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasDocDirectoryDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasDocLibraryDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.BatInstBatch;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasDocDirectory;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasDocLibrary;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.AbstractPlugin;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.apps.SdEnvUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.common.SSubsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.common.SSubsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.docs.git.queue.DocTemplateRepoPullQueueExecutor;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class DocsInitLocalDirPlugin
extends AbstractPlugin {
    private BatInstBatch buildLog;

    @Override
    protected boolean doReadConfigureFromDB(Connection conn, String szConfIdentify) throws SQLException {
        String batchSerialNo = this.context.getSzBatchSn();
        BatInstBatchDao batInstBatchDao = new BatInstBatchDao(conn);
        this.buildLog = batInstBatchDao.queryByBatchSerialNo(batchSerialNo);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        String docsRootPath = SdEnvUtil.DOCS_PATH;
        boolean flag = true;
        Connection conn = null;
        try {
            conn = this.getPluginConnection();
            DocTemplateRepoPullQueueExecutor.run();
            String sysCode = this.buildLog.getSubsId();
            File sysDir = new File(docsRootPath + File.separator + sysCode);
            if (sysDir.exists()) {
                FileUtils.deleteQuietly((File)sysDir);
            }
            sysDir.mkdirs();
            SSubsInfoDao sSubsInfoDao = new SSubsInfoDao(conn);
            PaasDocLibraryDao paasDocLibraryDao = new PaasDocLibraryDao(conn);
            PaasDocDirectoryDao paasDocDirectoryDao = new PaasDocDirectoryDao(conn);
            SSubsInfo subsInfo = new SSubsInfo();
            subsInfo.setSubsCode(this.buildLog.getSubsId());
            subsInfo = sSubsInfoDao.querySSubsInfoWithKeys(this.buildLog.getSubsId());
            if (StringUtils.isBlank((CharSequence)subsInfo.getDocLibraryId())) {
                subsInfo.setDocLibraryId("DEFAULT");
            }
            PaasDocLibrary lib = paasDocLibraryDao.queryByPk(subsInfo.getDocLibraryId());
            PaasDocDirectory dirParam = new PaasDocDirectory();
            dirParam.setLibId(lib.getLibId());
            List<PaasDocDirectory> dirList = paasDocDirectoryDao.queryList(dirParam);
            HashMap<String, PaasDocDirectory> dirMap = new HashMap<String, PaasDocDirectory>();
            for (PaasDocDirectory dir : dirList) {
                dirMap.put(dir.getDirId(), dir);
            }
            ArrayList<PaasDocDirectory> roots = new ArrayList<PaasDocDirectory>();
            for (PaasDocDirectory dir : dirList) {
                PaasDocDirectory parent = (PaasDocDirectory)((Object)dirMap.get(dir.getDirAbvId()));
                if (parent != null) {
                    if (parent.getChildren() == null) {
                        parent.setChildren(new ArrayList<PaasDocDirectory>());
                    }
                    parent.getChildren().add(dir);
                    continue;
                }
                roots.add(dir);
            }
            if (CollectionUtils.isNotEmpty(roots)) {
                roots.stream().forEach(p -> this.recursionMkdir((PaasDocDirectory)((Object)p), sysDir));
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), e);
            flag = false;
        }
        finally {
            if (conn != null) {
                this.closePluginConnection(conn);
            }
        }
        return flag;
    }

    private void recursionMkdir(PaasDocDirectory dir, File parentDir) {
        File dirFile = new File(parentDir, dir.getDirName());
        dirFile.mkdirs();
        if (CollectionUtils.isNotEmpty(dir.getChildren())) {
            dir.getChildren().stream().forEach(p -> this.recursionMkdir((PaasDocDirectory)((Object)p), dirFile));
        }
    }
}

